/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrowseHostHandler {
    private static final Log LOG;
    private static final int NOT_STARTED = -1;
    private static final int STARTED = 0;
    private static final int DIRECTLY_CONNECTING = 1;
    private static final int PUSHING = 2;
    private static final int EXCHANGING = 3;
    private static final int FINISHED = 4;
    private static final int DIRECT_CONNECT_TIME = 10000;
    private static final long EXPIRE_TIME = 15000L;
    private static final int SPECIAL_INDEX = 0;
    private static Map _pushedHosts;
    private ActivityCallback _callback = null;
    private GUID _guid = null;
    private GUID _serventID = null;
    private volatile long _replyLength = 0L;
    private volatile long _currentLength = 0L;
    private volatile int _state = -1;
    private volatile long _stateStarted = 0L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.BrowseHostHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        _pushedHosts = new HashMap();
        Expirer expirer = new Expirer();
        RouterService.schedule(expirer, 0L, 5000L);
    }

    public BrowseHostHandler(ActivityCallback activityCallback, GUID gUID, GUID gUID2) {
        this._callback = activityCallback;
        this._guid = gUID;
        this._serventID = gUID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browseHost(String string, int n, Set set, boolean bl) {
        if (!NetworkUtils.isValidPort(n) || !NetworkUtils.isValidAddress(string)) {
            this.failed();
            return;
        }
        LOG.trace((Object)"starting browse protocol.");
        this.setState(0);
        int n2 = BrowseHostHandler.needsPush(string);
        LOG.trace((Object)("push needed? " + n2));
        boolean bl2 = false;
        switch (n2) {
            case 0: {
                Object object;
                try {
                    this.setState(1);
                    LOG.trace((Object)"Attempting direct connection");
                    object = Sockets.connect(string, n, 10000);
                    LOG.trace((Object)"direct connect successful");
                    this.browseExchange((Socket)object);
                }
                catch (IOException iOException) {
                    LOG.debug((Object)"error while direct transfer", (Throwable)iOException);
                    bl2 = true;
                }
                if (!bl2) break;
            }
            case 1: {
                LOG.debug((Object)"Attempting push connection");
                if (this._serventID == null) {
                    LOG.debug((Object)"No serventID, failing");
                    this.failed();
                    break;
                }
                Object object = new RemoteFileDesc(string, n, 0L, "fake", 0, this._serventID.bytes(), 0, false, 0, false, null, null, false, true, "", 0L, set, -1L, bl ? 1 : 0);
                Map map = _pushedHosts;
                synchronized (map) {
                    _pushedHosts.put(this._serventID, new PushRequestDetails(this));
                }
                LOG.trace((Object)"trying push.");
                this.setState(2);
                RouterService.getDownloadManager().sendPush((RemoteFileDesc)object);
            }
        }
    }

    public double getPercentComplete(long l) {
        switch (this._state) {
            case -1: {
                return 0.0;
            }
            case 0: {
                return 0.0;
            }
            case 1: {
                long l2 = l - this._stateStarted;
                return (double)l2 / 10000.0;
            }
            case 2: {
                long l3 = l - this._stateStarted;
                return (double)l3 / 15000.0;
            }
            case 3: {
                if (this._replyLength > 0L) {
                    return (double)this._currentLength / (double)this._replyLength;
                }
                return 0.5;
            }
            case 4: {
                return 1.0;
            }
        }
        throw new IllegalStateException("invalid state");
    }

    private void setState(int n) {
        this._state = n;
        this._stateStarted = System.currentTimeMillis();
    }

    private void failed() {
        this.setState(4);
        this._callback.browseHostFailed(this._guid);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void browseExchange(Socket socket) throws IOException {
        try {
            this.browseExchangeInternal(socket);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            IOUtils.close(socket);
            this.setState(4);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        IOUtils.close(socket);
        this.setState(4);
    }

    private void browseExchangeInternal(Socket socket) throws IOException {
        socket.setSoTimeout(5000);
        LOG.trace((Object)"BHH.browseExchange(): entered.");
        this.setState(3);
        String string = null;
        OutputStream outputStream = socket.getOutputStream();
        LOG.trace((Object)"BHH.browseExchange(): got output stream.");
        string = "GET / HTTP/1.1\r\n";
        outputStream.write(string.getBytes());
        string = "Host: " + NetworkUtils.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort() + "\r\n";
        outputStream.write(string.getBytes());
        string = "User-Agent: " + CommonUtils.getVendor() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Accept: application/x-gnutella-packets\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: 0\r\n";
        outputStream.write(string.getBytes());
        string = "Connection: close\r\n";
        outputStream.write(string.getBytes());
        string = "\r\n";
        outputStream.write(string.getBytes());
        outputStream.flush();
        LOG.trace((Object)"BHH.browseExchange(): wrote request A-OK.");
        InputStream inputStream = socket.getInputStream();
        LOG.trace((Object)"BHH.browseExchange(): got input stream");
        ByteReader byteReader = new ByteReader(inputStream);
        LOG.trace((Object)"BHH.browseExchange(): trying to get HTTP code....");
        int n = BrowseHostHandler.parseHTTPCode(byteReader.readLine());
        if (n < 200 || n >= 300) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Bad code: " + n));
            }
            throw new IOException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BHH.browseExchange(): HTTP Response is " + n));
        }
        boolean bl = true;
        String string2 = null;
        while (bl) {
            string2 = byteReader.readLine();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("BHH.browseExchange(): currLine = " + string2));
            }
            if (string2 == null || string2.equals("")) {
                bl = false;
                continue;
            }
            if (this.indexOfIgnoreCase(string2, "Content-Type") > -1) {
                if (this.indexOfIgnoreCase(string2, "application/x-gnutella-packets") >= 0) continue;
                throw new IOException();
            }
            if (this.indexOfIgnoreCase(string2, "Content-Encoding") > -1) {
                throw new IOException();
            }
            if (!this.markContentLength(string2)) continue;
        }
        LOG.debug((Object)"BHH.browseExchange(): read HTTP seemingly OK.");
        inputStream = new BufferedInputStream(inputStream);
        Message message = null;
        while (true) {
            try {
                message = null;
                LOG.debug((Object)"reading message");
                message = MessageFactory.read(inputStream);
            }
            catch (BadPacketException badPacketException) {
                LOG.debug((Object)"BPE while reading", (Throwable)badPacketException);
            }
            catch (IOException iOException) {
                LOG.debug((Object)"IOE while reading", (Throwable)iOException);
            }
            if (message == null) {
                LOG.debug((Object)"Unable to read a message");
                return;
            }
            if (!(message instanceof QueryReply)) continue;
            this._currentLength += (long)message.getTotalLength();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("BHH.browseExchange(): read QR:" + message));
            }
            QueryReply queryReply = (QueryReply)message;
            queryReply.setGUID(this._guid);
            queryReply.setBrowseHostReply(true);
            ForMeReplyHandler.instance().handleQueryReply(queryReply, null);
        }
    }

    private boolean markContentLength(String string) {
        int n = this.indexOfIgnoreCase(string, "Content-Length:");
        if (n < 0) {
            return false;
        }
        String string2 = string.substring("Content-Length:".length()).trim();
        try {
            this._replyLength = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return true;
    }

    private static int needsPush(String string) {
        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && NetworkUtils.isPrivateAddress(string)) {
            return 1;
        }
        return 0;
    }

    private int indexOfIgnoreCase(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        return string3.indexOf(string4);
    }

    private static int parseHTTPCode(String string) throws IOException {
        if (string == null) {
            throw new IOException("couldn't read anything");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IOException("no tokens to read: " + string);
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new IOException("didn't contain HTTP, had: " + string2);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IOException("no number token: " + string);
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("BHH.parseHTTPCode(): returning " + string3));
            }
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("not a number: " + string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handlePush(int n, GUID gUID, Socket socket) {
        boolean bl = false;
        LOG.trace((Object)"BHH.handlePush(): entered.");
        PushRequestDetails pushRequestDetails = null;
        Object object = _pushedHosts;
        synchronized (object) {
            pushRequestDetails = (PushRequestDetails)_pushedHosts.remove(gUID);
        }
        if (pushRequestDetails != null) {
            object = pushRequestDetails;
            ThreadFactory.startThread(new Runnable((PushRequestDetails)object, socket){
                private final /* synthetic */ PushRequestDetails val$finalPRD;
                private final /* synthetic */ Socket val$socket;
                {
                    this.val$finalPRD = pushRequestDetails;
                    this.val$socket = socket;
                }

                public void run() {
                    try {
                        this.val$finalPRD.bhh.browseExchange(this.val$socket);
                    }
                    catch (IOException iOException) {
                        LOG.debug((Object)"error while push transfer", (Throwable)iOException);
                        this.val$finalPRD.bhh.failed();
                    }
                }
            }, "BrowseHost");
            bl = true;
        } else {
            LOG.debug((Object)"BHH.handlePush(): no matching BHH.");
        }
        LOG.trace((Object)"BHH.handlePush(): returning.");
        return bl;
    }

    private static class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Iterator<Object> iterator = null;
                HashSet hashSet = new HashSet();
                Map map = _pushedHosts;
                synchronized (map) {
                    iterator = _pushedHosts.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        PushRequestDetails pushRequestDetails = null;
                        pushRequestDetails = (PushRequestDetails)_pushedHosts.get(k);
                        if (pushRequestDetails == null || !pushRequestDetails.isExpired()) continue;
                        LOG.debug((Object)"Expirer.run(): expiring a badboy.");
                        hashSet.add(k);
                        pushRequestDetails.bhh.failed();
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        _pushedHosts.remove(iterator.next());
                    }
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }

    private static class PushRequestDetails {
        private BrowseHostHandler bhh;
        private long timeStamp = System.currentTimeMillis();

        public PushRequestDetails(BrowseHostHandler browseHostHandler) {
            this.bhh = browseHostHandler;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timeStamp > 15000L;
        }
    }
}

