/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.AqMain;

public class AqEvent {
    private static Map stateCache = Collections.synchronizedMap(new HashMap());
    private static int currentLocalIndex = -1;
    private static final String kSep = "<aq/>";
    protected static final int kLWEventQueryResult = 1;
    protected static final int kLWEventConnectionInitialized = 2;
    protected static final int kLWEventConnectionClosed = 3;
    protected static final int kLWEventConnectionsUpdated = 4;
    protected static final int kLWEventAddDownload = 5;
    protected static final int kLWEventRemoveDownload = 6;
    protected static final int kLWEventUpdateDownloadStats = 7;
    protected static final int kLWEventDownloadsUpdated = 8;
    protected static final int kLWEventAddUpload = 9;
    protected static final int kLWEventRemoveUpload = 10;
    protected static final int kLWEventUpdateUploadStats = 11;
    protected static final int kLWEventUploadsUpdated = 12;
    protected static final int kLWEventAddSharedFile = 13;
    protected static final int kLWEventCoreConnected = 98;
    protected static final int kLWEventCoreInitialized = 99;

    private static String decodeXMLString(String string) {
        if (string == null) {
            return "";
        }
        string = StringUtils.replace(string, "&amp;", "&");
        string = StringUtils.replace(string, "&lt;", "<");
        string = StringUtils.replace(string, "&gt;", ">");
        string = StringUtils.replace(string, "&apos;", "'");
        string = StringUtils.replace(string, "&quot;", "\"");
        return string;
    }

    protected static void signalEvent(int n) {
        AqEvent.signalEvent(n, null, null, null);
    }

    protected static void signalEvent(int n, Object object) {
        AqEvent.signalEvent(n, object, null, null);
    }

    protected static void signalEvent(int n, Object object, Object object2) {
        AqEvent.signalEvent(n, object, object2, null);
    }

    protected static void signalEvent(int n, Object object, Object object2, Object object3) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            switch (n) {
                case 1: {
                    int n2;
                    Object object4;
                    RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
                    HostData hostData = (HostData)object2;
                    Set set = (Set)object3;
                    GUID gUID = new GUID(hostData.getMessageGUID());
                    String string = (String)AqEventHandler.queriesToIndices.get(gUID);
                    String string2 = String.valueOf(++currentLocalIndex);
                    String string3 = String.valueOf(string) + ":" + string2;
                    AqEventHandler.queryGUIDs.put(string3, gUID);
                    AqEventHandler.responses.put(string3, remoteFileDesc);
                    AqEventHandler.alts.put(string3, set);
                    int n3 = 0;
                    int n4 = 0;
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    if (remoteFileDesc.getXMLDocument() != null) {
                        object4 = remoteFileDesc.getXMLDocument();
                        try {
                            n3 = new Integer(((LimeXMLDocument)object4).getValue("audios__audio__bitrate__"));
                            if (n3 > 320) {
                                n3 = 0;
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            n4 = new Integer(((LimeXMLDocument)object4).getValue("audios__audio__seconds__"));
                            if (n4 > 86400) {
                                n4 = 0;
                            }
                        }
                        catch (Exception exception) {}
                        string4 = ((LimeXMLDocument)object4).isLicenseAvailable() ? "<" + ((LimeXMLDocument)object4).getLicenseString() + "> " + AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__artist__")) : AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__artist__"));
                        string5 = AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__album__"));
                        string6 = AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__title__"));
                    }
                    object4 = String.valueOf(hostData.getIP()) + ":" + hostData.getPort();
                    int n5 = n2 = hostData.isBrowseHostEnabled() ? 1 : 0;
                    if (n2 == 1) {
                        AqEventHandler.hosts.put(object4, hostData);
                    }
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(set.size());
                    stringBuffer.append(kSep);
                    stringBuffer.append((String)object4);
                    stringBuffer.append(kSep);
                    stringBuffer.append(n2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSHA1Urn());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getFileName());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSpeed());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(n3);
                    stringBuffer.append(kSep);
                    stringBuffer.append(n4);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string4);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string5);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string6);
                    stringBuffer.append("\n");
                    break;
                }
                case 2: {
                    ManagedConnection managedConnection = (ManagedConnection)object;
                    String string = new Locale(managedConnection.getLocalePref()).getDisplayLanguage();
                    String string7 = managedConnection.isSupernodeClientConnection() ? "Leaf" : (managedConnection.isClientSupernodeConnection() ? "Ultrapeer" : (managedConnection.isSupernodeSupernodeConnection() ? "Peer" : "Standard"));
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedConnection.getAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(managedConnection.getPort());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedConnection.getUserAgent());
                    stringBuffer.append(kSep);
                    stringBuffer.append(string);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string7);
                    stringBuffer.append("\n");
                    break;
                }
                case 3: {
                    ManagedConnection managedConnection = (ManagedConnection)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedConnection.getAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(managedConnection.getPort());
                    stringBuffer.append("\n");
                    break;
                }
                case 5: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getSaveFile().getName());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getContentLength());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getAmountRead());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getSHA1Urn());
                    stringBuffer.append("\n");
                    break;
                }
                case 6: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.hashCode());
                    stringBuffer.append("\n");
                    stateCache.remove(String.valueOf(managedDownloader.hashCode()));
                    if (!managedDownloader.isManualCanceled() || managedDownloader.getFile() == null) break;
                    managedDownloader.getFile().delete();
                    break;
                }
                case 7: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    float f = managedDownloader.getMeasuredBandwidth() * 1024.0f;
                    float f2 = managedDownloader.getAverageBandwidth() * 1024.0f;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getContentLength());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getAmountRead());
                    stringBuffer.append(kSep);
                    stringBuffer.append(f);
                    stringBuffer.append(kSep);
                    stringBuffer.append(f2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getNumHosts());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getBusyHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getPossibleHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getQueuedHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getFile().getAbsolutePath());
                    stringBuffer.append(kSep);
                    stringBuffer.append(managedDownloader.getActiveHostAddresses());
                    stringBuffer.append("\n");
                    String string = String.valueOf(managedDownloader.hashCode());
                    if (stringBuffer.toString().equals((String)stateCache.get(string))) {
                        stringBuffer = null;
                        break;
                    }
                    stateCache.put(string, stringBuffer.toString());
                    break;
                }
                case 9: {
                    Uploader uploader = (Uploader)object;
                    int n6 = uploader.isBrowseHostEnabled() ? 1 : 0;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileName());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getHost());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getGnutellaPort());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getUserAgent());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getTotalAmountUploaded());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileDesc().getPath());
                    stringBuffer.append(kSep);
                    stringBuffer.append(n6);
                    stringBuffer.append("\n");
                    break;
                }
                case 10: {
                    Uploader uploader = (Uploader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append("\n");
                    stateCache.remove(String.valueOf(uploader.hashCode()));
                    break;
                }
                case 11: {
                    Uploader uploader = (Uploader)object;
                    float f = uploader.getMeasuredBandwidth() * 1024.0f;
                    float f3 = uploader.getAverageBandwidth() * 1024.0f;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getTotalAmountUploaded());
                    stringBuffer.append(kSep);
                    stringBuffer.append(f);
                    stringBuffer.append(kSep);
                    stringBuffer.append(f3);
                    stringBuffer.append("\n");
                    String string = String.valueOf(uploader.hashCode());
                    if (stringBuffer.toString().equals((String)stateCache.get(string))) {
                        stringBuffer = null;
                        break;
                    }
                    stateCache.put(string, stringBuffer.toString());
                    break;
                }
                case 13: {
                    FileDesc fileDesc = (FileDesc)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(fileDesc.getSHA1Urn());
                    stringBuffer.append("\n");
                    break;
                }
                default: {
                    stringBuffer.append(n);
                    stringBuffer.append("\n");
                }
            }
            if (stringBuffer != null) {
                AqMain.writeEvent(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

