/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.IpPort;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class IpPortImpl
implements IpPort {
    private final InetAddress addr;
    private final String addrString;
    private final int port;

    public IpPortImpl(InetSocketAddress inetSocketAddress) {
        this(inetSocketAddress.getAddress(), inetSocketAddress.getHostName(), inetSocketAddress.getPort());
    }

    public IpPortImpl(InetAddress inetAddress, String string, int n) {
        this.addr = inetAddress;
        this.addrString = string;
        this.port = n;
    }

    public IpPortImpl(String string, int n) throws UnknownHostException {
        this(InetAddress.getByName(string), string, n);
    }

    public IpPortImpl(String string) throws UnknownHostException {
        int n = string.indexOf(":");
        if (n == string.length() - 1) {
            throw new UnknownHostException("invalid hostport: " + string);
        }
        String string2 = string;
        int n2 = 80;
        if (n != -1) {
            string2 = string.substring(0, n);
            try {
                n2 = Integer.parseInt(string.substring(n + 1).trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnknownHostException("invalid hostport: " + string);
            }
        }
        this.addr = InetAddress.getByName(string2);
        this.addrString = string2;
        this.port = n2;
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public String getAddress() {
        return this.addrString;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "host: " + this.getAddress() + ", port: " + this.getPort();
    }
}

