/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.I18NConvert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class CommonUtils {
    private static final String LIMEWIRE_VERSION = "4.11.2";
    private static String testVersion = null;
    private static final int _majorVersionNumber = CommonUtils.getMajorVersionNumberInternal("4.11.2");
    private static final int _minorVersionNumber = CommonUtils.getMinorVersionNumberInternal("4.11.2");
    private static final int _serviceVersionNumber = CommonUtils.getServiceVersionNumberInternal("4.11.2");
    private static final int _guessMajorVersionNumber = 0;
    private static final int _guessMinorVersionNumber = 1;
    private static final int _upMajorVersionNumber = 0;
    private static final int _upMinorVersionNumber = 1;
    public static final String QHD_VENDOR_NAME = "LIME";
    private static final Properties PROPS = System.getProperties();
    private static boolean _isWindows = false;
    private static boolean _isWindowsNT = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsNTor2000orXP = false;
    private static boolean _isWindows2000orXP = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _isWindowsMe = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;
    private static boolean _isOS2 = false;
    private static final char[] ILLEGAL_CHARS_ANY_OS;
    private static final char[] ILLEGAL_CHARS_UNIX;
    private static final char[] ILLEGAL_CHARS_WINDOWS;
    private static final char[] ILLEGAL_CHARS_MACOS;
    private static final String HTTP_SERVER;
    private static final String LIMEWIRE_PREFS_DIR_NAME = ".cabos";
    private static final File CURRENT_DIRECTORY;
    private static boolean _isPro;
    static File SETTINGS_DIRECTORY;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        char[] cArray = new char[6];
        cArray[0] = 47;
        cArray[1] = 10;
        cArray[2] = 13;
        cArray[3] = 9;
        cArray[5] = 12;
        ILLEGAL_CHARS_ANY_OS = cArray;
        ILLEGAL_CHARS_UNIX = new char[]{'`'};
        ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};
        ILLEGAL_CHARS_MACOS = new char[]{':'};
        CURRENT_DIRECTORY = new File(PROPS.getProperty("user.dir"));
        _isPro = false;
        SETTINGS_DIRECTORY = null;
        CommonUtils.setOperatingSystems();
        HTTP_SERVER = "LimeWire/4.11.2 (Cabos/0.6.4)";
    }

    private CommonUtils() {
    }

    private static void setOperatingSystems() {
        _isWindows = false;
        _isWindowsNTor2000orXP = false;
        _isWindows2000orXP = false;
        _isWindowsNT = false;
        _isWindowsXP = false;
        _isWindows95 = false;
        _isWindows98 = false;
        _isWindowsMe = false;
        _isSolaris = false;
        _isLinux = false;
        _isOS2 = false;
        _isMacOSX = false;
        String string = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean bl = _isWindows = string.indexOf("windows") != -1;
        if (string.indexOf("windows nt") != -1 || string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
            _isWindowsNTor2000orXP = true;
        }
        if (string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
            _isWindows2000orXP = true;
        }
        if (string.indexOf("windows nt") != -1) {
            _isWindowsNT = true;
        }
        if (string.indexOf("windows xp") != -1) {
            _isWindowsXP = true;
        }
        if (string.indexOf("windows 95") != -1) {
            _isWindows95 = true;
        }
        if (string.indexOf("windows 98") != -1) {
            _isWindows98 = true;
        }
        if (string.indexOf("windows me") != -1) {
            _isWindowsMe = true;
        }
        _isSolaris = string.indexOf("solaris") != -1;
        _isLinux = string.indexOf("linux") != -1;
        boolean bl2 = _isOS2 = string.indexOf("os/2") != -1;
        if (_isWindows || _isLinux) {
            _supportsTray = true;
        }
        if (string.startsWith("mac os") && string.endsWith("x")) {
            _isMacOSX = true;
        }
    }

    public static int getGUESSMajorVersionNumber() {
        return 0;
    }

    public static int getGUESSMinorVersionNumber() {
        return 1;
    }

    public static int getUPMajorVersionNumber() {
        return 0;
    }

    public static int getUPMinorVersionNumber() {
        return 1;
    }

    public static String getLimeWireVersion() {
        if (testVersion == null) {
            return LIMEWIRE_VERSION;
        }
        return testVersion;
    }

    public static int getMajorVersionNumber() {
        return _majorVersionNumber;
    }

    public static int getMinorVersionNumber() {
        return _minorVersionNumber;
    }

    public static int getServiceVersionNumber() {
        return _serviceVersionNumber;
    }

    static int getMajorVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(0, n);
                return new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 2;
    }

    public static boolean isPro() {
        return _isPro;
    }

    public static boolean isTestingVersion() {
        return LIMEWIRE_VERSION.equals("@version@");
    }

    static int getMinorVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(n + 1);
                int n2 = string2.indexOf(".");
                String string3 = string2.substring(0, n2);
                return new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 7;
    }

    static int getServiceVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n;
                int n2 = string.indexOf(".");
                int n3 = string.indexOf(".", n2 + 1);
                int n4 = n = n3 + 1;
                while (n4 < string.length() && Character.isDigit(string.charAt(n4))) {
                    ++n4;
                }
                if (n != n4) {
                    String string2 = string.substring(n, n4);
                    return new Integer(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public static String getVendor() {
        return "Cabos 0.6.4";
    }

    public static String getHttpServer() {
        return HTTP_SERVER;
    }

    public static String getJavaVersion() {
        return PROPS.getProperty("java.version");
    }

    public static String getOS() {
        return PROPS.getProperty("os.name");
    }

    public static String getOSVersion() {
        return PROPS.getProperty("os.version");
    }

    public static File getCurrentDirectory() {
        return CURRENT_DIRECTORY;
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isUltrapeerOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsNTor2000orXP() {
        return _isWindowsNTor2000orXP;
    }

    public static boolean isWindows2000orXP() {
        return _isWindows2000orXP;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isOS2() {
        return _isOS2;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isJaguarOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.2");
    }

    public static boolean isPantherOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.3");
    }

    public static boolean isCocoaFoundationAvailable() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        try {
            Class.forName("com.apple.cocoa.foundation.NSUserDefaults");
            Class.forName("com.apple.cocoa.foundation.NSMutableDictionary");
            Class.forName("com.apple.cocoa.foundation.NSMutableArray");
            Class.forName("com.apple.cocoa.foundation.NSObject");
            Class.forName("com.apple.cocoa.foundation.NSSystem");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public static boolean isLog4JAvailable() {
        try {
            Class.forName("org.apache.log4j.LogManager");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public static boolean isAnyMac() {
        return _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isPOSIX() {
        return _isLinux || _isSolaris || _isMacOSX;
    }

    public static boolean isJava14OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.3") && !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static boolean isJava142OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.4.1") && !string.startsWith("1.4.0") && CommonUtils.isJava14OrLater();
    }

    public static boolean isJava15OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static boolean isJavaOutOfDate() {
        return CommonUtils.isWindows() && !CommonUtils.isSpecificJRE() && (CommonUtils.getJavaVersion().startsWith("1.3") || CommonUtils.getJavaVersion().startsWith("1.4.0"));
    }

    public static boolean isSpecificJRE() {
        return new File(".", "jre").isDirectory();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copy(File file, int n, File file2) {
        OutputStream outputStream;
        int n2;
        block18: {
            n2 = n;
            BufferedInputStream bufferedInputStream = null;
            outputStream = null;
            try {
                try {
                    int n3;
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    byte[] byArray = new byte[1024];
                    while (n2 > 0 && (n3 = ((InputStream)bufferedInputStream).read(byArray, 0, Math.min(1024, n2))) != -1) {
                        n2 -= n3;
                        outputStream.write(byArray, 0, n3);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream == null) throw throwable;
                try {
                    outputStream.flush();
                }
                catch (IOException iOException) {}
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (bufferedInputStream == null) break block18;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)bufferedInputStream).close();
        }
        if (outputStream == null) return n - n2;
        try {}
        catch (IOException iOException) {}
        outputStream.flush();
        try {}
        catch (IOException iOException) {
            return n - n2;
        }
        outputStream.close();
        return n - n2;
    }

    public static boolean copy(File file, File file2) {
        long l = file.length();
        return (long)CommonUtils.copy(file, (int)l, file2) == l;
    }

    public static File getUserHomeDir() {
        return new File(PROPS.getProperty("user.home"));
    }

    public static String getUserName() {
        return PROPS.getProperty("user.name");
    }

    private static synchronized void setUserSettingsDir(File file) throws IOException, SecurityException {
        if (!(file = file.getAbsoluteFile()).isDirectory()) {
            file.delete();
            if (!file.mkdirs()) {
                String string = "could not create preferences directory: " + file;
                throw new IOException(string);
            }
        }
        if (!file.canWrite()) {
            throw new IOException("settings dir not writable");
        }
        if (!file.canRead()) {
            throw new IOException("settings dir not readable");
        }
        SETTINGS_DIRECTORY = file;
    }

    public static synchronized File getUserSettingsDir() {
        if (SETTINGS_DIRECTORY != null) {
            return SETTINGS_DIRECTORY;
        }
        File file = new File(CommonUtils.getUserHomeDir(), LIMEWIRE_PREFS_DIR_NAME);
        if (CommonUtils.isWindows()) {
            File file2;
            String string = null;
            string = CommonUtils.isJava15OrLater() ? System.getProperty("LIMEWIRE_PREFS_DIR", System.getenv("APPDATA")) : System.getProperty("LIMEWIRE_PREFS_DIR", null);
            if ("%APPDATA%".equals(string)) {
                string = null;
            }
            if (string != null && string.length() > 0 && ((file2 = new File(string, "Cabos")).isDirectory() || !file.exists())) {
                try {
                    CommonUtils.setUserSettingsDir(file2);
                    return file2;
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {}
            }
        } else if (CommonUtils.isMacOSX()) {
            file = new File(CommonUtils.getUserHomeDir(), "Library/Application Support/Cabos");
        }
        try {
            CommonUtils.setUserSettingsDir(file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return file;
    }

    public static File getResourceFile(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.util.CommonUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            return new File(string);
        }
        return new File(CommonUtils.decode(uRL.getFile()));
    }

    public static InputStream getResourceStream(String string) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.util.CommonUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException("null resource: " + string);
        }
        return uRL.openStream();
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(string);
                    }
                    n += 2;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        try {
            byte[] byArray = string2.getBytes("8859_1");
            string2 = new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return string2;
    }

    public static void copyResourceFile(String string) {
        CommonUtils.copyResourceFile(string, null);
    }

    public static void copyResourceFile(String string, File file) {
        CommonUtils.copyResourceFile(string, file, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyResourceFile(String string, File file, boolean bl) {
        FilterOutputStream filterOutputStream;
        block22: {
            Class<?> clazz;
            if (file == null) {
                file = new File(".", string);
            }
            if (!bl && file.exists()) {
                return;
            }
            String string2 = file.getParent();
            if (string2 == null) {
                return;
            }
            File file2 = new File(string2);
            if (!file2.isDirectory()) {
                file2.mkdirs();
            }
            if ((clazz = class$0) == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("com.limegroup.gnutella.util.CommonUtils");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            BufferedInputStream bufferedInputStream = null;
            filterOutputStream = null;
            try {
                try {
                    URL uRL;
                    URL uRL2 = uRL = classLoader != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
                    if (uRL == null) {
                        throw new NullPointerException("resource: " + string + " doesn't exist.");
                    }
                    InputStream inputStream = uRL.openStream();
                    bufferedInputStream = new BufferedInputStream(inputStream, 2048);
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);
                    byte[] byArray = new byte[2048];
                    int n = 0;
                    do {
                        if ((n = bufferedInputStream.read(byArray, 0, 2048)) <= 0) continue;
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    } while (n == 2048);
                }
                catch (IOException iOException) {
                    file.delete();
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (filterOutputStream == null) throw throwable;
                try {
                    filterOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var12_14 = null;
                if (bufferedInputStream == null) break block22;
            }
            try {}
            catch (IOException iOException) {}
            bufferedInputStream.close();
        }
        if (filterOutputStream == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        filterOutputStream.close();
    }

    public static String convertFileName(File file, String string) {
        block8: {
            int n;
            block9: {
                block7: {
                    string = I18NConvert.instance().compose(string);
                    int n2 = 254 - file.getAbsolutePath().length();
                    if (string.length() > n2) {
                        n = string.lastIndexOf(46);
                        if (n == -1) {
                            string = string.substring(0, n2);
                        } else {
                            int n3 = string.length() - n;
                            int n4 = n3 > 11 ? n + 11 : string.length();
                            string = String.valueOf(string.substring(0, n2 - n3)) + string.substring(n, n4);
                        }
                    }
                    n = 0;
                    while (n < ILLEGAL_CHARS_ANY_OS.length) {
                        string = string.replace(ILLEGAL_CHARS_ANY_OS[n], '_');
                        ++n;
                    }
                    if (!_isWindows && !_isOS2) break block7;
                    n = 0;
                    while (n < ILLEGAL_CHARS_WINDOWS.length) {
                        string = string.replace(ILLEGAL_CHARS_WINDOWS[n], '_');
                        ++n;
                    }
                    break block8;
                }
                if (!_isLinux && !_isSolaris) break block9;
                n = 0;
                while (n < ILLEGAL_CHARS_UNIX.length) {
                    string = string.replace(ILLEGAL_CHARS_UNIX[n], '_');
                    ++n;
                }
                break block8;
            }
            if (!_isMacOSX) break block8;
            n = 0;
            while (n < ILLEGAL_CHARS_MACOS.length) {
                string = string.replace(ILLEGAL_CHARS_MACOS[n], '_');
                ++n;
            }
        }
        return string;
    }

    public static String seconds2time(int n) {
        int n2 = n / 60;
        n -= n2 * 60;
        int n3 = n2 / 60;
        n2 -= n3 * 60;
        int n4 = n3 / 24;
        n3 -= n4 * 24;
        StringBuffer stringBuffer = new StringBuffer();
        if (n4 != 0) {
            stringBuffer.append(Integer.toString(n4));
            stringBuffer.append(":");
            if (n3 < 10) {
                stringBuffer.append("0");
            }
        }
        if (n4 != 0 || n3 != 0) {
            stringBuffer.append(Integer.toString(n3));
            stringBuffer.append(":");
            if (n2 < 10) {
                stringBuffer.append("0");
            }
        }
        stringBuffer.append(Integer.toString(n2));
        stringBuffer.append(":");
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(n));
        return stringBuffer.toString();
    }

    public static String getAllStackTraces() {
        if (!CommonUtils.isJava15OrLater()) {
            return "";
        }
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Thread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method method = clazz.getDeclaredMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)method.invoke(null, new Object[0]);
            ArrayList arrayList = new ArrayList(map.entrySet());
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    Thread thread = (Thread)((Map.Entry)object).getKey();
                    Thread thread2 = (Thread)((Map.Entry)object2).getKey();
                    return thread.getName().compareTo(thread2.getName());
                }
            });
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Thread thread = (Thread)entry.getKey();
                StackTraceElement[] stackTraceElementArray = (StackTraceElement[])entry.getValue();
                stringBuffer.append(thread.getName()).append("\n");
                int n = 0;
                while (n < stackTraceElementArray.length) {
                    stringBuffer.append("    ").append(stackTraceElementArray[n]).append("\n");
                    ++n;
                }
                stringBuffer.append("\n");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("An error occured during getting the StackTraces of all active Threads");
            exception.printStackTrace(printWriter);
            printWriter.flush();
            return stringWriter.toString();
        }
    }
}

