/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.Stack;

public class ByteArrayCache {
    private static final int DEFAULT_SIZE = 512;
    private static final int DEFAULT_LENGTH = 1024;
    private final Stack CACHE = new Stack();
    private int _numCreated;
    private int _maxSize;
    private int _length;

    public ByteArrayCache() {
        this(512, 1024);
    }

    public ByteArrayCache(int n, int n2) {
        this._maxSize = n;
        this._length = n2;
        this.CACHE.ensureCapacity(n);
    }

    public synchronized byte[] get() throws InterruptedException {
        while (this.CACHE.isEmpty()) {
            if (this._numCreated < this._maxSize) {
                ++this._numCreated;
                return new byte[this._length];
            }
            this.wait();
        }
        return (byte[])this.CACHE.pop();
    }

    public synchronized byte[] getQuick() {
        if (!this.CACHE.isEmpty()) {
            return (byte[])this.CACHE.pop();
        }
        if (this._numCreated < this._maxSize) {
            ++this._numCreated;
            return new byte[this._length];
        }
        return null;
    }

    public synchronized void release(byte[] byArray) {
        this.CACHE.push(byArray);
        this.notifyAll();
    }

    public synchronized void clear() {
        this._numCreated -= this.CACHE.size();
        this.CACHE.clear();
        this.notifyAll();
    }

    public synchronized boolean isBufferAvailable() {
        return !this.CACHE.isEmpty() || this._numCreated < this._maxSize;
    }

    public synchronized int getCreated() {
        return this._numCreated;
    }

    public int getLength() {
        return this._length;
    }

    public int getMaxSize() {
        return this._maxSize;
    }
}

