/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BucketQueue
implements Cloneable {
    private Buffer[] buckets;
    private int size = 0;

    public BucketQueue(int n, int n2) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Bad priorities: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Bad capacity: " + n2);
        }
        this.buckets = new Buffer[n];
        int n3 = 0;
        while (n3 < this.buckets.length) {
            this.buckets[n3] = new Buffer(n2);
            ++n3;
        }
    }

    public BucketQueue(int[] nArray) throws IllegalArgumentException {
        if (nArray.length <= 0) {
            throw new IllegalArgumentException();
        }
        this.buckets = new Buffer[nArray.length];
        int n = 0;
        while (n < this.buckets.length) {
            if (nArray[n] <= 0) {
                throw new IllegalArgumentException("Non-positive capacity: " + nArray[n]);
            }
            this.buckets[n] = new Buffer(nArray[n]);
            ++n;
        }
    }

    public BucketQueue(BucketQueue bucketQueue) {
        this.buckets = new Buffer[bucketQueue.buckets.length];
        int n = 0;
        while (n < this.buckets.length) {
            this.buckets[n] = new Buffer(bucketQueue.buckets[n]);
            ++n;
        }
        this.size = bucketQueue.size;
    }

    public void clear() {
        this.repOk();
        int n = 0;
        while (n < this.buckets.length) {
            this.buckets[n].clear();
            ++n;
        }
        this.size = 0;
        this.repOk();
    }

    public Object insert(Object object, int n) {
        this.repOk();
        if (n < 0 || n >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + n);
        }
        Object object2 = this.buckets[n].addFirst(object);
        if (object2 == null) {
            ++this.size;
        }
        this.repOk();
        return object2;
    }

    public boolean removeAll(Object object) {
        this.repOk();
        boolean bl = false;
        int n = 0;
        while (n < this.buckets.length) {
            bl |= this.buckets[n].removeAll(object);
            ++n;
        }
        if (bl) {
            this.size = 0;
            n = 0;
            while (n < this.buckets.length) {
                this.size += this.buckets[n].getSize();
                ++n;
            }
        }
        this.repOk();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object extractMax() throws NoSuchElementException {
        this.repOk();
        try {
            int n = this.buckets.length - 1;
            while (true) {
                if (n < 0) {
                    throw new NoSuchElementException();
                }
                if (!this.buckets[n].isEmpty()) {
                    --this.size;
                    Object object = this.buckets[n].removeFirst();
                    Object var2_3 = null;
                    this.repOk();
                    return object;
                }
                --n;
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.repOk();
            throw throwable;
        }
    }

    public Object getMax() throws NoSuchElementException {
        int n = this.buckets.length - 1;
        while (n >= 0) {
            if (!this.buckets[n].isEmpty()) {
                return this.buckets[n].first();
            }
            --n;
        }
        throw new NoSuchElementException();
    }

    public int size() {
        return this.size;
    }

    public int size(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + n);
        }
        return this.buckets[n].getSize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new BucketQueueIterator(this.buckets.length - 1, this.size());
    }

    public Iterator iterator(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + n);
        }
        return new BucketQueueIterator(n, n2);
    }

    public Object clone() {
        return new BucketQueue(this);
    }

    private void repOk() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = this.buckets.length - 1;
        while (n >= 0) {
            if (n != this.buckets.length - 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.buckets[n].toString());
            --n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class BucketQueueIterator
    extends UnmodifiableIterator {
        private Iterator currentIterator;
        private int currentBucket;
        private int left;

        public BucketQueueIterator(int n, int n2) {
            this.currentBucket = n;
            this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
            this.left = n2;
        }

        public synchronized boolean hasNext() {
            if (this.left <= 0) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentBucket < 0) {
                return false;
            }
            --this.currentBucket;
            while (this.currentBucket >= 0) {
                this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                --this.currentBucket;
            }
            return false;
        }

        public synchronized Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.left;
            return this.currentIterator.next();
        }
    }
}

