/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LimitReachedUploadState
extends UploadState {
    private static final Log LOG;
    public static final String RETRY_AFTER_VALIDATING = "20";
    public static final int RETRY_AFTER_TIME = 900;
    private static final String NO_ALT_LOCS_RETRY_AFTER = "1200";
    private static final String NORMAL_RETRY_AFTER = "900";
    private static final byte[] ERROR_MESSAGE;
    private static final byte[] VALIDATING_MSG;
    private final boolean validating;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.uploader.LimitReachedUploadState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        ERROR_MESSAGE = "Server busy.  Too many active uploads.".getBytes();
        VALIDATING_MSG = "Validating file.  One moment please.".getBytes();
    }

    public LimitReachedUploadState(HTTPUploader hTTPUploader) {
        this(hTTPUploader, false);
    }

    public LimitReachedUploadState(HTTPUploader hTTPUploader, boolean bl) {
        super(hTTPUploader);
        this.validating = bl;
        LOG.debug((Object)"creating limit reached state");
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing headers");
        String string = "HTTP/1.1 503 Service Unavailable\r\n";
        outputStream.write(string.getBytes());
        string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Type: text/plain\r\n";
        outputStream.write(string.getBytes());
        this.writeProxies(outputStream);
        this.writeAlts(outputStream);
        byte[] byArray = ERROR_MESSAGE;
        if (this.FILE_DESC != null) {
            URN uRN = this.FILE_DESC.getSHA1Urn();
            if (this.validating) {
                byArray = VALIDATING_MSG;
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, RETRY_AFTER_VALIDATING, outputStream);
            } else if (uRN != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, !RouterService.getAltlocManager().hasAltlocs(uRN) ? NO_ALT_LOCS_RETRY_AFTER : NORMAL_RETRY_AFTER, outputStream);
                outputStream.write(string.getBytes());
                this.writeRanges(outputStream);
            } else {
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, NO_ALT_LOCS_RETRY_AFTER, outputStream);
            }
        }
        outputStream.write(string.getBytes());
        string = "Content-Length: " + byArray.length + "\r\n";
        HTTPUtils.writeHeader(HTTPHeaderName.CONNECTION, ConstantHTTPHeaderValue.CLOSE_VALUE, outputStream);
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing body");
        outputStream.write(ERROR_MESSAGE);
    }

    public boolean getCloseConnection() {
        return true;
    }
}

