/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.ChunkReleaser;
import com.limegroup.gnutella.udpconnect.DataMessage;
import com.limegroup.gnutella.udpconnect.DataRecord;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataWindow {
    private static final Log LOG;
    public static final int MAX_SEQUENCE_NUMBER = 65535;
    private static final int HIST_SIZE = 4;
    private static final float RTT_GAIN = 0.125f;
    private static final float DEVIATION_GAIN = 0.25f;
    private final HashMap window;
    private long windowStart;
    private int windowSize;
    private long averageRTT;
    private long averageLowRTT;
    private int lowRTTCount;
    private float srtt;
    private float rttvar;
    private float rto;
    private boolean readableData;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.udpconnect.DataWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public DataWindow(int n, long l) {
        this.windowStart = l;
        this.windowSize = n;
        this.window = new HashMap(n + 2);
    }

    public DataRecord addData(DataMessage dataMessage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding message seq " + dataMessage.getSequenceNumber() + " window start " + this.windowStart));
        }
        long l = dataMessage.getSequenceNumber();
        DataRecord dataRecord = new DataRecord(l, dataMessage);
        if (l == this.windowStart) {
            this.readableData = true;
        }
        this.window.put(dataRecord.pkey, dataRecord);
        return dataRecord;
    }

    public DataRecord getBlock(long l) {
        return (DataRecord)this.window.get(new Long(l));
    }

    public long getWindowStart() {
        return this.windowStart;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getUsedSpots() {
        int n = 0;
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 3L) {
            Long l2 = new Long(l);
            DataRecord dataRecord = (DataRecord)this.window.get(l2);
            if (!(dataRecord == null || dataRecord.read && l == this.windowStart)) {
                ++n;
            }
            ++l;
        }
        return n;
    }

    public int getWindowSpace() {
        return this.windowSize - this.getUsedSpots();
    }

    public int calculateWaitTime(long l, int n) {
        int n2 = 0;
        long l2 = 0L;
        long l3 = this.windowStart;
        while (l3 < this.windowStart + (long)this.windowSize + 1L) {
            Long l4 = new Long(l3);
            DataRecord dataRecord = (DataRecord)this.window.get(l4);
            if (dataRecord != null && dataRecord.acks == 0) {
                l2 += l - dataRecord.sentTime;
                if (++n2 >= n) break;
            }
            ++l3;
        }
        if (n2 > 0) {
            return (int)l2 / n2;
        }
        return 0;
    }

    public int clearLowAckedBlocks(ChunkReleaser chunkReleaser) {
        int n = 0;
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            Long l2 = new Long(l);
            DataRecord dataRecord = (DataRecord)this.window.get(l2);
            if (dataRecord == null || dataRecord.acks <= 0) break;
            if (chunkReleaser != null) {
                chunkReleaser.releaseChunk(dataRecord.msg.getChunk());
            }
            this.window.remove(l2);
            ++n;
            ++l;
        }
        this.windowStart += (long)n;
        return n;
    }

    public long getLowestUnsentBlock() {
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            Long l2 = new Long(l);
            if (this.window.get(l2) == null) {
                return l;
            }
            ++l;
        }
        return -1L;
    }

    public int countHigherAckBlocks() {
        int n = 0;
        long l = this.windowStart + 1L;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            Long l2 = new Long(l);
            DataRecord dataRecord = (DataRecord)this.window.get(l2);
            if (dataRecord != null && dataRecord.acks > 0) {
                ++n;
            }
            ++l;
        }
        return n;
    }

    public boolean acksAppearToBeMissing(long l, int n) {
        int n2 = (int)this.rto;
        DataRecord dataRecord = this.getBlock(this.windowStart);
        return n2 > 0 && dataRecord != null && dataRecord.acks < 1 && dataRecord.sentTime + (long)(n * n2) < l;
    }

    public int getRTO() {
        return (int)this.rto;
    }

    public float getRTTVar() {
        return this.rttvar;
    }

    public float getSRTT() {
        return this.srtt;
    }

    public int lowRoundTripTime() {
        return (int)this.averageLowRTT;
    }

    public void ackBlock(long l) {
        DataRecord dataRecord;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("entered ackBlock with # " + l));
        }
        if ((dataRecord = this.getBlock(l)) != null) {
            ++dataRecord.acks;
            dataRecord.ackTime = System.currentTimeMillis();
            if (dataRecord.acks == 1 && dataRecord.sends == 1) {
                long l2 = dataRecord.ackTime - dataRecord.sentTime;
                float f = (float)l2 - this.srtt;
                if (l2 > 0L) {
                    float f2;
                    this.srtt = (double)this.srtt <= 0.1 ? f : (this.srtt += 0.125f * f);
                    this.rttvar += 0.25f * (Math.abs(f) - this.rttvar);
                    this.rto = (float)((double)(this.srtt + 4.0f * this.rttvar) + 0.5);
                    if (this.averageRTT == 0L) {
                        this.averageRTT = l2;
                    } else {
                        f2 = (float)(this.averageRTT * 3L + l2) / 4.0f;
                        this.averageRTT = (long)f2;
                    }
                    if (this.lowRTTCount < 10 || l2 < this.averageLowRTT) {
                        if (this.averageLowRTT == 0L) {
                            this.averageLowRTT = l2;
                        } else {
                            f2 = (float)(this.averageLowRTT * 3L + l2) / 4.0f;
                            this.averageLowRTT = (long)f2;
                        }
                        ++this.lowRTTCount;
                    }
                }
            }
        }
    }

    public void pseudoAckToReceiverWindow(long l) {
        if (l <= this.windowStart) {
            return;
        }
        long l2 = this.windowStart;
        while (l2 < l) {
            DataRecord dataRecord = this.getBlock(l2);
            if (dataRecord != null && dataRecord.acks == 0) {
                ++dataRecord.acks;
                dataRecord.ackTime = dataRecord.sentTime + (long)((int)this.rto);
            }
            ++l2;
        }
    }

    public DataRecord getOldestUnackedBlock() {
        DataRecord dataRecord = null;
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            DataRecord dataRecord2 = this.getBlock(l);
            if (dataRecord2 != null && dataRecord2.acks == 0 && (dataRecord == null || dataRecord2.sentTime < dataRecord.sentTime)) {
                dataRecord = dataRecord2;
            }
            ++l;
        }
        return dataRecord;
    }

    public boolean hasReadableData() {
        return this.readableData;
    }

    public DataRecord getReadableBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("wStart " + this.windowStart + " wSize " + this.windowSize));
        }
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            DataRecord dataRecord = this.getBlock(l);
            if (dataRecord == null) break;
            if (!dataRecord.read) {
                return dataRecord;
            }
            ++l;
        }
        return null;
    }

    public int clearEarlyReadBlocks() {
        int n = 0;
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            Long l2 = new Long(l);
            DataRecord dataRecord = (DataRecord)this.window.get(l2);
            if (dataRecord != null && dataRecord.read) {
                this.window.remove(l2);
                ++n;
            } else {
                if (dataRecord == null) {
                    this.readableData = false;
                    break;
                }
                this.readableData = true;
                break;
            }
            ++l;
        }
        this.windowStart += (long)n;
        return n;
    }

    public DataRecord findMostAcked() {
        DataRecord dataRecord = null;
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            DataRecord dataRecord2 = this.getBlock(l);
            if (dataRecord == null) {
                dataRecord = dataRecord2;
            } else if (dataRecord2 != null && dataRecord.acks < dataRecord2.acks) {
                dataRecord = dataRecord2;
            }
            ++l;
        }
        return dataRecord;
    }

    public int numNotRead() {
        int n = 0;
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            DataRecord dataRecord = this.getBlock(l);
            if (dataRecord != null && !dataRecord.read) {
                ++n;
            }
            ++l;
        }
        return n;
    }

    public int numNotAcked() {
        int n = 0;
        long l = this.windowStart;
        while (l < this.windowStart + (long)this.windowSize + 1L) {
            DataRecord dataRecord = this.getBlock(l);
            if (dataRecord != null && dataRecord.acks <= 0) {
                ++n;
            }
            ++l;
        }
        return n;
    }

    public void printFinalStats() {
        System.out.println(" avgRTT:" + this.averageRTT + " lowRTT:" + this.averageLowRTT);
    }
}

