/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;

public class AckMessage
extends UDPConnectionMessage {
    private long _windowStart;
    private int _windowSpace;

    public AckMessage(byte by, long l, long l2, int n) {
        super(by, (byte)1, l, AckMessage.buildByteArray((int)l2 & 0xFFFF, n < 0 ? 0 : n), 4);
        this._windowStart = l2;
        this._windowSpace = n;
    }

    public AckMessage(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, byArray2);
        this._windowStart = AckMessage.getShortInt(byArray[4], byArray[5]);
        this._windowSpace = AckMessage.getShortInt(byArray[6], byArray[7]);
    }

    public long getWindowStart() {
        return this._windowStart;
    }

    public void extendWindowStart(long l) {
        this._windowStart = l;
    }

    public int getWindowSpace() {
        return this._windowSpace;
    }

    public String toString() {
        return "AckMessage DestID:" + this.getConnectionID() + " start:" + this._windowStart + " space:" + this._windowSpace + " seq:" + this.getSequenceNumber();
    }
}

