/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.Tokenizer;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RatingTable {
    private static final Log LOG;
    private static final int MAX_SIZE = 50000;
    private static final RatingTable INSTANCE;
    private final Map _tokenMap = this.readData();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.spam.Tokenizer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new RatingTable();
    }

    public static RatingTable instance() {
        return INSTANCE;
    }

    private RatingTable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("size of tokenSet " + this._tokenMap.size()));
        }
    }

    synchronized void clear() {
        this._tokenMap.clear();
    }

    float getRating(RemoteFileDesc remoteFileDesc) {
        float f = this.getRating(this.lookup(Tokenizer.getTokens(remoteFileDesc)));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(String.valueOf(remoteFileDesc.toString()) + " rated " + f));
        }
        return f;
    }

    float getRating(Token[] tokenArray) {
        float f = 1.0f;
        int n = 0;
        while (n < tokenArray.length && f > 0.0f) {
            f *= 1.0f - tokenArray[n].getRating();
            ++n;
        }
        float f2 = SearchSettings.FILTER_SPAM_RESULTS.getValue();
        if ((f = 1.0f - f) >= f2 && f <= 0.995f) {
            this.markInternal(tokenArray, 2);
        } else if (f <= 1.0f - f2) {
            this.markInternal(tokenArray, 4);
        }
        return f;
    }

    void mark(RemoteFileDesc[] remoteFileDescArray, int n) {
        this.markInternal(this.lookup(Tokenizer.getTokens(remoteFileDescArray)), n);
    }

    void mark(RemoteFileDesc remoteFileDesc, int n) {
        this.markInternal(this.lookup(Tokenizer.getTokens(remoteFileDesc)), n);
    }

    void mark(QueryRequest queryRequest, int n) {
        this.markInternal(this.lookup(Tokenizer.getTokens(queryRequest)), n);
    }

    private void markInternal(Token[] tokenArray, int n) {
        int n2 = 0;
        while (n2 < tokenArray.length) {
            tokenArray[n2].rate(n);
            ++n2;
        }
    }

    private Token[] lookup(Token[] tokenArray) {
        int n = 0;
        while (n < tokenArray.length) {
            tokenArray[n] = this.lookup(tokenArray[n]);
            ++n;
        }
        return tokenArray;
    }

    private synchronized Token lookup(Token token) {
        Token token2 = (Token)this._tokenMap.get(token);
        if (token2 == null) {
            this._tokenMap.put(token, token);
            this.checkSize();
            token2 = token;
        }
        return token2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map readData() {
        HashMap hashMap;
        ObjectInputStream objectInputStream;
        block6: {
            Map map;
            block5: {
                objectInputStream = null;
                try {
                    try {
                        objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(RatingTable.getSpamDat())));
                        Object object = objectInputStream.readObject();
                        if (object instanceof Map) {
                            map = (Map)object;
                            Object var3_6 = null;
                            break block5;
                        }
                        hashMap = new HashMap();
                        break block6;
                    }
                    catch (Exception exception) {
                        HashMap hashMap2 = new HashMap();
                        Object var3_8 = null;
                        IOUtils.close(objectInputStream);
                        return hashMap2;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    IOUtils.close(objectInputStream);
                    throw throwable;
                }
            }
            IOUtils.close(objectInputStream);
            return map;
        }
        Object var3_7 = null;
        IOUtils.close(objectInputStream);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        HashMap hashMap;
        Object object = this;
        synchronized (object) {
            if (this._tokenMap.size() > 50000) {
                this.pruneEntries();
            }
            hashMap = new HashMap(this._tokenMap);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("size of tokenMap " + hashMap.size()));
        }
        object = null;
        try {
            try {
                object = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(RatingTable.getSpamDat())));
                ((ObjectOutputStream)object).writeObject(hashMap);
                ((ObjectOutputStream)object).flush();
            }
            catch (IOException iOException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"saving rating table failed", (Throwable)iOException);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            IOUtils.close((OutputStream)object);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        IOUtils.close((OutputStream)object);
    }

    public synchronized void ageAndSave() {
        Iterator iterator = this._tokenMap.values().iterator();
        while (iterator.hasNext()) {
            ((Token)iterator.next()).incrementAge();
        }
        this.save();
    }

    private synchronized void checkSize() {
        if (this._tokenMap.size() < 100000) {
            return;
        }
        this.pruneEntries();
    }

    private void pruneEntries() {
        int n;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"pruning unimportant entries from RatingTable");
        }
        if ((n = this._tokenMap.size() - 50000) <= 0) {
            return;
        }
        TreeSet treeSet = new TreeSet(this._tokenMap.values());
        Iterator iterator = treeSet.iterator();
        while (n > 0) {
            this._tokenMap.remove(iterator.next());
            --n;
        }
    }

    private static File getSpamDat() {
        return new File(CommonUtils.getUserSettingsDir(), "spam.dat");
    }
}

