/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Constants;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class UDPCrawlerPong
extends VendorMessage {
    public static final int VERSION = 1;
    public static final String AGENT_SEP = ";";
    private String _agents;
    private List _ultrapeers;
    private List _leaves;
    final boolean _connectionTime;
    final boolean _localeInfo;
    final boolean _newOnly;
    final boolean _userAgent;
    private final byte _format;

    public UDPCrawlerPong(UDPCrawlerPing uDPCrawlerPing) {
        super(F_LIME_VENDOR_ID, 6, 1, UDPCrawlerPong.derivePayload(uDPCrawlerPing));
        this.setGUID(new GUID(uDPCrawlerPing.getGUID()));
        this._format = (byte)(uDPCrawlerPing.getFormat() & 0xF);
        this._localeInfo = uDPCrawlerPing.hasLocaleInfo();
        this._connectionTime = uDPCrawlerPing.hasConnectionTime();
        this._newOnly = uDPCrawlerPing.hasNewOnly();
        this._userAgent = uDPCrawlerPing.hasUserAgent();
    }

    private static byte[] derivePayload(UDPCrawlerPing uDPCrawlerPing) {
        Object object;
        Object object2;
        Object object3;
        byte by = (byte)(uDPCrawlerPing.getFormat() & 0xF);
        List list = new LinkedList<Connection>();
        List list2 = new LinkedList<Object>();
        Iterator iterator = RouterService.getConnectionManager().getInitializedConnections().iterator();
        boolean bl = uDPCrawlerPing.hasNewOnly();
        while (iterator.hasNext()) {
            object3 = (Connection)iterator.next();
            if (bl) {
                if (((Connection)object3).remoteHostSupportsUDPCrawling() < 1) continue;
                list.add(object3);
                continue;
            }
            if (!((Connection)object3).isGoodUltrapeer()) continue;
            list.add(object3);
        }
        iterator = RouterService.getConnectionManager().getInitializedClientConnections().iterator();
        while (iterator.hasNext()) {
            object3 = (Connection)iterator.next();
            list2.add(object3);
        }
        if (!uDPCrawlerPing.hasLocaleInfo()) {
            if (uDPCrawlerPing.getNumberUP() != -1 && uDPCrawlerPing.getNumberUP() < list.size()) {
                int n = (int)Math.floor(Math.random() * (double)(list.size() - uDPCrawlerPing.getNumberUP()));
                list = list.subList(n, n + uDPCrawlerPing.getNumberUP());
            }
            if (uDPCrawlerPing.getNumberLeaves() != -1 && uDPCrawlerPing.getNumberLeaves() < list2.size()) {
                int n = (int)Math.floor(Math.random() * (double)(list2.size() - uDPCrawlerPing.getNumberLeaves()));
                list2 = list2.subList(n, n + uDPCrawlerPing.getNumberLeaves());
            }
        } else {
            object3 = ApplicationSettings.LANGUAGE.getValue();
            object2 = RouterService.getConnectionManager().getInitializedConnectionsMatchLocale((String)object3);
            list.removeAll((Collection<?>)object2);
            object2.addAll(list);
            list = object2;
            object2 = RouterService.getConnectionManager().getInitializedClientConnectionsMatchLocale((String)object3);
            list2.removeAll((Collection<?>)object2);
            object2.addAll(list2);
            list2 = object2;
            if (uDPCrawlerPing.getNumberUP() != -1 && uDPCrawlerPing.getNumberUP() < list.size()) {
                list = list.subList(0, uDPCrawlerPing.getNumberUP());
            }
            if (uDPCrawlerPing.getNumberLeaves() != -1 && uDPCrawlerPing.getNumberLeaves() < list2.size()) {
                list2 = list2.subList(0, uDPCrawlerPing.getNumberLeaves());
            }
        }
        int n = 6;
        if (uDPCrawlerPing.hasConnectionTime()) {
            n += 2;
        }
        if (uDPCrawlerPing.hasLocaleInfo()) {
            n += 2;
        }
        object2 = new byte[(list.size() + list2.size()) * n + 3];
        object2[0] = (byte)list.size();
        object2[1] = (byte)list2.size();
        object2[2] = by;
        list.addAll(list2);
        long l = System.currentTimeMillis();
        int n2 = 3;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Connection)iterator.next();
            System.arraycopy(UDPCrawlerPong.packIPAddress(((Connection)object).getInetAddress(), ((Connection)object).getPort()), 0, object2, n2, 6);
            n2 += 6;
            if (uDPCrawlerPing.hasConnectionTime()) {
                long l2 = l - ((Connection)object).getConnectionTime();
                short s = (short)(l2 / Constants.MINUTE);
                ByteOrder.short2leb(s, (byte[])object2, n2);
                n2 += 2;
            }
            if (!uDPCrawlerPing.hasLocaleInfo()) continue;
            System.arraycopy(((Connection)object).getLocalePref().getBytes(), 0, object2, n2, 2);
            n2 += 2;
        }
        if (uDPCrawlerPing.hasUserAgent()) {
            Object object4;
            object = new StringBuffer();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                object4 = connection.getUserAgent();
                object4 = StringUtils.replace((String)object4, AGENT_SEP, "\\;");
                ((StringBuffer)object).append((String)object4).append(AGENT_SEP);
            }
            ((StringBuffer)object).append(CommonUtils.getHttpServer());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                object4 = new GZIPOutputStream(byteArrayOutputStream);
                byte[] byArray = new byte[2];
                ByteOrder.short2leb((short)((StringBuffer)object).length(), byArray, 0);
                ((FilterOutputStream)object4).write(byArray);
                ((FilterOutputStream)object4).write(((StringBuffer)object).toString().getBytes());
                ((DeflaterOutputStream)object4).flush();
                ((DeflaterOutputStream)object4).close();
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            object4 = byteArrayOutputStream.toByteArray();
            Object object5 = object2;
            object2 = new byte[((Object)object2).length + ((Object)object4).length + 2];
            System.arraycopy(object5, 0, object2, 0, ((Object)object5).length);
            ByteOrder.short2leb((short)((Object)object4).length, (byte[])object2, ((Object)object5).length);
            System.arraycopy(object4, 0, object2, ((Object)object5).length + 2, ((Object)object4).length);
        }
        return object2;
    }

    private static byte[] packIPAddress(InetAddress inetAddress, int n) {
        try {
            IPPortCombo iPPortCombo = new IPPortCombo(inetAddress.getHostAddress(), n);
            return iPPortCombo.toBytes();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(unknownHostException.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected UDPCrawlerPong(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 6, n, byArray2);
        String string;
        Object object;
        Object object2;
        Object object3;
        int n2;
        this._ultrapeers = new LinkedList();
        this._leaves = new LinkedList();
        if (this.getVersion() == 1) {
            if (byArray2 == null) throw new BadPacketException();
            if (byArray2.length < 3) {
                throw new BadPacketException();
            }
        }
        byte by3 = byArray2[0];
        byte by4 = byArray2[1];
        this._format = (byte)(byArray2[2] & 0xF);
        this._connectionTime = (this._format & 1) == 1;
        this._localeInfo = (this._format & 2) == 2;
        this._newOnly = (this._format & 4) == 4;
        this._userAgent = (this._format & 8) == 8;
        int n3 = 6;
        if (this._connectionTime) {
            n3 += 2;
        }
        if (this._localeInfo) {
            n3 += 2;
        }
        int n4 = (by3 + by4) * n3 + 3;
        if (this.getVersion() == 1 && byArray2.length < n4) {
            throw new BadPacketException("size is " + byArray2.length + " but should have been at least" + n4);
        }
        int n5 = 3;
        while (true) {
            if (n5 >= by3 * n3) break;
            n2 = n5;
            object3 = new byte[6];
            System.arraycopy(byArray2, n2, object3, 0, 6);
            n2 += 6;
            object2 = IPPortCombo.getCombo(object3);
            if (object2 == null) throw new BadPacketException("parsing of ip:port failed.  dump of current byte block: " + object3);
            if (((IPPortCombo)object2).getInetAddress() == null) {
                throw new BadPacketException("parsing of ip:port failed.  dump of current byte block: " + object3);
            }
            object = new ExtendedEndpoint(((IPPortCombo)object2).getInetAddress(), ((IPPortCombo)object2).getPort());
            if (this._connectionTime) {
                ((ExtendedEndpoint)object).setDailyUptime(ByteOrder.leb2short(byArray2, n2));
                n2 += 2;
            }
            if (this._localeInfo) {
                string = new String(byArray2, n2, 2);
                ((ExtendedEndpoint)object).setClientLocale(string);
                n2 += 2;
            }
            this._ultrapeers.add(object);
            n5 += n3;
        }
        n5 = by3 * n3 + 3;
        while (true) {
            if (n5 >= n4) {
                if (!this._userAgent) return;
                n5 = ByteOrder.leb2short(byArray2, n4);
                if (byArray2.length >= n5 + n4 + 2) break;
                throw new BadPacketException("payload is " + byArray2.length + " but should have been at least " + (n4 + n5 + 2));
            }
            n2 = n5;
            object3 = new byte[6];
            System.arraycopy(byArray2, n2, object3, 0, 6);
            n2 += 6;
            object2 = IPPortCombo.getCombo(object3);
            if (object2 == null) throw new BadPacketException("parsing of ip:port failed.  dump of current byte block: " + object3);
            if (((IPPortCombo)object2).getInetAddress() == null) {
                throw new BadPacketException("parsing of ip:port failed.  dump of current byte block: " + object3);
            }
            object = new ExtendedEndpoint(((IPPortCombo)object2).getInetAddress(), ((IPPortCombo)object2).getPort());
            if (this._connectionTime) {
                ((ExtendedEndpoint)object).setDailyUptime(ByteOrder.leb2short(byArray2, n2));
                n2 += 2;
            }
            if (this._localeInfo) {
                string = new String(byArray2, n2, 2);
                ((ExtendedEndpoint)object).setClientLocale(string);
                n2 += 2;
            }
            this._leaves.add(object);
            n5 += n3;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, n4 + 2, n5);
        object3 = null;
        try {
            try {
                object3 = new GZIPInputStream(byteArrayInputStream);
                object2 = new DataInputStream((InputStream)object3);
                object = new byte[2];
                ((DataInputStream)object2).readFully((byte[])object);
                short s = ByteOrder.leb2short((byte[])object, 0);
                byte[] byArray3 = new byte[s];
                ((DataInputStream)object2).readFully(byArray3);
                this._agents = new String(byArray3);
            }
            catch (IOException iOException) {
                throw new BadPacketException("invalid compressed agent data");
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            IOUtils.close((InputStream)object3);
            throw throwable;
        }
        {
            Object var17_21 = null;
        }
        IOUtils.close((InputStream)object3);
    }

    public List getUltrapeers() {
        return this._ultrapeers;
    }

    public List getLeaves() {
        return this._leaves;
    }

    public boolean hasConnectionTime() {
        return this._connectionTime;
    }

    public boolean hasLocaleInfo() {
        return this._localeInfo;
    }

    public String getAgents() {
        return this._agents;
    }
}

