/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.messages.SecureMessage;
import com.limegroup.gnutella.messages.SecureMessageCallback;
import com.limegroup.gnutella.security.SignatureVerifier;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecureMessageVerifier {
    private static final Log LOG;
    private final ProcessingQueue QUEUE = new ProcessingQueue("SecureMessageVerifier");
    private PublicKey pubKey;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.messages.SecureMessageVerifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void verify(SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
        this.QUEUE.add(new Verifier(secureMessage, secureMessageCallback));
    }

    private void initializePublicKey() {
        if (this.pubKey == null) {
            this.pubKey = this.createPublicKey();
        }
    }

    protected PublicKey createPublicKey() {
        return SignatureVerifier.readKey(this.getKeyFile(), "DSA");
    }

    protected File getKeyFile() {
        return new File(CommonUtils.getUserSettingsDir(), "secureMessage.key");
    }

    private void verifyMessage(SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
        if (this.pubKey == null) {
            LOG.warn((Object)"Cannot verify message without a public key.");
            secureMessage.setSecureStatus(0);
            secureMessageCallback.handleSecureMessage(secureMessage, false);
            return;
        }
        byte[] byArray = secureMessage.getSecureSignature();
        if (byArray == null) {
            LOG.warn((Object)"Cannot verify message without a signature.");
            secureMessage.setSecureStatus(0);
            secureMessageCallback.handleSecureMessage(secureMessage, false);
            return;
        }
        try {
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(this.pubKey);
            secureMessage.updateSignatureWithSecuredBytes(signature);
            if (signature.verify(byArray)) {
                secureMessage.setSecureStatus(2);
                secureMessageCallback.handleSecureMessage(secureMessage, true);
                return;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)"No alg.", (Throwable)noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            LOG.error((Object)"Invalid key", (Throwable)invalidKeyException);
        }
        catch (SignatureException signatureException) {
            LOG.error((Object)"Bad sig", (Throwable)signatureException);
        }
        catch (ClassCastException classCastException) {
            LOG.error((Object)"bad cast", (Throwable)classCastException);
        }
        secureMessage.setSecureStatus(1);
        secureMessageCallback.handleSecureMessage(secureMessage, false);
    }

    private class Verifier
    implements Runnable {
        private final SecureMessage message;
        private final SecureMessageCallback callback;

        Verifier(SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
            this.message = secureMessage;
            this.callback = secureMessageCallback;
        }

        public void run() {
            SecureMessageVerifier.this.initializePublicKey();
            SecureMessageVerifier.this.verifyMessage(this.message, this.callback);
        }
    }
}

