/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.Timeoutable;
import com.limegroup.gnutella.util.BinaryHeap;

public class TimeoutController {
    private final BinaryHeap items = new BinaryHeap(20, true);

    public void addTimeout(Timeoutable timeoutable, long l, long l2) {
        this.items.insert(new Timeout(timeoutable, l, l2));
    }

    public void processTimeouts(long l) {
        while (!this.items.isEmpty()) {
            Timeout timeout = (Timeout)this.items.getMax();
            if (timeout == null || l < timeout.expireTime) break;
            timeout.timeoutable.notifyTimeout(l, timeout.expireTime, timeout.timeoutLength);
            this.items.extractMax();
        }
    }

    public long getNextExpireTime() {
        if (this.items.isEmpty()) {
            return -1L;
        }
        return ((Timeout)this.items.getMax()).expireTime;
    }

    private static class Timeout
    implements Comparable {
        private long expireTime;
        private Timeoutable timeoutable;
        private long timeoutLength;

        Timeout(Timeoutable timeoutable, long l, long l2) {
            this.expireTime = l + l2;
            this.timeoutLength = l2;
            this.timeoutable = timeoutable;
        }

        public int compareTo(Object object) {
            Timeout timeout = (Timeout)object;
            return this.expireTime < timeout.expireTime ? 1 : (this.expireTime > timeout.expireTime ? -1 : 0);
        }
    }
}

