/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.AcceptChannelObserver;
import com.limegroup.gnutella.io.AcceptObserver;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NIOServerSocket
extends ServerSocket
implements AcceptChannelObserver {
    private static final Log LOG;
    private final ServerSocketChannel channel = ServerSocketChannel.open();
    private final ServerSocket socket = this.channel.socket();
    private final AcceptObserver observer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.NIOServerSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public NIOServerSocket() throws IOException {
        this((AcceptObserver)null);
    }

    public NIOServerSocket(AcceptObserver acceptObserver) throws IOException {
        this.init();
        this.observer = acceptObserver == null ? new BlockingObserver() : acceptObserver;
    }

    public NIOServerSocket(int n) throws IOException {
        this(n, null);
    }

    public NIOServerSocket(int n, AcceptObserver acceptObserver) throws IOException {
        this(acceptObserver);
        this.bind(new InetSocketAddress(n));
    }

    public NIOServerSocket(int n, int n2) throws IOException {
        this(n, n2, (AcceptObserver)null);
    }

    public NIOServerSocket(int n, int n2, AcceptObserver acceptObserver) throws IOException {
        this(acceptObserver);
        this.bind(new InetSocketAddress(n), n2);
    }

    public NIOServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this(n, n2, inetAddress, null);
    }

    public NIOServerSocket(int n, int n2, InetAddress inetAddress, AcceptObserver acceptObserver) throws IOException {
        this(acceptObserver);
        this.bind(new InetSocketAddress(inetAddress, n), n2);
    }

    private void init() throws IOException {
        this.channel.configureBlocking(false);
    }

    public Socket accept() throws IOException {
        if (this.observer instanceof BlockingObserver) {
            return ((BlockingObserver)this.observer).accept();
        }
        throw new IllegalBlockingModeException();
    }

    public void handleAcceptChannel(SocketChannel socketChannel) throws IOException {
        this.observer.handleAccept(new NIOSocket(socketChannel.socket()));
    }

    public void handleIOException(IOException iOException) {
        this.observer.handleIOException(iOException);
    }

    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.socket.bind(socketAddress);
        NIODispatcher.instance().registerAccept(this.channel, this);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        this.socket.bind(socketAddress, n);
        NIODispatcher.instance().registerAccept(this.channel, this);
    }

    public void close() throws IOException {
        IOException iOException = null;
        try {
            this.socket.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.observer.shutdown();
        if (iOException != null) {
            throw iOException;
        }
    }

    public ServerSocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSoTimeout() throws IOException {
        return this.socket.getSoTimeout();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.socket.setReceiveBufferSize(n);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.socket.setReuseAddress(bl);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public String toString() {
        return "NIOServerSocket::" + this.socket.toString();
    }

    private class BlockingObserver
    implements AcceptObserver {
        private final List pendingSockets = new LinkedList();
        private IOException storedException = null;
        private final Object LOCK = new Object();

        BlockingObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket accept() throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                boolean bl = false;
                int n = NIOServerSocket.this.getSoTimeout();
                while (!NIOServerSocket.this.isClosed() && NIOServerSocket.this.isBound() && this.storedException == null && this.pendingSockets.isEmpty()) {
                    if (bl && n != 0) {
                        throw new SocketTimeoutException("accept timed out: " + n);
                    }
                    LOG.debug((Object)"Waiting for incoming socket...");
                    try {
                        this.LOCK.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException(interruptedException);
                    }
                    bl = true;
                }
                IOException iOException = this.storedException;
                this.storedException = null;
                if (NIOServerSocket.this.isClosed()) {
                    throw new SocketException("Socket Closed");
                }
                if (iOException != null) {
                    throw iOException;
                }
                if (!NIOServerSocket.this.isBound()) {
                    throw new SocketException("Not Bound!");
                }
                LOG.debug((Object)"Retrieved a socket!");
                return (Socket)this.pendingSockets.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAccept(Socket socket) throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                this.pendingSockets.add(socket);
                this.LOCK.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleIOException(IOException iOException) {
            Object object = this.LOCK;
            synchronized (object) {
                this.storedException = iOException;
                this.LOCK.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.LOCK;
            synchronized (object) {
                Iterator iterator = this.pendingSockets.iterator();
                while (iterator.hasNext()) {
                    NIOSocket nIOSocket = (NIOSocket)iterator.next();
                    nIOSocket.close();
                }
                this.pendingSockets.clear();
                this.LOCK.notify();
            }
        }
    }
}

