/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferOutputStream;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class NIOOutputStream
implements WriteObserver {
    private final Shutdownable handler;
    private final InterestWriteChannel channel;
    private BufferOutputStream sink;
    private volatile Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;

    NIOOutputStream(Shutdownable shutdownable, InterestWriteChannel interestWriteChannel) {
        this.handler = shutdownable;
        this.channel = interestWriteChannel;
    }

    private synchronized NIOOutputStream init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("already closed!");
        }
        this.buffer = NIODispatcher.instance().getBufferCache().getHeap();
        this.sink = new BufferOutputStream(this.buffer, this.handler, this, this.channel);
        this.bufferLock = this.sink.getBufferLock();
        return this;
    }

    synchronized OutputStream getOutputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        if (this.buffer == null) {
            return false;
        }
        Object object = this.bufferLock;
        synchronized (object) {
            block11: {
                this.buffer.flip();
                while (this.buffer.hasRemaining() && this.channel.write(this.buffer) > 0) {
                }
                if (this.buffer.position() > 0) {
                    if (this.buffer.hasRemaining()) {
                        this.buffer.compact();
                    } else {
                        this.buffer.clear();
                    }
                } else {
                    this.buffer.position(this.buffer.limit()).limit(this.buffer.capacity());
                }
                if (this.buffer.hasRemaining()) {
                    this.bufferLock.notify();
                }
                if (this.buffer.position() != 0) break block11;
                this.channel.interest(this, false);
                return false;
            }
            return true;
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        if (this.buffer != null) {
            NIODispatcher.instance().getBufferCache().release(this.buffer);
        }
        if (this.sink != null) {
            this.sink.shutdown();
        }
        this.shutdown = true;
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("unsupported operation", iOException);
    }
}

