/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.BlockingHandshakeSupport;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.statistics.HandshakingStat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class BlockingIncomingHandshaker
implements Handshaker {
    private HandshakeResponder responder;
    private BlockingHandshakeSupport support;

    public BlockingIncomingHandshaker(HandshakeResponder handshakeResponder, Socket socket, InputStream inputStream, OutputStream outputStream) {
        this.responder = handshakeResponder;
        this.support = new BlockingHandshakeSupport(socket, inputStream, outputStream);
    }

    public void shake() throws IOException, BadHandshakeException, NoGnutellaOkException {
        this.initializeIncoming();
        this.concludeIncomingHandshake();
    }

    public HandshakeResponse getReadHeaders() {
        return this.support.getReadHandshakeResponse();
    }

    public HandshakeResponse getWrittenHeaders() {
        return this.support.getWrittenHandshakeResponse();
    }

    private void initializeIncoming() throws IOException {
        String string = this.support.readLine();
        if (!this.support.notLessThan06(string)) {
            throw new IOException("Unexpected connect string: " + string);
        }
        this.support.readHeaders();
    }

    private void concludeIncomingHandshake() throws IOException {
        HandshakeResponse handshakeResponse = this.support.getReadHandshakeResponse();
        HandshakeResponse handshakeResponse2 = this.responder.respond(handshakeResponse, false);
        this.support.writeResponse(handshakeResponse2);
        if (handshakeResponse.isCrawler()) {
            this.support.readLine();
            throw new IOException("crawler");
        }
        switch (handshakeResponse2.getStatusCode()) {
            case 200: {
                break;
            }
            case 503: {
                HandshakingStat.INCOMING_CLIENT_REJECT.incrementStat();
                throw NoGnutellaOkException.CLIENT_REJECT;
            }
            default: {
                HandshakingStat.INCOMING_CLIENT_UNKNOWN.incrementStat();
                throw NoGnutellaOkException.createClientUnknown(handshakeResponse2.getStatusCode());
            }
        }
        String string = this.support.readLine();
        if (!this.support.isConnectLineValid(string)) {
            HandshakingStat.INCOMING_BAD_CONNECT.incrementStat();
            throw new IOException("Bad connect string");
        }
        this.support.readHeaders();
        HandshakeResponse handshakeResponse3 = this.support.createRemoteResponse(string);
        switch (handshakeResponse3.getStatusCode()) {
            case 200: {
                HandshakingStat.SUCCESSFUL_INCOMING.incrementStat();
                break;
            }
            default: {
                HandshakingStat.INCOMING_SERVER_UNKNOWN.incrementStat();
                throw NoGnutellaOkException.createServerUnknown(handshakeResponse3.getStatusCode());
            }
        }
    }
}

