/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;

class BlockingHandshakeSupport
extends HandshakeSupport {
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    BlockingHandshakeSupport(Socket socket, InputStream inputStream, OutputStream outputStream) {
        super(socket.getInetAddress().getHostAddress());
        this.socket = socket;
        this.in = inputStream;
        this.out = outputStream;
    }

    String readLine() throws IOException {
        return this.readLine(8000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readLine(int n) throws IOException {
        String string;
        int n2 = this.socket.getSoTimeout();
        try {
            try {
                this.socket.setSoTimeout(n);
                String string2 = new ByteReader(this.in).readLine();
                if (string2 == null) {
                    throw new IOException("read null line");
                }
                BandwidthStat.GNUTELLA_HEADER_DOWNSTREAM_BANDWIDTH.addData(string2.length());
                string = string2;
                Object var4_5 = null;
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.socket.setSoTimeout(n2);
            throw throwable;
        }
        this.socket.setSoTimeout(n2);
        return string;
    }

    void readHeaders() throws IOException {
        this.readHeaders(8000);
    }

    void readHeaders(int n) throws IOException {
        block2: {
            do {
                String string;
                if ((string = this.readLine(n)) == null) {
                    throw new IOException("unexpected end of file");
                }
                if (!this.processReadHeader(string)) break block2;
            } while (this.getHeadersReadSize() <= ConnectionSettings.MAX_HANDSHAKE_HEADERS.getValue());
            throw new IOException("too many headers");
        }
    }

    void writeConnectLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendConnectLine(stringBuffer);
        this.writeLine(stringBuffer.toString());
    }

    void writeResponse(HandshakeResponse handshakeResponse) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendResponse(handshakeResponse, stringBuffer);
        this.writeLine(stringBuffer.toString());
    }

    void writeLine(String string) throws IOException {
        if (string == null || string.equals("")) {
            throw new NullPointerException("null or empty string: " + string);
        }
        byte[] byArray = string.getBytes();
        BandwidthStat.GNUTELLA_HEADER_UPSTREAM_BANDWIDTH.addData(byArray.length);
        this.out.write(byArray);
        this.out.flush();
    }

    void sendHeaders(Properties properties) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendHeaders(properties, stringBuffer);
        this.writeLine(stringBuffer.toString());
    }
}

