/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.Serializable;

public class ResumeDownloader
extends ManagedDownloader
implements Serializable {
    static final long serialVersionUID = -4535935715006098724L;
    private final File _incompleteFile;
    private final String _name;
    private final int _size;
    private final URN _hash;

    public ResumeDownloader(IncompleteFileManager incompleteFileManager, File file, String string, int n) {
        super(new RemoteFileDesc[0], incompleteFileManager, null);
        if (file == null) {
            throw new NullPointerException("null incompleteFile");
        }
        this._incompleteFile = file;
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Bad name in ResumeDownloader");
        }
        this._name = string;
        this._size = n;
        this._hash = incompleteFileManager.getCompletedHash(file);
    }

    public void initialize(DownloadManager downloadManager, FileManager fileManager, DownloadCallback downloadCallback) {
        if (this._hash != null) {
            this.downloadSHA1 = this._hash;
        }
        this.incompleteFile = this._incompleteFile;
        super.initialize(downloadManager, fileManager, downloadCallback);
    }

    public boolean conflictsWithIncompleteFile(File file) {
        return file.equals(this._incompleteFile);
    }

    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        return IncompleteFileManager.same(this._name, this._size, this.downloadSHA1, remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getSHA1Urn());
    }

    public synchronized int getContentLength() {
        return this._size;
    }

    protected synchronized String getDefaultFileName() {
        return this._name;
    }

    public synchronized boolean resume() {
        boolean bl = super.resume();
        if (bl) {
            this.deserializedFromDisk = false;
        }
        return bl;
    }

    protected boolean shouldSendRequeryImmediately(int n) {
        if (this.deserializedFromDisk) {
            return false;
        }
        if (n > 0) {
            return super.shouldSendRequeryImmediately(n);
        }
        return true;
    }

    protected boolean shouldInitAltLocs(boolean bl) {
        return !bl;
    }

    protected QueryRequest newRequery(int n) {
        String string = StringUtils.createQueryString(this.getDefaultFileName());
        if (this.downloadSHA1 != null) {
            return QueryRequest.createQuery(string);
        }
        return QueryRequest.createQuery(string);
    }
}

