/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.AsyncDimeRecordReader;
import com.limegroup.gnutella.dime.DIMEException;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.io.ReadState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncDimeParser
extends ReadState {
    private static final Log LOG;
    private boolean lastRead = false;
    private List records = new LinkedList();
    private long amountRead = 0L;
    private AsyncDimeRecordReader reader;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.dime.AsyncDimeParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        do {
            DIMERecord dIMERecord;
            if (this.lastRead) {
                throw new IOException("already read last message.");
            }
            if (this.reader == null) {
                this.reader = new AsyncDimeRecordReader();
            }
            try {
                if (this.reader.process(readableByteChannel, byteBuffer)) {
                    return true;
                }
            }
            catch (DIMEException dIMEException) {
                LOG.warn((Object)"Error processing DIME", (Throwable)dIMEException);
                this.amountRead += this.reader.getAmountProcessed();
                return false;
            }
            this.amountRead += this.reader.getAmountProcessed();
            try {
                dIMERecord = this.reader.getRecord();
            }
            catch (DIMEException dIMEException) {
                LOG.warn((Object)"Error constructing DIME record", (Throwable)dIMEException);
                return false;
            }
            if (dIMERecord.isLastRecord()) {
                this.lastRead = true;
            }
            if (this.records.isEmpty() && !dIMERecord.isFirstRecord()) {
                throw new IOException("middle of stream.");
            }
            if (!this.records.isEmpty() && dIMERecord.isFirstRecord()) {
                throw new IOException("two first records.");
            }
            this.records.add(dIMERecord);
            this.reader = null;
        } while (!this.lastRead);
        return false;
    }

    public List getRecords() {
        return this.records;
    }

    public long getAmountProcessed() {
        return this.amountRead;
    }
}

