/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.io.ChannelReader;
import com.limegroup.gnutella.io.InterestReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterReader
implements ChannelReader,
InterestReadChannel {
    private Inflater inflater;
    private InterestReadChannel channel;
    private ByteBuffer data;

    public InflaterReader(Inflater inflater) {
        this(null, inflater);
    }

    public InflaterReader(InterestReadChannel interestReadChannel, Inflater inflater) {
        if (inflater == null) {
            throw new NullPointerException("null inflater!");
        }
        this.channel = interestReadChannel;
        this.inflater = inflater;
        this.data = ByteBuffer.allocate(512);
    }

    public void setReadChannel(InterestReadChannel interestReadChannel) {
        if (interestReadChannel == null) {
            throw new NullPointerException("cannot set null channel!");
        }
        this.channel = interestReadChannel;
    }

    public InterestReadChannel getReadChannel() {
        return this.channel;
    }

    public void interest(boolean bl) {
        this.channel.interest(bl);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            int n3 = this.inflate(byteBuffer);
            n += n3;
            if (n3 != 0) continue;
            if (this.inflater.finished() || this.inflater.needsDictionary()) {
                n2 = -1;
                break;
            }
            if (!this.inflater.needsInput()) continue;
            while (this.data.hasRemaining() && (n2 = this.channel.read(this.data)) > 0) {
            }
            if (this.data.position() == 0) break;
            this.inflater.setInput(this.data.array(), 0, this.data.position());
            this.data.clear();
        }
        if (n > 0) {
            return n;
        }
        if (n2 == -1) {
            return -1;
        }
        return 0;
    }

    private int inflate(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        int n2 = byteBuffer.position();
        try {
            n = this.inflater.inflate(byteBuffer.array(), n2, byteBuffer.remaining());
        }
        catch (DataFormatException dataFormatException) {
            IOException iOException = new IOException();
            iOException.initCause(dataFormatException);
            throw iOException;
        }
        catch (NullPointerException nullPointerException) {
            IOException iOException = new IOException();
            iOException.initCause(nullPointerException);
            throw iOException;
        }
        byteBuffer.position(n2 + n);
        return n;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

