/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.FeatureSearchData;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.ReceivedMessageStat;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class StandardMessageRouter
extends MessageRouter {
    protected void respondToPingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        Object object;
        byte by;
        byte by2 = pingRequest.getHops();
        if (by2 + (by = pingRequest.getTTL()) > 2 && !_manager.allowAnyConnection()) {
            return;
        }
        if (NetworkUtils.isValidAddress(RouterService.getAddress()) && NetworkUtils.isValidPort(RouterService.getPort())) {
            if (by2 == 1 && by == 1) {
                this.handleCrawlerPing(pingRequest, replyHandler);
                return;
            }
            if (pingRequest.isHeartbeat()) {
                this.sendPingReply(PingReply.create(pingRequest.getGUID(), (byte)1), replyHandler);
                return;
            }
            int n = by2 + 1;
            if (by2 + by <= 2) {
                n = 1;
            }
            if (RouterService.getConnectionManager().hasFreeSlots() || Statistics.instance().calculateDailyUptime() > 1800) {
                object = PingReply.create(pingRequest.getGUID(), (byte)n);
                this.sendPingReply((PingReply)object, replyHandler);
            }
        }
        List list = PongCacher.instance().getBestPongs(pingRequest.getLocale());
        object = list.iterator();
        byte[] byArray = pingRequest.getGUID();
        InetAddress inetAddress = replyHandler.getInetAddress();
        while (object.hasNext()) {
            PingReply pingReply = (PingReply)object.next();
            if (pingReply.getInetAddress().equals(inetAddress)) continue;
            this.sendPingReply(pingReply.mutateGUID(byArray), replyHandler);
        }
    }

    protected void respondToUDPPingRequest(PingRequest pingRequest, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        if (!RouterService.isIpPortValid()) {
            return;
        }
        IPPortCombo iPPortCombo = null;
        if (pingRequest.requestsIP()) {
            try {
                iPPortCombo = new IPPortCombo(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
            }
            catch (IOException iOException) {}
        }
        byte[] byArray = pingRequest.getSupportsCachedPongData();
        Collection collection = Collections.EMPTY_LIST;
        if (byArray != null) {
            boolean bl = byArray.length >= 1 && (byArray[0] & 1) == 1;
            collection = RouterService.getPreferencedHosts(bl, pingRequest.getLocale(), ConnectionSettings.NUM_RETURN_PONGS.getValue());
        }
        PingReply pingReply = iPPortCombo != null ? PingReply.create(pingRequest.getGUID(), (byte)1, iPPortCombo, collection) : PingReply.create(pingRequest.getGUID(), (byte)1, collection);
        this.sendPingReply(pingReply, replyHandler);
    }

    private void handleCrawlerPing(PingRequest pingRequest, ReplyHandler replyHandler) {
        List list = _manager.getInitializedClientConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            PingReply pingReply = PingReply.createExternal(pingRequest.getGUID(), (byte)2, managedConnection.getPort(), managedConnection.getInetAddress().getAddress(), false);
            pingReply.hop();
            this.sendPingReply(pingReply, replyHandler);
        }
    }

    protected boolean respondToQueryRequest(QueryRequest queryRequest, byte[] byArray, ReplyHandler replyHandler) {
        if (!FeatureSearchData.supportsFeature(queryRequest.getFeatureSelector())) {
            return false;
        }
        if (queryRequest.isWhatIsNewRequest()) {
            ReceivedMessageStat.WHAT_IS_NEW_QUERY_MESSAGES.incrementStat();
        }
        if (!RouterService.getUploadManager().isServiceable()) {
            return false;
        }
        if (!NetworkUtils.isValidPort(RouterService.getPort()) || !NetworkUtils.isValidAddress(RouterService.getAddress())) {
            return false;
        }
        Response[] responseArray = RouterService.getFileManager().query(queryRequest);
        if (RouterService.isShieldedLeaf() && queryRequest.isTCP()) {
            if (responseArray != null && responseArray.length > 0) {
                RoutedQueryStat.LEAF_HIT.incrementStat();
            } else {
                RoutedQueryStat.LEAF_FALSE_POSITIVE.incrementStat();
            }
        }
        return this.sendResponses(responseArray, queryRequest, replyHandler);
    }

    public boolean sendResponses(Response[] responseArray, QueryRequest queryRequest, ReplyHandler replyHandler) {
        Object object;
        if (responseArray == null || responseArray.length < 1) {
            return false;
        }
        if (queryRequest.desiresOutOfBandReplies() && !this.isConnectedTo(queryRequest, replyHandler) && RouterService.canReceiveSolicited() && RouterService.getUploadManager().isServiceable() && NetworkUtils.isValidAddressAndPort(queryRequest.getReplyAddress(), queryRequest.getReplyPort())) {
            if (this.bufferResponsesForLaterDelivery(queryRequest, responseArray)) {
                object = null;
                try {
                    object = InetAddress.getByName(queryRequest.getReplyAddress());
                }
                catch (UnknownHostException unknownHostException) {}
                int n = queryRequest.getReplyPort();
                if (object != null) {
                    int n2 = responseArray.length > 255 ? 255 : responseArray.length;
                    ReplyNumberVendorMessage replyNumberVendorMessage = new ReplyNumberVendorMessage(new GUID(queryRequest.getGUID()), n2);
                    UDPService.instance().send(replyNumberVendorMessage, (InetAddress)object, n);
                    return true;
                }
            } else {
                return false;
            }
        }
        object = this.responsesToQueryReplies(responseArray, queryRequest);
        try {
            while (object.hasNext()) {
                QueryReply queryReply = (QueryReply)object.next();
                this.sendQueryReply(queryReply);
            }
        }
        catch (IOException iOException) {}
        return true;
    }

    private final boolean isConnectedTo(QueryRequest queryRequest, ReplyHandler replyHandler) {
        return queryRequest.matchesReplyAddress(replyHandler.getInetAddress().getAddress());
    }

    protected List createQueryReply(byte[] byArray, byte by, long l, Response[] responseArray, byte[] byArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Set set;
        String string;
        ArrayList<QueryReply> arrayList = new ArrayList<QueryReply>();
        QueryReply queryReply = null;
        int n = -1;
        byte[] byArray3 = null;
        if (bl4) {
            byArray3 = RouterService.getNonForcedAddress();
            n = RouterService.getNonForcedPort();
            if (!NetworkUtils.isValidPort(n) || !NetworkUtils.isValidAddress(byArray3)) {
                bl4 = false;
            }
        }
        if (!bl4) {
            if (bl5) {
                n = UDPService.instance().getStableUDPPort();
                byArray3 = RouterService.getExternalAddress();
                if (!NetworkUtils.isValidAddress(byArray3) || !NetworkUtils.isValidPort(n)) {
                    bl5 = false;
                }
            }
            if (!bl5) {
                byArray3 = RouterService.getAddress();
                n = RouterService.getPort();
                if (!NetworkUtils.isValidAddress(byArray3) || !NetworkUtils.isValidPort(n)) {
                    return Collections.EMPTY_LIST;
                }
            }
        }
        if ((string = LimeXMLDocumentHelper.getAggregateString(responseArray)) == null) {
            string = "";
        }
        byte[] byArray4 = null;
        try {
            byArray4 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException, "encountered UnsupportedEncodingException in creation of QueryReply : xmlCollectionString : " + string);
        }
        boolean bl6 = !RouterService.acceptedIncomingConnection();
        Set set2 = set = bl6 ? _manager.getPushProxies() : null;
        if (byArray4.length > 32768) {
            LinkedList linkedList = new LinkedList();
            this.splitAndAddResponses(linkedList, responseArray);
            while (!linkedList.isEmpty()) {
                Response[] responseArray2 = (Response[])linkedList.remove(0);
                String string2 = LimeXMLDocumentHelper.getAggregateString(responseArray2);
                byte[] byArray5 = null;
                try {
                    byArray5 = string2.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ErrorService.error(unsupportedEncodingException, "encountered UnsupportedEncodingException : currXML " + string2);
                    byArray5 = "".getBytes();
                }
                if (byArray5.length > 32768 && responseArray2.length > 1) {
                    this.splitAndAddResponses(linkedList, responseArray2);
                    continue;
                }
                byte[] byArray6 = null;
                byArray6 = string2 != null && !string2.equals("") ? LimeXMLUtils.compress(byArray5) : DataUtils.EMPTY_BYTE_ARRAY;
                queryReply = new QueryReply(byArray, by, n, byArray3, l, responseArray2, this._clientGUID, byArray6, bl6, bl, bl2, bl3, ChatSettings.CHAT_ENABLED.getValue(), bl4, bl5, set);
                arrayList.add(queryReply);
            }
        } else {
            byte[] byArray7 = null;
            byArray7 = string != null && !string.equals("") ? LimeXMLUtils.compress(byArray4) : DataUtils.EMPTY_BYTE_ARRAY;
            queryReply = new QueryReply(byArray, by, n, byArray3, l, responseArray, this._clientGUID, byArray7, bl6, bl, bl2, bl3, ChatSettings.CHAT_ENABLED.getValue(), bl4, bl5, set);
            arrayList.add(queryReply);
        }
        return arrayList;
    }

    private Response[][] splitResponses(Response[] responseArray) {
        int n = responseArray.length / 2;
        Response[][] responseArray2 = new Response[][]{new Response[n], new Response[responseArray.length - n]};
        int n2 = 0;
        while (n2 < n) {
            responseArray2[0][n2] = responseArray[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < responseArray.length - n) {
            responseArray2[1][n2] = responseArray[n2 + n];
            ++n2;
        }
        return responseArray2;
    }

    private void splitAndAddResponses(List list, Response[] responseArray) {
        Response[][] responseArray2 = this.splitResponses(responseArray);
        list.add(responseArray2[0]);
        list.add(responseArray2[1]);
    }
}

