/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.library.LibraryData;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IntSet;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileManager {
    private static final Log LOG;
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    public static final File PROGRAM_SHARE;
    public static final File PREFERENCE_SHARE;
    private static final ProcessingQueue LOADER;
    private volatile List eventListeners = Collections.EMPTY_LIST;
    private final Object listenerLock = new Object();
    private final LibraryData _data = new LibraryData();
    private List _files;
    private long _filesSize;
    private int _numFiles;
    private int _numPendingFiles;
    private int _numIncompleteFiles;
    private int _numForcedFiles;
    private Map _fileToFileDescMap;
    private Trie _keywordTrie;
    private Map _urnMap;
    private static Set _extensions;
    private Map _sharedDirectories;
    private Set _completelySharedDirectories;
    private IntSet _incompletesShared;
    private Set _requestingValidation = Collections.synchronizedSet(new HashSet());
    protected volatile int _revision = 0;
    private volatile int _pendingFinished = -1;
    private volatile int _updatingFinished = -1;
    private volatile boolean _isUpdating = false;
    private volatile int _loadingFinished = -1;
    protected volatile boolean shutdown;
    private final FileFilter SHAREABLE_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return FileManager.this.isFileShareable(file);
        }
    };
    private static final FileFilter DIRECTORY_FILTER;
    private static final FileEventListener EMPTY_CALLBACK;
    protected static QueryRouteTable _queryRouteTable;
    protected static volatile boolean _needRebuild;
    public static final String DELIMITERS = " -._+/*()\\,";
    private static final Response[] EMPTY_RESPONSES;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.FileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        File file = new File(".", ".NetworkShare").getAbsoluteFile();
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {}
        PROGRAM_SHARE = file;
        file = new File(CommonUtils.getUserSettingsDir(), ".NetworkShare").getAbsoluteFile();
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {}
        PREFERENCE_SHARE = file;
        LOADER = new ProcessingQueue("FileManagerLoader");
        DIRECTORY_FILTER = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        EMPTY_CALLBACK = new FileEventListener(){

            public void handleFileEvent(FileManagerEvent fileManagerEvent) {
            }
        };
        _needRebuild = true;
        EMPTY_RESPONSES = new Response[0];
    }

    private static final boolean isDelimiter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public FileManager() {
        this.resetVariables();
    }

    private void resetVariables() {
        this._filesSize = 0L;
        this._numFiles = 0;
        this._numIncompleteFiles = 0;
        this._numPendingFiles = 0;
        this._numForcedFiles = 0;
        this._files = new ArrayList();
        this._keywordTrie = new Trie(true);
        this._urnMap = new HashMap();
        _extensions = new HashSet();
        this._sharedDirectories = new HashMap();
        this._completelySharedDirectories = new HashSet();
        this._incompletesShared = new IntSet();
        this._fileToFileDescMap = new HashMap();
    }

    public void start() {
        this._data.clean();
        this.cleanIndividualFiles();
        this.loadSettings();
    }

    public void stop() {
        this.save();
        this.shutdown = true;
    }

    protected void save() {
        this._data.save();
        UrnCache.instance().persistCache();
        CreationTimeCache.instance().persistCache();
    }

    public int getSize() {
        return ByteOrder.long2int(this._filesSize);
    }

    public int getNumFiles() {
        return this._numFiles - this._numForcedFiles;
    }

    public int getNumIncompleteFiles() {
        return this._numIncompleteFiles;
    }

    public int getNumPendingFiles() {
        return this._numPendingFiles;
    }

    public int getNumForcedFiles() {
        return this._numForcedFiles;
    }

    public synchronized FileDesc get(int n) {
        return (FileDesc)this._files.get(n);
    }

    public synchronized boolean isValidIndex(int n) {
        return n >= 0 && n < this._files.size();
    }

    public synchronized URN getURNForFile(File file) {
        FileDesc fileDesc = this.getFileDescForFile(file);
        if (fileDesc != null) {
            return fileDesc.getSHA1Urn();
        }
        return null;
    }

    public synchronized FileDesc getFileDescForFile(File file) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        return (FileDesc)this._fileToFileDescMap.get(file);
    }

    public synchronized boolean isUrnShared(URN uRN) {
        FileDesc fileDesc = this.getFileDescForUrn(uRN);
        return fileDesc != null && !(fileDesc instanceof IncompleteFileDesc);
    }

    public synchronized FileDesc getFileDescForUrn(URN uRN) {
        IntSet intSet = (IntSet)this._urnMap.get(uRN);
        if (intSet == null) {
            return null;
        }
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        FileDesc fileDesc = null;
        while (intSetIterator.hasNext() && (fileDesc == null || fileDesc instanceof IncompleteFileDesc)) {
            int n = intSetIterator.next();
            fileDesc = (FileDesc)this._files.get(n);
        }
        return fileDesc;
    }

    public synchronized FileDesc[] getIncompleteFileDescriptors() {
        if (this._incompletesShared == null) {
            return null;
        }
        FileDesc[] fileDescArray = new FileDesc[this._incompletesShared.size()];
        IntSet.IntSetIterator intSetIterator = this._incompletesShared.iterator();
        int n = 0;
        while (intSetIterator.hasNext()) {
            FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
            Assert.that(fileDesc != null, "Directory has null entry");
            fileDescArray[n] = fileDesc;
            ++n;
        }
        return fileDescArray;
    }

    public synchronized FileDesc[] getAllSharedFileDescriptors() {
        FileDesc[] fileDescArray = new FileDesc[this._fileToFileDescMap.size()];
        fileDescArray = this._fileToFileDescMap.values().toArray(fileDescArray);
        return fileDescArray;
    }

    public synchronized FileDesc[] getSharedFileDescriptors(File file) {
        if (file == null) {
            throw new NullPointerException("null directory");
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return new FileDesc[0];
        }
        IntSet intSet = (IntSet)this._sharedDirectories.get(file);
        if (intSet == null) {
            return new FileDesc[0];
        }
        FileDesc[] fileDescArray = new FileDesc[intSet.size()];
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        int n = 0;
        while (intSetIterator.hasNext()) {
            FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
            Assert.that(fileDesc != null, "Directory has null entry");
            fileDescArray[n] = fileDesc;
            ++n;
        }
        return fileDescArray;
    }

    public void loadSettings() {
        final int n = ++this._revision;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting new library revision: " + n));
        }
        LOADER.add(new Runnable(){

            public void run() {
                FileManager.this.loadStarted(n);
                FileManager.this.loadSettingsInternal(n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWithNewDirectories(Set set) {
        SharingSettings.DIRECTORIES_TO_SHARE.setValue(set);
        Set set2 = this._data.DIRECTORIES_NOT_TO_SHARE;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this._data.DIRECTORIES_NOT_TO_SHARE.remove((File)iterator.next());
            }
        }
        RouterService.getFileManager().loadSettings();
    }

    protected void loadStarted(int n) {
        UrnCache.instance().clearPendingHashes(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToFinish() {
        int n;
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._pendingFinished != this._updatingFinished || this._pendingFinished != this._revision || this._loadingFinished >= this._revision) {
                return;
            }
            n = this._loadingFinished = this._revision;
        }
        this.loadFinished(n);
    }

    protected void loadFinished(int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finished loading revision: " + n));
        }
        this.trim();
        CreationTimeCache.instance().pruneTimes();
        RouterService.getDownloadManager().getIncompleteFileManager().registerAllIncompleteFiles();
        this.save();
        SavedFileManager.instance().run();
        RouterService.getCallback().fileManagerLoaded();
    }

    public boolean isLoadFinished() {
        return this._loadingFinished == this._revision;
    }

    public boolean isUpdating() {
        return this._isUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsInternal(int n) {
        File[] fileArray;
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loading Library Revision: " + n));
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            this.resetVariables();
            object = StringUtils.split(SharingSettings.EXTENSIONS_TO_SHARE.getValue(), ";");
            int n2 = 0;
            while (n2 < ((String[])object).length) {
                _extensions.add(object[n2].toLowerCase());
                ++n2;
            }
            fileArray = SharingSettings.DIRECTORIES_TO_SHARE.getValueAsArray();
            Arrays.sort(fileArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return object.toString().length() - object2.toString().length();
                }
            });
        }
        RouterService.getCallback().fileManagerLoading();
        this.updateSharedDirectories(PROGRAM_SHARE, null, n);
        this.updateSharedDirectories(PREFERENCE_SHARE, null, n);
        this._isUpdating = true;
        int n3 = 0;
        while (n3 < fileArray.length && this._revision == n) {
            this.updateSharedDirectories(fileArray[n3], null, n);
            ++n3;
        }
        Set set = this._data.SPECIAL_FILES_TO_SHARE;
        Object object2 = set;
        synchronized (object2) {
            object = new ArrayList(set);
        }
        object2 = ((ArrayList)object).iterator();
        while (object2.hasNext() && this._revision == n) {
            this.addFileIfShared((File)object2.next(), Collections.EMPTY_LIST, true, n, null);
        }
        this._isUpdating = false;
        this.trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finished queueing shared files for revision: " + n));
        }
        this._updatingFinished = n;
        if (this._numPendingFiles == 0) {
            this._pendingFinished = n;
        }
        this.tryToFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSharedDirectories(File file, File file2, int n) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        if (file.equals(SharingSettings.INCOMPLETE_DIRECTORY.getValue())) {
            return;
        }
        if (this._data.DIRECTORIES_NOT_TO_SHARE.contains(file)) {
            return;
        }
        if (FileManager.isSensitiveDirectory(file)) {
            if (this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.contains(file)) {
                return;
            }
            if (this._data.SENSITIVE_DIRECTORIES_VALIDATED.contains(file) && !RouterService.getCallback().warnAboutSharingSensitiveDirectory(file)) {
                return;
            }
        }
        if (this._revision != n) {
            return;
        }
        boolean bl = FileManager.isForcedShareDirectory(file);
        File[] fileArray = this;
        synchronized (this) {
            if (this._completelySharedDirectories.contains(file)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            this._completelySharedDirectories.add(file);
            if (!bl) {
                this.dispatchFileEvent(new FileManagerEvent((FileManager)this, 7, file, file2));
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            fileArray = file.listFiles(this.SHAREABLE_FILE_FILTER);
            if (fileArray == null) {
                return;
            }
            int n2 = 0;
            while (n2 < fileArray.length && this._revision == n) {
                this.addFileIfShared(fileArray[n2], Collections.EMPTY_LIST, true, n, null);
                ++n2;
            }
            if (this._revision != n) {
                return;
            }
            if (bl) {
                return;
            }
            File[] fileArray2 = file.listFiles(DIRECTORY_FILTER);
            int n3 = 0;
            while (n3 < fileArray2.length && this._revision == n) {
                super.updateSharedDirectories(fileArray2[n3], file, n);
                ++n3;
            }
            return;
        }
    }

    public void removeFolderIfShared(File file) {
        this._isUpdating = true;
        this.removeFolderIfShared(file, null);
        this._isUpdating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeFolderIfShared(File file, File file2) {
        if (!file.isDirectory() && file.exists()) {
            throw new IllegalArgumentException("Expected a directory, but given: " + file);
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {}
        File[] fileArray = this;
        synchronized (this) {
            boolean bl = this._completelySharedDirectories.contains(file);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (!bl) return;
            if (file2 != null && SharingSettings.DIRECTORIES_TO_SHARE.contains(file)) {
                return;
            }
            if (file2 == null && !SharingSettings.DIRECTORIES_TO_SHARE.remove(file)) {
                this._data.DIRECTORIES_NOT_TO_SHARE.add(file);
            }
            fileArray = this;
            synchronized (this) {
                this._completelySharedDirectories.remove(file);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                fileArray = file.listFiles();
                if (fileArray != null) {
                    int n = 0;
                    while (n < fileArray.length) {
                        File file3 = fileArray[n];
                        if (file3.isDirectory()) {
                            this.removeFolderIfShared(file3, file);
                        } else if (file3.isFile() && !this._data.SPECIAL_FILES_TO_SHARE.contains(file3) && this.removeFileIfShared(file3) == null) {
                            UrnCache.instance().clearPendingHashesFor(file3, this);
                        }
                        ++n;
                    }
                }
                this.dispatchFileEvent(new FileManagerEvent((FileManager)this, 8, file));
                return;
            }
        }
    }

    public void addSharedFolder(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Expected a directory, but given: " + file);
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {}
        this._data.DIRECTORIES_NOT_TO_SHARE.remove(file);
        if (!this.isCompletelySharedDirectory(file.getParentFile())) {
            SharingSettings.DIRECTORIES_TO_SHARE.add(file);
        }
        this._isUpdating = true;
        this.updateSharedDirectories(file, null, this._revision);
        this._isUpdating = false;
    }

    public void addFileAlways(File file) {
        this.addFileAlways(file, Collections.EMPTY_LIST, null);
    }

    public void addFileAlways(File file, FileEventListener fileEventListener) {
        this.addFileAlways(file, Collections.EMPTY_LIST, fileEventListener);
    }

    public void addFileAlways(File file, List list) {
        this.addFileAlways(file, list, null);
    }

    public void addFileAlways(File file, List list, FileEventListener fileEventListener) {
        this._data.FILES_NOT_TO_SHARE.remove(file);
        if (!this.isFileShareable(file)) {
            this._data.SPECIAL_FILES_TO_SHARE.add(file);
        }
        this.addFileIfShared(file, list, true, this._revision, fileEventListener);
    }

    public void addFileIfShared(File file) {
        this.addFileIfShared(file, Collections.EMPTY_LIST, true, this._revision, null);
    }

    public void addFileIfShared(File file, FileEventListener fileEventListener) {
        this.addFileIfShared(file, Collections.EMPTY_LIST, true, this._revision, fileEventListener);
    }

    public void addFileIfShared(File file, List list) {
        this.addFileIfShared(file, list, true, this._revision, null);
    }

    public void addFileIfShared(File file, List list, FileEventListener fileEventListener) {
        this.addFileIfShared(file, list, true, this._revision, fileEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileIfShared(File file, List list, boolean bl, int n, FileEventListener fileEventListener) {
        if (fileEventListener == null) {
            fileEventListener = EMPTY_CALLBACK;
        }
        if (n != this._revision) {
            fileEventListener.handleFileEvent(new FileManagerEvent(this, 5, file));
            return;
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            fileEventListener.handleFileEvent(new FileManagerEvent(this, 5, file));
            return;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (n != this._revision) {
                fileEventListener.handleFileEvent(new FileManagerEvent(this, 5, file));
                return;
            }
            if (!this.isFileShareable(file)) {
                this._data.SPECIAL_FILES_TO_SHARE.remove(file);
                fileEventListener.handleFileEvent(new FileManagerEvent(this, 5, file));
                return;
            }
            if (this.isFileShared(file)) {
                fileEventListener.handleFileEvent(new FileManagerEvent(this, 6, file));
                return;
            }
            ++this._numPendingFiles;
            this._pendingFinished = -1;
        }
        UrnCache.instance().calculateAndCacheUrns(file, this.getNewUrnCallback(file, list, bl, n, fileEventListener));
    }

    protected UrnCallback getNewUrnCallback(final File file, final List list, final boolean bl, final int n, final FileEventListener fileEventListener) {
        return new UrnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void urnsCalculated(File file2, Set set) {
                FileDesc fileDesc = null;
                Object object = FileManager.this;
                synchronized (object) {
                    if (n != FileManager.this._revision) {
                        LOG.warn((Object)"Revisions changed, dropping share.");
                        fileEventListener.handleFileEvent(new FileManagerEvent(FileManager.this, 5, file));
                        return;
                    }
                    FileManager fileManager = FileManager.this;
                    fileManager._numPendingFiles = fileManager._numPendingFiles - 1;
                    if (!set.isEmpty() && FileManager.this.isFileShareable(file)) {
                        fileDesc = FileManager.this.addFile(file, set);
                    }
                }
                if (fileDesc != null) {
                    FileManager.this.loadFile(fileDesc, file, list, set);
                    object = new FileManagerEvent(FileManager.this, 1, fileDesc);
                    if (bl) {
                        FileManager.this.dispatchFileEvent((FileManagerEvent)object);
                    }
                    fileEventListener.handleFileEvent((FileManagerEvent)object);
                } else {
                    fileEventListener.handleFileEvent(new FileManagerEvent(FileManager.this, 5, file));
                }
                if (FileManager.this._numPendingFiles == 0) {
                    FileManager.this._pendingFinished = n;
                    FileManager.this.tryToFinish();
                }
            }

            public boolean isOwner(Object object) {
                return object == FileManager.this;
            }
        };
    }

    protected void loadFile(FileDesc fileDesc, File file, List list, Set set) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FileDesc addFile(File file, Set set) {
        Object object;
        Object object2;
        int n = this._files.size();
        FileDesc fileDesc = new FileDesc(file, set, n);
        ContentResponseData contentResponseData = RouterService.getContentManager().getResponse(fileDesc.getSHA1Urn());
        if (contentResponseData != null && !contentResponseData.isOK()) {
            return null;
        }
        long l = file.length();
        this._filesSize += l;
        this._files.add(fileDesc);
        this._fileToFileDescMap.put(file, fileDesc);
        ++this._numFiles;
        File file2 = file.getParentFile();
        Assert.that(file2 != null, "Null parent to \"" + file + "\"");
        IntSet intSet = (IntSet)this._sharedDirectories.get(file2);
        if (intSet == null) {
            intSet = new IntSet();
            this._sharedDirectories.put(file2, intSet);
        }
        boolean bl = intSet.add(n);
        Assert.that(bl, "File " + n + " already found in " + intSet);
        if (FileManager.isForcedShareDirectory(file2)) {
            ++this._numForcedFiles;
        }
        String[] stringArray = FileManager.extractKeywords(fileDesc);
        int n2 = 0;
        while (n2 < stringArray.length) {
            object2 = stringArray[n2];
            object = (IntSet)this._keywordTrie.get((String)object2);
            if (object == null) {
                object = new IntSet();
                this._keywordTrie.add((String)object2, object);
            }
            ((IntSet)object).add(n);
            ++n2;
        }
        if (!FileManager.isForcedShare(file)) {
            URN uRN = fileDesc.getSHA1Urn();
            object = object2 = CreationTimeCache.instance();
            synchronized (object) {
                Long l2 = ((CreationTimeCache)object2).getCreationTime(uRN);
                if (l2 == null) {
                    l2 = new Long(file.lastModified());
                }
                if (l2 > 0L) {
                    ((CreationTimeCache)object2).addTime(uRN, l2);
                    ((CreationTimeCache)object2).commitTime(uRN);
                }
            }
        }
        this.updateUrnIndex(fileDesc);
        _needRebuild = true;
        return fileDesc;
    }

    public synchronized void stopSharingFile(File file) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        boolean bl = this._data.SPECIAL_FILES_TO_SHARE.remove(file);
        FileDesc fileDesc = this.removeFileIfShared(file);
        if (fileDesc == null) {
            UrnCache.instance().clearPendingHashesFor(file, this);
        } else {
            file = fileDesc.getFile();
            if (!bl) {
                this._data.FILES_NOT_TO_SHARE.add(file);
            }
        }
    }

    public synchronized FileDesc removeFileIfShared(File file) {
        return this.removeFileIfShared(file, true);
    }

    protected synchronized FileDesc removeFileIfShared(File file, boolean bl) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        FileDesc fileDesc = (FileDesc)this._fileToFileDescMap.get(file);
        if (fileDesc == null) {
            return null;
        }
        int n = fileDesc.getIndex();
        Assert.that(((FileDesc)this._files.get(n)).getFile().equals(file), "invariant broken!");
        this._files.set(n, null);
        this._fileToFileDescMap.remove(file);
        _needRebuild = true;
        if (fileDesc instanceof IncompleteFileDesc) {
            this.removeUrnIndex(fileDesc);
            --this._numIncompleteFiles;
            boolean bl2 = this._incompletesShared.remove(n);
            Assert.that(bl2, "File " + n + " not found in " + this._incompletesShared);
            if (bl) {
                FileManagerEvent fileManagerEvent = new FileManagerEvent(this, 2, fileDesc);
                this.dispatchFileEvent(fileManagerEvent);
            }
            return fileDesc;
        }
        --this._numFiles;
        this._filesSize -= fileDesc.getFileSize();
        File file2 = file.getParentFile();
        IntSet intSet = (IntSet)this._sharedDirectories.get(file2);
        Assert.that(intSet != null, "Removed file's directory \"" + file2 + "\" not in " + this._sharedDirectories);
        boolean bl3 = intSet.remove(n);
        Assert.that(bl3, "File " + n + " not found in " + intSet);
        if (FileManager.isForcedShareDirectory(file2)) {
            bl = false;
            --this._numForcedFiles;
        }
        String[] stringArray = FileManager.extractKeywords(fileDesc);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            IntSet intSet2 = (IntSet)this._keywordTrie.get(string);
            if (intSet2 != null) {
                intSet2.remove(n);
                if (intSet2.size() == 0) {
                    this._keywordTrie.remove(string);
                }
            }
            ++n2;
        }
        this.removeUrnIndex(fileDesc);
        if (this._urnMap.get(fileDesc.getSHA1Urn()) == null) {
            CreationTimeCache.instance().removeTime(fileDesc.getSHA1Urn());
        }
        if (bl) {
            FileManagerEvent fileManagerEvent = new FileManagerEvent(this, 2, fileDesc);
            this.dispatchFileEvent(fileManagerEvent);
        }
        return fileDesc;
    }

    public synchronized void addIncompleteFile(File file, Set set, String string, int n, VerifyingFile verifyingFile) {
        Object object;
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IntSet intSet = (IntSet)this._urnMap.get(iterator.next());
            if (intSet == null) continue;
            object = intSet.iterator();
            while (((IntSet.IntSetIterator)object).hasNext()) {
                String string2;
                String string3;
                int n2 = ((IntSet.IntSetIterator)object).next();
                FileDesc fileDesc = (FileDesc)this._files.get(n2);
                if (fileDesc == null || !(string3 = file.getAbsolutePath()).equals(string2 = fileDesc.getFile().getAbsolutePath())) continue;
                return;
            }
        }
        int n3 = this._files.size();
        this._incompletesShared.add(n3);
        object = new IncompleteFileDesc(file, set, n3, string, n, verifyingFile);
        this._files.add(object);
        this._fileToFileDescMap.put(file, object);
        this.updateUrnIndex((FileDesc)object);
        ++this._numIncompleteFiles;
        _needRebuild = true;
        this.dispatchFileEvent(new FileManagerEvent(this, 1, (FileDesc)object));
    }

    public abstract void fileChanged(File var1);

    public void validate(final FileDesc fileDesc) {
        ContentManager contentManager = RouterService.getContentManager();
        if (this._requestingValidation.add(fileDesc.getSHA1Urn())) {
            contentManager.request(fileDesc.getSHA1Urn(), new ContentResponseObserver(){

                public void handleResponse(URN uRN, ContentResponseData contentResponseData) {
                    FileManager.this._requestingValidation.remove(fileDesc.getSHA1Urn());
                    if (contentResponseData != null && !contentResponseData.isOK()) {
                        FileManager.this.removeFileIfShared(fileDesc.getFile());
                    }
                }
            }, 5000L);
        }
    }

    private synchronized void updateUrnIndex(FileDesc fileDesc) {
        Iterator iterator = fileDesc.getUrns().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet = (IntSet)this._urnMap.get(uRN);
            if (intSet == null) {
                intSet = new IntSet();
                this._urnMap.put(uRN, intSet);
            }
            intSet.add(fileDesc.getIndex());
        }
    }

    private static String[] extractKeywords(FileDesc fileDesc) {
        return StringUtils.split(I18NConvert.instance().getNorm(fileDesc.getPath()), DELIMITERS);
    }

    private synchronized void removeUrnIndex(FileDesc fileDesc) {
        Iterator iterator = fileDesc.getUrns().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet = (IntSet)this._urnMap.get(uRN);
            Assert.that(intSet != null, "Invariant broken");
            intSet.remove(fileDesc.getIndex());
            if (intSet.size() != 0) continue;
            RouterService.getAltlocManager().purge(uRN);
            this._urnMap.remove(uRN);
        }
    }

    public void renameFileIfShared(File file, File file2) {
        this.renameFileIfShared(file, file2, null);
    }

    public synchronized void renameFileIfShared(File file, File file2, final FileEventListener fileEventListener) {
        FileDesc fileDesc = this.getFileDescForFile(file);
        if (fileDesc == null) {
            FileManagerEvent fileManagerEvent = new FileManagerEvent(this, 5, file);
            this.dispatchFileEvent(fileManagerEvent);
            if (fileEventListener != null) {
                fileEventListener.handleFileEvent(fileManagerEvent);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to rename: " + file + " to: " + file2));
        }
        LinkedList linkedList = new LinkedList(fileDesc.getLimeXMLDocuments());
        final FileDesc fileDesc2 = this.removeFileIfShared(file, false);
        Assert.that(fileDesc2 == fileDesc, "invariant broken.");
        if (this._data.SPECIAL_FILES_TO_SHARE.remove(file) && !this.isFileInCompletelySharedDirectory(file2)) {
            this._data.SPECIAL_FILES_TO_SHARE.add(file2);
        }
        UrnCache.instance().addUrns(file2, fileDesc2.getUrns());
        this.addFileIfShared(file2, linkedList, false, this._revision, new FileEventListener(){

            public void handleFileEvent(FileManagerEvent fileManagerEvent) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Add of newFile returned callback: " + fileManagerEvent));
                }
                FileManagerEvent fileManagerEvent2 = null;
                if (fileManagerEvent.isAddEvent()) {
                    FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
                    fileManagerEvent2 = new FileManagerEvent(FileManager.this, 3, new FileDesc[]{fileDesc2, fileDesc});
                } else {
                    fileManagerEvent2 = new FileManagerEvent(FileManager.this, 2, fileDesc2);
                }
                FileManager.this.dispatchFileEvent(fileManagerEvent2);
                if (fileEventListener != null) {
                    fileEventListener.handleFileEvent(fileManagerEvent2);
                }
            }
        });
    }

    private synchronized void trim() {
        this._keywordTrie.trim(new Function(){

            public Object apply(Object object) {
                ((IntSet)object).trim();
                return object;
            }
        });
    }

    public void validateSensitiveFile(File file) {
        this._data.SENSITIVE_DIRECTORIES_VALIDATED.add(file);
        this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.remove(file);
    }

    public void invalidateSensitiveFile(File file) {
        this._data.SENSITIVE_DIRECTORIES_VALIDATED.remove(file);
        this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.add(file);
        SharingSettings.DIRECTORIES_TO_SHARE.remove(file);
    }

    public boolean hasIndividualFiles() {
        return !this._data.SPECIAL_FILES_TO_SHARE.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getIndividualFiles() {
        Set set;
        Set set2 = set = this._data.SPECIAL_FILES_TO_SHARE;
        synchronized (set2) {
            ArrayList<File> arrayList = new ArrayList<File>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (!file.exists()) continue;
                arrayList.add(file);
            }
            if (arrayList.isEmpty()) {
                return new File[0];
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
    }

    public boolean isIndividualShare(File file) {
        return this._data.SPECIAL_FILES_TO_SHARE.contains(file) && FileManager.isFilePhysicallyShareable(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanIndividualFiles() {
        Set set;
        Set set2 = set = this._data.SPECIAL_FILES_TO_SHARE;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof File && FileManager.isFilePhysicallyShareable((File)e)) continue;
                iterator.remove();
            }
        }
    }

    public boolean isFileShared(File file) {
        if (file == null) {
            return false;
        }
        return this._fileToFileDescMap.get(file) != null;
    }

    private static boolean hasShareableExtension(File file) {
        if (file == null) {
            return false;
        }
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return _extensions.contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileInCompletelySharedDirectory(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            return this._completelySharedDirectories.contains(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompletelySharedDirectory(File file) {
        if (file == null) {
            return false;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            return this._completelySharedDirectories.contains(file);
        }
    }

    private boolean isFileShareable(File file) {
        if (!FileManager.isFilePhysicallyShareable(file)) {
            return false;
        }
        if (this._data.SPECIAL_FILES_TO_SHARE.contains(file)) {
            return true;
        }
        if (this._data.FILES_NOT_TO_SHARE.contains(file)) {
            return false;
        }
        if (this.isFileInCompletelySharedDirectory(file)) {
            if (file.getName().toUpperCase().startsWith("LIMEWIRE")) {
                return true;
            }
            return FileManager.hasShareableExtension(file);
        }
        return false;
    }

    public static boolean isFilePhysicallyShareable(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canRead() || file.isHidden()) {
            return false;
        }
        long l = file.length();
        return l <= Integer.MAX_VALUE && l > 0L;
    }

    public static boolean isSensitiveDirectory(File file) {
        String string;
        if (file == null) {
            return false;
        }
        File[] fileArray = File.listRoots();
        if (fileArray != null && fileArray.length > 0) {
            int n = 0;
            while (n < fileArray.length) {
                if (file.equals(fileArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        if (file.equals(new File(string = System.getProperty("user.home")))) {
            return true;
        }
        if (CommonUtils.isWindows()) {
            if (file.getName().equals("Documents and Settings")) {
                return true;
            }
            if (file.getName().equals("My Documents")) {
                return true;
            }
            if (file.getName().equals("Desktop")) {
                return true;
            }
            if (file.getName().equals("Program Files")) {
                return true;
            }
            if (file.getName().equals("Windows")) {
                return true;
            }
            if (file.getName().equals("WINNT")) {
                return true;
            }
        }
        if (CommonUtils.isMacOSX()) {
            if (file.getName().equals("Users")) {
                return true;
            }
            if (file.getName().equals("System")) {
                return true;
            }
            if (file.getName().equals("System Folder")) {
                return true;
            }
            if (file.getName().equals("Previous Systems")) {
                return true;
            }
            if (file.getName().equals("private")) {
                return true;
            }
            if (file.getName().equals("Volumes")) {
                return true;
            }
            if (file.getName().equals("Desktop")) {
                return true;
            }
            if (file.getName().equals("Applications")) {
                return true;
            }
            if (file.getName().equals("Applications (Mac OS 9)")) {
                return true;
            }
            if (file.getName().equals("Network")) {
                return true;
            }
        }
        if (CommonUtils.isPOSIX()) {
            if (file.getName().equals("bin")) {
                return true;
            }
            if (file.getName().equals("boot")) {
                return true;
            }
            if (file.getName().equals("dev")) {
                return true;
            }
            if (file.getName().equals("etc")) {
                return true;
            }
            if (file.getName().equals("home")) {
                return true;
            }
            if (file.getName().equals("mnt")) {
                return true;
            }
            if (file.getName().equals("opt")) {
                return true;
            }
            if (file.getName().equals("proc")) {
                return true;
            }
            if (file.getName().equals("root")) {
                return true;
            }
            if (file.getName().equals("sbin")) {
                return true;
            }
            if (file.getName().equals("usr")) {
                return true;
            }
            if (file.getName().equals("var")) {
                return true;
            }
        }
        return false;
    }

    public synchronized QueryRouteTable getQRT() {
        if (_needRebuild) {
            this.buildQRT();
            _needRebuild = false;
        }
        QueryRouteTable queryRouteTable = new QueryRouteTable(_queryRouteTable.getSize());
        queryRouteTable.addAll(_queryRouteTable);
        return queryRouteTable;
    }

    protected synchronized void buildQRT() {
        _queryRouteTable = new QueryRouteTable();
        FileDesc[] fileDescArray = this.getAllSharedFileDescriptors();
        int n = 0;
        while (n < fileDescArray.length) {
            if (!(fileDescArray[n] instanceof IncompleteFileDesc)) {
                _queryRouteTable.add(fileDescArray[n].getPath());
            }
            ++n;
        }
    }

    public synchronized Response[] query(QueryRequest queryRequest) {
        String string = queryRequest.getQuery();
        boolean bl = this.shouldIncludeXMLInResponse(queryRequest);
        if (queryRequest.isWhatIsNewRequest()) {
            return this.respondToWhatIsNewRequest(queryRequest, bl);
        }
        if (string.equals(INDEXING_QUERY) || string.equals(BROWSE_QUERY)) {
            return this.respondToIndexingQuery(bl);
        }
        string = this._keywordTrie.canonicalCase(string);
        IntSet intSet = this.search(string, null);
        if (queryRequest.getQueryUrns().size() > 0) {
            intSet = this.urnSearch(queryRequest.getQueryUrns().iterator(), intSet);
        }
        if (intSet == null) {
            return EMPTY_RESPONSES;
        }
        LinkedList<Response> linkedList = new LinkedList<Response>();
        MediaType.Aggregator aggregator = MediaType.getAggregator(queryRequest);
        LimeXMLDocument limeXMLDocument = queryRequest.getRichQuery();
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext()) {
            int n = intSetIterator.next();
            FileDesc fileDesc = (FileDesc)this._files.get(n);
            if (fileDesc == null) {
                Assert.that(false, "unexpected null in FileManager for query:\n" + queryRequest);
            }
            if (aggregator != null && !aggregator.allow(fileDesc.getFileName())) continue;
            fileDesc.incrementHitCount();
            RouterService.getCallback().handleSharedFileUpdate(fileDesc.getFile());
            Response response = new Response(fileDesc);
            if (bl) {
                this.addXMLToResponse(response, fileDesc);
                if (limeXMLDocument != null && response.getDocument() != null && !this.isValidXMLMatch(response, limeXMLDocument)) continue;
            }
            linkedList.add(response);
        }
        if (linkedList.size() == 0) {
            return EMPTY_RESPONSES;
        }
        return linkedList.toArray(new Response[linkedList.size()]);
    }

    private Response[] respondToWhatIsNewRequest(QueryRequest queryRequest, boolean bl) {
        List list = CreationTimeCache.instance().getFiles(queryRequest, 3);
        if (list.size() == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] responseArray = new Response[list.size()];
        int n = 0;
        while (n < list.size()) {
            URN uRN = (URN)list.get(n);
            FileDesc fileDesc = this.getFileDescForUrn(uRN);
            if (fileDesc == null || fileDesc instanceof IncompleteFileDesc) {
                throw new RuntimeException("Bad Rep - No IFDs allowed!");
            }
            Response response = new Response(fileDesc);
            if (bl) {
                this.addXMLToResponse(response, fileDesc);
            }
            responseArray[n] = response;
            ++n;
        }
        return responseArray;
    }

    private Response[] respondToIndexingQuery(boolean bl) {
        if (this._numFiles == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] responseArray = new Response[this._numFiles - this._numForcedFiles];
        int n = 0;
        int n2 = 0;
        while (n2 < this._files.size()) {
            FileDesc fileDesc = (FileDesc)this._files.get(n2);
            if (fileDesc != null && !(fileDesc instanceof IncompleteFileDesc) && !FileManager.isForcedShare(fileDesc)) {
                Assert.that(n < responseArray.length, "_numFiles is too small");
                responseArray[n] = new Response(fileDesc);
                if (bl) {
                    this.addXMLToResponse(responseArray[n], fileDesc);
                }
                ++n;
            }
            ++n2;
        }
        Assert.that(n == responseArray.length, "_numFiles is too large");
        return responseArray;
    }

    protected abstract boolean shouldIncludeXMLInResponse(QueryRequest var1);

    protected abstract void addXMLToResponse(Response var1, FileDesc var2);

    protected abstract boolean isValidXMLMatch(Response var1, LimeXMLDocument var2);

    protected IntSet search(String string, IntSet intSet) {
        IntSet intSet2 = intSet;
        int n = 0;
        while (n < string.length()) {
            if (FileManager.isDelimiter(string.charAt(n))) {
                ++n;
                continue;
            }
            int n2 = n + 1;
            while (n2 < string.length()) {
                if (FileManager.isDelimiter(string.charAt(n2))) break;
                ++n2;
            }
            Iterator iterator = this._keywordTrie.getPrefixedBy(string, n, n2);
            if (iterator.hasNext()) {
                IntSet intSet3 = null;
                while (iterator.hasNext()) {
                    IntSet intSet4 = (IntSet)iterator.next();
                    if (intSet3 == null) {
                        if (n == 0 && n2 == string.length() && !iterator.hasNext()) {
                            return intSet4;
                        }
                        intSet3 = new IntSet();
                    }
                    intSet3.addAll(intSet4);
                }
                if (intSet2 == null) {
                    intSet2 = intSet3;
                } else {
                    intSet2.retainAll(intSet3);
                }
            } else {
                return null;
            }
            if (intSet2.size() == 0) {
                return null;
            }
            n = n2;
        }
        if (intSet2 == null || intSet2.size() == 0) {
            return null;
        }
        return intSet2;
    }

    private synchronized IntSet urnSearch(Iterator iterator, IntSet intSet) {
        IntSet intSet2 = intSet;
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            IntSet intSet3 = (IntSet)this._urnMap.get(uRN);
            if (intSet3 == null) continue;
            IntSet.IntSetIterator intSetIterator = intSet3.iterator();
            while (intSetIterator.hasNext()) {
                FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
                if (fileDesc == null || fileDesc instanceof IncompleteFileDesc || !fileDesc.containsUrn(uRN)) continue;
                if (intSet2 == null) {
                    intSet2 = new IntSet();
                }
                intSet2.add(fileDesc.getIndex());
            }
        }
        return intSet2;
    }

    public static boolean isForcedShare(FileDesc fileDesc) {
        return FileManager.isForcedShare(fileDesc.getFile());
    }

    public static boolean isForcedShare(File file) {
        File file2 = file.getParentFile();
        return file2 != null && FileManager.isForcedShareDirectory(file2);
    }

    public static boolean isForcedShareDirectory(File file) {
        return file.equals(PROGRAM_SHARE) || file.equals(PREFERENCE_SHARE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFileManagerEventListener(FileEventListener fileEventListener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.eventListeners.contains(fileEventListener)) {
                return;
            }
            ArrayList<FileEventListener> arrayList = new ArrayList<FileEventListener>(this.eventListeners);
            arrayList.add(fileEventListener);
            this.eventListeners = Collections.unmodifiableList(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFileManagerEventListener(FileEventListener fileEventListener) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList(this.eventListeners);
            arrayList.remove(fileEventListener);
            this.eventListeners = Collections.unmodifiableList(arrayList);
        }
    }

    public void dispatchFileEvent(FileManagerEvent fileManagerEvent) {
        Iterator iterator = this.eventListeners.iterator();
        while (iterator.hasNext()) {
            FileEventListener fileEventListener = (FileEventListener)iterator.next();
            fileEventListener.handleFileEvent(fileManagerEvent);
        }
    }
}

