/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.test;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import org.logi.crypto.Crypto;
import org.logi.crypto.io.CipherStreamClient;
import org.logi.crypto.io.CipherStreamServer;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.DESKey;
import org.logi.crypto.keys.KeyPair;
import org.logi.crypto.keys.KeyRing;
import org.logi.crypto.keys.RSAKey;
import org.logi.crypto.keys.SignatureKey;
import org.logi.crypto.keys.TriDESKey;
import org.logi.crypto.modes.DecryptOFB;
import org.logi.crypto.modes.EncryptOFB;
import org.logi.crypto.protocols.DHEKEKeyExClient;
import org.logi.crypto.protocols.DHEKEKeyExServer;
import org.logi.crypto.protocols.DHKeyExClient;
import org.logi.crypto.protocols.DHKeyExServer;
import org.logi.crypto.protocols.EncryptedKeyExClient;
import org.logi.crypto.protocols.EncryptedKeyExServer;
import org.logi.crypto.protocols.QRAuthClient;
import org.logi.crypto.protocols.QRAuthServer;
import org.logi.crypto.protocols.SendHashKeyExClient;
import org.logi.crypto.protocols.SendHashKeyExServer;

public class TestCliSer
extends Crypto {
    static int serverPort;
    static Random rand;
    static CipherKey secret;
    static KeyPair serverKeys;
    static KeyPair clientKeys;
    static boolean auth;
    static String keyEx;

    private static void help() {
        System.err.println("Use: java org.logi.crypto.test.TestCliSer <key-ex> [auth]");
        System.err.println("where <key-ex> is one of DH, EncryptedKey or SendHash.");
        System.err.println();
        System.err.println("DH             Diffie-Hellman. Encryption but no authentication.");
        System.err.println("DHEKE          DH-EKE key-exchange and authentication. Encryption and authentication.");
        System.err.println("EncryptedKey   Encrypted key sent. Encryption and implicit authentication.");
        System.err.println("SendHash       Send hash of key to use. Encryption and implicit authentication.");
        System.err.println("");
        System.err.println("auth           Use the query-responce protocol for authentication.");
    }

    public static void main(String[] stringArray) {
        ServerSocket serverSocket;
        Crypto.initRandom();
        if (stringArray.length < 1) {
            TestCliSer.help();
            return;
        }
        keyEx = stringArray[0];
        if (!(keyEx.equals("DH") || keyEx.equals("DHEKE") || keyEx.equals("EncryptedKey") || keyEx.equals("SendHash"))) {
            TestCliSer.help();
            return;
        }
        if (stringArray.length > 1) {
            if (stringArray[1].equals("auth")) {
                auth = true;
            } else {
                TestCliSer.help();
                return;
            }
        }
        secret = new DESKey();
        KeyRing keyRing = new KeyRing();
        keyRing.insert(secret);
        keySource = keyRing;
        if (keyEx.equals("EncryptedKey")) {
            clientKeys = RSAKey.createKeys(256);
            serverKeys = RSAKey.createKeys(256);
        }
        Crypto.random = new Random();
        do {
            try {
                serverPort = rand.nextInt() % 32768 + 32768;
                System.out.println("Server on port " + serverPort);
                serverSocket = new ServerSocket(serverPort);
            }
            catch (Throwable throwable) {
                System.err.println("Failed to open server port " + serverPort);
                serverSocket = null;
            }
        } while (serverSocket == null);
        int n = 0;
        while (n < 10) {
            new ClientThread(n).start();
            ++n;
        }
        while (true) {
            try {
                System.err.println("S\twaiting for connection");
                new ServerThread(serverSocket.accept()).start();
                continue;
            }
            catch (IOException iOException) {
                System.err.println("S\tConnection threw an exception");
                continue;
            }
            break;
        }
    }

    private TestCliSer() {
    }

    static {
        rand = new Random();
    }

    static class ClientThread
    extends Thread {
        int id;

        public CipherStreamClient makeCS(Socket socket) throws Exception {
            if (keyEx.equals("DH")) {
                return new CipherStreamClient(socket.getInputStream(), socket.getOutputStream(), new DHKeyExClient(512, "TriDESKey"), new EncryptOFB(64), new DecryptOFB(64));
            }
            if (keyEx.equals("EncryptedKey")) {
                return new CipherStreamClient(socket.getInputStream(), socket.getOutputStream(), new EncryptedKeyExClient((CipherKey)serverKeys.getPublic(), (SignatureKey)clientKeys.getPrivate(), new TriDESKey()), new EncryptOFB(64), new DecryptOFB(64));
            }
            if (keyEx.equals("SendHash")) {
                return new CipherStreamClient(socket.getInputStream(), socket.getOutputStream(), new SendHashKeyExClient(secret), new EncryptOFB(64), new DecryptOFB(64));
            }
            if (keyEx.equals("DHEKE")) {
                return new CipherStreamClient(socket.getInputStream(), socket.getOutputStream(), new DHEKEKeyExClient(512, "TriDESKey", secret), new EncryptOFB(64), new DecryptOFB(64));
            }
            return null;
        }

        public void run() {
            while (true) {
                Socket socket = null;
                try {
                    System.err.println("C(" + this.id + ")\tCreating CipherStreamClient");
                    socket = new Socket("127.0.0.1", serverPort);
                    CipherStreamClient cipherStreamClient = this.makeCS(socket);
                    if (auth) {
                        System.err.println("S\tAuthenticating");
                        cipherStreamClient.execute(new QRAuthClient(secret));
                    }
                    DataInputStream dataInputStream = new DataInputStream(cipherStreamClient.getInputStream());
                    DataOutputStream dataOutputStream = new DataOutputStream(cipherStreamClient.getOutputStream());
                    do {
                        int n = rand.nextInt() % 50 + 50;
                        dataOutputStream.writeInt(n);
                        int n2 = dataInputStream.readInt();
                        System.err.println("C(" + this.id + ")\t" + n + "^2=" + n2);
                    } while (rand.nextInt() % 50 != 0);
                    socket.close();
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("C(" + this.id + ")\tDied with an exception");
                    exception.printStackTrace(System.err);
                    try {
                        socket.close();
                    }
                    catch (Exception exception2) {
                    }
                    continue;
                }
                break;
            }
        }

        public ClientThread(int n) {
            this.id = n;
        }
    }

    static class ServerThread
    extends Thread {
        Socket s;

        public CipherStreamServer makeCS(Socket socket) throws Exception {
            if (keyEx.equals("DH")) {
                return new CipherStreamServer(socket.getInputStream(), socket.getOutputStream(), new DHKeyExServer(512, "TriDESKey"), new EncryptOFB(64), new DecryptOFB(64));
            }
            if (keyEx.equals("EncryptedKey")) {
                return new CipherStreamServer(socket.getInputStream(), socket.getOutputStream(), new EncryptedKeyExServer((CipherKey)serverKeys.getPrivate(), (SignatureKey)clientKeys.getPublic()), new EncryptOFB(64), new DecryptOFB(64));
            }
            if (keyEx.equals("SendHash")) {
                return new CipherStreamServer(socket.getInputStream(), socket.getOutputStream(), new SendHashKeyExServer(), new EncryptOFB(64), new DecryptOFB(64));
            }
            if (keyEx.equals("DHEKE")) {
                return new CipherStreamServer(socket.getInputStream(), socket.getOutputStream(), new DHEKEKeyExServer(512, "TriDESKey", secret), new EncryptOFB(64), new DecryptOFB(64));
            }
            return null;
        }

        public void run() {
            try {
                System.err.println("S\tCreating CipherStreamServer");
                CipherStreamServer cipherStreamServer = this.makeCS(this.s);
                if (auth) {
                    System.err.println("S\tAuthenticating");
                    cipherStreamServer.execute(new QRAuthServer(secret));
                }
                DataInputStream dataInputStream = new DataInputStream(cipherStreamServer.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(cipherStreamServer.getOutputStream());
                while (true) {
                    int n = dataInputStream.readInt();
                    dataOutputStream.writeInt(n * n);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof EOFException)) {
                    System.err.println("S\tDied with an exception");
                    exception.printStackTrace();
                }
                try {
                    this.s.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                System.err.println("S\tclosing connection");
                return;
            }
        }

        public ServerThread(Socket socket) {
            this.s = socket;
        }
    }
}

