/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.DispatchCommand;
import jp.sourceforge.cabos.TransferUpdate;

public class AqMain {
    private static InputStreamReader reader = null;
    private static OutputStreamWriter writer = null;
    private static Socket socket = null;
    protected static List dispatches = Collections.EMPTY_LIST;

    public static void main(String[] stringArray) {
        try {
            socket = new Socket("localhost", 1024);
            reader = new InputStreamReader(socket.getInputStream(), "UTF-8");
            writer = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
        }
        catch (Exception exception) {
            System.exit(0);
        }
        AqEvent.signalEvent(98);
        AqEventHandler aqEventHandler = new AqEventHandler();
        ErrorService.setErrorCallback(aqEventHandler);
        MessageService.setCallback(aqEventHandler);
        if (CommonUtils.getUserHomeDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserHomeDir());
        }
        if (CommonUtils.getUserSettingsDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        }
        RouterService routerService = new RouterService(aqEventHandler);
        routerService.start();
        RouterService.schedule(new DispatchCommand(), 100L, 100L);
        RouterService.schedule(new ConnectionUpdate(), 60000L, 60000L);
        RouterService.schedule(new TransferUpdate(), 1000L, 1000L);
        AqEvent.signalEvent(99);
        AqMain.readLoop();
    }

    private static void readLoop() {
        LinkedList linkedList = new LinkedList();
        StringBuffer stringBuffer = new StringBuffer();
        Thread.currentThread().setPriority(1);
        try {
            while (true) {
                char c;
                if ((c = (char)reader.read()) == '|' || c == '\n') {
                    linkedList.add((Object)stringBuffer.toString());
                    stringBuffer.setLength(0);
                    if (c != '\n') continue;
                    if (!((String)linkedList.get(0)).equals("shutdown")) {
                        LinkedList linkedList2 = new LinkedList((Collection)dispatches);
                        linkedList2.add(linkedList.clone());
                        dispatches = Collections.unmodifiableList((List)linkedList2);
                        linkedList.clear();
                        continue;
                    }
                    break;
                }
                stringBuffer.append(c);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeEvent(String string) {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                writer.write(string);
                writer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                writer.close();
                reader.close();
                socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        RouterService.shutdown();
        System.exit(0);
    }
}

