/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class LimeXMLSchemaFieldExtractor {
    private Map _nameSchemaFieldInfoListMap = new HashMap();
    private static final String DUMMY = "DUMMY";
    private static final String DUMMY_SIMPLETYPE = "DUMMY_SIMPLETYPE";
    private static final Set PRIMITIVE_TYPES = new HashSet();
    private int _uniqueCount = 1;
    private String _lastUniqueComplexTypeName = "";
    private SchemaFieldInfo _lastFieldInfoObject = null;
    private Set _referencedNames = new HashSet();

    static {
        PRIMITIVE_TYPES.add((Object)"xsi:string");
        PRIMITIVE_TYPES.add((Object)"string");
        PRIMITIVE_TYPES.add((Object)"xsi:boolean");
        PRIMITIVE_TYPES.add((Object)"boolean");
        PRIMITIVE_TYPES.add((Object)"xsi:float");
        PRIMITIVE_TYPES.add((Object)"float");
        PRIMITIVE_TYPES.add((Object)"xsi:double");
        PRIMITIVE_TYPES.add((Object)"double");
        PRIMITIVE_TYPES.add((Object)"xsi:decimal");
        PRIMITIVE_TYPES.add((Object)"decimal");
        PRIMITIVE_TYPES.add((Object)"xsi:timeDuration");
        PRIMITIVE_TYPES.add((Object)"timeDuration");
        PRIMITIVE_TYPES.add((Object)"xsi:recurringDuration");
        PRIMITIVE_TYPES.add((Object)"recurringDuration");
        PRIMITIVE_TYPES.add((Object)"xsi:binary");
        PRIMITIVE_TYPES.add((Object)"binary");
        PRIMITIVE_TYPES.add((Object)"xsi:uriReference");
        PRIMITIVE_TYPES.add((Object)"uriReference");
        PRIMITIVE_TYPES.add((Object)"xsi:ID");
        PRIMITIVE_TYPES.add((Object)"ID");
        PRIMITIVE_TYPES.add((Object)"xsi:IDREF");
        PRIMITIVE_TYPES.add((Object)"IDREF");
        PRIMITIVE_TYPES.add((Object)"xsi:ENTITY");
        PRIMITIVE_TYPES.add((Object)"ENTITY");
        PRIMITIVE_TYPES.add((Object)"xsi:NUMTOKEN");
        PRIMITIVE_TYPES.add((Object)"NUMTOKEN");
        PRIMITIVE_TYPES.add((Object)"xsi:Qname");
        PRIMITIVE_TYPES.add((Object)"Qname");
    }

    LimeXMLSchemaFieldExtractor() {
    }

    public List getFields(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.getDocumentElement();
        this.traverse(element);
        String string = this.getRootElementName();
        LinkedList linkedList = new LinkedList();
        this.fillWithFieldNames((List)linkedList, (SchemaFieldInfoList)this._nameSchemaFieldInfoListMap.get((Object)string), string);
        return linkedList;
    }

    private void fillWithFieldNames(List list, SchemaFieldInfoList schemaFieldInfoList, String string) {
        Iterator iterator = schemaFieldInfoList.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfoPair schemaFieldInfoPair = (SchemaFieldInfoPair)iterator.next();
            SchemaFieldInfoList schemaFieldInfoList2 = (SchemaFieldInfoList)this._nameSchemaFieldInfoListMap.get((Object)schemaFieldInfoPair.getSchemaFieldInfo().getType());
            String string2 = schemaFieldInfoPair.getField();
            SchemaFieldInfo schemaFieldInfo = schemaFieldInfoPair.getSchemaFieldInfo();
            if (schemaFieldInfoList2 == null) {
                if (!this.isDummy(string2)) {
                    schemaFieldInfo.setCanonicalizedFieldName(String.valueOf(string) + "__" + string2);
                } else {
                    schemaFieldInfo.setCanonicalizedFieldName(string);
                }
                list.add((Object)schemaFieldInfo);
                continue;
            }
            if (!this.isDummy(string2)) {
                this.fillWithFieldNames(list, schemaFieldInfoList2, String.valueOf(string) + "__" + string2);
                continue;
            }
            this.fillWithFieldNames(list, schemaFieldInfoList2, string);
        }
    }

    private boolean isDummy(String string) {
        return string.trim().equals(DUMMY);
    }

    private String getRootElementName() {
        Set set = ((HashMap)((HashMap)this._nameSchemaFieldInfoListMap).clone()).keySet();
        Iterator iterator = this._referencedNames.iterator();
        while (iterator.hasNext()) {
            set.remove(iterator.next());
        }
        Iterator iterator2 = set.iterator();
        return (String)iterator2.next();
    }

    private void traverse(Node node) {
        String string = node.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(string)) {
            this.processElementTag(node);
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                this.traverse(node2);
                ++n2;
            }
        } else if (this.isComplexTypeTag(string)) {
            this.processComplexTypeTag(node);
        } else if (this.isSimpleTypeTag(string)) {
            LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(node, this._lastFieldInfoObject);
        } else {
            this.traverseChildren(node);
        }
    }

    private void processComplexTypeTag(Node node) {
        String string = this._lastUniqueComplexTypeName;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 != null) {
            string = node2.getNodeValue();
        }
        SchemaFieldInfoList schemaFieldInfoList = new SchemaFieldInfoList();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node3 = nodeList.item(n2);
            this.processChildOfComplexType(node3, schemaFieldInfoList);
            ++n2;
        }
        this._nameSchemaFieldInfoListMap.put((Object)string, (Object)schemaFieldInfoList);
        this._referencedNames.add((Object)string);
    }

    private void processChildOfComplexType(Node node, SchemaFieldInfoList schemaFieldInfoList) {
        String string = node.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(string)) {
            this.processChildElementTag(node, schemaFieldInfoList);
        } else if (this.isAttributeTag(string)) {
            this.processChildAttributeTag(node, schemaFieldInfoList);
        } else {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                this.processChildOfComplexType(node2, schemaFieldInfoList);
                ++n2;
            }
        }
    }

    private void processChildElementTag(Node node, SchemaFieldInfoList schemaFieldInfoList) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        SchemaFieldInfo schemaFieldInfo = null;
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            Node node3 = namedNodeMap.getNamedItem("ref");
            if (node3 == null) {
                return;
            }
            String string = node3.getNodeValue();
            schemaFieldInfo = new SchemaFieldInfo(string);
            schemaFieldInfoList.add(new SchemaFieldInfoPair(string, schemaFieldInfo));
            this._referencedNames.add((Object)string);
        } else {
            String string;
            String string2 = node2.getNodeValue();
            Node node4 = namedNodeMap.getNamedItem("type");
            if (node4 != null) {
                string = node4.getNodeValue();
            } else {
                this._lastUniqueComplexTypeName = string = this.getUniqueComplexTypeName();
            }
            schemaFieldInfo = new SchemaFieldInfo(this.removeNameSpace(string));
            schemaFieldInfoList.add(new SchemaFieldInfoPair(string2, schemaFieldInfo));
            this._lastFieldInfoObject = schemaFieldInfo;
            this.traverseChildren(node);
        }
    }

    private String removeNameSpace(String string) {
        if (string.indexOf(58) == -1) {
            return string;
        }
        return string.substring(string.indexOf(58) + 1);
    }

    private void processChildAttributeTag(Node node, SchemaFieldInfoList schemaFieldInfoList) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            return;
        }
        String string = String.valueOf(node2.getNodeValue()) + "__";
        Node node3 = namedNodeMap.getNamedItem("type");
        String string2 = node3 == null ? DUMMY_SIMPLETYPE : node3.getNodeValue();
        SchemaFieldInfo schemaFieldInfo = new SchemaFieldInfo(this.removeNameSpace(string2));
        LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(node, schemaFieldInfo);
        this.addAttributeSchemaFieldInfoPair(new SchemaFieldInfoPair(string, schemaFieldInfo), schemaFieldInfoList);
    }

    private void addAttributeSchemaFieldInfoPair(SchemaFieldInfoPair schemaFieldInfoPair, SchemaFieldInfoList schemaFieldInfoList) {
        int n = 0;
        Iterator iterator = schemaFieldInfoList.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfoPair schemaFieldInfoPair2 = (SchemaFieldInfoPair)iterator.next();
            if (!this.isAttribute(schemaFieldInfoPair2.getField())) break;
            ++n;
        }
        schemaFieldInfoList.add(n, schemaFieldInfoPair);
    }

    private static void processSimpleTypeForEnumeration(Node node, SchemaFieldInfo schemaFieldInfo) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            String string = node2.getNodeName();
            if (!LimeXMLSchemaFieldExtractor.isEnumerationTag(string)) {
                LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(node2, schemaFieldInfo);
            } else {
                Node node3 = node2.getAttributes().getNamedItem("value");
                if (node3 != null) {
                    schemaFieldInfo.addEnumerationValue(node3.getNodeValue());
                }
            }
            ++n2;
        }
    }

    private void traverseChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            this.traverse(node2);
            ++n2;
        }
    }

    private boolean isComplexTypeTag(String string) {
        return string.trim().equals("complexType") || string.trim().equals("xsd:complexType");
    }

    private boolean isSimpleTypeTag(String string) {
        return string.trim().equals("simpleType") || string.trim().equals("xsd:simpleType");
    }

    private boolean isAttributeTag(String string) {
        return string.trim().equals("attribute") || string.trim().equals("xsd:attribute");
    }

    private void processElementTag(Node node) {
        String string;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            return;
        }
        String string2 = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem("type");
        if (node3 != null) {
            string = node3.getNodeValue();
        } else {
            this._lastUniqueComplexTypeName = string = this.getUniqueComplexTypeName();
        }
        this.addToSchemaFieldInfoListMap(string2, string);
    }

    private String getUniqueComplexTypeName() {
        return "COMPLEXTYPE___" + this._uniqueCount++;
    }

    private void addToSchemaFieldInfoListMap(String string, String string2) {
        SchemaFieldInfoList schemaFieldInfoList = new SchemaFieldInfoList();
        schemaFieldInfoList.add(new SchemaFieldInfoPair(DUMMY, new SchemaFieldInfo(this.removeNameSpace(string2))));
        this._nameSchemaFieldInfoListMap.put((Object)string, (Object)schemaFieldInfoList);
        this._referencedNames.add((Object)this.removeNameSpace(string2));
    }

    private static boolean isElementTag(String string) {
        return string.trim().equals("element") || string.trim().equals("xsd:element");
    }

    private static boolean isEnumerationTag(String string) {
        return string.trim().equals("enumeration") || string.trim().equals("xsd:enumeration");
    }

    public boolean isAttribute(String string) {
        return string.endsWith("__");
    }

    private static class SchemaFieldInfoList {
        private LinkedList _elements = new LinkedList();

        SchemaFieldInfoList() {
        }

        public void add(SchemaFieldInfoPair schemaFieldInfoPair) {
            this._elements.add((Object)schemaFieldInfoPair);
        }

        public void add(int n, SchemaFieldInfoPair schemaFieldInfoPair) {
            this._elements.add(n, (Object)schemaFieldInfoPair);
        }

        public Iterator iterator() {
            return this._elements.iterator();
        }

        public String toString() {
            return this._elements.toString();
        }
    }

    private static class SchemaFieldInfoPair {
        private String _field;
        private SchemaFieldInfo _fieldInfo;

        public SchemaFieldInfoPair(String string, SchemaFieldInfo schemaFieldInfo) {
            this._field = string;
            this._fieldInfo = schemaFieldInfo;
        }

        public String getField() {
            return this._field;
        }

        public SchemaFieldInfo getSchemaFieldInfo() {
            return this._fieldInfo;
        }

        public String toString() {
            return "[" + this._field + ":" + this._fieldInfo + "]";
        }
    }
}

