/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.mp3.ID3Editor;
import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class LimeXMLReplyCollection {
    private static final Log LOG;
    private final String schemaURI;
    private final HashMap mainMap;
    private final Map trieMap;
    private final boolean audio;
    private File dataFile = null;
    private final Object WRITE_LOCK = new Object();
    public static final int NORMAL = 0;
    public static final int FILE_DEFECTIVE = 1;
    public static final int RW_ERROR = 2;
    public static final int BAD_ID3 = 3;
    public static final int FAILED_TITLE = 4;
    public static final int FAILED_ARTIST = 5;
    public static final int FAILED_ALBUM = 6;
    public static final int FAILED_YEAR = 7;
    public static final int FAILED_COMMENT = 8;
    public static final int FAILED_TRACK = 9;
    public static final int FAILED_GENRE = 10;
    public static final int HASH_FAILED = 11;
    public static final int INCORRECT_FILETYPE = 12;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.xml.LimeXMLReplyCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public LimeXMLReplyCollection(FileDesc[] fileDescArray, String string, boolean bl) {
        this.schemaURI = string;
        this.audio = bl;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("LimeXMLReplyCollection(): entered with audio = " + bl));
        }
        this.mainMap = new HashMap();
        this.trieMap = new HashMap();
        MapSerializer mapSerializer = this.initializeMapSerializer(string);
        Object object = mapSerializer == null ? new HashMap() : mapSerializer.getMap();
        boolean bl2 = false;
        Iterator iterator = object.keySet().iterator();
        if (iterator.hasNext()) {
            bl2 = iterator.next() instanceof String;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("requiresConversion: " + bl2));
        }
        int n = 0;
        while (n < fileDescArray.length) {
            block16: {
                FileDesc fileDesc = fileDescArray[n];
                if (!(fileDesc instanceof IncompleteFileDesc)) {
                    Object object2;
                    File file = fileDesc.getFile();
                    URN uRN = fileDesc.getSHA1Urn();
                    Object object3 = null;
                    Object object4 = null;
                    if (bl2) {
                        object2 = null;
                        try {
                            object2 = new String(LimeXMLUtils.hashFile(file));
                        }
                        catch (IOException iOException) {
                            break block16;
                        }
                        object3 = object.get(object2);
                        object4 = object3 != null && object3 instanceof LimeXMLDocument ? (LimeXMLDocument)object3 : this.constructDocument((String)object3, file);
                    } else {
                        object3 = object.get((Object)uRN);
                        object4 = object3 == null ? this.constructDocument(null, file) : (LimeXMLDocument)object3;
                    }
                    if (object4 != null) {
                        if (!((LimeXMLDocument)object4).supportsID3v2() && LimeXMLUtils.isMP3File(file)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("reconstructing document for id3v2: " + file));
                            }
                            if ((object2 = this.constructDocument(null, file)) != null) {
                                object4 = object2;
                            }
                        }
                        if (((LimeXMLDocument)object4).isValid() || (object4 = this.constructDocument(null, file)) != null && ((LimeXMLDocument)object4).isValid()) {
                            if (ID3Reader.isCorrupted((LimeXMLDocument)object4)) {
                                object4 = ID3Reader.fixCorruption((LimeXMLDocument)object4);
                                this.addReplyWithCommit(file, fileDesc, (LimeXMLDocument)object4, false);
                            } else {
                                this.addReply(fileDesc, (LimeXMLDocument)object4);
                            }
                        }
                    }
                }
            }
            ++n;
        }
        LOG.trace((Object)"LimeXMLReplyCollection(): returning.");
        this.write();
    }

    private LimeXMLDocument constructDocument(String string, File file) {
        if (this.audio && LimeXMLUtils.isMP3File(file)) {
            boolean bl = string == null || string.equals("");
            try {
                String string2;
                String string3;
                if (!bl && (string3 = this.joinAudioXMLStrings(string2 = ID3Reader.readDocument(file, bl), string)) != null) {
                    return new LimeXMLDocument(string3);
                }
                return ID3Reader.readDocument(file);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
            }
            catch (SchemaNotFoundException schemaNotFoundException) {}
        } else {
            try {
                if (string != null && !string.equals("")) {
                    return new LimeXMLDocument(string);
                }
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
            }
            catch (SchemaNotFoundException schemaNotFoundException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getKeyWords() {
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator iterator = this.mainMap.values().iterator();
            while (iterator.hasNext()) {
                LimeXMLDocument limeXMLDocument = (LimeXMLDocument)iterator.next();
                arrayList.addAll((Collection)limeXMLDocument.getKeyWords());
            }
        }
        return arrayList;
    }

    private MapSerializer initializeMapSerializer(String string) {
        String string2 = String.valueOf(LimeXMLSchema.getDisplayString(string)) + ".sxml";
        LimeXMLProperties limeXMLProperties = LimeXMLProperties.instance();
        String string3 = limeXMLProperties.getXMLDocsDir();
        this.dataFile = new File(string3, string2);
        if (this.dataFile.isDirectory()) {
            return null;
        }
        try {
            return new MapSerializer(this.dataFile);
        }
        catch (IOException iOException) {
            LOG.debug((Object)"exception initializing", (Throwable)iOException);
            return null;
        }
    }

    private String joinAudioXMLStrings(String string, String string2) {
        int n = string2.lastIndexOf("></audio>");
        if (n == -1) {
            return null;
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n);
        return String.valueOf(string3) + string + string4;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeywords(LimeXMLDocument limeXMLDocument) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator iterator = limeXMLDocument.getNameValueSet().iterator();
            while (iterator.hasNext()) {
                List list;
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                String string2 = I18NConvert.instance().getNorm((String)entry.getValue());
                Trie trie = (Trie)this.trieMap.get((Object)string);
                if (trie == null) {
                    trie = new Trie(true);
                    this.trieMap.put((Object)string, (Object)trie);
                }
                if ((list = (List)trie.get(string2)) == null) {
                    list = new LinkedList();
                    trie.add(string2, list);
                }
                list.add((Object)limeXMLDocument);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeywords(LimeXMLDocument limeXMLDocument) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator iterator = limeXMLDocument.getNameValueSet().iterator();
            while (iterator.hasNext()) {
                String string;
                List list;
                Map.Entry entry = (Map.Entry)iterator.next();
                String string2 = (String)entry.getKey();
                Trie trie = (Trie)this.trieMap.get((Object)string2);
                if (trie == null || (list = (List)trie.get(string = I18NConvert.instance().getNorm((String)entry.getValue()))) == null) continue;
                list.remove((Object)limeXMLDocument);
                if (list.size() != 0) continue;
                trie.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReply(FileDesc fileDesc, LimeXMLDocument limeXMLDocument) {
        URN uRN = fileDesc.getSHA1Urn();
        Object object = this.mainMap;
        synchronized (object) {
            this.mainMap.put((Object)uRN, (Object)limeXMLDocument);
            this.addKeywords(limeXMLDocument);
        }
        fileDesc.addLimeXMLDocument(limeXMLDocument);
        try {
            object = fileDesc.getFile().getCanonicalPath();
            limeXMLDocument.setIdentifier((String)object);
        }
        catch (IOException iOException) {}
    }

    void addReplyWithCommit(File file, FileDesc fileDesc, LimeXMLDocument limeXMLDocument, boolean bl) {
        this.addReply(fileDesc, limeXMLDocument);
        if (this.audio) {
            try {
                this.mp3ToDisk(fileDesc, file.getCanonicalPath(), limeXMLDocument, bl);
            }
            catch (IOException iOException) {}
        } else {
            this.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            return this.mainMap.size();
        }
    }

    public boolean isAudio() {
        return this.audio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument getDocForHash(URN uRN) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            return (LimeXMLDocument)this.mainMap.get((Object)uRN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMatchingReplies(LimeXMLDocument limeXMLDocument) {
        Object object;
        Iterator iterator;
        HashSet hashSet = null;
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            iterator = limeXMLDocument.getNameValueSet().iterator();
            while (iterator.hasNext()) {
                String string;
                Iterator iterator2;
                object = (Map.Entry)iterator.next();
                String string2 = (String)object.getKey();
                Trie trie = (Trie)this.trieMap.get((Object)string2);
                if (trie == null || !(iterator2 = trie.getPrefixedBy(string = (String)object.getValue())).hasNext()) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                while (iterator2.hasNext()) {
                    List list = (List)iterator2.next();
                    hashSet.addAll((Collection)list);
                }
            }
        }
        if (hashSet == null || hashSet.size() == 0) {
            return DataUtils.EMPTY_LIST;
        }
        hashMap = null;
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (LimeXMLDocument)iterator.next();
            if (!LimeXMLUtils.match((LimeXMLDocument)object, limeXMLDocument)) continue;
            if (hashMap == null) {
                hashMap = new LinkedList();
            }
            hashMap.add(object);
        }
        if (hashMap == null || hashMap.size() == 0) {
            return DataUtils.EMPTY_LIST;
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument replaceDoc(FileDesc fileDesc, LimeXMLDocument limeXMLDocument) {
        LimeXMLDocument limeXMLDocument2 = null;
        URN uRN = fileDesc.getSHA1Urn();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            limeXMLDocument2 = (LimeXMLDocument)this.mainMap.put((Object)uRN, (Object)limeXMLDocument);
            if (limeXMLDocument2 == null) {
                Assert.that(false, "attempted to replace doc that did not exist!!");
            }
            this.removeKeywords(limeXMLDocument2);
            this.addKeywords(limeXMLDocument);
        }
        fileDesc.replaceLimeXMLDocument(limeXMLDocument2, limeXMLDocument);
        return limeXMLDocument2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDoc(FileDesc fileDesc) {
        boolean bl;
        LimeXMLDocument limeXMLDocument;
        URN uRN = fileDesc.getSHA1Urn();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            limeXMLDocument = (LimeXMLDocument)this.mainMap.remove((Object)uRN);
            bl = limeXMLDocument != null;
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.write();
            if (bl2) {
                fileDesc.removeLimeXMLDocument(limeXMLDocument);
                this.removeKeywords(limeXMLDocument);
            } else {
                HashMap hashMap2 = this.mainMap;
                synchronized (hashMap2) {
                    this.mainMap.put((Object)uRN, (Object)limeXMLDocument);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found: " + bl + ", written: " + bl2));
        }
        return bl && bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        Object object;
        Object object2;
        if (this.dataFile == null) {
            object2 = String.valueOf(LimeXMLSchema.getDisplayString(this.schemaURI)) + ".sxml";
            object = LimeXMLProperties.instance();
            String string = ((LimeXMLProperties)object).getXMLDocsDir();
            this.dataFile = new File(string, (String)object2);
        }
        if (this.dataFile.isDirectory()) {
            return false;
        }
        try {
            object2 = new MapSerializer(this.dataFile, (Map)this.mainMap);
            object = this.WRITE_LOCK;
            synchronized (object) {
                ((MapSerializer)object2).commit();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public int mp3ToDisk(FileDesc fileDesc, String string, LimeXMLDocument limeXMLDocument, boolean bl) {
        ID3Editor iD3Editor;
        boolean bl2 = false;
        int n = -1;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("writing: " + string + " to disk."));
        }
        if ((iD3Editor = this.ripMP3XML(string, limeXMLDocument, bl)) != null) {
            if (iD3Editor.getCorrectDocument() == null) {
                n = this.commitID3Data(string, iD3Editor);
            } else {
                this.removeDoc(fileDesc);
                this.addReply(fileDesc, iD3Editor.getCorrectDocument());
                n = 0;
            }
        }
        Assert.that(n != 12, "trying to write id3 to non mp3 file");
        bl2 = this.write();
        if (!bl2) {
            return 2;
        }
        return n;
    }

    private ID3Editor ripMP3XML(String string, LimeXMLDocument limeXMLDocument, boolean bl) {
        if (!LimeXMLUtils.isMP3File(string)) {
            return null;
        }
        ID3Editor iD3Editor = new ID3Editor();
        String string2 = null;
        try {
            string2 = limeXMLDocument.getXMLStringWithIdentifier();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return null;
        }
        iD3Editor.removeID3Tags(string2);
        ID3Editor iD3Editor2 = new ID3Editor();
        LimeXMLDocument limeXMLDocument2 = null;
        try {
            limeXMLDocument2 = ID3Reader.readDocument(new File(string));
        }
        catch (IOException iOException) {
            return null;
        }
        String string3 = null;
        try {
            string3 = limeXMLDocument2.getXMLStringWithIdentifier();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return null;
        }
        iD3Editor2.removeID3Tags(string3);
        if (!bl) {
            if (iD3Editor.equals(iD3Editor2)) {
                return null;
            }
            return iD3Editor;
        }
        if (iD3Editor.equals(iD3Editor2)) {
            LOG.debug((Object)"tag read from disk is same as XML doc.");
            return null;
        }
        if (iD3Editor2.betterThan(iD3Editor)) {
            iD3Editor2.setCorrectDocument(limeXMLDocument2);
            return iD3Editor2;
        }
        iD3Editor.pickBetterFields(iD3Editor2);
        return iD3Editor;
    }

    private int commitID3Data(String string, ID3Editor iD3Editor) {
        int n = iD3Editor.writeID3DataToDisk(string);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("wrote data: " + n));
        }
        if (n == 1 || n == 2 || n == 3 || n == 12) {
            return n;
        }
        RouterService.getFileManager().fileChanged(new File(string));
        return n;
    }

    static /* synthetic */ Log access$0() {
        return LOG;
    }

    static class MapSerializer {
        private File _backingStoreFile;
        private Map _hashMap;

        MapSerializer(File file) throws IOException {
            this._backingStoreFile = file;
            if (this._backingStoreFile.exists()) {
                this.deserializeFromFile();
            } else {
                this._hashMap = new HashMap();
            }
        }

        MapSerializer(File file, Map map) {
            this._backingStoreFile = file;
            this._hashMap = map;
        }

        /*
         * Exception decompiling
         */
        private void deserializeFromFile() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [8 : 220->224)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void commit() throws IOException {
            this.serializeToFile();
        }

        /*
         * Exception decompiling
         */
        private void serializeToFile() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 75->79)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Map getMap() {
            return this._hashMap;
        }
    }
}

