/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.downloader.Interval;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.SortedSet;
import com.sun.java.util.collections.TreeSet;

public class IntervalSet {
    private final SortedSet intervals = new TreeSet((Comparator)new IntervalComparator());

    public void add(Interval interval) {
        int n = interval.low;
        int n2 = interval.high;
        Interval interval2 = null;
        Interval interval3 = null;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval4 = (Interval)iterator.next();
            if (n <= interval4.low && interval4.high <= n2) {
                iterator.remove();
                continue;
            }
            if (n <= interval4.high && interval4.low < n) {
                interval2 = interval4;
            }
            if (interval4.high == n - 1) {
                interval2 = interval4;
            }
            if (interval4.low <= n2 && interval4.high > n2) {
                interval3 = interval4;
            }
            if (n2 == interval4.low - 1) {
                interval3 = interval4;
            }
            if (interval3 != null || interval4.low > n2) break;
        }
        if (interval2 == null && interval3 == null) {
            this.intervals.add((Object)new Interval(n, n2));
        } else if (interval2 != null && interval3 != null) {
            this.intervals.remove(interval3);
            this.intervals.remove(interval2);
            this.intervals.add((Object)new Interval(interval2.low, interval3.high));
        } else if (interval3 != null) {
            this.intervals.remove(interval3);
            this.intervals.add((Object)new Interval(n, interval3.high));
        } else {
            this.intervals.remove(interval2);
            this.intervals.add((Object)new Interval(interval2.low, n2));
        }
    }

    public void delete(Interval interval) {
        int n = interval.low;
        int n2 = interval.high;
        Interval interval2 = null;
        Interval interval3 = null;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval4 = (Interval)iterator.next();
            if (interval4.high >= n && interval4.low <= n2) {
                iterator.remove();
                if (interval4.high <= n2) {
                    if (interval4.low >= n) continue;
                    interval2 = new Interval(interval4.low, n - 1);
                    continue;
                }
                if (interval4.low >= n) {
                    interval3 = new Interval(n2 + 1, interval4.high);
                    break;
                }
                interval2 = new Interval(interval4.low, n - 1);
                interval3 = new Interval(n2 + 1, interval4.high);
                break;
            }
            if (interval4.low >= n2) break;
        }
        if (interval2 != null) {
            this.add(interval2);
        }
        if (interval3 != null) {
            this.add(interval3);
        }
    }

    public void delete(IntervalSet intervalSet) {
        Iterator iterator = intervalSet.getAllIntervals();
        while (iterator.hasNext()) {
            this.delete((Interval)iterator.next());
        }
    }

    public Interval removeFirst() throws NoSuchElementException {
        Interval interval = (Interval)this.intervals.first();
        this.intervals.remove((Object)interval);
        return interval;
    }

    public List getOverlapIntervals(Interval interval) {
        ArrayList arrayList = new ArrayList();
        long l = interval.low;
        long l2 = interval.high;
        if (l >= l2) {
            return arrayList;
        }
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval2 = (Interval)iterator.next();
            if (l <= (long)interval2.low && (long)interval2.high <= l2) {
                arrayList.add((Object)interval2);
                continue;
            }
            if (l <= (long)interval2.high && (long)interval2.low < l) {
                arrayList.add((Object)new Interval((int)l, Math.min((int)l2, interval2.high)));
            }
            if ((long)interval2.low > l2 || (long)interval2.high <= l2) continue;
            arrayList.add((Object)new Interval(Math.max(interval2.low, (int)l), (int)l2));
        }
        return arrayList;
    }

    public Iterator getAllIntervals() {
        return this.intervals.iterator();
    }

    public List getAllIntervalsAsList() {
        return new ArrayList((Collection)this.intervals);
    }

    public int getSize() {
        int n = 0;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            n += interval.high - interval.low + 1;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.intervals.clear();
    }

    public IntervalSet invert(int n) {
        IntervalSet intervalSet = new IntervalSet();
        if (n < 1) {
            return intervalSet;
        }
        if (this.intervals.size() == 0) {
            Interval interval = new Interval(0, n - 1);
            intervalSet.add(interval);
            return intervalSet;
        }
        int n2 = -1;
        Interval interval = null;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            interval = (Interval)iterator.next();
            if (interval.low != 0 && n2 < interval.low) {
                intervalSet.add(new Interval(n2 + 1, interval.low - 1));
            }
            n2 = interval.high;
        }
        Assert.that(interval != null, "Null interval in getFreeBlocks");
        if (interval.high < n - 1) {
            intervalSet.add(new Interval(interval.high + 1, n - 1));
        }
        return intervalSet;
    }

    public Iterator getNeededIntervals(int n) {
        return this.invert(n).getAllIntervals();
    }

    public Object clone() {
        IntervalSet intervalSet = new IntervalSet();
        Iterator iterator = this.getAllIntervals();
        while (iterator.hasNext()) {
            intervalSet.intervals.add(iterator.next());
        }
        return intervalSet;
    }

    public String toString() {
        return this.intervals.toString();
    }

    private class IntervalComparator
    implements Comparator {
        IntervalComparator() {
        }

        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            return interval.low - interval2.low;
        }
    }
}

