/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.uploader.BannedUploadState;
import com.limegroup.gnutella.uploader.BrowseHostUploadState;
import com.limegroup.gnutella.uploader.FileNotFoundUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.LimitReachedUploadState;
import com.limegroup.gnutella.uploader.MalformedRequestState;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.uploader.PushProxyUploadState;
import com.limegroup.gnutella.uploader.QueuedUploadState;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.uploader.THEXUploadState;
import com.limegroup.gnutella.uploader.UnavailableRangeUploadState;
import com.limegroup.gnutella.uploader.UpdateFileState;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.CountingOutputStream;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public final class HTTPUploader
implements Uploader {
    private CountingOutputStream _ostream;
    private InputStream _fis;
    private Socket _socket;
    private int _totalAmountRead;
    private int _amountRead;
    private int _amountRequested;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _fileSize;
    private final int _index;
    private String _userAgent;
    private boolean _headersParsed;
    private final String _fileName;
    private final String _hostName;
    private int _stateNum = 0;
    private int _lastTransferStateNum;
    private HTTPMessage _state;
    private boolean _firstReply = true;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private boolean _supportsQueueing = false;
    private final StalledUploadWatchdog STALLED_WATCHDOG;
    private URN _requestedURN;
    private FileDesc _fileDesc;
    private boolean _clientAcceptsXGnutellaQueryreplies = false;
    private InetAddress _nodeAddress = null;
    private int _nodePort = -1;
    private Map _parameters = null;
    private BandwidthTrackerImpl bandwidthTracker = null;
    private Set _writtenLocs;
    private static final int MAX_LOCATIONS = 10;
    private HTTPRequestMethod _method;
    private static final boolean RECORD_STATS = !CommonUtils.isJava118();
    private final boolean debugOn = false;

    public HTTPUploader(HTTPRequestMethod hTTPRequestMethod, String string, Socket socket, int n, Map map, StalledUploadWatchdog stalledUploadWatchdog) {
        this.STALLED_WATCHDOG = stalledUploadWatchdog;
        this._socket = socket;
        this._hostName = this._socket.getInetAddress().getHostAddress();
        this._fileName = string;
        this._index = n;
        this._writtenLocs = null;
        this.reinitialize(hTTPRequestMethod, map);
    }

    public void reinitialize(HTTPRequestMethod hTTPRequestMethod, Map map) {
        this._method = hTTPRequestMethod;
        this._amountRequested = 0;
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        this._headersParsed = false;
        this._stateNum = 0;
        this._state = null;
        this._nodePort = 0;
        this._supportsQueueing = false;
        this._requestedURN = null;
        this._clientAcceptsXGnutellaQueryreplies = false;
        this._parameters = map;
        if (this.bandwidthTracker == null) {
            this.bandwidthTracker = new BandwidthTrackerImpl();
            this._totalAmountRead = 0;
            this._amountRead = 0;
        } else {
            this._totalAmountRead += this._amountRead;
            this._amountRead = 0;
        }
    }

    public void setFileDesc(FileDesc fileDesc) throws IOException {
        this._fileDesc = fileDesc;
        this._fileSize = (int)fileDesc.getSize();
        if (this._writtenLocs == null) {
            this._writtenLocs = new HashSet();
        }
        if (this._fis != null) {
            try {
                this._fis.close();
            }
            catch (IOException iOException) {}
        }
        this._fis = this._fileDesc.createInputStream();
    }

    public void initializeStreams() throws IOException {
        this._ostream = new CountingOutputStream(this._socket.getOutputStream());
    }

    public void writeResponse() throws IOException {
        block2: {
            this._ostream.setIsCounting(this._stateNum == 15);
            try {
                this._method.writeHttpResponse(this._state, this._ostream);
            }
            catch (IOException iOException) {
                if (this.amountUploaded() >= this.getAmountRequested()) break block2;
                throw iOException;
            }
        }
        this._firstReply = false;
    }

    public void stop() {
        try {
            if (this._ostream != null) {
                this._ostream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void closeFileStreams() {
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void setState(int n) {
        this._stateNum = n;
        switch (n) {
            case 3: {
                this._state = new NormalUploadState(this, this.STALLED_WATCHDOG);
                break;
            }
            case 9: {
                int n2 = RouterService.getUploadManager().positionInQueue(this._socket);
                this._state = new QueuedUploadState(n2, this);
                break;
            }
            case 2: {
                this._state = new LimitReachedUploadState(this);
                break;
            }
            case 1: {
                this._state = new FreeloaderUploadState();
                break;
            }
            case 8: {
                this._state = new BrowseHostUploadState(this);
                break;
            }
            case 12: {
                this._state = new PushProxyUploadState(this);
                break;
            }
            case 10: {
                this._state = new UpdateFileState(this);
                break;
            }
            case 7: {
                this._state = new FileNotFoundUploadState();
                break;
            }
            case 11: {
                this._state = new MalformedRequestState();
                break;
            }
            case 13: {
                this._state = new UnavailableRangeUploadState(this);
                break;
            }
            case 14: {
                this._state = new BannedUploadState();
                break;
            }
            case 15: {
                this._state = new THEXUploadState(this, this.STALLED_WATCHDOG);
                break;
            }
            case 0: 
            case 4: 
            case 5: {
                this._state = null;
                break;
            }
            default: {
                Assert.that(false, "Invalid state: " + n);
            }
        }
        if (this._state != null) {
            this._lastTransferStateNum = n;
        }
    }

    OutputStream getOutputStream() {
        return this._ostream;
    }

    InputStream getInputStream() {
        return this._fis;
    }

    public boolean getCloseConnection() {
        Assert.that(this._state != null);
        return this._state.getCloseConnection();
    }

    public HTTPRequestMethod getMethod() {
        return this._method;
    }

    public int getQueuePosition() {
        if (this._lastTransferStateNum != 9 || this._stateNum == 5) {
            return -1;
        }
        return RouterService.getUploadManager().positionInQueue(this._socket);
    }

    void setAmountUploaded(int n) {
        int n2 = n - this._amountRead;
        if (RECORD_STATS && n2 > 0) {
            BandwidthStat.HTTP_BODY_UPSTREAM_BANDWIDTH.addData(n2);
        }
        this._amountRead = n;
    }

    public boolean isInactive() {
        switch (this._stateNum) {
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    Map getParameters() {
        return this._parameters;
    }

    public int getUploadBegin() {
        return this._uploadBegin;
    }

    public int getUploadEnd() {
        return this._uploadEnd;
    }

    public int getFileSize() {
        if (this._stateNum == 15) {
            return this._fileDesc.getHashTree().getOutputLength();
        }
        return this._fileSize;
    }

    public int getAmountRequested() {
        if (this._stateNum == 15) {
            return this._fileDesc.getHashTree().getOutputLength();
        }
        return this._amountRequested;
    }

    public int getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getState() {
        return this._stateNum;
    }

    public int getLastTransferState() {
        return this._lastTransferStateNum;
    }

    public String getHost() {
        return this._hostName;
    }

    public boolean isChatEnabled() {
        return this._chatEnabled;
    }

    public boolean isBrowseHostEnabled() {
        return this._browseEnabled;
    }

    public int getGnutellaPort() {
        return this._nodePort;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public boolean isHeaderParsed() {
        return this._headersParsed;
    }

    public boolean supportsQueueing() {
        return this._supportsQueueing && this.isValidQueueingAgent();
    }

    public boolean isTHEXRequest() {
        return "N2X?".equals(this._parameters.get((Object)"service_id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getNextSetOfAltsToSend() {
        AlternateLocationCollection alternateLocationCollection = this._fileDesc.getAlternateLocationCollection();
        HashSet hashSet = null;
        AlternateLocationCollection alternateLocationCollection2 = alternateLocationCollection;
        synchronized (alternateLocationCollection2) {
            Iterator iterator = alternateLocationCollection.iterator();
            int n = 0;
            while (iterator.hasNext() && n < 10) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                if (this._writtenLocs.contains((Object)alternateLocation)) continue;
                this._writtenLocs.add((Object)alternateLocation);
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.add((Object)alternateLocation);
                ++n;
            }
            return hashSet == null ? DataUtils.EMPTY_SET : hashSet;
        }
    }

    private boolean isValidQueueingAgent() {
        if (this._userAgent == null) {
            return true;
        }
        return !this._userAgent.startsWith("Morpheus 3.0.2");
    }

    protected boolean isFirstReply() {
        return this._firstReply;
    }

    public InetAddress getNodeAddress() {
        return this._nodeAddress;
    }

    public int getNodePort() {
        return this._nodePort;
    }

    public int amountUploaded() {
        if (this._stateNum == 15) {
            if (this._ostream == null) {
                return 0;
            }
            return this._ostream.getAmountWritten();
        }
        return this._amountRead;
    }

    public int getTotalAmountUploaded() {
        if (this._stateNum == 15) {
            if (this._ostream == null) {
                return 0;
            }
            return this._ostream.getAmountWritten();
        }
        return this._totalAmountRead + this._amountRead;
    }

    public FileDesc getFileDesc() {
        return this._fileDesc;
    }

    boolean getClientAcceptsXGnutellaQueryreplies() {
        return this._clientAcceptsXGnutellaQueryreplies;
    }

    public URN getRequestedURN() {
        return this._requestedURN;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readHeader(InputStream inputStream) throws IOException {
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        this._clientAcceptsXGnutellaQueryreplies = false;
        ByteReader byteReader = new ByteReader(inputStream);
        try {
            try {
                String string;
                while ((string = byteReader.readLine()) != null && !string.equals("")) {
                    if (RECORD_STATS) {
                        BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
                    }
                    this.debug("HTTPUploader.readHeader(): str = " + string);
                    if (this.readChatHeader(string) || this.readRangeHeader(string) || this.readUserAgentHeader(string) || this.readContentURNHeader(string) || this.readAltLocationHeader(string) || this.readNAltLocationHeader(string) || this.readAcceptHeader(string) || this.readQueueVersion(string) || this.readNodeHeader(string)) continue;
                }
            }
            catch (ProblemReadingHeaderException problemReadingHeaderException) {
                String string;
                do {
                    if ((string = byteReader.readLine()) == null) throw problemReadingHeaderException;
                } while (!string.equals(""));
                throw problemReadingHeaderException;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (this._uploadEnd <= 0 || this._uploadEnd <= this._uploadBegin || this._uploadEnd > this._fileSize) {
                this._uploadEnd = this._fileSize;
            }
            this._amountRequested = this._uploadEnd - this._uploadBegin;
            this._headersParsed = true;
            throw throwable;
        }
        {
            Object var5_8 = null;
            if (this._uploadEnd <= 0 || this._uploadEnd <= this._uploadBegin || this._uploadEnd > this._fileSize) {
                this._uploadEnd = this._fileSize;
            }
            this._amountRequested = this._uploadEnd - this._uploadBegin;
            this._headersParsed = true;
            return;
        }
    }

    private boolean readChatHeader(String string) throws IOException {
        int n;
        String string2;
        if (string.toUpperCase().indexOf("CHAT:") == -1) {
            return false;
        }
        try {
            string2 = string.substring(5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        string2 = string2.trim();
        int n2 = string2.indexOf(":");
        String string3 = string2.substring(0, n2);
        string3 = string3.trim();
        String string4 = string2.substring(n2 + 1);
        string4 = string4.trim();
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        this._chatEnabled = true;
        this._browseEnabled = true;
        this._nodePort = n;
        return true;
    }

    private boolean readRangeHeader(String string) throws IOException {
        String string2;
        String string3;
        int n;
        if (StringUtils.indexOfIgnoreCase(string, "Range:") == -1) {
            return false;
        }
        try {
            n = string.indexOf("bytes");
            if (n < 0) {
                throw new ProblemReadingHeaderException("bytes not present in range");
            }
            string3 = string.substring(n += 6);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        string3 = string3.trim();
        try {
            n = string3.charAt(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        if (n == 45) {
            String string4;
            try {
                string4 = string3.substring(1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ProblemReadingHeaderException();
            }
            string4 = string4.trim();
            try {
                this._uploadBegin = Math.max(0, this._fileSize - Integer.parseInt(string4));
                this._uploadEnd = this._fileSize;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProblemReadingHeaderException();
            }
        }
        int n2 = string3.indexOf("-");
        if (n2 == -1) {
            throw new ProblemReadingHeaderException();
        }
        String string5 = string3.substring(0, n2).trim();
        try {
            this._uploadBegin = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        try {
            string2 = string3.substring(n2 + 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        string2 = string2.trim();
        if (!string2.equals("")) {
            try {
                this._uploadEnd = Integer.parseInt(string2) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProblemReadingHeaderException();
            }
        }
        return true;
    }

    private boolean readUserAgentHeader(String string) throws FreeloaderUploadingException {
        if (StringUtils.indexOfIgnoreCase(string, "User-Agent:") == -1) {
            return false;
        }
        if (!(SharingSettings.ALLOW_BROWSER.getValue() || this._stateNum == 8 || this._stateNum == 12 || this._fileName.toUpperCase().startsWith("LIMEWIRE") || string.indexOf("Mozilla") == -1 && string.indexOf("Morpheus") == -1 && string.indexOf("DA") == -1 && string.indexOf("Download") == -1 && string.indexOf("FlashGet") == -1 && string.indexOf("GetRight") == -1 && string.indexOf("Go!Zilla") == -1 && string.indexOf("Inet") == -1 && string.indexOf("MIIxpc") == -1 && string.indexOf("MSProxy") == -1 && string.indexOf("Mass") == -1 && string.indexOf("MLdonkey") == -1 && string.indexOf("MyGetRight") == -1 && string.indexOf("NetAnts") == -1 && string.indexOf("NetZip") == -1 && string.indexOf("RealDownload") == -1 && string.indexOf("SmartDownload") == -1 && string.indexOf("Teleport") == -1 && string.indexOf("WebDownloader") == -1)) {
            throw new FreeloaderUploadingException();
        }
        this._userAgent = string.substring(11).trim();
        return true;
    }

    private boolean readContentURNHeader(String string) {
        if (!HTTPHeaderName.GNUTELLA_CONTENT_URN.matchesStartOfString(string)) {
            return false;
        }
        this._requestedURN = HTTPUploader.parseContentUrn(string);
        return true;
    }

    private boolean readAltLocationHeader(String string) {
        if (!HTTPHeaderName.ALT_LOCATION.matchesStartOfString(string)) {
            return false;
        }
        if (this._fileDesc != null) {
            this.parseAlternateLocations(string, this._fileDesc, true);
        }
        return true;
    }

    private boolean readNAltLocationHeader(String string) {
        if (!HTTPHeaderName.NALTS.matchesStartOfString(string)) {
            return false;
        }
        if (this._fileDesc != null) {
            this.parseAlternateLocations(string, this._fileDesc, false);
        }
        return true;
    }

    private boolean readAcceptHeader(String string) {
        if (StringUtils.indexOfIgnoreCase(string, "accept:") == -1) {
            return false;
        }
        if (StringUtils.indexOfIgnoreCase(string, "application/x-gnutella-packets") != -1) {
            this._clientAcceptsXGnutellaQueryreplies = true;
        }
        return true;
    }

    private boolean readQueueVersion(String string) {
        if (!HTTPHeaderName.QUEUE_HEADER.matchesStartOfString(string)) {
            return false;
        }
        this._supportsQueueing = true;
        return true;
    }

    private boolean readNodeHeader(String string) {
        if (!HTTPHeaderName.NODE.matchesStartOfString(string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(HTTPUtils.extractHeaderValue(string), ":");
        InetAddress inetAddress = null;
        int n = -1;
        if (stringTokenizer.countTokens() == 2) {
            try {
                inetAddress = InetAddress.getByName(stringTokenizer.nextToken().trim());
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (NetworkUtils.isValidPort(n)) {
                    this._nodeAddress = inetAddress;
                    this._nodePort = n;
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return true;
    }

    private boolean readFeatureHeader(String string) {
        if (!HTTPHeaderName.FEATURES.matchesStartOfString(string)) {
            return false;
        }
        string = HTTPUtils.extractHeaderValue(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            int n = string2.indexOf("/");
            string3 = n == -1 ? string2.toLowerCase().trim() : string2.substring(0, n).toLowerCase().trim();
            if (string3.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (string3.equals("browse")) {
                this._browseEnabled = true;
                continue;
            }
            if (!string3.equals("queue")) continue;
            this._supportsQueueing = true;
        }
        return true;
    }

    private static URN parseContentUrn(String string) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return URN.INVALID;
        }
        try {
            return URN.createSHA1Urn(string2);
        }
        catch (IOException iOException) {
            return URN.INVALID;
        }
    }

    private void parseAlternateLocations(String string, AlternateLocationCollector alternateLocationCollector, boolean bl) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                AlternateLocation alternateLocation = AlternateLocation.create(stringTokenizer.nextToken().trim(), this._fileDesc.getSHA1Urn());
                URN uRN = alternateLocation.getSHA1Urn();
                if (!uRN.equals(alternateLocationCollector.getSHA1Urn())) continue;
                if (bl) {
                    alternateLocationCollector.add(alternateLocation);
                } else {
                    alternateLocationCollector.remove(alternateLocation);
                }
                this._writtenLocs.add((Object)alternateLocation);
            }
            catch (IOException iOException) {}
        }
    }

    public void measureBandwidth() {
        int n = this._totalAmountRead + this._amountRead;
        if (this._ostream != null) {
            n += this._ostream.getAmountWritten();
        }
        this.bandwidthTracker.measureBandwidth(n);
    }

    public float getMeasuredBandwidth() {
        float f = 0.0f;
        try {
            f = this.bandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            f = 0.0f;
        }
        return f;
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    private void debug(String string) {
    }

    public String toString() {
        return "<" + this._hostName + ":" + this._index + ">";
    }
}

