/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache
implements Serializable {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final transient Log LOG;
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.tigertree.TigerTreeCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
    }

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fileDesc) {
        HashTree hashTree = (HashTree)TREE_MAP.get((Object)fileDesc.getSHA1Urn());
        if (hashTree == null) {
            QUEUE.add(new HashRunner(fileDesc));
        }
        return hashTree;
    }

    public synchronized HashTree getHashTree(URN uRN) {
        HashTree hashTree = (HashTree)TREE_MAP.get((Object)uRN);
        return hashTree;
    }

    public synchronized void purgeTree(URN uRN) {
        TREE_MAP.remove((Object)uRN);
    }

    public static synchronized void addHashTree(URN uRN, HashTree hashTree) {
        if (hashTree.isGoodDepth()) {
            TREE_MAP.put((Object)uRN, (Object)hashTree);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added hashtree for urn " + uRN + ";" + hashTree.getRootHash()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hashtree for urn " + uRN + " had bad depth"));
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        Map map;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ObjectInputStream(new FileInputStream(CACHE_FILE));
                map = (Map)objectInputStream.readObject();
                Object var1_10 = null;
                if (objectInputStream == null) return map;
            }
            catch (IOException iOException) {
                HashMap hashMap = new HashMap();
                Object var1_11 = null;
                if (objectInputStream == null) return hashMap;
                try {
                    objectInputStream.close();
                    return hashMap;
                }
                catch (IOException iOException2) {}
                return hashMap;
            }
            catch (ClassCastException classCastException) {
                HashMap hashMap = new HashMap();
                Object var1_12 = null;
                if (objectInputStream == null) return hashMap;
                try {}
                catch (IOException iOException) {}
                objectInputStream.close();
                return hashMap;
            }
            catch (ClassNotFoundException classNotFoundException) {
                HashMap hashMap = new HashMap();
                Object var1_13 = null;
                if (objectInputStream == null) return hashMap;
                try {}
                catch (IOException iOException) {}
                objectInputStream.close();
                return hashMap;
            }
            catch (ArrayStoreException arrayStoreException) {
                HashMap hashMap = new HashMap();
                Object var1_14 = null;
                if (objectInputStream == null) return hashMap;
                try {}
                catch (IOException iOException) {}
                objectInputStream.close();
                return hashMap;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                HashMap hashMap = new HashMap();
                Object var1_15 = null;
                if (objectInputStream == null) return hashMap;
                try {}
                catch (IOException iOException) {}
                objectInputStream.close();
                return hashMap;
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                HashMap hashMap = new HashMap();
                Object var1_16 = null;
                if (objectInputStream == null) return hashMap;
                try {}
                catch (IOException iOException) {}
                objectInputStream.close();
                return hashMap;
            }
            catch (IllegalStateException illegalStateException) {
                HashMap hashMap = new HashMap();
                Object var1_17 = null;
                if (objectInputStream == null) return hashMap;
                try {}
                catch (IOException iOException) {}
                objectInputStream.close();
                return hashMap;
            }
            catch (SecurityException securityException) {
                HashMap hashMap = new HashMap();
                Object var1_18 = null;
                if (objectInputStream == null) return hashMap;
                try {}
                catch (IOException iOException) {}
                objectInputStream.close();
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var1_19 = null;
            if (objectInputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            objectInputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        objectInputStream.close();
        return map;
    }

    private static void removeOldEntries(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (RouterService.getFileManager().getFileDescForUrn(uRN) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(uRN) != null || Math.random() > (double)(map.size() / 200)) continue;
            map.remove((Object)uRN);
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void persistCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 67->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fileDesc) {
            this.FD = fileDesc;
        }

        public void run() {
            try {
                URN uRN = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(uRN) == null) {
                    HashTree hashTree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(uRN, hashTree);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

