/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.ByteSetting;
import com.limegroup.gnutella.settings.CharArraySetting;
import com.limegroup.gnutella.settings.FileArraySetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.FloatSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.LongSetting;
import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.settings.StringArraySetting;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public final class SettingsFactory {
    private final byte[] PRE_HEADER = "#LimeWire Properties IO Test\n".getBytes();
    private static final long EXPIRY_INTERVAL = 1209600000L;
    private LongSetting LAST_EXPIRE_TIME = null;
    private File SETTINGS_FILE;
    private final String HEADING;
    protected final Properties DEFAULT_PROPS = new Properties();
    protected final Properties PROPS = new Properties(this.DEFAULT_PROPS);
    private ArrayList settings = new ArrayList(10);
    private boolean expired = false;

    SettingsFactory(File file) {
        this(file, "");
    }

    SettingsFactory(File file, String string) {
        this.SETTINGS_FILE = file;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.HEADING = string;
        this.reload();
    }

    public synchronized Iterator iterator() {
        return this.settings.iterator();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void reload() {
        Object object;
        block15: {
            if (!this.SETTINGS_FILE.isFile()) {
                this.setExpireValue();
                return;
            }
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(this.SETTINGS_FILE);
                    try {
                        this.PROPS.load(fileInputStream);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IOException iOException) {
                        object = iOException.getMessage();
                        if (StringUtils.indexOfIgnoreCase((String)object, "corrupted") < 0) {
                            throw iOException;
                        }
                        this.SETTINGS_FILE.delete();
                        MessageService.showError("ERROR_PROPS_CORRUPTED");
                    }
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var4_8 = null;
                if (fileInputStream == null) break block15;
            }
            try {}
            catch (IOException iOException) {}
            fileInputStream.close();
        }
        Iterator iterator = this.settings.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.setExpireValue();
                return;
            }
            object = (Setting)iterator.next();
            ((Setting)object).reload();
        }
    }

    private synchronized void setExpireValue() {
        if (this.LAST_EXPIRE_TIME == null) {
            this.LAST_EXPIRE_TIME = this.createLongSetting("LAST_EXPIRE_TIME", 0L);
            boolean bl = this.expired = this.LAST_EXPIRE_TIME.getValue() + 1209600000L < System.currentTimeMillis();
            if (this.expired) {
                this.LAST_EXPIRE_TIME.setValue(System.currentTimeMillis());
            }
        }
    }

    public synchronized void changeFile(File file) {
        this.SETTINGS_FILE = file;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.revertToDefault();
        this.reload();
    }

    public synchronized void revertToDefault() {
        Iterator iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            Setting setting = (Setting)iterator.next();
            setting.revertToDefault();
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void save() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 194->198)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Properties getProperties() {
        return this.PROPS;
    }

    public synchronized StringSetting createStringSetting(String string, String string2) {
        StringSetting stringSetting = new StringSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
        this.settings.add((Object)stringSetting);
        stringSetting.reload();
        return stringSetting;
    }

    public synchronized BooleanSetting createBooleanSetting(String string, boolean bl) {
        BooleanSetting booleanSetting = new BooleanSetting(this.DEFAULT_PROPS, this.PROPS, string, bl);
        this.settings.add((Object)booleanSetting);
        booleanSetting.reload();
        return booleanSetting;
    }

    public synchronized IntSetting createIntSetting(String string, int n) {
        IntSetting intSetting = new IntSetting(this.DEFAULT_PROPS, this.PROPS, string, n);
        this.settings.add((Object)intSetting);
        intSetting.reload();
        return intSetting;
    }

    public synchronized ByteSetting createByteSetting(String string, byte by) {
        ByteSetting byteSetting = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, string, by);
        this.settings.add((Object)byteSetting);
        byteSetting.reload();
        return byteSetting;
    }

    public synchronized LongSetting createLongSetting(String string, long l) {
        LongSetting longSetting = new LongSetting(this.DEFAULT_PROPS, this.PROPS, string, l);
        this.settings.add((Object)longSetting);
        longSetting.reload();
        return longSetting;
    }

    public synchronized FileSetting createFileSetting(String string, File file) {
        Object object;
        String string2 = file.getParent();
        if (string2 != null && !((File)(object = new File(string2))).isDirectory()) {
            ((File)object).mkdirs();
        }
        object = new FileSetting(this.DEFAULT_PROPS, this.PROPS, string, file);
        this.settings.add(object);
        ((Setting)object).reload();
        return object;
    }

    public synchronized CharArraySetting createCharArraySetting(String string, char[] cArray) {
        CharArraySetting charArraySetting = CharArraySetting.createCharArraySetting(this.DEFAULT_PROPS, this.PROPS, string, cArray);
        this.settings.add((Object)charArraySetting);
        charArraySetting.reload();
        return charArraySetting;
    }

    public synchronized FloatSetting createFloatSetting(String string, float f) {
        FloatSetting floatSetting = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, string, f);
        this.settings.add((Object)floatSetting);
        floatSetting.reload();
        return floatSetting;
    }

    public synchronized StringArraySetting createStringArraySetting(String string, String[] stringArray) {
        StringArraySetting stringArraySetting = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, string, stringArray);
        this.settings.add((Object)stringArraySetting);
        stringArraySetting.reload();
        return stringArraySetting;
    }

    public synchronized FileArraySetting createFileArraySetting(String string, File[] fileArray) {
        FileArraySetting fileArraySetting = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray);
        this.settings.add((Object)fileArraySetting);
        fileArraySetting.reload();
        return fileArraySetting;
    }

    public synchronized BooleanSetting createExpirableBooleanSetting(String string, boolean bl) {
        BooleanSetting booleanSetting = this.createBooleanSetting(string, bl);
        if (this.expired) {
            booleanSetting.revertToDefault();
        }
        return booleanSetting;
    }

    public synchronized IntSetting createExpirableIntSetting(String string, int n) {
        IntSetting intSetting = this.createIntSetting(string, n);
        if (this.expired) {
            intSetting.revertToDefault();
        }
        return intSetting;
    }
}

