/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import java.util.Hashtable;
import java.util.Properties;

public abstract class Setting {
    protected final Properties DEFAULT_PROPS;
    protected final Properties PROPS;
    protected final String KEY;
    protected final String DEFAULT_VALUE;
    private boolean _alwaysSave = false;

    protected Setting(Properties properties, Properties properties2, String string, String string2) {
        this.DEFAULT_PROPS = properties;
        this.PROPS = properties2;
        this.KEY = string;
        this.DEFAULT_VALUE = string2;
        if (((Hashtable)this.DEFAULT_PROPS).containsKey(string)) {
            throw new IllegalArgumentException("duplicate setting key");
        }
        ((Hashtable)this.DEFAULT_PROPS).put(this.KEY, string2);
        this.loadValue(string2);
    }

    public void reload() {
        String string = this.PROPS.getProperty(this.KEY);
        if (string == null) {
            string = this.DEFAULT_VALUE;
        }
        this.loadValue(string);
    }

    public void revertToDefault() {
        this.setValue(this.DEFAULT_VALUE);
    }

    public boolean shouldAlwaysSave() {
        return this._alwaysSave;
    }

    public Setting setAlwaysSave(boolean bl) {
        this._alwaysSave = bl;
        return this;
    }

    public boolean isDefault() {
        String string = this.PROPS.getProperty(this.KEY);
        if (string == null) {
            return false;
        }
        return string.equals(this.DEFAULT_PROPS.getProperty(this.KEY));
    }

    public String getKey() {
        return this.KEY;
    }

    public String getValueAsString() {
        return this.PROPS.getProperty(this.KEY);
    }

    protected void setValue(String string) {
        ((Hashtable)this.PROPS).put(this.KEY, string);
        this.loadValue(string);
    }

    protected abstract void loadValue(String var1);
}

