/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.QueryHandler;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;

final class ProbeQuery {
    private final List TTL_1_PROBES;
    private final List TTL_2_PROBES;
    private final QueryHandler QUERY_HANDLER;

    ProbeQuery(List list, QueryHandler queryHandler) {
        this.QUERY_HANDLER = queryHandler;
        LinkedList[] linkedListArray = ProbeQuery.createProbeLists(list, queryHandler.QUERY);
        this.TTL_1_PROBES = linkedListArray[0];
        this.TTL_2_PROBES = linkedListArray[1];
    }

    long getTimeToWait() {
        if (!this.TTL_2_PROBES.isEmpty()) {
            return (long)((double)this.QUERY_HANDLER.getTimeToWaitPerHop() * 1.3);
        }
        if (!this.TTL_1_PROBES.isEmpty()) {
            return (long)((double)this.QUERY_HANDLER.getTimeToWaitPerHop() * ((double)this.TTL_1_PROBES.size() / 2.0));
        }
        return 0L;
    }

    int sendProbe() {
        ManagedConnection managedConnection;
        Iterator iterator = this.TTL_1_PROBES.iterator();
        int n = 0;
        QueryRequest queryRequest = this.QUERY_HANDLER.createQuery((byte)1);
        while (iterator.hasNext()) {
            managedConnection = (ManagedConnection)iterator.next();
            n += QueryHandler.sendQueryToHost(queryRequest, managedConnection, this.QUERY_HANDLER);
        }
        queryRequest = this.QUERY_HANDLER.createQuery((byte)2);
        iterator = this.TTL_2_PROBES.iterator();
        while (iterator.hasNext()) {
            managedConnection = (ManagedConnection)iterator.next();
            n += QueryHandler.sendQueryToHost(queryRequest, managedConnection, this.QUERY_HANDLER);
        }
        this.TTL_1_PROBES.clear();
        this.TTL_2_PROBES.clear();
        return n;
    }

    private static LinkedList[] createProbeLists(List list, QueryRequest queryRequest) {
        boolean bl;
        Object object;
        Iterator iterator = list.iterator();
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        while (iterator.hasNext()) {
            object = (ManagedConnection)iterator.next();
            if (((Connection)object).isUltrapeerQueryRoutingConnection()) {
                if (((ManagedConnection)object).shouldForwardQuery(queryRequest)) {
                    linkedList3.add(object);
                    continue;
                }
                linkedList.add(object);
                continue;
            }
            linkedList2.add(object);
        }
        object = new LinkedList[2];
        LinkedList linkedList4 = new LinkedList();
        LinkedList linkedList5 = new LinkedList();
        object[0] = linkedList4;
        object[1] = linkedList5;
        boolean bl2 = bl = linkedList.size() + linkedList3.size() > 8;
        if (linkedList3.size() == 0 || !bl) {
            return ProbeQuery.createAggressiveProbe((List)linkedList2, (List)linkedList, (List)linkedList3, (LinkedList[])object);
        }
        int n = linkedList3.size();
        double d = (double)n / ((double)linkedList.size() + (double)n);
        if (d == 1.0) {
            linkedList4.add(linkedList3.removeFirst());
            return object;
        }
        if (n > 3) {
            int n2 = Math.min(9, n);
            int n3 = n - n2;
            int n4 = n;
            linkedList4.addAll((Collection)linkedList3.subList(n3, n4));
            return object;
        }
        linkedList4.addAll((Collection)linkedList3);
        ProbeQuery.addToList((List)linkedList5, (List)linkedList2, (List)linkedList, 3);
        return object;
    }

    private static void addToList(List list, List list2, List list3, int n) {
        if (list2.size() >= n) {
            list.addAll((Collection)list2.subList(0, n));
            return;
        }
        list.addAll((Collection)list2);
        if (list3.size() >= (n -= list2.size())) {
            list.addAll((Collection)list3.subList(0, n));
        } else {
            list.addAll((Collection)list3);
        }
    }

    private static LinkedList[] createAggressiveProbe(List list, List list2, List list3, LinkedList[] linkedListArray) {
        ProbeQuery.addToList((List)linkedListArray[1], list, list2, 3);
        int n = Math.min(4, list3.size());
        linkedListArray[0].addAll((Collection)list3.subList(0, n));
        return linkedListArray;
    }
}

