/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.ByteOrder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class MP3Info {
    private final String _file;
    private int _header;
    private VBRHeader _vbrHeader;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MP3Info(String string) throws IOException {
        this._file = string;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[2048];
        try {
            fileInputStream = new FileInputStream(this._file);
            n4 = fileInputStream.read(byArray, 0, byArray.length);
            if (n4 < 4) {
                throw new IOException("early EOF, tiny file?");
            }
            if (!(byArray[0] != 105 && byArray[0] != 73 || byArray[1] != 100 && byArray[1] != 68 || byArray[2] != 51)) {
                n = byArray[6] << 7 | byArray[7] << 7 | byArray[8] << 7 | byArray[9];
                if (n > 0) {
                    n += 10;
                } else if (n < 0) {
                    n = 0;
                }
            }
            block10: do {
                if (n2 < byArray.length - 3) {
                    n3 = n4 - 3;
                } else {
                    n = 0;
                    n3 = n4;
                }
                while (true) {
                    if (n >= n3) {
                        if (n3 != -1) {
                            byArray[0] = byArray[n4 - 3];
                            byArray[1] = byArray[n4 - 2];
                            byArray[2] = byArray[n4 - 1];
                        }
                        n2 += n4 - 3;
                        n4 = fileInputStream.read(byArray, 3, byArray.length - 3);
                        if (n4 >= 6) continue block10;
                        throw new IOException("MP3 Header not found.");
                    }
                    if (byArray[n] == -1 && (byArray[n + 1] & 0xFF) >= 224) {
                        this._header = ByteOrder.ubyte2int(byArray[n + 3]) | ByteOrder.ubyte2int(byArray[n + 2]) << 8 | ByteOrder.ubyte2int(byArray[n + 1]) << 16 | ByteOrder.ubyte2int(byArray[n]) << 24;
                        if (this.getVersionIndex() != 1 && this.getLayerIndex() != 0 && this.getBitrateIndex() != 0 && this.getBitrateIndex() != 15 && this.getFrequencyIndex() != 3 && this.getEmphasisIndex() != 2) {
                            n2 += n;
                            break block10;
                        }
                    }
                    ++n;
                }
            } while (n4 != -1 && n2 < 100000);
            if (n4 == -1 || n2 >= 100000) {
                this._header = 0;
                throw new IOException("MP3 header not found.");
            }
            int n5 = byArray.length - n - 3 - 120 - 36;
            if (n5 < 0) {
                n5 = -n5;
                n -= n5;
                int n6 = 0;
                while (true) {
                    if (n5 >= byArray.length) {
                        n4 = fileInputStream.read(byArray, n6, byArray.length - n6);
                        break;
                    }
                    byArray[n6] = byArray[n5];
                    ++n6;
                    ++n5;
                }
            }
            n = this.getVersionIndex() == 3 ? (n += this.getModeIndex() == 3 ? 21 : 36) : (n += this.getModeIndex() == 3 ? 23 : 21);
            switch (byArray[n + 0]) {
                case 88: {
                    if (!(byArray[n + 1] != 105 && byArray[n + 1] != 73 || byArray[n + 2] != 110 && byArray[n + 2] != 78 || byArray[n + 3] != 103 && byArray[n + 3] != 71)) {
                        this.loadXingHeader(byArray, n + 4);
                    }
                    break;
                }
                case 86: {
                    if (byArray[n + 1] == 66 && byArray[n + 2] == 82 && byArray[n + 3] == 73) {
                        this.loadFhgHeader(byArray, n + 4);
                    }
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fileInputStream == null) return;
        fileInputStream.close();
    }

    public int getBitRate() {
        double d;
        int n;
        if (this.hasVariableBitRate() && (n = this._vbrHeader.getBitRate()) != -1) {
            return n;
        }
        long l = this.getFileSize();
        int n2 = (int)((double)l / ((double)l / (d = (double)((this.getLayerIndex() == 3 ? 12000 : 144000) * this.getHeaderBitRate()) / (double)this.getFrequency())) * (double)this.getFrequency() / (double)(this.getLayerIndex() == 3 ? 12000 : 144000));
        if (n2 < 1) {
            return this.getHeaderBitRate();
        }
        return n2;
    }

    private int getBitrateIndex() {
        return this._header >> 12 & 0xF;
    }

    public String getEmphasis() {
        switch (this.getEmphasisIndex()) {
            case 0: {
                return "none";
            }
            case 1: {
                return "50/15 ms";
            }
            case 2: {
                return null;
            }
            case 3: {
                return "CCIT J.17";
            }
        }
        return "<unknown>";
    }

    private int getEmphasisIndex() {
        return this._header & 3;
    }

    public long getFileSize() {
        if (this.hasVariableBitRate() && this._vbrHeader.numBytes != -1) {
            return this._vbrHeader.numBytes;
        }
        return new File(this._file).length();
    }

    private int getFrameSync() {
        return this._header >> 21 & 0x7FF;
    }

    public int getFrequency() {
        switch (this.getVersionIndex()) {
            case 0: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 11025;
                    }
                    case 1: {
                        return 12000;
                    }
                    case 2: {
                        return 8000;
                    }
                }
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 22050;
                    }
                    case 1: {
                        return 24000;
                    }
                    case 2: {
                        return 16000;
                    }
                }
                return -1;
            }
            case 3: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 44100;
                    }
                    case 1: {
                        return 48000;
                    }
                    case 2: {
                        return 32000;
                    }
                }
                return -1;
            }
        }
        return -1;
    }

    private int getFrequencyIndex() {
        return this._header >> 10 & 3;
    }

    public int getHeaderBitRate() {
        int n = -1;
        switch (this.getVersionIndex()) {
            case 0: 
            case 2: {
                if (this.getLayer_Numeric() == 1) {
                    n = 3;
                    break;
                }
                n = 4;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                n = this.getLayer_Numeric() - 1;
            }
        }
        try {
            short[] sArray = new short[75];
            sArray[5] = 32;
            sArray[6] = 32;
            sArray[7] = 32;
            sArray[8] = 32;
            sArray[9] = 8;
            sArray[10] = 64;
            sArray[11] = 48;
            sArray[12] = 40;
            sArray[13] = 48;
            sArray[14] = 16;
            sArray[15] = 96;
            sArray[16] = 56;
            sArray[17] = 48;
            sArray[18] = 56;
            sArray[19] = 24;
            sArray[20] = 128;
            sArray[21] = 64;
            sArray[22] = 56;
            sArray[23] = 64;
            sArray[24] = 32;
            sArray[25] = 160;
            sArray[26] = 80;
            sArray[27] = 64;
            sArray[28] = 80;
            sArray[29] = 40;
            sArray[30] = 192;
            sArray[31] = 96;
            sArray[32] = 80;
            sArray[33] = 96;
            sArray[34] = 48;
            sArray[35] = 224;
            sArray[36] = 112;
            sArray[37] = 96;
            sArray[38] = 112;
            sArray[39] = 56;
            sArray[40] = 256;
            sArray[41] = 128;
            sArray[42] = 112;
            sArray[43] = 128;
            sArray[44] = 64;
            sArray[45] = 288;
            sArray[46] = 160;
            sArray[47] = 128;
            sArray[48] = 144;
            sArray[49] = 80;
            sArray[50] = 320;
            sArray[51] = 192;
            sArray[52] = 160;
            sArray[53] = 160;
            sArray[54] = 96;
            sArray[55] = 352;
            sArray[56] = 224;
            sArray[57] = 192;
            sArray[58] = 176;
            sArray[59] = 112;
            sArray[60] = 384;
            sArray[61] = 256;
            sArray[62] = 224;
            sArray[63] = 192;
            sArray[64] = 128;
            sArray[65] = 416;
            sArray[66] = 320;
            sArray[67] = 256;
            sArray[68] = 224;
            sArray[69] = 144;
            sArray[70] = 448;
            sArray[71] = 384;
            sArray[72] = 320;
            sArray[73] = 256;
            sArray[74] = 160;
            short[] sArray2 = sArray;
            return sArray2[this.getBitrateIndex() * 5 + n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public int getLayer_Numeric() {
        return 4 - this.getLayerIndex();
    }

    public String getLayer_String() {
        switch (this.getLayerIndex()) {
            case 1: {
                return "Layer III";
            }
            case 2: {
                return "Layer II";
            }
            case 3: {
                return "Layer I";
            }
        }
        return "Layer ?";
    }

    private int getLayerIndex() {
        return this._header >> 17 & 3;
    }

    public long getLengthInSeconds() {
        int n;
        if (this.hasVariableBitRate() && (n = this._vbrHeader.getLengthInSeconds()) != -1) {
            return n;
        }
        return this.getFileSize() / (long)(this.getHeaderBitRate() * 1000 / 8);
    }

    public String getMode() {
        switch (this.getModeIndex()) {
            case 0: {
                return "Stereo";
            }
            case 1: {
                return "Joint Stereo";
            }
            case 2: {
                return "Dual Channel";
            }
            case 3: {
                return "Single Channel";
            }
        }
        return "<unknown>";
    }

    private int getModeExtIndex() {
        return this._header >> 4 & 3;
    }

    private int getModeIndex() {
        return this._header >> 6 & 3;
    }

    public int getNumberOfFrames() {
        if (this.hasVariableBitRate() && this._vbrHeader.numFrames != -1) {
            return this._vbrHeader.numFrames;
        }
        return (int)(this.getFileSize() / (long)(this.getLayerIndex() == 3 ? 12000 : 144000 * this.getBitRate() / this.getFrequency() + (this.isPadded() ? (this.getLayerIndex() == 3 ? 32 : 8) : 0)));
    }

    public VBRHeader getVBRHeader() {
        return this._vbrHeader;
    }

    public double getVersion_Numeric() {
        switch (this.getVersionIndex()) {
            case 0: {
                return 2.5;
            }
            default: {
                return 0.0;
            }
            case 2: {
                return 2.0;
            }
            case 3: 
        }
        return 1.0;
    }

    public String getVersion_String() {
        switch (this.getVersionIndex()) {
            case 0: {
                return "MPEG Version 2.5";
            }
            case 1: {
                return null;
            }
            case 2: {
                return "MPEG Version 2.0";
            }
            case 3: {
                return "MPEG Version 1.0";
            }
        }
        return "MPEG Version ?";
    }

    private int getVersionIndex() {
        return this._header >> 19 & 3;
    }

    public boolean hasVariableBitRate() {
        return this._vbrHeader != null;
    }

    public boolean isCoprighted() {
        return (this._header >> 3 & 1) != 0;
    }

    public boolean isOriginal() {
        return (this._header >> 2 & 1) != 0;
    }

    public boolean isPadded() {
        return (this._header >> 9 & 1) != 0;
    }

    public boolean isPrivate() {
        return (this._header >> 8 & 1) != 0;
    }

    public boolean isProtected() {
        return (this._header >> 16 & 1) == 0;
    }

    /*
     * Exception decompiling
     */
    public boolean isRiffWav() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 168->171)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadFhgHeader(byte[] byArray, int n) {
        this._vbrHeader = new VBRHeader();
        this._vbrHeader.scale = ByteOrder.ubyte2int(byArray[n += 2]);
        this._vbrHeader.numBytes = (ByteOrder.ubyte2int(byArray[++n]) << 24) + (ByteOrder.ubyte2int(byArray[++n]) << 16) + (ByteOrder.ubyte2int(byArray[++n]) << 8) + ByteOrder.ubyte2int(byArray[++n]);
        this._vbrHeader.numFrames = (ByteOrder.ubyte2int(byArray[++n]) << 24) + (ByteOrder.ubyte2int(byArray[++n]) << 16) + (ByteOrder.ubyte2int(byArray[++n]) << 8) + ByteOrder.ubyte2int(byArray[++n]);
    }

    private void loadXingHeader(byte[] byArray, int n) {
        this._vbrHeader = new VBRHeader();
        byte by = (byte)ByteOrder.ubyte2int(byArray[n += 3]);
        if ((by & 1) != 0) {
            this._vbrHeader.numFrames = (ByteOrder.ubyte2int(byArray[++n]) << 24) + (ByteOrder.ubyte2int(byArray[++n]) << 16) + (ByteOrder.ubyte2int(byArray[++n]) << 8) + ByteOrder.ubyte2int(byArray[++n]);
        }
        if ((by & 2) != 0) {
            this._vbrHeader.numBytes = (ByteOrder.ubyte2int(byArray[++n]) << 24) + (ByteOrder.ubyte2int(byArray[++n]) << 16) + (ByteOrder.ubyte2int(byArray[++n]) << 8) + ByteOrder.ubyte2int(byArray[++n]);
        }
        if ((by & 4) != 0) {
            this._vbrHeader.toc = new byte[100];
            System.arraycopy(byArray, ++n, this._vbrHeader.toc, 0, 100);
            n += 99;
        }
        if ((by & 8) != 0) {
            this._vbrHeader.scale = ByteOrder.ubyte2int(byArray[n += 4]);
        }
    }

    final class VBRHeader {
        private int numFrames = -1;
        private int numBytes = -1;
        private int scale = -1;
        private byte[] toc;

        VBRHeader() {
        }

        int getScale() {
            return this.scale;
        }

        byte[] getTableOfContents() {
            return this.toc;
        }

        int getBitRate() {
            if (this.numFrames != -1 && this.numBytes != -1) {
                double d = 0.0;
                switch (MP3Info.this.getLayerIndex()) {
                    case 1: 
                    case 2: {
                        d = 1152.0;
                        break;
                    }
                    case 3: {
                        d = 384.0;
                    }
                }
                d /= (double)MP3Info.this.getFrequency();
                if (MP3Info.this.getVersion_Numeric() == 2.0 || MP3Info.this.getVersion_Numeric() == 0.0) {
                    d /= 2.0;
                }
                return (int)((double)(this.numBytes * 8) / (d * (double)this.numFrames * 1000.0));
            }
            return -1;
        }

        int getLengthInSeconds() {
            if (this.numFrames != -1) {
                double d = 0.0;
                switch (MP3Info.this.getLayerIndex()) {
                    case 1: 
                    case 2: {
                        d = 1152.0;
                        break;
                    }
                    case 3: {
                        d = 384.0;
                    }
                }
                d /= (double)MP3Info.this.getFrequency();
                if (MP3Info.this.getVersion_Numeric() == 2.0 || MP3Info.this.getVersion_Numeric() == 0.0) {
                    d /= 2.0;
                }
                return (int)(d * (double)this.numFrames);
            }
            return -1;
        }
    }
}

