/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.AuthenticationHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class UltrapeerHandshakeResponder
extends AuthenticationHandshakeResponder {
    public UltrapeerHandshakeResponder(String string) {
        super(RouterService.getConnectionManager(), string);
    }

    protected HandshakeResponse respondUnauthenticated(HandshakeResponse handshakeResponse, boolean bl) throws IOException {
        if (bl) {
            return this.respondToOutgoing(handshakeResponse);
        }
        return this.respondToIncoming(handshakeResponse);
    }

    private HandshakeResponse respondToOutgoing(HandshakeResponse handshakeResponse) {
        if (!this._manager.allowConnection(handshakeResponse)) {
            return HandshakeResponse.createRejectOutgoingResponse();
        }
        Properties properties = new Properties();
        if (handshakeResponse.hasLeafGuidance() && this._manager.allowLeafDemotion() && handshakeResponse.isGoodUltrapeer()) {
            ((Hashtable)properties).put("X-Ultrapeer", "False");
        }
        if (handshakeResponse.isDeflateAccepted()) {
            ((Hashtable)properties).put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(properties);
    }

    private HandshakeResponse respondToIncoming(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isCrawler()) {
            return HandshakeResponse.createCrawlerResponse();
        }
        UltrapeerHeaders ultrapeerHeaders = new UltrapeerHeaders(this.getRemoteIP());
        ((Hashtable)ultrapeerHeaders).put("Listen-IP", String.valueOf(NetworkUtils.ip2string(RouterService.getAddress())) + ":" + RouterService.getPort());
        if (this.reject(handshakeResponse, ultrapeerHeaders)) {
            return HandshakeResponse.createUltrapeerRejectIncomingResponse(handshakeResponse);
        }
        if (handshakeResponse.isDeflateAccepted()) {
            ((Hashtable)ultrapeerHeaders).put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(handshakeResponse, ultrapeerHeaders);
    }

    private boolean reject(HandshakeResponse handshakeResponse, Properties properties) {
        boolean bl = this._manager.allowConnectionAsLeaf(handshakeResponse);
        if (handshakeResponse.isLeaf()) {
            return !bl;
        }
        boolean bl2 = this._manager.supernodeNeeded();
        if (bl && !bl2) {
            ((Hashtable)properties).put("X-Ultrapeer-Needed", Boolean.FALSE.toString());
            return false;
        }
        boolean bl3 = this._manager.allowConnection(handshakeResponse);
        if (bl3) {
            ((Hashtable)properties).put("X-Ultrapeer-Needed", Boolean.TRUE.toString());
            return false;
        }
        return true;
    }
}

