/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;

final class HeadRequester
implements Runnable {
    private final Set HOSTS;
    private final URN RESOURCE_NAME;
    private final AlternateLocationCollector COLLECTOR;
    private final AlternateLocationCollection TOTAL_ALTS;

    public HeadRequester(Set set, URN uRN, AlternateLocationCollector alternateLocationCollector, AlternateLocationCollection alternateLocationCollection) {
        this.HOSTS = set;
        this.RESOURCE_NAME = uRN;
        this.COLLECTOR = alternateLocationCollector;
        this.TOTAL_ALTS = alternateLocationCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            Iterator iterator = this.HOSTS.iterator();
            while (true) {
                Object var11_12;
                HeadMethod headMethod;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block14: {
                                    URN uRN;
                                    if (!iterator.hasNext()) {
                                        return;
                                    }
                                    RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
                                    if (QueryReply.isFirewalledQuality(remoteFileDesc.getQuality()) || (uRN = remoteFileDesc.getSHA1Urn()) == null || !uRN.equals(this.RESOURCE_NAME)) continue;
                                    URL uRL = remoteFileDesc.getUrl();
                                    String string = uRL.toExternalForm();
                                    headMethod = new HeadMethod(string);
                                    headMethod.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
                                    headMethod.addRequestHeader("Cache-Control", "no-cache");
                                    headMethod.addRequestHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN.httpStringValue(), this.RESOURCE_NAME.httpStringValue());
                                    headMethod.addRequestHeader(HTTPHeaderName.ALT_LOCATION.httpStringValue(), this.TOTAL_ALTS.httpStringValue());
                                    headMethod.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
                                    headMethod.setFollowRedirects(false);
                                    HttpClient httpClient = HttpClientManager.getNewClient();
                                    try {
                                        try {
                                            Object object;
                                            block15: {
                                                httpClient.executeMethod((HttpMethod)headMethod);
                                                String string2 = HeadRequester.getHeader((HttpMethod)headMethod, HTTPHeaderName.GNUTELLA_CONTENT_URN);
                                                if (string2 == null) {
                                                    var11_12 = null;
                                                    if (headMethod == null) continue;
                                                    break block14;
                                                }
                                                try {
                                                    object = URN.createSHA1Urn(string2);
                                                    if (((URN)object).equals(this.RESOURCE_NAME)) break block15;
                                                    break block16;
                                                }
                                                catch (IOException iOException) {
                                                    var11_12 = null;
                                                    if (headMethod == null) continue;
                                                    headMethod.releaseConnection();
                                                    continue;
                                                }
                                            }
                                            object = HeadRequester.getHeader((HttpMethod)headMethod, HTTPHeaderName.ALT_LOCATION);
                                            if (object == null) {
                                                break block17;
                                            }
                                            AlternateLocationCollection alternateLocationCollection = AlternateLocationCollection.createCollectionFromHttpValue((String)object);
                                            if (alternateLocationCollection == null) {
                                                break block18;
                                            }
                                            if (!alternateLocationCollection.getSHA1Urn().equals(this.COLLECTOR.getSHA1Urn())) break block19;
                                            this.COLLECTOR.addAll(alternateLocationCollection);
                                            break block19;
                                        }
                                        catch (IOException iOException) {
                                            var11_12 = null;
                                            if (headMethod == null) continue;
                                            headMethod.releaseConnection();
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var11_12 = null;
                                        if (headMethod == null) throw throwable;
                                        headMethod.releaseConnection();
                                        throw throwable;
                                    }
                                }
                                headMethod.releaseConnection();
                                continue;
                            }
                            var11_12 = null;
                            if (headMethod == null) continue;
                            headMethod.releaseConnection();
                            continue;
                        }
                        var11_12 = null;
                        if (headMethod == null) continue;
                        headMethod.releaseConnection();
                        continue;
                    }
                    var11_12 = null;
                    if (headMethod == null) continue;
                    headMethod.releaseConnection();
                    continue;
                }
                var11_12 = null;
                if (headMethod == null) continue;
                headMethod.releaseConnection();
            }
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    private static String getHeader(HttpMethod httpMethod, HTTPHeaderName hTTPHeaderName) {
        Header header = httpMethod.getResponseHeader(hTTPHeaderName.httpStringValue());
        if (header == null) {
            return null;
        }
        return header.getValue();
    }
}

