/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class UrnCache {
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static final File URN_CACHE_BACKUP_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.bak");
    private static UrnCache instance = null;
    private static final Map URN_MAP = UrnCache.createMap();

    public static synchronized UrnCache instance() {
        if (instance == null) {
            instance = new UrnCache();
        }
        return instance;
    }

    private UrnCache() {
        UrnCache.removeOldEntries(URN_MAP);
    }

    public synchronized Set getUrns(File file) {
        if (file.lastModified() == 0L) {
            return DataUtils.EMPTY_SET;
        }
        UrnSetKey urnSetKey = new UrnSetKey(file);
        Set set = (Set)URN_MAP.get((Object)urnSetKey);
        if (set == null) {
            return DataUtils.EMPTY_SET;
        }
        return Collections.unmodifiableSet((Set)set);
    }

    public synchronized void removeUrns(File file) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        URN_MAP.remove((Object)urnSetKey);
    }

    public synchronized void addUrns(File file, Set set) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        URN_MAP.put((Object)urnSetKey, (Object)Collections.unmodifiableSet((Set)set));
    }

    private static Map createMap() {
        Map map = UrnCache.readMap(URN_CACHE_FILE);
        if (map == null) {
            map = UrnCache.readMap(URN_CACHE_BACKUP_FILE);
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    private static Map readMap(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [9 : 100->103)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void removeOldEntries(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof UrnSetKey) {
                File file;
                UrnSetKey urnSetKey = (UrnSetKey)object;
                if (urnSetKey == null || (file = new File(urnSetKey._path)).exists() && file.lastModified() == urnSetKey._modTime) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void persistCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 71->75)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int n = 17;
            n = n * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            n = n * 37 + this._path.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey urnSetKey = (UrnSetKey)object;
            return this._modTime == urnSetKey._modTime && this._path.equals(urnSetKey._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeLong(this._modTime);
            objectOutputStream.writeObject(this._path);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this._modTime = objectInputStream.readLong();
            this._path = (String)objectInputStream.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }
}

