/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.RemoteHostData;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteFileDesc
implements Serializable {
    private static final Log LOG;
    private static final long serialVersionUID = 6619479308616716538L;
    private static final int COPY_INDEX = Integer.MAX_VALUE;
    private final String _host;
    private final int _port;
    private final String _filename;
    private final long _index;
    private final byte[] _clientGUID;
    private final int _speed;
    private final int _size;
    private final boolean _chatEnabled;
    private final int _quality;
    private final boolean _replyToMulticast;
    private LimeXMLDocument[] _xmlDocs;
    private Set _urns;
    private boolean _browseHostEnabled;
    private boolean _firewalled;
    private String _vendor;
    private long _timestamp;
    private boolean _http11;
    private transient Set _proxies;
    private transient IntervalSet _availableRanges = null;
    private transient int _failedCount = 0;
    private transient long _earliestRetryTime = 0L;
    private transient int _hashCode = 0;
    private transient boolean _THEXFailed = false;
    private transient RemoteHostData _hostData = null;
    private transient boolean _isDownloading = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.RemoteFileDesc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public RemoteFileDesc(RemoteFileDesc remoteFileDesc, Endpoint endpoint) {
        this(endpoint.getAddress(), endpoint.getPort(), Integer.MAX_VALUE, remoteFileDesc.getFileName(), remoteFileDesc.getSize(), DataUtils.EMPTY_GUID, 0, false, 2, false, remoteFileDesc.getXMLDoc(), remoteFileDesc.getUrns(), false, false, "ALT", System.currentTimeMillis(), DataUtils.EMPTY_SET);
    }

    public RemoteFileDesc(String string, int n, long l, String string2, int n2, byte[] byArray, int n3, boolean bl, int n4, boolean bl2, LimeXMLDocument limeXMLDocument, Set set, boolean bl3, boolean bl4, String string3, long l2, Set set2) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (((long)n3 & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + n3);
        }
        if (string2 == null) {
            throw new NullPointerException("null filename");
        }
        if (string2.equals("")) {
            throw new IllegalArgumentException("cannot accept empty string file name");
        }
        if (((long)n2 & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid size: " + n2);
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + l);
        }
        if (string == null) {
            throw new NullPointerException("null host");
        }
        this._speed = n3;
        this._host = string;
        this._port = n;
        this._index = l;
        this._filename = string2;
        this._size = n2;
        this._clientGUID = byArray;
        this._chatEnabled = bl;
        this._quality = n4;
        this._browseHostEnabled = bl2;
        this._replyToMulticast = bl3;
        this._firewalled = bl4;
        this._vendor = string3;
        this._timestamp = l2;
        this._proxies = set2 == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet((Set)set2);
        this._xmlDocs = limeXMLDocument != null ? new LimeXMLDocument[]{limeXMLDocument} : null;
        this._urns = set == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet((Set)set);
        this._http11 = !this._urns.isEmpty();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this._urns == null) {
            this._urns = DataUtils.EMPTY_SET;
            this._browseHostEnabled = false;
        } else {
            HashSet hashSet = null;
            Iterator iterator = this._urns.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof URN) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashSet.addAll((Collection)this._urns);
                }
                hashSet.remove(object);
            }
            if (hashSet != null) {
                this._urns = Collections.unmodifiableSet(hashSet);
            }
        }
        if (this._proxies == null) {
            this._proxies = DataUtils.EMPTY_SET;
        }
        if (this._xmlDocs != null && this._xmlDocs.length == 0) {
            this._xmlDocs = null;
        }
        this._http11 = this._http11 || !this._urns.isEmpty();
    }

    public boolean isHTTP11() {
        return this._http11;
    }

    public void setHTTP11(boolean bl) {
        this._http11 = bl;
    }

    public boolean isPartialSource() {
        return this._availableRanges != null;
    }

    public IntervalSet getAvailableRanges() {
        return (IntervalSet)this._availableRanges.clone();
    }

    public void setAvailableRanges(IntervalSet intervalSet) {
        this._availableRanges = intervalSet;
    }

    public int getFailedCount() {
        return this._failedCount;
    }

    public void incrementFailedCount() {
        ++this._failedCount;
    }

    public void resetFailedCount() {
        this._failedCount = 0;
    }

    public boolean isFromAlternateLocation() {
        return "ALT".equals(this._vendor);
    }

    public boolean isBusy() {
        return System.currentTimeMillis() < this._earliestRetryTime;
    }

    public int getWaitTime() {
        return this.isBusy() ? (int)(this._earliestRetryTime - System.currentTimeMillis()) / 1000 + 1 : 0;
    }

    public void setRetryAfter(int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setting retry after to be [" + n + "] seconds for " + this));
        }
        this._earliestRetryTime = System.currentTimeMillis() + (long)(n * 1000);
    }

    public boolean hasTHEXFailed() {
        return this._THEXFailed;
    }

    public void setTHEXFailed() {
        this._THEXFailed = true;
    }

    public void setDownloading(boolean bl) {
        this._isDownloading = bl;
    }

    public boolean isDownloading() {
        return this._isDownloading;
    }

    public final String getHost() {
        return this._host;
    }

    public final int getPort() {
        return this._port;
    }

    public final long getIndex() {
        return this._index;
    }

    public final int getSize() {
        return this._size;
    }

    public final String getFileName() {
        return this._filename;
    }

    public final byte[] getClientGUID() {
        return this._clientGUID;
    }

    public final int getSpeed() {
        return this._speed;
    }

    public final String getVendor() {
        return this._vendor;
    }

    public final boolean chatEnabled() {
        return this._chatEnabled;
    }

    public final boolean browseHostEnabled() {
        return this._browseHostEnabled;
    }

    public final int getQuality() {
        return this._quality;
    }

    public final LimeXMLDocument getXMLDoc() {
        if (this._xmlDocs == null) {
            return null;
        }
        return this._xmlDocs[0];
    }

    public final Set getUrns() {
        return this._urns;
    }

    public final URN getSHA1Urn() {
        Iterator iterator = this._urns.iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (uRN == null || !uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public URL getUrl() {
        try {
            String string = "";
            URN uRN = this.getSHA1Urn();
            string = uRN == null ? "/get/" + this._index + "/" + this._filename : "/uri-res/N2R?" + uRN.httpStringValue();
            return new URL("http", this._host, this._port, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public final boolean isReplyToMulticast() {
        return this._replyToMulticast;
    }

    public final boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(this._host);
    }

    public final Set getPushProxies() {
        return this._proxies;
    }

    public final RemoteHostData getRemoteHostData() {
        if (this._hostData == null) {
            this._hostData = new RemoteHostData(this._host, this._port, this._clientGUID);
        }
        return this._hostData;
    }

    public final boolean isAltLocCapable() {
        return this.getSHA1Urn() != null && !this._replyToMulticast && !this._firewalled && NetworkUtils.isValidPort(this._port) && !NetworkUtils.isPrivateAddress(this._host) && NetworkUtils.isValidAddress(this._host);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
        if (!this.nullEquals(this._host, remoteFileDesc._host) || this._port != remoteFileDesc._port) {
            return false;
        }
        if ((NetworkUtils.isPrivateAddress(this._host) || NetworkUtils.isPrivateAddress(remoteFileDesc._host)) && !this.byteArrayEquals(this._clientGUID, remoteFileDesc._clientGUID)) {
            return false;
        }
        if (this._size != remoteFileDesc._size) {
            return false;
        }
        if (this._urns.isEmpty() && remoteFileDesc._urns.isEmpty()) {
            return this.nullEquals(this._filename, remoteFileDesc._filename);
        }
        return this.urnSetEquals(this._urns, remoteFileDesc._urns);
    }

    private boolean nullEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private boolean urnSetEquals(Set set, Set set2) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!set2.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean byteArrayEquals(byte[] byArray, byte[] byArray2) {
        return byArray == null ? byArray2 == null : Arrays.equals((byte[])byArray, (byte[])byArray2);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int n = 17;
            n = 37 * n + this._host.hashCode();
            n = 37 * n + this._port;
            n = 37 * n + this._size;
            this._hashCode = n = 37 * n + this._urns.hashCode();
        }
        return this._hashCode;
    }

    public String toString() {
        return "<" + this.getHost() + ":" + this.getPort() + ", " + this.getFileName().toLowerCase() + ">";
    }
}

