/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.BucketQueue;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;

public final class PongCacher {
    private static final PongCacher INSTANCE = new PongCacher();
    public static final int NUM_PONGS_PER_HOP = 1;
    public static final int NUM_HOPS = 6;
    public static final int EXPIRE_TIME = 6000;
    public static final int EXPIRE_TIME_LOC = 90000;
    private static final Map PONGS = new HashMap();

    public static PongCacher instance() {
        return INSTANCE;
    }

    private PongCacher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBestPongs(String string) {
        Map map = PONGS;
        synchronized (map) {
            LinkedList linkedList = new LinkedList();
            long l = System.currentTimeMillis();
            List list = this.addBestPongs(string, (List)linkedList, l, 0);
            this.removePongs(string, list);
            if (!ApplicationSettings.DEFAULT_LOCALE.getValue().equals(string) && linkedList.size() < 6) {
                list = this.addBestPongs(ApplicationSettings.DEFAULT_LOCALE.getValue(), (List)linkedList, l, linkedList.size());
                this.removePongs(ApplicationSettings.DEFAULT_LOCALE.getValue(), list);
            }
            return linkedList;
        }
    }

    private List addBestPongs(String string, List list, long l, int n) {
        int n2 = ApplicationSettings.DEFAULT_LOCALE.getValue().equals(string) ? 6000 : 90000;
        LinkedList linkedList = null;
        if (PONGS.containsKey((Object)string)) {
            BucketQueue bucketQueue = (BucketQueue)PONGS.get((Object)string);
            Iterator iterator = bucketQueue.iterator();
            while (iterator.hasNext() && n < 6) {
                PingReply pingReply = (PingReply)iterator.next();
                if (l - pingReply.getCreationTime() > (long)n2) {
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    linkedList.add((Object)pingReply);
                } else {
                    list.add((Object)pingReply);
                }
                ++n;
            }
        }
        return linkedList;
    }

    private void removePongs(String string, List list) {
        if (list != null) {
            BucketQueue bucketQueue = (BucketQueue)PONGS.get((Object)string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PingReply pingReply = (PingReply)iterator.next();
                bucketQueue.removeAll(pingReply);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPong(PingReply pingReply) {
        if (!RouterService.isSupernode()) {
            return;
        }
        if (!pingReply.isUltrapeer()) {
            return;
        }
        if (pingReply.getHops() >= 6) {
            return;
        }
        Map map = PONGS;
        synchronized (map) {
            if (PONGS.containsKey((Object)pingReply.getClientLocale())) {
                BucketQueue bucketQueue = (BucketQueue)PONGS.get((Object)pingReply.getClientLocale());
                bucketQueue.insert(pingReply, pingReply.getHops());
            } else {
                BucketQueue bucketQueue = new BucketQueue(6, 1);
                bucketQueue.insert(pingReply, pingReply.getHops());
                PONGS.put((Object)pingReply.getClientLocale(), (Object)bucketQueue);
            }
        }
    }
}

