/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.StatisticsSettings;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.statistics.RouteErrorStat;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FixedsizeHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.NoMoreStorageException;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.Sockets;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public abstract class MessageRouter {
    protected static ConnectionManager _manager;
    private static final int OLD_CONNECTIONS_TO_USE = 15;
    protected byte[] _clientGUID;
    private final ReplyHandler FOR_ME_REPLY_HANDLER = ForMeReplyHandler.instance();
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    private final int MAX_BYPASSED_RESULTS = 150;
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    private static final long CLEAR_TIME = 30000L;
    static int MAX_BUFFERED_REPLIES;
    private final Map _outOfBandReplies = new Hashtable();
    private final Map _bypassedResults = new HashMap();
    private static final FixedsizeHashMap _udpConnectBacks;
    private static final int MAX_UDP_CONNECTBACK_FORWARDS = 5;
    private static final FixedsizeHashMap _tcpConnectBacks;
    private static final int MAX_TCP_CONNECTBACK_FORWARDS = 5;
    private static final ProcessingQueue TCP_CONNECT_BACKER;
    protected final QueryUnicaster UNICASTER = QueryUnicaster.instance();
    private final QueryDispatcher DYNAMIC_QUERIER = QueryDispatcher.instance();
    private ActivityCallback _callback;
    private static FileManager _fileManager;
    private static final boolean RECORD_STATS;
    private final QRPPropagator QRP_PROPAGATOR = new QRPPropagator();
    private QueryRouteTable _lastQueryRouteTable;
    private static final int HIGH_HOPS_RESPONSE_LIMIT = 10;
    private static final long TIMED_GUID_LIFETIME = 25000L;
    private volatile Map _messageListeners = DataUtils.EMPTY_MAP;
    private final Object MESSAGE_LISTENER_LOCK = new Object();
    private PromotionManager _promotionManager;

    static {
        MAX_BUFFERED_REPLIES = 250;
        _udpConnectBacks = new FixedsizeHashMap(200);
        _tcpConnectBacks = new FixedsizeHashMap(200);
        TCP_CONNECT_BACKER = new ProcessingQueue("TCPConnectBack");
        RECORD_STATS = !CommonUtils.isJava118();
    }

    protected MessageRouter() {
        try {
            this._clientGUID = new GUID(GUID.fromHexString(ApplicationSettings.CLIENT_ID.getValue())).bytes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._clientGUID = Message.makeGuid();
            ApplicationSettings.CLIENT_ID.setValue(new GUID(this._clientGUID).toHexString());
        }
    }

    public void initialize() {
        _manager = RouterService.getConnectionManager();
        this._callback = RouterService.getCallback();
        _fileManager = RouterService.getFileManager();
        this._promotionManager = RouterService.getPromotionManager();
        this.DYNAMIC_QUERIER.start();
        this.QRP_PROPAGATOR.start();
        RouterService.schedule(new Expirer(), 30000L, 30000L);
        RouterService.schedule(new ConnectBackExpirer(), 300000L, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryKilled(GUID gUID) throws IllegalArgumentException {
        if (gUID == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!RouterService.getDownloadManager().isGuidForQueryDownloading(gUID)) {
                this._bypassedResults.remove((Object)gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFinished(GUID gUID) throws IllegalArgumentException {
        if (gUID == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!this._callback.isQueryAlive(gUID) && !RouterService.getDownloadManager().isGuidForQueryDownloading(gUID)) {
                this._bypassedResults.remove((Object)gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGuessLocs(GUID gUID) {
        HashSet hashSet = new HashSet();
        Map map = this._bypassedResults;
        synchronized (map) {
            Set set = (Set)this._bypassedResults.get((Object)gUID);
            if (set != null) {
                hashSet.addAll((Collection)set);
            }
        }
        return hashSet;
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ReplyHandler replyHandler) {
        this.DYNAMIC_QUERIER.removeReplyHandler(replyHandler);
        this._pingRouteTable.removeReplyHandler(replyHandler);
        this._queryRouteTable.removeReplyHandler(replyHandler);
        this._pushRouteTable.removeReplyHandler(replyHandler);
    }

    public void handleMessage(Message message, ManagedConnection managedConnection) {
        message.hop();
        if (message instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PING_REQUESTS.addMessage(message);
            }
            this.handlePingRequestPossibleDuplicate((PingRequest)message, managedConnection);
        } else if (message instanceof PingReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PING_REPLIES.addMessage(message);
            }
            this.handlePingReply((PingReply)message, managedConnection);
        } else if (message instanceof QueryRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(message);
            }
            this.handleQueryRequestPossibleDuplicate((QueryRequest)message, managedConnection);
        } else if (message instanceof QueryReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_QUERY_REPLIES.addMessage(message);
            }
            QueryReply queryReply = (QueryReply)message;
            this.handleQueryReply(queryReply, managedConnection);
        } else if (message instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(message);
            }
            this.handlePushRequest((PushRequest)message, managedConnection);
        } else if (message instanceof ResetTableMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_RESET_ROUTE_TABLE_MESSAGES.addMessage(message);
            }
            this.handleResetTableMessage((ResetTableMessage)message, managedConnection);
        } else if (message instanceof PatchTableMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PATCH_ROUTE_TABLE_MESSAGES.addMessage(message);
            }
            this.handlePatchTableMessage((PatchTableMessage)message, managedConnection);
        } else if (message instanceof MessagesSupportedVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_MESSAGES_SUPPORTED.addMessage(message);
            }
            managedConnection.handleVendorMessage((VendorMessage)message);
        } else if (message instanceof CapabilitiesVM) {
            if (RECORD_STATS) {
                // empty if block
            }
            managedConnection.handleVendorMessage((VendorMessage)message);
        } else if (message instanceof HopsFlowVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_HOPS_FLOW.addMessage(message);
            }
            managedConnection.handleVendorMessage((VendorMessage)message);
        } else if (message instanceof TCPConnectBackVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_TCP_CONNECTBACK.addMessage(message);
            }
            this.handleTCPConnectBackRequest((TCPConnectBackVendorMessage)message, managedConnection);
        } else if (message instanceof UDPConnectBackVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_UDP_CONNECTBACK.addMessage(message);
            }
            this.handleUDPConnectBackRequest((UDPConnectBackVendorMessage)message, managedConnection);
        } else if (message instanceof TCPConnectBackRedirect) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleTCPConnectBackRedirect((TCPConnectBackRedirect)message, managedConnection);
        } else if (message instanceof UDPConnectBackRedirect) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleUDPConnectBackRedirect((UDPConnectBackRedirect)message, managedConnection);
        } else if (message instanceof PushProxyRequest) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handlePushProxyRequest((PushProxyRequest)message, managedConnection);
        } else if (message instanceof PushProxyAcknowledgement) {
            if (RECORD_STATS) {
                // empty if block
            }
            managedConnection.handleVendorMessage((VendorMessage)message);
        } else if (message instanceof QueryStatusResponse) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleQueryStatus((QueryStatusResponse)message, managedConnection);
        } else if (message instanceof GiveStatsVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleGiveStats((GiveStatsVendorMessage)message, managedConnection);
        } else if (message instanceof StatisticVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleStatisticsMessage((StatisticVendorMessage)message, managedConnection);
        }
        this.notifyMessageListener(message, managedConnection);
    }

    private final void notifyMessageListener(Message message, ReplyHandler replyHandler) {
        List list = (List)this._messageListeners.get((Object)message.getGUID());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MessageListener messageListener = (MessageListener)iterator.next();
                messageListener.processMessage(message, replyHandler);
            }
        }
    }

    public void handleUDPMessage(Message message, DatagramPacket datagramPacket) {
        message.hop();
        InetAddress inetAddress = datagramPacket.getAddress();
        int n = datagramPacket.getPort();
        if (!RouterService.isIpPortValid()) {
            return;
        }
        UDPReplyHandler uDPReplyHandler = new UDPReplyHandler(inetAddress, n);
        if (message instanceof QueryRequest) {
            if (this.hasValidQueryKey(inetAddress, n, (QueryRequest)message)) {
                this.sendAcknowledgement(datagramPacket, message.getGUID());
                if (!this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, uDPReplyHandler)) {
                    ReceivedMessageStatHandler.UDP_DUPLICATE_QUERIES.addMessage(message);
                }
            }
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(message);
            }
        } else if (message instanceof QueryReply) {
            QueryReply queryReply = (QueryReply)message;
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(message);
                short s = queryReply.getResultCount();
                try {
                    if (!queryReply.isReplyToMulticastQuery()) {
                        OutOfBandThroughputStat.RESPONSES_RECEIVED.addData(s);
                    }
                }
                catch (BadPacketException badPacketException) {
                    return;
                }
            }
            this.handleQueryReply(queryReply, uDPReplyHandler);
        } else if (message instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PING_REQUESTS.addMessage(message);
            }
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, uDPReplyHandler, datagramPacket);
        } else if (message instanceof PingReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(message);
            }
            this.handleUDPPingReply((PingReply)message, uDPReplyHandler, inetAddress, n);
        } else if (message instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(message);
            }
            this.handlePushRequest((PushRequest)message, uDPReplyHandler);
        } else if (message instanceof LimeACKVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_LIME_ACK.addMessage(message);
            }
            this.handleLimeACKMessage((LimeACKVendorMessage)message, datagramPacket);
        } else if (message instanceof ReplyNumberVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleReplyNumberMessage((ReplyNumberVendorMessage)message, datagramPacket);
        } else if (message instanceof GiveStatsVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleGiveStats((GiveStatsVendorMessage)message, uDPReplyHandler);
        } else if (message instanceof StatisticVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleStatisticsMessage((StatisticVendorMessage)message, uDPReplyHandler);
        } else if (message instanceof UDPCrawlerPing) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleUDPCrawlerPing((UDPCrawlerPing)message, uDPReplyHandler);
        }
        this.notifyMessageListener(message, uDPReplyHandler);
    }

    public void handleMulticastMessage(Message message, DatagramPacket datagramPacket) {
        if (message.getTTL() > 1) {
            return;
        }
        message.hop();
        InetAddress inetAddress = datagramPacket.getAddress();
        int n = datagramPacket.getPort();
        if (NetworkUtils.isLocalAddress(inetAddress) && !ConnectionSettings.ALLOW_MULTICAST_LOOPBACK.getValue()) {
            return;
        }
        UDPReplyHandler uDPReplyHandler = new UDPReplyHandler(inetAddress, n);
        if (message instanceof QueryRequest) {
            if (!this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, uDPReplyHandler)) {
                ReceivedMessageStatHandler.MULTICAST_DUPLICATE_QUERIES.addMessage(message);
            }
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(message);
            }
        } else if (message instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_PING_REQUESTS.addMessage(message);
            }
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, uDPReplyHandler, datagramPacket);
        } else if (message instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(message);
            }
            this.handlePushRequest((PushRequest)message, uDPReplyHandler);
        }
        this.notifyMessageListener(message, uDPReplyHandler);
    }

    protected boolean hasValidQueryKey(InetAddress inetAddress, int n, QueryRequest queryRequest) {
        if (queryRequest.getQueryKey() == null) {
            return false;
        }
        QueryKey queryKey = QueryKey.getQueryKey(inetAddress, n);
        return queryRequest.getQueryKey().equals(queryKey);
    }

    protected void sendAcknowledgement(DatagramPacket datagramPacket, byte[] byArray) {
        PingReply pingReply;
        ConnectionManager connectionManager = RouterService.getConnectionManager();
        Endpoint endpoint = connectionManager.getConnectedGUESSUltrapeer();
        if (endpoint != null) {
            try {
                pingReply = PingReply.createGUESSReply(byArray, (byte)1, endpoint);
            }
            catch (UnknownHostException unknownHostException) {
                pingReply = this.createPingReply(byArray);
            }
        } else {
            pingReply = this.createPingReply(byArray);
        }
        if (pingReply == null) {
            return;
        }
        UDPService.instance().send(pingReply, datagramPacket.getAddress(), datagramPacket.getPort());
        if (RECORD_STATS) {
            SentMessageStatHandler.UDP_PING_REPLIES.addMessage(pingReply);
        }
    }

    private PingReply createPingReply(byte[] byArray) {
        GUESSEndpoint gUESSEndpoint = this.UNICASTER.getUnicastEndpoint();
        if (gUESSEndpoint == null) {
            if (RouterService.isIpPortValid()) {
                return PingReply.create(byArray, (byte)1);
            }
            return null;
        }
        return PingReply.createGUESSReply(byArray, (byte)1, gUESSEndpoint.getPort(), gUESSEndpoint.getAddress().getAddress());
    }

    final void handlePingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler) != null) {
            this.handlePingRequest(pingRequest, replyHandler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler, DatagramPacket datagramPacket) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler) != null) {
            this.handleUDPPingRequest(pingRequest, replyHandler, datagramPacket);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest queryRequest, ManagedConnection managedConnection) {
        boolean bl = queryRequest.getTTL() == 0 && (queryRequest.getHops() == 1 || queryRequest.getHops() == 2);
        ResultCounter resultCounter = this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), managedConnection);
        if (resultCounter != null) {
            if (bl) {
                this._queryRouteTable.setTTL(resultCounter, (byte)1);
            }
            this.handleQueryRequest(queryRequest, managedConnection, resultCounter, true);
        } else if (resultCounter == null && !bl) {
            if (this.wasProbeQuery(queryRequest)) {
                this.handleQueryRequest(queryRequest, managedConnection, resultCounter, false);
            } else {
                this.tallyDupQuery(queryRequest);
            }
        } else if (resultCounter == null && bl) {
            this.tallyDupQuery(queryRequest);
        } else {
            this.tallyDupQuery(queryRequest);
        }
    }

    private boolean wasProbeQuery(QueryRequest queryRequest) {
        return queryRequest.getTTL() > 0 && this._queryRouteTable.getAndSetTTL(queryRequest.getGUID(), (byte)1, (byte)(queryRequest.getTTL() + 1));
    }

    private void tallyDupQuery(QueryRequest queryRequest) {
        if (RECORD_STATS) {
            ReceivedMessageStatHandler.TCP_DUPLICATE_QUERIES.addMessage(queryRequest);
        }
    }

    final boolean handleUDPQueryRequestPossibleDuplicate(QueryRequest queryRequest, ReplyHandler replyHandler) {
        ResultCounter resultCounter = this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), replyHandler);
        if (resultCounter != null) {
            this.handleQueryRequest(queryRequest, replyHandler, resultCounter, true);
            return true;
        }
        return false;
    }

    private final void handlePingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (pingRequest.isHeartbeat() || replyHandler.allowNewPings()) {
            this.respondToPingRequest(pingRequest, replyHandler);
        }
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, DatagramPacket datagramPacket) {
        if (pingRequest.isQueryKeyRequest()) {
            this.sendQueryKeyPong(pingRequest, datagramPacket);
        } else {
            this.respondToUDPPingRequest(pingRequest, datagramPacket, replyHandler);
        }
    }

    protected void sendQueryKeyPong(PingRequest pingRequest, DatagramPacket datagramPacket) {
        InetAddress inetAddress = datagramPacket.getAddress();
        int n = datagramPacket.getPort();
        QueryKey queryKey = QueryKey.getQueryKey(inetAddress, n);
        PingReply pingReply = PingReply.createQueryKeyReply(pingRequest.getGUID(), (byte)1, queryKey);
        UDPService.instance().send(pingReply, datagramPacket.getAddress(), datagramPacket.getPort());
    }

    protected void handleUDPPingReply(PingReply pingReply, ReplyHandler replyHandler, InetAddress inetAddress, int n) {
        if (pingReply.getQueryKey() != null) {
            OnDemandUnicaster.handleQueryKeyPong(pingReply);
            return;
        }
        if (pingReply.getPort() != n || !pingReply.getInetAddress().equals(inetAddress)) {
            this.UNICASTER.addUnicastEndpoint(inetAddress, n);
        }
        this.handlePingReply(pingReply, replyHandler);
    }

    protected void handleQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler, ResultCounter resultCounter, boolean bl) {
        if (!replyHandler.isPersonalSpam(queryRequest)) {
            this._callback.handleQueryString(queryRequest.getQuery());
        }
        this.updateMessage(queryRequest, replyHandler);
        if (replyHandler.isSupernodeClientConnection() && resultCounter != null) {
            if (queryRequest.desiresOutOfBandReplies()) {
                String string = replyHandler.getInetAddress().getHostAddress();
                String string2 = NetworkUtils.ip2string(RouterService.getAddress());
                if (!(queryRequest.getReplyAddress().equals(string) || queryRequest.getReplyAddress().equals(string2) && RouterService.isOOBCapable())) {
                    return;
                }
            }
            bl = false;
            this.respondToQueryRequest(queryRequest, this._clientGUID, replyHandler);
            this.multicastQueryRequest(queryRequest);
            if (replyHandler.isGoodLeaf()) {
                this.sendDynamicQuery(QueryHandler.createHandlerForNewLeaf(queryRequest, replyHandler, resultCounter), replyHandler);
            } else {
                this.sendDynamicQuery(QueryHandler.createHandlerForOldLeaf(queryRequest, replyHandler, resultCounter), replyHandler);
            }
        } else if (queryRequest.getTTL() > 0 && RouterService.isSupernode()) {
            if (replyHandler.isGoodUltrapeer()) {
                this.forwardQueryToUltrapeers(queryRequest, replyHandler);
            } else {
                this.forwardLimitedQueryToUltrapeers(queryRequest, replyHandler);
            }
        }
        if (bl) {
            this.forwardQueryRequestToLeaves(queryRequest, replyHandler);
            if (queryRequest.isFirewalledSource() && !RouterService.acceptedIncomingConnection() && !ApplicationSettings.SERVER.getValue()) {
                return;
            }
            this.respondToQueryRequest(queryRequest, this._clientGUID, replyHandler);
        }
    }

    protected void handleLimeACKMessage(LimeACKVendorMessage limeACKVendorMessage, DatagramPacket datagramPacket) {
        GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(limeACKVendorMessage.getGUID()), 25000L);
        QueryResponseBundle queryResponseBundle = (QueryResponseBundle)this._outOfBandReplies.remove((Object)timedGUID);
        if (queryResponseBundle != null && limeACKVendorMessage.getNumResults() > 0) {
            Object object;
            InetAddress inetAddress = datagramPacket.getAddress();
            int n = datagramPacket.getPort();
            Iterator iterator = null;
            if (limeACKVendorMessage.getNumResults() < queryResponseBundle._responses.length) {
                object = new Response[limeACKVendorMessage.getNumResults()];
                int n2 = 0;
                while (n2 < ((Response[])object).length) {
                    object[n2] = queryResponseBundle._responses[n2];
                    ++n2;
                }
                iterator = this.responsesToQueryReplies((Response[])object, queryResponseBundle._query, 1);
            } else {
                iterator = this.responsesToQueryReplies(queryResponseBundle._responses, queryResponseBundle._query, 1);
            }
            while (iterator.hasNext()) {
                object = (QueryReply)iterator.next();
                UDPService.instance().send((Message)object, inetAddress, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReplyNumberMessage(ReplyNumberVendorMessage replyNumberVendorMessage, DatagramPacket datagramPacket) {
        GUID gUID = new GUID(replyNumberVendorMessage.getGUID());
        int n = RouterService.getSearchResultHandler().getNumResultsForQuery(gUID);
        if (n < 0) {
            n = this.DYNAMIC_QUERIER.getLeafResultsForQuery(gUID);
        }
        if (n < 0 || n > 250) {
            if (RECORD_STATS) {
                OutOfBandThroughputStat.RESPONSES_BYPASSED.addData(replyNumberVendorMessage.getNumResults());
            }
            DownloadManager downloadManager = RouterService.getDownloadManager();
            if (!this._callback.isQueryAlive(gUID) && !downloadManager.isGuidForQueryDownloading(gUID)) {
                return;
            }
            GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(datagramPacket.getAddress(), datagramPacket.getPort());
            Map map = this._bypassedResults;
            synchronized (map) {
                Set set = (Set)this._bypassedResults.get((Object)gUID);
                if (set == null) {
                    set = new HashSet();
                    this._bypassedResults.put((Object)gUID, (Object)set);
                }
                if (this._bypassedResults.size() <= 150) {
                    set.add((Object)gUESSEndpoint);
                }
            }
            return;
        }
        LimeACKVendorMessage limeACKVendorMessage = new LimeACKVendorMessage(gUID, replyNumberVendorMessage.getNumResults());
        UDPService.instance().send(limeACKVendorMessage, datagramPacket.getAddress(), datagramPacket.getPort());
        if (RECORD_STATS) {
            OutOfBandThroughputStat.RESPONSES_REQUESTED.addData(replyNumberVendorMessage.getNumResults());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bufferResponsesForLaterDelivery(QueryRequest queryRequest, Response[] responseArray) {
        Map map = this._outOfBandReplies;
        synchronized (map) {
            block4: {
                if (this._outOfBandReplies.size() >= MAX_BUFFERED_REPLIES) break block4;
                GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(queryRequest.getGUID()), 25000L);
                this._outOfBandReplies.put((Object)timedGUID, (Object)new QueryResponseBundle(queryRequest, responseArray));
                return true;
            }
            return false;
        }
    }

    protected void handleUDPConnectBackRequest(UDPConnectBackVendorMessage uDPConnectBackVendorMessage, Connection connection) {
        GUID gUID = uDPConnectBackVendorMessage.getConnectBackGUID();
        int n = uDPConnectBackVendorMessage.getConnectBackPort();
        InetAddress inetAddress = connection.getInetAddress();
        UDPConnectBackRedirect uDPConnectBackRedirect = new UDPConnectBackRedirect(gUID, inetAddress, n);
        int n2 = 0;
        ArrayList arrayList = new ArrayList((Collection)_manager.getInitializedConnections());
        Collections.shuffle((List)arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n2 < 5) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection == connection || managedConnection.remoteHostSupportsUDPRedirect() < 0) continue;
            managedConnection.send(uDPConnectBackRedirect);
            ++n2;
        }
    }

    protected void handleUDPConnectBackRedirect(UDPConnectBackRedirect uDPConnectBackRedirect, Connection connection) {
        if (!connection.isSupernodeSupernodeConnection()) {
            return;
        }
        GUID gUID = uDPConnectBackRedirect.getConnectBackGUID();
        int n = uDPConnectBackRedirect.getConnectBackPort();
        InetAddress inetAddress = uDPConnectBackRedirect.getConnectBackAddress();
        Endpoint endpoint = new Endpoint(inetAddress.getAddress(), n);
        if (_manager.isConnectedTo(endpoint.getAddress())) {
            return;
        }
        String string = inetAddress.getHostAddress();
        Object object = _udpConnectBacks.get(string);
        if (object == null) {
            try {
                _udpConnectBacks.put(string, new Object());
            }
            catch (NoMoreStorageException noMoreStorageException) {
                return;
            }
        } else {
            return;
        }
        PingRequest pingRequest = new PingRequest(gUID.bytes(), 1, 0);
        UDPService.instance().send(pingRequest, inetAddress, n);
    }

    protected void handleTCPConnectBackRequest(TCPConnectBackVendorMessage tCPConnectBackVendorMessage, Connection connection) {
        int n = tCPConnectBackVendorMessage.getConnectBackPort();
        InetAddress inetAddress = connection.getInetAddress();
        TCPConnectBackRedirect tCPConnectBackRedirect = new TCPConnectBackRedirect(inetAddress, n);
        int n2 = 0;
        ArrayList arrayList = new ArrayList((Collection)_manager.getInitializedConnections());
        Collections.shuffle((List)arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n2 < 5) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection == connection || managedConnection.remoteHostSupportsTCPRedirect() < 0) continue;
            managedConnection.send(tCPConnectBackRedirect);
            ++n2;
        }
    }

    protected void handleTCPConnectBackRedirect(TCPConnectBackRedirect tCPConnectBackRedirect, Connection connection) {
        if (!connection.isSupernodeSupernodeConnection()) {
            return;
        }
        final int n = tCPConnectBackRedirect.getConnectBackPort();
        final String string = tCPConnectBackRedirect.getConnectBackAddress().getHostAddress();
        Endpoint endpoint = new Endpoint(string, n);
        if (_manager.isConnectedTo(endpoint.getAddress())) {
            return;
        }
        Object object = _tcpConnectBacks.get(string);
        if (object == null) {
            try {
                _tcpConnectBacks.put(string, new Object());
            }
            catch (NoMoreStorageException noMoreStorageException) {
                return;
            }
        } else {
            return;
        }
        TCP_CONNECT_BACKER.add(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Socket socket = null;
                try {
                    try {
                        socket = Sockets.connect(string, n, 12000);
                        OutputStream outputStream = socket.getOutputStream();
                        outputStream.write("CONNECT BACK\r\n\r\n".getBytes());
                        outputStream.flush();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (IOException iOException) {
                    }
                    catch (Throwable throwable) {
                        ErrorService.error(throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    IOUtils.close(socket);
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                IOUtils.close(socket);
            }
        });
    }

    protected void handlePushProxyRequest(PushProxyRequest pushProxyRequest, ManagedConnection managedConnection) {
        if (managedConnection.isSupernodeClientConnection() && RouterService.isIpPortValid()) {
            String string = NetworkUtils.ip2string(RouterService.getAddress());
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                ErrorService.error(unknownHostException);
            }
            PushProxyAcknowledgement pushProxyAcknowledgement = new PushProxyAcknowledgement(inetAddress, RouterService.getPort(), pushProxyRequest.getClientGUID());
            managedConnection.send(pushProxyAcknowledgement);
            this._pushRouteTable.routeReply(pushProxyRequest.getClientGUID().bytes(), managedConnection);
        }
    }

    protected void handleQueryStatus(QueryStatusResponse queryStatusResponse, ManagedConnection managedConnection) {
        if (!managedConnection.isSupernodeClientConnection()) {
            return;
        }
        GUID gUID = queryStatusResponse.getQueryGUID();
        int n = queryStatusResponse.getNumResults();
        this.DYNAMIC_QUERIER.updateLeafResultsForQuery(gUID, n);
    }

    public void sendPingRequest(PingRequest pingRequest, ManagedConnection managedConnection) {
        if (pingRequest == null) {
            throw new NullPointerException("null ping");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        managedConnection.send(pingRequest);
    }

    public void sendQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        managedConnection.send(queryRequest);
    }

    public void broadcastPingRequest(PingRequest pingRequest) {
        if (pingRequest == null) {
            throw new NullPointerException("null ping");
        }
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        this.broadcastPingRequest(pingRequest, this.FOR_ME_REPLY_HANDLER, _manager);
    }

    public void sendDynamicQuery(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new NullPointerException("null QueryHandler");
        }
        ResultCounter resultCounter = this._queryRouteTable.routeReply(queryRequest.getGUID(), this.FOR_ME_REPLY_HANDLER);
        if (RouterService.isSupernode()) {
            this.sendDynamicQuery(QueryHandler.createHandlerForMe(queryRequest, resultCounter), this.FOR_ME_REPLY_HANDLER);
        } else {
            this.originateLeafQuery(queryRequest);
        }
        this.multicastQueryRequest(QueryRequest.createMulticastQuery(queryRequest));
    }

    private void sendDynamicQuery(QueryHandler queryHandler, ReplyHandler replyHandler) {
        if (queryHandler == null) {
            throw new NullPointerException("null QueryHandler");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        this.DYNAMIC_QUERIER.addQuery(queryHandler);
    }

    private void broadcastPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, ConnectionManager connectionManager) {
        List list = connectionManager.getInitializedConnections();
        int n = list.size();
        boolean bl = false;
        if (n > 3) {
            bl = true;
        }
        int n2 = 0;
        while (n2 < n) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n2);
            if (managedConnection.isStable() && (replyHandler == this.FOR_ME_REPLY_HANDLER || managedConnection != replyHandler && !managedConnection.isClientSupernodeConnection())) {
                double d = managedConnection.supportsPongCaching() ? 0.7 : 0.9;
                if (!bl || !(Math.random() < d)) {
                    managedConnection.send(pingRequest);
                }
            }
            ++n2;
        }
    }

    public final void forwardQueryRequestToLeaves(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (!RouterService.isSupernode()) {
            return;
        }
        List list = _manager.getInitializedClientConnections();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (managedConnection != replyHandler && managedConnection.shouldForwardQuery(queryRequest)) {
                arrayList.add((Object)managedConnection);
            }
            ++n;
        }
        if (list.size() > 8 && (double)arrayList.size() / (double)list.size() > 0.8) {
            n = (int)Math.floor(Math.random() * (double)arrayList.size() * 0.75);
            arrayList = arrayList.subList(n, n + arrayList.size() / 4);
        }
        n = list.size() - arrayList.size();
        RoutedQueryStat.LEAF_DROP.addData(n);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            ManagedConnection managedConnection = (ManagedConnection)arrayList.get(n2);
            this.sendQueryRequest(queryRequest, managedConnection, replyHandler);
            RoutedQueryStat.LEAF_SEND.incrementStat();
            ++n2;
        }
    }

    private boolean sendRoutedQueryToHost(QueryRequest queryRequest, ManagedConnection managedConnection, ReplyHandler replyHandler) {
        if (managedConnection.shouldForwardQuery(queryRequest)) {
            this.sendQueryRequest(queryRequest, managedConnection, replyHandler);
            return true;
        }
        return false;
    }

    protected void unicastQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler) {
        queryRequest.setTTL((byte)1);
        this.UNICASTER.addQuery(queryRequest, replyHandler);
    }

    protected void multicastQueryRequest(QueryRequest queryRequest) {
        queryRequest.setTTL((byte)1);
        if (RECORD_STATS) {
            SentMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(queryRequest);
        }
        MulticastService.instance().send(queryRequest);
    }

    private void forwardQueryToUltrapeers(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List list = _manager.getInitializedConnections();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n2);
            this.forwardQueryToUltrapeer(queryRequest, replyHandler, managedConnection);
            ++n2;
        }
    }

    private void forwardLimitedQueryToUltrapeers(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List list = _manager.getInitializedConnections();
        int n = list.size();
        int n2 = 15;
        int n3 = 0;
        while (n3 < n) {
            if (n2 == 0) break;
            ManagedConnection managedConnection = (ManagedConnection)list.get(n3);
            if (!managedConnection.isGoodUltrapeer() || n - n3 <= n2) {
                this.forwardQueryToUltrapeer(queryRequest, replyHandler, managedConnection);
                --n2;
            }
            ++n3;
        }
    }

    private void forwardQueryToUltrapeer(QueryRequest queryRequest, ReplyHandler replyHandler, ManagedConnection managedConnection) {
        boolean bl;
        if (managedConnection == replyHandler) {
            return;
        }
        if (managedConnection.isClientSupernodeConnection()) {
            return;
        }
        if (queryRequest.getCapabilitySelector() > 0 && managedConnection.getRemoteHostCapabilitySelector() < 1) {
            return;
        }
        boolean bl2 = bl = queryRequest.getTTL() == 1;
        if (bl && managedConnection.isUltrapeerQueryRoutingConnection()) {
            boolean bl3 = this.sendRoutedQueryToHost(queryRequest, managedConnection, replyHandler);
            if (bl3 && RECORD_STATS) {
                RoutedQueryStat.ULTRAPEER_SEND.incrementStat();
            } else if (RECORD_STATS) {
                RoutedQueryStat.ULTRAPEER_DROP.incrementStat();
            }
        } else {
            this.sendQueryRequest(queryRequest, managedConnection, replyHandler);
        }
    }

    private void originateLeafQuery(QueryRequest queryRequest) {
        List list = _manager.getInitializedConnections();
        int n = queryRequest.isWhatIsNewRequest() ? 2 : 4;
        int n2 = !queryRequest.isWhatIsNewRequest() ? 0 : (int)Math.floor(Math.random() * (double)(list.size() - 1));
        int n3 = Math.min(n, list.size());
        boolean bl = queryRequest.desiresOutOfBandReplies();
        int n4 = n2;
        while (n4 < n2 + n3) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n4);
            QueryRequest queryRequest2 = queryRequest;
            if (bl && managedConnection.remoteHostSupportsLeafGuidance() < 0) {
                queryRequest2 = QueryRequest.unmarkOOBQuery(queryRequest);
            }
            this.sendQueryRequest(queryRequest2, managedConnection, this.FOR_ME_REPLY_HANDLER);
            ++n4;
        }
    }

    public void sendQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection, ReplyHandler replyHandler) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null send connection");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        if (replyHandler == this.FOR_ME_REPLY_HANDLER) {
            managedConnection.send(queryRequest);
        }
    }

    public boolean originateQuery(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (managedConnection == null) {
            throw new NullPointerException("null connection");
        }
        if (queryRequest.getCapabilitySelector() > 0 && managedConnection.getRemoteHostCapabilitySelector() < 1) {
            return false;
        }
        managedConnection.originateQuery(queryRequest);
        return true;
    }

    protected abstract void respondToPingRequest(PingRequest var1, ReplyHandler var2);

    protected abstract void respondToUDPPingRequest(PingRequest var1, DatagramPacket var2, ReplyHandler var3);

    protected abstract boolean respondToQueryRequest(QueryRequest var1, byte[] var2, ReplyHandler var3);

    protected void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        ReplyHandler replyHandler2;
        boolean bl = RouterService.getHostCatcher().add(pingReply);
        if (bl && !pingReply.isUDPHostCache()) {
            PongCacher.instance().addPong(pingReply);
        }
        if ((replyHandler2 = this._pingRouteTable.getReplyHandler(pingReply.getGUID())) != null) {
            replyHandler2.handlePingReply(pingReply, replyHandler);
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.PING_REPLY_ROUTE_ERRORS.incrementStat();
            }
            replyHandler.countDroppedMessage();
        }
        boolean bl2 = pingReply.supportsUnicast();
        if (bl && (pingReply.isUltrapeer() || bl2)) {
            List list = _manager.getInitializedClientConnections();
            int n = 0;
            while (n < list.size()) {
                ManagedConnection managedConnection = (ManagedConnection)list.get(n);
                Assert.that(managedConnection != null, "null c.");
                if (managedConnection != replyHandler && managedConnection != replyHandler2 && managedConnection.allowNewPongs()) {
                    managedConnection.handlePingReply(pingReply, replyHandler);
                }
                ++n;
            }
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        if (queryReply == null) {
            throw new NullPointerException("null query reply");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (replyRoutePair != null) {
            queryReply.setPriority(replyRoutePair.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), replyHandler);
            ReplyHandler replyHandler2 = replyRoutePair.getReplyHandler();
            if (!this.shouldDropReply(replyRoutePair, replyHandler2, queryReply)) {
                replyHandler2.handleQueryReply(queryReply, replyHandler);
                this.UNICASTER.handleQueryReply(queryReply);
            } else {
                if (RECORD_STATS) {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
                    byte by = queryReply.getTTL();
                    if (by < RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length) {
                        RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[by].incrementStat();
                    } else {
                        RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length - 1].incrementStat();
                    }
                }
                replyHandler.countDroppedMessage();
            }
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.NO_ROUTE_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
            }
            replyHandler.countDroppedMessage();
        }
    }

    private boolean shouldDropReply(RouteTable.ReplyRoutePair replyRoutePair, ReplyHandler replyHandler, QueryReply queryReply) {
        byte by = queryReply.getTTL();
        if (replyHandler == this.FOR_ME_REPLY_HANDLER) {
            return false;
        }
        if (by == 0) {
            return true;
        }
        int n = replyRoutePair.getResultsRouted();
        if (n > 100) {
            return true;
        }
        int n2 = replyRoutePair.getBytesRouted();
        if (by > 2 && n2 < 51200) {
            return false;
        }
        if (by == 1 && n2 < 204800) {
            return false;
        }
        return by != 2 || n2 >= 102400;
    }

    private void handleGiveStats(GiveStatsVendorMessage giveStatsVendorMessage, ReplyHandler replyHandler) {
        StatisticVendorMessage statisticVendorMessage = null;
        try {
            if (StatisticVendorMessage.isSupported(giveStatsVendorMessage)) {
                statisticVendorMessage = new StatisticVendorMessage(giveStatsVendorMessage);
                replyHandler.handleStatisticVM(statisticVendorMessage);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void handleStatisticsMessage(final StatisticVendorMessage statisticVendorMessage, ReplyHandler replyHandler) {
        if (StatisticsSettings.RECORD_VM_STATS.getValue()) {
            ManagedThread managedThread = new ManagedThread("Stat writer "){

                /*
                 * Exception decompiling
                 */
                public void managedRun() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 91->95)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            managedThread.start();
        }
    }

    protected void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        if (pushRequest == null) {
            throw new NullPointerException("null request");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        ReplyHandler replyHandler2 = this._pushRouteTable.getReplyHandler(pushRequest.getClientGUID());
        if (replyHandler2 != null) {
            replyHandler2.handlePushRequest(pushRequest, replyHandler);
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.PUSH_REQUEST_ROUTE_ERRORS.incrementStat();
            }
            replyHandler.countDroppedMessage();
        }
    }

    protected void sendPingReply(PingReply pingReply, ReplyHandler replyHandler) {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        replyHandler.handlePingReply(pingReply, null);
    }

    protected void sendQueryReply(QueryReply queryReply) throws IOException {
        if (queryReply == null) {
            throw new NullPointerException("null reply");
        }
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (replyRoutePair == null) {
            throw new IOException("no route for reply");
        }
        queryReply.setPriority(replyRoutePair.getBytesRouted());
        this._pushRouteTable.routeReply(queryReply.getClientGUID(), this.FOR_ME_REPLY_HANDLER);
        replyRoutePair.getReplyHandler().handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest pushRequest) throws IOException {
        if (pushRequest == null) {
            throw new NullPointerException("null push");
        }
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(pushRequest.getClientGUID());
        if (replyHandler == null) {
            throw new IOException("no route for push");
        }
        replyHandler.handlePushRequest(pushRequest, this.FOR_ME_REPLY_HANDLER);
    }

    protected void sendMulticastPushRequest(PushRequest pushRequest) {
        if (pushRequest == null) {
            throw new NullPointerException("null push");
        }
        Assert.that(pushRequest.getTTL() == 1, "multicast push ttl not 1");
        MulticastService.instance().send(pushRequest);
        SentMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(pushRequest);
    }

    public Iterator responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest) {
        return this.responsesToQueryReplies(responseArray, queryRequest, 10);
    }

    private Iterator responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest, int n) {
        int n2;
        Response[] responseArray2;
        int n3;
        LinkedList linkedList = new LinkedList();
        byte[] byArray = queryRequest.getGUID();
        byte by = (byte)(queryRequest.getHops() + 1);
        UploadManager uploadManager = RouterService.getUploadManager();
        long l = uploadManager.measuredUploadSpeed();
        boolean bl = true;
        if (l == -1L) {
            l = ConnectionSettings.CONNECTION_SPEED.getValue();
            bl = false;
        }
        int n4 = responseArray.length;
        int n5 = 0;
        byte by2 = queryRequest.getHops();
        if (n > 1 && by2 > 2 && n4 > 10) {
            n3 = (int)(Math.random() * (double)n4) % (n4 - 10);
            responseArray2 = new Response[10];
            n2 = 0;
            while (n2 < 10) {
                responseArray2[n2] = responseArray[n3];
                ++n2;
                ++n3;
            }
            responseArray = responseArray2;
            n4 = responseArray.length;
        }
        while (n4 > 0) {
            boolean bl2;
            n3 = n4 < n ? n4 : n;
            if (n5 == 0 && n3 < n) {
                responseArray2 = responseArray;
            } else {
                responseArray2 = new Response[n3];
                n2 = 0;
                while (n2 < n3) {
                    responseArray2[n2] = responseArray[n5];
                    ++n5;
                    ++n2;
                }
            }
            n4 -= n3;
            n2 = uploadManager.isServiceable() ? 0 : 1;
            boolean bl3 = uploadManager.hadSuccesfulUpload();
            boolean bl4 = bl2 = queryRequest.isMulticast() && queryRequest.getTTL() + queryRequest.getHops() == 1;
            if (bl2) {
                by = 1;
            }
            List list = this.createQueryReply(byArray, by, l, responseArray2, this._clientGUID, n2 != 0, bl3, bl, bl2);
            linkedList.addAll((Collection)list);
        }
        return linkedList.iterator();
    }

    protected abstract List createQueryReply(byte[] var1, byte var2, long var3, Response[] var5, byte[] var6, boolean var7, boolean var8, boolean var9, boolean var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResetTableMessage(ResetTableMessage resetTableMessage, ManagedConnection managedConnection) {
        if (!MessageRouter.isQRPConnection(managedConnection)) {
            return;
        }
        Object object = managedConnection.getQRPLock();
        synchronized (object) {
            managedConnection.resetQueryRouteTable(resetTableMessage);
        }
        if (managedConnection.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePatchTableMessage(PatchTableMessage patchTableMessage, ManagedConnection managedConnection) {
        if (!MessageRouter.isQRPConnection(managedConnection)) {
            return;
        }
        Object object = managedConnection.getQRPLock();
        synchronized (object) {
            managedConnection.patchQueryRouteTable(patchTableMessage);
        }
        if (managedConnection.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    private void updateMessage(QueryRequest queryRequest, ReplyHandler replyHandler) {
        if (!(replyHandler instanceof Connection)) {
            return;
        }
        Connection connection = (Connection)((Object)replyHandler);
        if (queryRequest.getHops() == 1 && connection.isOldLimeWire()) {
            if (StaticMessages.updateReply == null) {
                return;
            }
            QueryReply queryReply = new QueryReply(queryRequest.getGUID(), StaticMessages.updateReply);
            try {
                this.sendQueryReply(queryReply);
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isQRPConnection(Connection connection) {
        if (connection.isSupernodeClientConnection()) {
            return true;
        }
        return connection.isUltrapeerQueryRoutingConnection();
    }

    private void forwardQueryRouteTables() {
        long l = System.currentTimeMillis();
        List list = _manager.getInitializedConnections();
        QueryRouteTable queryRouteTable = null;
        List list2 = null;
        QueryRouteTable queryRouteTable2 = null;
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (!(!RouterService.isSupernode() ? !managedConnection.isClientSupernodeConnection() || !managedConnection.isQueryRoutingEnabled() : !managedConnection.isUltrapeerQueryRoutingConnection())) {
                if (l >= managedConnection.getNextQRPForwardTime()) {
                    managedConnection.incrementNextQRPForwardTime(l);
                    if (queryRouteTable == null) {
                        this._lastQueryRouteTable = queryRouteTable = MessageRouter.createRouteTable();
                    }
                    if (queryRouteTable2 == managedConnection.getQueryRouteTableSent()) {
                        if (list2 == null) {
                            list2 = queryRouteTable.encode(queryRouteTable2, true);
                        }
                    } else {
                        queryRouteTable2 = managedConnection.getQueryRouteTableSent();
                        list2 = queryRouteTable.encode(queryRouteTable2, true);
                    }
                    if (!ConnectionSettings.SEND_QRP.getValue()) {
                        return;
                    }
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        managedConnection.send((RouteTableMessage)iterator.next());
                    }
                    managedConnection.setQueryRouteTableSent(queryRouteTable);
                }
            }
            ++n;
        }
    }

    public QueryRouteTable getQueryRouteTable() {
        return this._lastQueryRouteTable;
    }

    private static QueryRouteTable createRouteTable() {
        QueryRouteTable queryRouteTable = _fileManager.getQRT();
        if (RouterService.isSupernode()) {
            MessageRouter.addQueryRoutingEntriesForLeaves(queryRouteTable);
        }
        return queryRouteTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addQueryRoutingEntriesForLeaves(QueryRouteTable queryRouteTable) {
        List list = _manager.getInitializedClientConnections();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            Object object = managedConnection.getQRPLock();
            synchronized (object) {
                QueryRouteTable queryRouteTable2 = managedConnection.getQueryRouteTableReceived();
                if (queryRouteTable2 != null) {
                    queryRouteTable.addAll(queryRouteTable2);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageListener(byte[] byArray, MessageListener messageListener) {
        messageListener.registered(byArray);
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            TreeMap treeMap = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
            treeMap.putAll(this._messageListeners);
            List list = (List)treeMap.get((Object)byArray);
            if (list == null) {
                list = new ArrayList(1);
                list.add((Object)messageListener);
            } else {
                ArrayList arrayList = new ArrayList(list.size() + 1);
                arrayList.addAll((Collection)list);
                list = arrayList;
                list.add((Object)messageListener);
            }
            treeMap.put((Object)byArray, (Object)Collections.unmodifiableList((List)list));
            this._messageListeners = Collections.unmodifiableMap((Map)treeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMessageListener(byte[] byArray, MessageListener messageListener) {
        boolean bl = false;
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            List list = (List)this._messageListeners.get((Object)byArray);
            if (list != null && (list = new ArrayList((Collection)list)).remove((Object)messageListener)) {
                bl = true;
                TreeMap treeMap = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
                treeMap.putAll(this._messageListeners);
                if (list.isEmpty()) {
                    treeMap.remove((Object)byArray);
                } else {
                    treeMap.put((Object)byArray, (Object)Collections.unmodifiableList((List)list));
                }
                this._messageListeners = Collections.unmodifiableMap((Map)treeMap);
            }
        }
        if (bl) {
            messageListener.unregistered(byArray);
        }
    }

    private void handleUDPCrawlerPing(UDPCrawlerPing uDPCrawlerPing, ReplyHandler replyHandler) {
        if (!this._promotionManager.allowUDPPing(replyHandler)) {
            return;
        }
        UDPCrawlerPong uDPCrawlerPong = new UDPCrawlerPong(uDPCrawlerPing);
        replyHandler.handleUDPCrawlerPong(uDPCrawlerPong);
    }

    private class QRPPropagator
    extends ManagedThread {
        public QRPPropagator() {
            this.setName("QRPPropagator");
            this.setDaemon(true);
        }

        public void managedRun() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    MessageRouter.this.forwardQueryRouteTables();
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                return;
            }
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest queryRequest, Response[] responseArray) {
            this._query = queryRequest;
            this._responses = responseArray;
        }
    }

    private class Expirer
    implements Runnable {
        Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashSet hashSet = new HashSet();
                Map map = MessageRouter.this._outOfBandReplies;
                synchronized (map) {
                    Iterator iterator = MessageRouter.this._outOfBandReplies.keySet().iterator();
                    while (iterator.hasNext()) {
                        GUID.TimedGUID timedGUID = (GUID.TimedGUID)iterator.next();
                        if (timedGUID == null || !timedGUID.shouldExpire()) continue;
                        hashSet.add((Object)timedGUID);
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        MessageRouter.this._outOfBandReplies.remove(iterator.next());
                    }
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }

    static class ConnectBackExpirer
    implements Runnable {
        ConnectBackExpirer() {
        }

        public void run() {
            try {
                _tcpConnectBacks.clear();
                _udpConnectBacks.clear();
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }
}

