/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Random12;
import com.sun.java.util.collections.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Acceptor
implements Runnable {
    private static final Log LOG;
    static long INCOMING_EXPIRE_TIME;
    static long WAIT_TIME_AFTER_REQUESTS;
    static long TIME_BETWEEN_VALIDATES;
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private final Object SOCKET_LOCK = new Object();
    private static byte[] _address;
    private static byte[] _externalAddress;
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastIncomingTime = 0L;
    private volatile long _lastConnectBackTime = System.currentTimeMillis();
    private static final boolean RECORD_STATS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INCOMING_EXPIRE_TIME = 540000000L;
        WAIT_TIME_AFTER_REQUESTS = 30000L;
        TIME_BETWEEN_VALIDATES = 2400000L;
        _address = new byte[4];
        _externalAddress = new byte[4];
        RECORD_STATS = !CommonUtils.isJava118();
    }

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - INCOMING_EXPIRE_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return;
        }
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean bl = false;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (!Arrays.equals((byte[])_address, (byte[])byArray)) {
                _address = byArray;
                bl = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (bl) {
                RouterService.addressChanged();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            _externalAddress = byArray;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void start() {
        MulticastService.instance().start();
        UDPService.instance().start();
        ManagedThread managedThread = new ManagedThread(this, "Acceptor");
        managedThread.setDaemon(true);
        managedThread.start();
        RouterService.schedule(new IncomingValidator(), TIME_BETWEEN_VALIDATES, TIME_BETWEEN_VALIDATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.equals((byte[])this.getAddress(true), (byte[])_externalAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getExternalAddress() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAddress(boolean bl) {
        Class<?> clazz;
        Object object;
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            object = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress inetAddress = InetAddress.getByName((String)object);
                return inetAddress.getAddress();
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        object = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _address;
        }
    }

    public int getPort(boolean bl) {
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningPort(int n) throws IOException {
        Object object;
        LOG.trace((Object)"Acceptor.setListeningPort(): entered.");
        if (this._socket != null && this._port == n) {
            return;
        }
        if (n == 0) {
            LOG.trace((Object)"Acceptor.setListeningPort(): shutting off service.");
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {}
            }
            Object object2 = this.SOCKET_LOCK;
            synchronized (object2) {
                this._socket = null;
                this._port = 0;
                this.SOCKET_LOCK.notify();
            }
            UDPService.instance().setListeningSocket(null);
            MulticastService.instance().setListeningSocket(null);
            LOG.trace((Object)"Acceptor.setListeningPort(): service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Acceptor.setListeningPort(): changing port to " + n));
        }
        DatagramSocket datagramSocket = UDPService.instance().newListeningSocket(n);
        LOG.trace((Object)"Acceptor.setListeningPort(): UDP Service is ready.");
        MulticastSocket multicastSocket = null;
        try {
            object = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            multicastSocket = MulticastService.instance().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), (InetAddress)object);
            LOG.trace((Object)"Acceptor.setListeningPort(): Multicast Service is ready.");
        }
        catch (IOException iOException) {
            multicastSocket = null;
            LOG.debug((Object)"Acceptor.setListeningPort(): Unable to start multicast service.", (Throwable)iOException);
        }
        object = null;
        try {
            object = new ServerSocket(n);
        }
        catch (IOException iOException) {
            datagramSocket.close();
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            datagramSocket.close();
            throw new IOException("could not create a listening socket");
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {}
        }
        Object object3 = this.SOCKET_LOCK;
        synchronized (object3) {
            this._socket = object;
            this._port = n;
            this.SOCKET_LOCK.notify();
        }
        LOG.trace((Object)"Acceptor.setListeningPort(): I am ready.");
        UDPService.instance().setListeningSocket(datagramSocket);
        if (multicastSocket != null) {
            MulticastService.instance().setListeningSocket(multicastSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Acceptor.setListeningPort(): listening UDP/TCP on " + this._port));
        }
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        block38: {
            var1_1 = ConnectionSettings.PORT.getValue();
            try {
                this.setAddress(InetAddress.getLocalHost());
            }
            catch (UnknownHostException v0) {
            }
            catch (SecurityException v1) {}
            var2_2 = var1_1;
            try {
                this.setListeningPort(var1_1);
                this._port = var1_1;
                break block38;
            }
            catch (IOException var3_3) {
                var4_7 = 20;
                var5_9 /* !! */  = null;
                var6_10 = 0;
                ** while (var6_10 < var4_7)
            }
lbl-1000:
            // 1 sources

            {
                if (var6_10 < 10) {
                    var1_1 = var6_10 + 6346;
                } else {
                    if (var5_9 /* !! */  == null) {
                        var5_9 /* !! */  = new Random12();
                    }
                    var1_1 = var5_9 /* !! */ .nextInt(50000);
                    var1_1 += 2000;
                }
                if (var1_1 == ConnectionSettings.MULTICAST_PORT.getValue()) {
                    ++var4_7;
                } else {
                    try {
                        this.setListeningPort(var1_1);
                        this._port = var1_1;
                        break;
                    }
                    catch (IOException var7_13) {
                    }
                }
                ++var6_10;
                continue;
            }
lbl39:
            // 2 sources

            if (this._socket == null) {
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
        if (this._port != var2_2) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsHandler.save();
            RouterService.addressChanged();
        }
        while (true) {
            try {
                while (true) {
                    block39: {
                        var3_4 = null;
                        var4_8 = this.SOCKET_LOCK;
                        // MONITORENTER : var4_8
                        if (this._socket != null) {
                            try {
                                var3_4 = this._socket.accept();
                                break block39;
                            }
                            catch (IOException v2) {
                                // MONITOREXIT : var4_8
                                continue;
                            }
                        }
                        try {
                            this.SOCKET_LOCK.wait();
                        }
                        catch (InterruptedException v3) {}
                        continue;
                    }
                    // MONITOREXIT : var4_8
                    var4_8 = var3_4.getInetAddress();
                    if (this.isBannedIP(var4_8.getHostAddress())) {
                        if (Acceptor.RECORD_STATS) {
                            HTTPStat.BANNED_REQUESTS.incrementStat();
                        }
                        var3_4.close();
                        continue;
                    }
                    var5_9 /* !! */  = var3_4.getLocalAddress();
                    this.setAddress((InetAddress)var5_9 /* !! */ );
                    if (this.isOutsideConnection((InetAddress)var4_8)) {
                        v5 = Acceptor.class$0;
                        if (v5 == null) {
                            try {
                                v5 = Class.forName("com.limegroup.gnutella.Acceptor");
                            }
                            catch (ClassNotFoundException v6) {
                                throw new NoClassDefFoundError(v6.getMessage());
                            }
                        }
                        var6_11 = v5;
                        // MONITORENTER : v5
                        this._acceptedIncoming = true;
                        ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(this._acceptedIncoming);
                        this._lastIncomingTime = System.currentTimeMillis();
                        // MONITOREXIT : var6_11
                    }
                    var6_12 = new ConnectionDispatchRunner(var3_4);
                    var7_14 = new ManagedThread(var6_12, "ConnectionDispatchRunner");
                    var7_14.setDaemon(true);
                    var7_14.start();
                }
            }
            catch (SecurityException var3_5) {
                ErrorService.error(var3_5);
                continue;
            }
            catch (Throwable var3_6) {
                ErrorService.error(var3_6);
                continue;
            }
            break;
        }
    }

    private boolean isOutsideConnection(InetAddress inetAddress) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        String string = inetAddress.getHostAddress();
        byte[] byArray = inetAddress.getAddress();
        return !RouterService.getConnectionManager().isConnectedTo(string) && !NetworkUtils.isCloseIP(byArray, this.getAddress(false)) && !NetworkUtils.isLocalAddress(inetAddress);
    }

    public boolean isBannedIP(String string) {
        return !IPFilter.instance().allow(string);
    }

    public boolean isBannedIP(byte[] byArray) {
        return !IPFilter.instance().allow(byArray);
    }

    static /* synthetic */ void access$5(Acceptor acceptor, boolean bl) {
        acceptor._acceptedIncoming = bl;
    }

    private static class ConnectionDispatchRunner
    implements Runnable {
        private final Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            this._socket = socket;
        }

        public void run() {
            block22: {
                ConnectionManager connectionManager = RouterService.getConnectionManager();
                UploadManager uploadManager = RouterService.getUploadManager();
                DownloadManager downloadManager = RouterService.getDownloadManager();
                try {
                    InputStream inputStream = null;
                    try {
                        inputStream = this._socket.getInputStream();
                    }
                    catch (IOException iOException) {
                        if (RECORD_STATS) {
                            HTTPStat.CLOSED_REQUESTS.incrementStat();
                        }
                        throw new IOException(iOException.getMessage());
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new IOException(((Throwable)nullPointerException).getMessage());
                    }
                    this._socket.setSoTimeout(8000);
                    String string = IOUtils.readWord(inputStream, 8);
                    this._socket.setSoTimeout(0);
                    if (!string.equals("MAGNET")) {
                        InetAddress inetAddress = this._socket.getInetAddress();
                        byte[] byArray = inetAddress.getAddress();
                        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && byArray[0] == 127) {
                            this._socket.close();
                            return;
                        }
                    }
                    boolean bl = ConnectionSettings.CONNECT_STRING.isDefault();
                    if (string.equals("GNUTELLA")) {
                        if (RECORD_STATS) {
                            HTTPStat.GNUTELLA_REQUESTS.incrementStat();
                        }
                        connectionManager.acceptConnection(this._socket);
                        break block22;
                    }
                    if (bl && string.equals("LIMEWIRE")) {
                        if (RECORD_STATS) {
                            HTTPStat.GNUTELLA_LIMEWIRE_REQUESTS.incrementStat();
                        }
                        connectionManager.acceptConnection(this._socket);
                        break block22;
                    }
                    if (string.equals("GET")) {
                        if (RECORD_STATS) {
                            HTTPStat.GET_REQUESTS.incrementStat();
                        }
                        uploadManager.acceptUpload(HTTPRequestMethod.GET, this._socket, false);
                        break block22;
                    }
                    if (string.equals("HEAD")) {
                        if (RECORD_STATS) {
                            HTTPStat.HEAD_REQUESTS.incrementStat();
                        }
                        uploadManager.acceptUpload(HTTPRequestMethod.HEAD, this._socket, false);
                        break block22;
                    }
                    if (string.equals("GIV")) {
                        if (RECORD_STATS) {
                            HTTPStat.GIV_REQUESTS.incrementStat();
                        }
                        downloadManager.acceptDownload(this._socket);
                        break block22;
                    }
                    if (RECORD_STATS) {
                        HTTPStat.UNKNOWN_REQUESTS.incrementStat();
                    }
                    throw new IOException("UNKOWN PROTOCOL: " + string);
                }
                catch (IOException iOException) {
                    try {
                        this._socket.close();
                    }
                    catch (IOException iOException2) {}
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        }
    }

    private class IncomingValidator
    implements Runnable {
        static /* synthetic */ Class class$0;

        public void run() {
            long l = System.currentTimeMillis();
            ConnectionManager connectionManager = RouterService.getConnectionManager();
            if ((Acceptor.this._acceptedIncoming && l - Acceptor.this._lastIncomingTime > INCOMING_EXPIRE_TIME || !Acceptor.this._acceptedIncoming && l - Acceptor.this._lastConnectBackTime > INCOMING_EXPIRE_TIME) && connectionManager.sendTCPConnectBackRequests()) {
                Acceptor.this._lastConnectBackTime = System.currentTimeMillis();
                Runnable runnable = new Runnable(this, l){
                    final /* synthetic */ IncomingValidator this$1;
                    private final /* synthetic */ long val$currTime;
                    {
                        this.this$1 = incomingValidator;
                        this.val$currTime = l;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Class<?> clazz = IncomingValidator.class$0;
                        if (clazz == null) {
                            try {
                                clazz = IncomingValidator.class$0 = Class.forName("com.limegroup.gnutella.Acceptor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Class<?> clazz2 = clazz;
                        synchronized (clazz) {
                            if (Acceptor.access$2(IncomingValidator.access$0(this.this$1)) < this.val$currTime) {
                                Acceptor.access$5(IncomingValidator.access$0(this.this$1), false);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                RouterService.schedule(runnable, WAIT_TIME_AFTER_REQUESTS, 0L);
            }
        }

        static /* synthetic */ Acceptor access$0(IncomingValidator incomingValidator) {
            return incomingValidator.Acceptor.this;
        }
    }
}

