/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.BinaryFrame;
import de.vdheide.mp3.ByteBuilder;
import de.vdheide.mp3.Frame;
import de.vdheide.mp3.FrameDamagedException;
import de.vdheide.mp3.ID3;
import de.vdheide.mp3.ID3Exception;
import de.vdheide.mp3.ID3IllegalFormatException;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2BadHeaderException;
import de.vdheide.mp3.ID3v2BadParsingException;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.ID3v2IllegalVersionException;
import de.vdheide.mp3.ID3v2WrongCRCException;
import de.vdheide.mp3.MP3Properties;
import de.vdheide.mp3.NoID3TagException;
import de.vdheide.mp3.NoMP3FrameException;
import de.vdheide.mp3.ParseException;
import de.vdheide.mp3.Parser;
import de.vdheide.mp3.TagContent;
import de.vdheide.mp3.TagFormatException;
import de.vdheide.mp3.TextFrameEncoding;
import de.vdheide.mp3.TextFrameNoEncoding;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MP3File
extends File {
    protected boolean write_id3 = true;
    protected boolean write_id3v2 = true;
    protected boolean use_compression = true;
    protected boolean use_crc = true;
    protected boolean use_padding = true;
    protected boolean use_unsynchronization = true;
    protected ID3 id3 = null;
    protected ID3v2 id3v2 = null;
    protected MP3Properties prop = new MP3Properties(this);

    public MP3File(String filename) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2BadHeaderException, ID3v2IllegalVersionException, ID3v2BadParsingException {
        super(filename);
        this.id3 = new ID3(this);
        this.id3v2 = new ID3v2(this);
    }

    public MP3File(File dir, String filename) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2IllegalVersionException, ID3v2BadHeaderException, ID3v2BadParsingException {
        super(dir, filename);
        this.id3 = new ID3(this);
        this.id3v2 = new ID3v2(this);
    }

    public MP3File(String dir, String filename) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2BadHeaderException, ID3v2DecompressionException, ID3v2IllegalVersionException, ID3v2BadParsingException {
        super(dir, filename);
        this.id3 = new ID3(this);
        this.id3v2 = new ID3v2(this);
    }

    public void update() throws ID3Exception, ID3v2Exception {
        if (this.write_id3) {
            try {
                this.id3.writeTag();
            }
            catch (IOException e) {
                throw new ID3Exception();
            }
        }
        if (this.write_id3v2) {
            try {
                this.id3v2.update();
            }
            catch (IOException e) {
                throw new ID3v2Exception();
            }
        }
    }

    public void setWriteID3(boolean write_id3) {
        this.write_id3 = write_id3;
    }

    public boolean getWriteID3() {
        return this.write_id3;
    }

    public void setWriteID3v2(boolean write_id3v2) {
        this.write_id3v2 = write_id3v2;
    }

    public boolean getWriteID3v2() {
        return this.write_id3v2;
    }

    public void setUseCompression(boolean use_compression) {
        this.use_compression = use_compression;
    }

    public boolean getUseCompression() {
        return this.use_compression;
    }

    public void setUseCRC(boolean use_crc) {
        this.use_crc = use_crc;
        if (this.id3v2 != null) {
            this.id3v2.setUseCRC(use_crc);
        }
    }

    public boolean getUseCRC() {
        return this.use_crc;
    }

    public void setUsePadding(boolean use_padding) {
        this.use_padding = use_padding;
        if (this.id3v2 != null) {
            this.id3v2.setUsePadding(use_padding);
        }
    }

    public boolean getUsePadding() {
        return this.use_padding;
    }

    public void setUseUnsynchronization(boolean use_unsynch) {
        this.use_unsynchronization = use_unsynch;
        if (this.id3v2 != null) {
            this.id3v2.setUseUnsynchronization(use_unsynch);
        }
    }

    public boolean getUseUnsynchronization() {
        return this.use_unsynchronization;
    }

    public int getMPEGLevel() {
        return this.prop.getMPEGLevel();
    }

    public int getLayer() {
        return this.prop.getLayer();
    }

    public int getBitrate() {
        return this.prop.getBitrate();
    }

    public int getSamplerate() {
        return this.prop.getSamplerate();
    }

    public int getMode() {
        return this.prop.getMode();
    }

    public int getEmphasis() {
        return this.prop.getEmphasis();
    }

    public boolean getProtection() {
        return this.prop.getProtection();
    }

    public boolean getPrivate() {
        return this.prop.getPrivate();
    }

    public boolean getPadding() {
        return this.prop.getPadding();
    }

    public boolean getCopyright() {
        return this.prop.getCopyright();
    }

    public boolean getOriginal() {
        return this.prop.getOriginal();
    }

    public long getLength() {
        return this.prop.getLength();
    }

    public TagContent getAlbum() throws FrameDamagedException {
        TagContent ret = TextFrameEncoding.read(this.id3v2, "TALB");
        if (ret.getTextContent() == null) {
            try {
                ret.setContent(this.id3.getAlbum());
            }
            catch (NoID3TagException noID3TagException) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setAlbum(TagContent album) throws TagFormatException {
        if (album.getTextContent() == null) {
            throw new TagFormatException();
        }
        this.id3.setAlbum(album.getTextContent());
        new TextFrameEncoding(this.id3v2, "TALB", album, this.use_compression).write();
    }

    public TagContent getBPM() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TBPM");
    }

    public void setBPM(TagContent bpm) throws TagFormatException {
        if (bpm.getTextContent() == null || !this.checkNumeric(bpm.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TBPM", bpm, this.use_compression).write();
    }

    public TagContent getComposer() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TCOM");
    }

    public void setComposer(TagContent composer) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TCOM", composer, this.use_compression).write();
    }

    public TagContent getGenre() throws FrameDamagedException {
        TagContent ret = new TagContent();
        byte[] v2cont = null;
        try {
            v2cont = ((ID3v2Frame)this.id3v2.getFrame("TCON").elementAt(0)).getContent();
        }
        catch (ID3v2Exception e) {
            // empty catch block
        }
        if (v2cont == null) {
            try {
                int v1cont = this.id3.getGenre();
                ret.setContent("(" + v1cont + ")");
            }
            catch (ID3Exception e) {}
        } else {
            Parser parse = new Parser(v2cont, true);
            try {
                ret.setContent(parse.parseText());
            }
            catch (ParseException e) {
                throw new FrameDamagedException();
            }
        }
        return ret;
    }

    public void setGenre(TagContent genre) throws TagFormatException {
        if (genre.getTextContent() == null) {
            throw new TagFormatException();
        }
        boolean found = false;
        int brackpos = 0;
        while (brackpos != -1 && !found) {
            int brackclose;
            brackpos = genre.getTextContent().indexOf(40, brackpos);
            if (brackpos == -1 || !Character.isDigit(genre.getTextContent().charAt(brackpos + 1)) || (brackclose = genre.getTextContent().indexOf(41, brackpos)) == -1) continue;
            try {
                Integer par = new Integer(genre.getTextContent().substring(brackpos + 1, brackclose));
                try {
                    this.id3.setGenre(par);
                }
                catch (ID3IllegalFormatException e2) {
                    // empty catch block
                }
                found = true;
            }
            catch (NumberFormatException e) {}
        }
        if (!found) {
            try {
                this.id3.setGenre(12);
            }
            catch (ID3IllegalFormatException e2) {
                // empty catch block
            }
        }
        ByteBuilder build = new ByteBuilder(1);
        build.put(genre.getTextContent());
        byte[] v2cont = build.getBytes();
        try {
            this.id3v2.removeFrame("TCON");
        }
        catch (ID3v2Exception e) {
            // empty catch block
        }
        try {
            ID3v2Frame add = new ID3v2Frame("TCON", v2cont, false, false, false, this.use_compression ? (byte)2 : 0, 0, 0, true);
            this.id3v2.addFrame(add);
        }
        catch (ID3v2DecompressionException e) {
            // empty catch block
        }
    }

    public TagContent getCopyrightText() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TCOP");
    }

    public void setCopyrightText(TagContent copyright) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TCOP", copyright, this.use_compression).write();
    }

    public TagContent getDate() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TDAT");
    }

    public void setDate(TagContent date) throws TagFormatException {
        if (date.getTextContent() == null || !this.checkExactLength(date.getTextContent(), 4) || !this.checkNumeric(date.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TDAT", date, this.use_compression).write();
    }

    public TagContent getPlaylistDelay() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TDLY");
    }

    public void setPlaylistDelay(TagContent delay) throws TagFormatException {
        if (delay.getTextContent() == null || !this.checkNumeric(delay.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TDLY", delay, this.use_compression).write();
    }

    public TagContent getEncodedBy() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TENC");
    }

    public void setEncodedBy(TagContent encoder) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TENC", encoder, this.use_compression).write();
    }

    public TagContent getLyricist() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TEXT");
    }

    public void setLyricist(TagContent lyricist) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TEXT", lyricist, this.use_compression).write();
    }

    public TagContent getFileType() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TFLT");
    }

    public void setFileType(TagContent type) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TFLT", type, this.use_compression).write();
    }

    public TagContent getTime() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TIME");
    }

    public void setTime(TagContent time) throws TagFormatException {
        if (time.getTextContent() == null || !this.checkExactLength(time.getTextContent(), 4) || !this.checkNumeric(time.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TIME", time, this.use_compression).write();
    }

    public TagContent getContentGroup() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TIT1");
    }

    public void setContentGroup(TagContent content) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TIT1", content, this.use_compression).write();
    }

    public TagContent getTitle() throws FrameDamagedException {
        TagContent ret = TextFrameEncoding.read(this.id3v2, "TIT2");
        if (ret.getTextContent() == null) {
            try {
                ret.setContent(this.id3.getTitle());
            }
            catch (NoID3TagException noID3TagException) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setTitle(TagContent title) throws TagFormatException {
        if (title.getTextContent() == null) {
            throw new TagFormatException();
        }
        this.id3.setTitle(title.getTextContent());
        new TextFrameEncoding(this.id3v2, "TIT2", title, this.use_compression).write();
    }

    public TagContent getSubtitle() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TIT3");
    }

    public void setSubtitle(TagContent subtitle) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TIT3", subtitle, this.use_compression).write();
    }

    public TagContent getInitialKey() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TKEY");
    }

    public void setInitialKey(TagContent key) throws TagFormatException {
        if (key.getTextContent() == null || !this.checkMaxLength(key.getTextContent(), 3)) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TKEY", key, this.use_compression).write();
    }

    public TagContent getLanguage() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TLAN");
    }

    public void setLanguage(TagContent lang) throws TagFormatException {
        if (lang.getTextContent() == null || !this.checkExactLength(lang.getTextContent(), 3)) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TLAN", lang, this.use_compression).write();
    }

    public TagContent getLengthInTag() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TLEN");
    }

    public void setLengthInTag(TagContent length) throws TagFormatException {
        if (length.getTextContent() == null || !this.checkNumeric(length.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TLEN", length, this.use_compression).write();
    }

    public TagContent getMediaType() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TMED");
    }

    public void setMediaType(TagContent type) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TMED", type, this.use_compression).write();
    }

    public TagContent getOriginalTitle() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOAL");
    }

    public void setOriginalTitle(TagContent title) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOAL", title, this.use_compression).write();
    }

    public TagContent getOriginalFilename() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOFN");
    }

    public void setOriginalFilename(TagContent filename) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOFN", filename, this.use_compression).write();
    }

    public TagContent getOriginalLyricist() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOLY");
    }

    public void setOriginalLyricist(TagContent lyricist) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOLY", lyricist, this.use_compression).write();
    }

    public TagContent getOriginalArtist() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOPE");
    }

    public void setOriginalArtist(TagContent artist) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOPE", artist, this.use_compression).write();
    }

    public TagContent getOriginalYear() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TORY");
    }

    public void setOriginalYear(TagContent year) throws TagFormatException {
        if (year.getTextContent() == null || !this.checkExactLength(year.getTextContent(), 4) || !this.checkNumeric(year.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TORY", year, this.use_compression).write();
    }

    public TagContent getFileOwner() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TOWN");
    }

    public void setFileOwner(TagContent owner) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TOWN", owner, this.use_compression).write();
    }

    public TagContent getArtist() throws FrameDamagedException {
        TagContent ret = TextFrameEncoding.read(this.id3v2, "TPE1");
        if (ret.getTextContent() == null) {
            try {
                ret.setContent(this.id3.getArtist());
            }
            catch (NoID3TagException noID3TagException) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setArtist(TagContent artist) throws TagFormatException {
        this.id3.setArtist(artist.getTextContent());
        new TextFrameEncoding(this.id3v2, "TPE1", artist, this.use_compression).write();
    }

    public TagContent getBand() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPE2");
    }

    public void setBand(TagContent band) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPE2", band, this.use_compression).write();
    }

    public TagContent getConductor() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPE3");
    }

    public void setConductor(TagContent conductor) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPE3", conductor, this.use_compression).write();
    }

    public TagContent getRemixer() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPE4");
    }

    public void setRemixer(TagContent remixer) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPE4", remixer, this.use_compression).write();
    }

    public TagContent getPartOfSet() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPOS");
    }

    public void setPartOfSet(TagContent part) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPOS", part, this.use_compression).write();
    }

    public TagContent getPublisher() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TPUB");
    }

    public void setPublisher(TagContent publisher) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TPUB", publisher, this.use_compression).write();
    }

    public TagContent getTrack() throws FrameDamagedException {
        TagContent ret = new TagContent();
        byte[] v2cont = null;
        try {
            v2cont = ((ID3v2Frame)this.id3v2.getFrame("TRCK").elementAt(0)).getContent();
        }
        catch (ID3v2Exception e) {
            // empty catch block
        }
        if (v2cont == null) {
            try {
                String v1cont = String.valueOf(this.id3.getTrack());
                ret.setContent(v1cont);
            }
            catch (ID3Exception e) {}
        } else {
            Parser parse = new Parser(v2cont, true);
            try {
                ret.setContent(parse.parseText());
            }
            catch (ParseException e) {
                throw new FrameDamagedException();
            }
        }
        return ret;
    }

    public void setTrack(TagContent track) throws TagFormatException {
        if (track.getTextContent() == null) {
            throw new TagFormatException();
        }
        boolean found = false;
        int slashpos = track.getTextContent().indexOf(47);
        String trackstring = slashpos != -1 ? track.getTextContent().substring(0, slashpos) : track.getTextContent();
        try {
            Integer test = new Integer(trackstring);
            try {
                this.id3.setGenre(test);
            }
            catch (Exception e) {}
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        ByteBuilder build = new ByteBuilder(1);
        build.put(track.getTextContent());
        byte[] v2cont = build.getBytes();
        try {
            this.id3v2.removeFrame("TRCK");
        }
        catch (ID3v2Exception e) {
            // empty catch block
        }
        try {
            ID3v2Frame add = new ID3v2Frame("TRCK", v2cont, false, false, false, this.use_compression ? (byte)2 : 0, 0, 0, true);
            this.id3v2.addFrame(add);
        }
        catch (ID3v2DecompressionException e) {
            // empty catch block
        }
    }

    public TagContent getRecordingDates() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TRDA");
    }

    public void setRecordingDate(TagContent date) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TRDA", date, this.use_compression).write();
    }

    public TagContent getInternetRadioStationName() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TRSN");
    }

    public void setInternetRadioStationName(TagContent name) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TRSO", name, this.use_compression).write();
    }

    public TagContent getInternetRadioStationOwner() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TRSO");
    }

    public void setInternetRadioStationOwner(TagContent owner) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TRSO", owner, this.use_compression).write();
    }

    public TagContent getFilesize() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TSIZ");
    }

    public void setFilesize(TagContent size) throws TagFormatException {
        if (size.getTextContent() == null || !this.checkNumeric(size.getTextContent())) {
            throw new TagFormatException();
        }
        new TextFrameEncoding(this.id3v2, "TSIZ", size, this.use_compression).write();
    }

    public TagContent getISRC() throws FrameDamagedException {
        return TextFrameEncoding.read(this.id3v2, "TSRC");
    }

    public void setISRC(TagContent isrc) throws TagFormatException {
        new TextFrameEncoding(this.id3v2, "TSRC", isrc, this.use_compression).write();
    }

    public TagContent getYear() throws FrameDamagedException {
        TagContent ret = TextFrameEncoding.read(this.id3v2, "TYER");
        if (ret.getTextContent() == null) {
            try {
                ret.setContent(this.id3.getYear());
            }
            catch (NoID3TagException noID3TagException) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setYear(TagContent year) throws TagFormatException {
        if (year.getTextContent() == null || !this.checkNumeric(year.getTextContent()) || !this.checkMaxLength(year.getTextContent(), 4) && !this.checkMaxLength(year.getTextContent(), 5)) {
            throw new TagFormatException();
        }
        this.id3.setYear(year.getTextContent());
        new TextFrameEncoding(this.id3v2, "TYER", year, this.use_compression).write();
    }

    public TagContent getCommercialInformation() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WCOM");
    }

    public void setCommercialInformation(TagContent info) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WCOM", info, this.use_compression).write();
    }

    public TagContent getCopyrightWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WCOP");
    }

    public void setCopyrightWebpage(TagContent copy) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WCOP", copy, this.use_compression).write();
    }

    public TagContent getAudioFileWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WOAF");
    }

    public void setAudioFileWebpage(TagContent page) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WOAF", page, this.use_compression).write();
    }

    public TagContent getArtistWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WOAR");
    }

    public void setArtistWebpage(TagContent page) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WOAR", page, this.use_compression).write();
    }

    public TagContent getAudioSourceWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WOAS");
    }

    public void setAudioSourceWebpage(TagContent page) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WOAS", page, this.use_compression).write();
    }

    public TagContent getInternetRadioStationWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WORS");
    }

    public void setInternetRadioStationWebpage(TagContent page) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WORS", page, this.use_compression).write();
    }

    public TagContent getPaymentWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WPAY");
    }

    public void setPaymentWebpage(TagContent page) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WPAY", page, this.use_compression).write();
    }

    public TagContent getPublishersWebpage() throws FrameDamagedException {
        return TextFrameNoEncoding.read(this.id3v2, "WPUB");
    }

    public void setPublishersWebpage(TagContent page) throws TagFormatException {
        new TextFrameNoEncoding(this.id3v2, "WPUB", page, this.use_compression).write();
    }

    public TagContent getEventTimingCodes() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "ETCO");
    }

    public void setEventTimingCodes(TagContent codes) throws TagFormatException {
        new BinaryFrame(this.id3v2, "ETCO", codes, this.use_compression).write();
    }

    public TagContent getLookupTable() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "MLLT");
    }

    public void setLookupTable(TagContent table) throws TagFormatException {
        new BinaryFrame(this.id3v2, "MLLT", table, this.use_compression).write();
    }

    public TagContent getSynchronizedTempoCodes() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "SYTC");
    }

    public void setSynchronizedTempoCodes(TagContent codes) throws TagFormatException {
        new BinaryFrame(this.id3v2, "SYTC", codes, this.use_compression).write();
    }

    public TagContent getSynchronizedLyrics() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "SYLT");
    }

    public void setSynchronizedLyrics(TagContent lyrics) throws TagFormatException {
        new BinaryFrame(this.id3v2, "SYLT", lyrics, this.use_compression).write();
    }

    public TagContent getRelativeVolumenAdjustment() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "RVAD");
    }

    public void setRelativeVolumeAdjustment(TagContent adjust) throws TagFormatException {
        new BinaryFrame(this.id3v2, "RVAD", adjust, this.use_compression).write();
    }

    public TagContent getEqualisation() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "EQUA");
    }

    public void setEqualisation(TagContent equal) throws TagFormatException {
        new BinaryFrame(this.id3v2, "EQUA", equal, this.use_compression).write();
    }

    public TagContent getReverb() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "RVRB");
    }

    public void setReverb(TagContent reverb) throws TagFormatException {
        new BinaryFrame(this.id3v2, "RVRB", reverb, this.use_compression).write();
    }

    public TagContent getPlayCounter() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "PCNT");
    }

    public void setPlayCounter(TagContent count) throws TagFormatException {
        new BinaryFrame(this.id3v2, "PCNT", count, this.use_compression).write();
    }

    public TagContent getPopularimeter() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "POPM");
    }

    public void setPopularimeter(TagContent pop) throws TagFormatException {
        new BinaryFrame(this.id3v2, "POPM", pop, this.use_compression).write();
    }

    public TagContent getRecommendedBufferSize() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "RBUF");
    }

    public void setRecommendedBufferSize(TagContent size) throws TagFormatException {
        new BinaryFrame(this.id3v2, "RBUF", size, this.use_compression).write();
    }

    public TagContent getPositionSynchronization() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "POSS");
    }

    public void setPositionSynchronization(TagContent synch) throws TagFormatException {
        new BinaryFrame(this.id3v2, "POSS", synch, this.use_compression).write();
    }

    public TagContent getOwnership() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "OWNE");
    }

    public void setOwnership(TagContent owner) throws TagFormatException {
        new BinaryFrame(this.id3v2, "OWNE", owner, this.use_compression).write();
    }

    public TagContent getCommercial() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "COMR");
    }

    public void setCommercial(TagContent commercial) throws TagFormatException {
        new BinaryFrame(this.id3v2, "COMR", commercial, this.use_compression).write();
    }

    public TagContent getCDIdentifier() throws FrameDamagedException {
        return BinaryFrame.read(this.id3v2, "MCDI");
    }

    public void setCDIdentifier(TagContent ident) throws TagFormatException {
        new BinaryFrame(this.id3v2, "MCDI", ident, this.use_compression).write();
    }

    public TagContent getUniqueFileIdentifier() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "UFID");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, false);
        try {
            ret.setDescription(parse.parseText());
            ret.setContent(parse.parseBinary());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setUniqueFileIdentifier(TagContent ufi) throws TagFormatException {
        if (ufi.getDescription() == null || ufi.getBinaryContent() == null || !this.checkMaxLength(ufi.getBinaryContent(), 64)) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(-1, ufi.getDescription().length() + 2 + ufi.getBinaryContent().length);
        build.put(ufi.getDescription());
        build.put((byte)0);
        build.put(ufi.getBinaryContent());
        new Frame(this.id3v2, "UFID", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getUserDefinedText() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "TXXX");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, true);
        try {
            ret.setDescription(parse.parseText());
            ret.setContent(parse.parseText());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setUserDefinedText(TagContent info) throws TagFormatException {
        if (info.getDescription() == null || info.getTextContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(1, info.getDescription().length() * 2 + 3 + info.getTextContent().length() * 2);
        build.put(info.getDescription());
        build.put((byte)0);
        build.put((byte)0);
        build.put(info.getTextContent());
        new Frame(this.id3v2, "TXXX", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getUserDefinedURL() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "WXXX");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, true);
        try {
            ret.setDescription(parse.parseText());
            ret.setContent(parse.parseText((byte)0));
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setUserDefinedURL(TagContent link) throws TagFormatException {
        if (link.getDescription() == null || link.getTextContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(1, link.getDescription().length() * 2 + 3 + link.getTextContent().length());
        build.put(link.getDescription());
        build.put((byte)0);
        build.put((byte)0);
        try {
            build.put(link.getTextContent().getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        new Frame(this.id3v2, "WXXX", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getUnsynchronizedLyrics() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "USLT");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, true);
        try {
            byte[] tmp = parse.parseBinary(3);
            try {
                ret.setType(new String(tmp, "ISO8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            ret.setDescription(parse.parseText());
            ret.setContent(parse.parseText());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setUnsynchronizedLyrics(TagContent lyric) throws TagFormatException {
        if (lyric.getType() == null || lyric.getDescription() == null || lyric.getTextContent() == null || !this.checkExactLength(lyric.getType(), 3)) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(1, 6 + lyric.getDescription().length() * 2 + lyric.getTextContent().length() * 2);
        try {
            build.put(lyric.getType().getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        build.put(lyric.getDescription());
        build.put((byte)0);
        build.put((byte)0);
        build.put(lyric.getTextContent());
        new Frame(this.id3v2, "USLT", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getComments() throws FrameDamagedException {
        TagContent ret = new TagContent();
        byte[] v2cont = Frame.read(this.id3v2, "COMM");
        if (v2cont == null) {
            try {
                ret.setContent(this.id3.getComment());
            }
            catch (Exception e) {}
        } else {
            Parser parse = new Parser(v2cont, true);
            try {
                byte[] tmp = parse.parseBinary(3);
                try {
                    ret.setType(new String(tmp, "ISO8859_1"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                ret.setDescription(parse.parseText());
                ret.setContent(parse.parseText());
                return ret;
            }
            catch (ParseException e) {
                throw new FrameDamagedException();
            }
        }
        return ret;
    }

    public void setComments(TagContent comm) throws TagFormatException {
        if (comm.getType() == null || comm.getDescription() == null || comm.getTextContent() == null || !this.checkExactLength(comm.getType(), 3)) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(1, 4 + comm.getDescription().length() * 2 + comm.getTextContent().length() * 2);
        try {
            build.put(comm.getType().getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        build.put(comm.getDescription());
        build.put((byte)0);
        build.put((byte)0);
        build.put(comm.getTextContent());
        new Frame(this.id3v2, "COMM", build.getBytes(), true, true, this.use_compression).write();
        this.id3.setComment(comm.getTextContent());
    }

    public TagContent getPicture() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "APIC");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, true);
        try {
            ret.setType(parse.parseText((byte)0));
            ret.setSubtype(parse.parseBinary(1));
            ret.setDescription(parse.parseText());
            ret.setContent(parse.parseBinary());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setPicture(TagContent pic) throws TagFormatException {
        if (pic.getType() == null || pic.getBinarySubtype() == null || pic.getDescription() == null || pic.getBinaryContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(1, 6 + pic.getType().length() + 1 + pic.getDescription().length() * 2 + pic.getBinaryContent().length);
        try {
            build.put(pic.getType().getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        build.put((byte)0);
        build.put(pic.getBinarySubtype()[0]);
        build.put(pic.getDescription());
        build.put((byte)0);
        build.put((byte)0);
        build.put(pic.getBinaryContent());
        new Frame(this.id3v2, "APIC", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getEncapsulatedObject() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "GEOB");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, true);
        try {
            ret.setType(parse.parseText((byte)0));
            ret.setSubtype(parse.parseText());
            ret.setDescription(parse.parseText());
            ret.setContent(parse.parseBinary());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setEncapsulatedObject(TagContent obj) throws TagFormatException {
        if (obj.getType() == null || obj.getTextSubtype() == null || obj.getDescription() == null || obj.getBinaryContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(1, 6 + obj.getType().length() + obj.getTextSubtype().length() * 2 + obj.getDescription().length() * 2 + obj.getBinaryContent().length);
        try {
            build.put(obj.getType().getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        build.put((byte)0);
        build.put(obj.getTextSubtype());
        build.put((byte)0);
        build.put((byte)0);
        build.put(obj.getDescription());
        build.put((byte)0);
        build.put((byte)0);
        build.put(obj.getBinaryContent());
        new Frame(this.id3v2, "GEOB", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getTermsOfUse() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "USER");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, true);
        try {
            byte[] tmp = parse.parseBinary(3);
            try {
                ret.setType(new String(tmp, "ISO8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            ret.setContent(parse.parseText());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setTermsOfUse(TagContent use) throws TagFormatException {
        if (use.getType() == null || use.getTextContent() == null || !this.checkExactLength(use.getType(), 3)) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(1, 3 + use.getTextContent().length() * 2);
        try {
            build.put(use.getType().getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        build.put(use.getTextContent());
        new Frame(this.id3v2, "USER", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getEncryptionMethodRegistration() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "ENCR");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, false);
        try {
            ret.setType(parse.parseText());
            ret.setSubtype(parse.parseBinary(1));
            ret.setContent(parse.parseBinary());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setEncryptionMethodRegistration(TagContent encr) throws TagFormatException {
        if (encr.getType() == null || encr.getBinarySubtype() == null || encr.getBinaryContent() == null || !this.checkExactLength(encr.getBinarySubtype(), 1)) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(-1, 2 + encr.getType().length() + encr.getBinaryContent().length);
        build.put(encr.getType());
        build.put((byte)0);
        build.put(encr.getBinarySubtype()[0]);
        build.put(encr.getBinaryContent());
        new Frame(this.id3v2, "ENCR", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getGroupIdentificationRegistration() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "GRID");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, false);
        try {
            ret.setType(parse.parseText());
            ret.setSubtype(parse.parseBinary(1));
            ret.setContent(parse.parseBinary());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setGroupIdentificationRegistration(TagContent grp) throws TagFormatException {
        if (grp.getType() == null || grp.getBinarySubtype() == null || grp.getBinaryContent() == null || !this.checkExactLength(grp.getBinarySubtype(), 1)) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(-1, 2 + grp.getType().length() + grp.getBinaryContent().length);
        build.put(grp.getType());
        build.put((byte)0);
        build.put(grp.getBinarySubtype()[0]);
        build.put(grp.getBinaryContent());
        new Frame(this.id3v2, "GRID", build.getBytes(), true, true, this.use_compression).write();
    }

    public TagContent getPrivateData() throws FrameDamagedException {
        byte[] v2cont = Frame.read(this.id3v2, "PRIV");
        if (v2cont == null) {
            return new TagContent();
        }
        TagContent ret = new TagContent();
        Parser parse = new Parser(v2cont, false);
        try {
            ret.setType(parse.parseText());
            ret.setContent(parse.parseBinary());
            return ret;
        }
        catch (ParseException e) {
            throw new FrameDamagedException();
        }
    }

    public void setPrivateData(TagContent data) throws TagFormatException {
        if (data.getType() == null || data.getBinaryContent() == null) {
            throw new TagFormatException();
        }
        ByteBuilder build = new ByteBuilder(-1, 1 + data.getType().length() + data.getBinaryContent().length);
        build.put(data.getType());
        build.put((byte)0);
        build.put(data.getBinaryContent());
        new Frame(this.id3v2, "PRIV", build.getBytes(), true, true, this.use_compression).write();
    }

    protected boolean checkExactLength(String in, int length) {
        return in.length() == length;
    }

    protected boolean checkMaxLength(String in, int length) {
        return in.length() <= length;
    }

    protected boolean checkExactLength(byte[] in, int length) {
        return in.length == length;
    }

    protected boolean checkMaxLength(byte[] in, int length) {
        return in.length <= length;
    }

    protected boolean checkNumeric(String in) {
        try {
            Integer test = new Integer(in);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

