/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.AqMain;

public class AqEvent {
    private static Map stateCache = Collections.synchronizedMap(new HashMap());
    private static int currentLocalIndex = -1;
    private static final String kSep = "<aq/>";
    protected static final int kLWEventQueryResult = 1;
    protected static final int kLWEventConnectionInitialized = 2;
    protected static final int kLWEventConnectionClosed = 3;
    protected static final int kLWEventConnectionsUpdated = 4;
    protected static final int kLWEventAddDownload = 5;
    protected static final int kLWEventRemoveDownload = 6;
    protected static final int kLWEventUpdateDownloadStats = 7;
    protected static final int kLWEventDownloadsUpdated = 8;
    protected static final int kLWEventAddUpload = 9;
    protected static final int kLWEventRemoveUpload = 10;
    protected static final int kLWEventUpdateUploadStats = 11;
    protected static final int kLWEventUploadsUpdated = 12;
    protected static final int kLWEventAddSharedFile = 13;
    protected static final int kLWEventCoreConnected = 97;
    protected static final int kLWEventCoreSettingRequest = 98;
    protected static final int kLWEventCoreInitialized = 99;

    private static String decodeXMLString(String string) {
        if (string == null) {
            return "";
        }
        string = StringUtils.replace(string, "&amp;", "&");
        string = StringUtils.replace(string, "&lt;", "<");
        string = StringUtils.replace(string, "&gt;", ">");
        string = StringUtils.replace(string, "&apos;", "'");
        string = StringUtils.replace(string, "&quot;", "\"");
        return string;
    }

    protected static void signalEvent(int n) {
        AqEvent.signalEvent(n, null, null, null);
    }

    protected static void signalEvent(int n, Object object) {
        AqEvent.signalEvent(n, object, null, null);
    }

    protected static void signalEvent(int n, Object object, Object object2) {
        AqEvent.signalEvent(n, object, object2, null);
    }

    protected static void signalEvent(int n, Object object, Object object2, Object object3) {
        String string = null;
        try {
            switch (n) {
                case 1: {
                    int n2;
                    Object object4;
                    RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
                    HostData hostData = (HostData)object2;
                    Set set = (Set)object3;
                    GUID gUID = new GUID(hostData.getMessageGUID());
                    String string2 = (String)AqEventHandler.queriesToIndices.get(gUID);
                    String string3 = String.valueOf(++currentLocalIndex);
                    String string4 = String.valueOf(string2) + ":" + string3;
                    AqEventHandler.queryGUIDs.put(string4, gUID);
                    AqEventHandler.responses.put(string4, remoteFileDesc);
                    AqEventHandler.alts.put(string4, set);
                    int n3 = 0;
                    int n4 = 0;
                    String string5 = I18NConvert.instance().compose(remoteFileDesc.getFileName());
                    String string6 = "";
                    String string7 = "";
                    String string8 = "";
                    if (remoteFileDesc.getXMLDocument() != null) {
                        String string9;
                        object4 = remoteFileDesc.getXMLDocument();
                        String string10 = ((LimeXMLDocument)object4).getValue("audios__audio__bitrate__");
                        if (string10 != null) {
                            try {
                                n3 = new Integer(string10);
                            }
                            catch (Exception exception) {}
                            if (n3 > 320) {
                                n3 = 0;
                            }
                        }
                        if ((string9 = ((LimeXMLDocument)object4).getValue("audios__audio__seconds__")) != null) {
                            try {
                                n4 = new Integer(string9);
                            }
                            catch (Exception exception) {}
                            if (n4 > 86400) {
                                n4 = 0;
                            }
                        }
                        string6 = AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__artist__"));
                        string7 = AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__album__"));
                        string8 = AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__title__"));
                        if (((LimeXMLDocument)object4).getLicenseString() != null) {
                            string6 = "<" + ((LimeXMLDocument)object4).getLicenseString() + "> " + string6;
                        }
                    }
                    object4 = String.valueOf(hostData.getIP()) + ":" + hostData.getPort();
                    int n5 = n2 = hostData.isBrowseHostEnabled() ? 1 : 0;
                    if (n2 == 1) {
                        AqEventHandler.hosts.put(object4, hostData);
                    }
                    string = String.valueOf(n) + kSep + string2 + kSep + string3 + kSep + set.size() + kSep + (String)object4 + kSep + n2 + kSep + remoteFileDesc.getSHA1Urn() + kSep + string5 + kSep + remoteFileDesc.getSpeed() + kSep + remoteFileDesc.getSize() + kSep + n3 + kSep + n4 + kSep + string6 + kSep + string7 + kSep + string8;
                    break;
                }
                case 2: {
                    ManagedConnection managedConnection = (ManagedConnection)object;
                    String string11 = new Locale(managedConnection.getLocalePref()).getDisplayLanguage();
                    String string12 = managedConnection.isSupernodeClientConnection() ? "Leaf" : (managedConnection.isClientSupernodeConnection() ? "Ultrapeer" : (managedConnection.isSupernodeSupernodeConnection() ? "Peer" : "Standard"));
                    string = String.valueOf(n) + kSep + managedConnection.getAddress() + ":" + managedConnection.getPort() + kSep + managedConnection.getUserAgent() + kSep + string11 + kSep + string12;
                    break;
                }
                case 3: {
                    ManagedConnection managedConnection = (ManagedConnection)object;
                    string = String.valueOf(n) + kSep + managedConnection.getAddress() + ":" + managedConnection.getPort();
                    break;
                }
                case 5: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    string = String.valueOf(n) + kSep + managedDownloader.hashCode() + kSep + managedDownloader.getSaveFile().getName() + kSep + managedDownloader.getState() + kSep + managedDownloader.getContentLength() + kSep + managedDownloader.getAmountRead() + kSep + managedDownloader.getSHA1Urn();
                    break;
                }
                case 6: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    string = String.valueOf(n) + kSep + managedDownloader.hashCode();
                    stateCache.remove("" + managedDownloader.hashCode());
                    if (managedDownloader.isManualCanceled() && managedDownloader.getFile() != null) {
                        managedDownloader.getFile().delete();
                    }
                    break;
                }
                case 7: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    float f = managedDownloader.getMeasuredBandwidth() * 1024.0f;
                    float f2 = managedDownloader.getAverageBandwidth() * 1024.0f;
                    String string13 = managedDownloader.getFile() != null ? managedDownloader.getFile().getAbsolutePath() : "";
                    string = String.valueOf(n) + kSep + managedDownloader.hashCode() + kSep + managedDownloader.getState() + kSep + managedDownloader.getContentLength() + kSep + managedDownloader.getAmountRead() + kSep + f + kSep + f2 + kSep + managedDownloader.getNumHosts() + kSep + managedDownloader.getBusyHostCount() + kSep + managedDownloader.getPossibleHostCount() + kSep + managedDownloader.getQueuedHostCount() + kSep + string13 + kSep + managedDownloader.getActiveHostAddresses();
                    String string14 = "" + managedDownloader.hashCode();
                    if (string.equals((String)stateCache.get(string14))) {
                        string = null;
                        break;
                    }
                    stateCache.put(string14, string);
                    break;
                }
                case 9: {
                    Uploader uploader = (Uploader)object;
                    String string15 = uploader.getFileDesc() != null ? uploader.getFileDesc().getPath() : "";
                    int n6 = uploader.isBrowseHostEnabled() ? 1 : 0;
                    string = String.valueOf(n) + kSep + uploader.hashCode() + kSep + uploader.getFileName() + kSep + uploader.getHost() + kSep + uploader.getGnutellaPort() + kSep + uploader.getUserAgent() + kSep + uploader.getState() + kSep + uploader.getFileSize() + kSep + uploader.getTotalAmountUploaded() + kSep + string15 + kSep + n6;
                    break;
                }
                case 10: {
                    Uploader uploader = (Uploader)object;
                    string = String.valueOf(n) + kSep + uploader.hashCode();
                    stateCache.remove("" + uploader.hashCode());
                    break;
                }
                case 11: {
                    Uploader uploader = (Uploader)object;
                    float f = 0.0f;
                    float f3 = 0.0f;
                    try {
                        f = uploader.getMeasuredBandwidth() * 1024.0f;
                        f3 = uploader.getAverageBandwidth() * 1024.0f;
                    }
                    catch (InsufficientDataException insufficientDataException) {
                        insufficientDataException.printStackTrace();
                    }
                    string = String.valueOf(n) + kSep + uploader.hashCode() + kSep + uploader.getState() + kSep + uploader.getFileSize() + kSep + uploader.getTotalAmountUploaded() + kSep + f + kSep + f3;
                    String string16 = "" + uploader.hashCode();
                    if (string.equals((String)stateCache.get(string16))) {
                        string = null;
                        break;
                    }
                    stateCache.put(string16, string);
                    break;
                }
                case 13: {
                    FileDesc fileDesc = (FileDesc)object;
                    string = String.valueOf(n) + kSep + fileDesc.getSHA1Urn();
                    break;
                }
                default: {
                    String string17 = object != null ? kSep + object : "";
                    String string18 = object2 != null ? kSep + object2 : "";
                    String string19 = object3 != null ? kSep + object3 : "";
                    string = String.valueOf(n) + string17 + string18 + string19;
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null) {
            AqMain.writeEvent(string);
        }
    }
}

