/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LimeXMLUtils {
    private static final double MATCHING_RATE = 0.9;
    private static final String C_HEADER_BEGIN = "{";
    private static final String C_HEADER_END = "}";
    private static final String C_HEADER_NONE_VAL = "plaintext";
    private static final String C_HEADER_ZLIB_VAL = "deflate";
    private static final String C_HEADER_GZIP_VAL = "gzip";
    private static final String COMPRESS_HEADER_ZLIB = "{deflate}";
    private static final String COMPRESS_HEADER_GZIP = "{gzip}";
    private static final String COMPRESS_HEADER_NONE = "{}";
    private static final int NONE = 0;
    private static final int GZIP = 1;
    private static final int ZLIB = 2;
    public static final String AUDIO_BITRATE_ATTR = "audios__audio__bitrate__";
    private static final int NUM_BYTES_TO_HASH = 100;
    private static final int NUM_TOTAL_HASH = 300;

    public static InputSource getInputSource(File file) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                stringBuffer.append(String.valueOf(string) + "\n");
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return new InputSource(new StringReader(stringBuffer.toString()));
    }

    public static String getTextContent(Node node) {
        return LimeXMLUtils.getText(node.getChildNodes());
    }

    public static String getText(NodeList nodeList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                    break;
                }
                case 5: {
                    if (node.getNodeName().equals("amp")) {
                        stringBuffer.append('&');
                        break;
                    }
                    if (node.getNodeName().equals("lt")) {
                        stringBuffer.append('<');
                        break;
                    }
                    if (node.getNodeName().equals("gt")) {
                        stringBuffer.append('>');
                        break;
                    }
                    if (node.getNodeName().equals("apos")) {
                        stringBuffer.append('\'');
                        break;
                    }
                    if (!node.getNodeName().equals("quot")) break;
                    stringBuffer.append('\"');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                writer.write("&lt;");
            } else if (c == '>') {
                writer.write("&gt;");
            } else if (c == '&') {
                writer.write("&amp;");
            } else if (c == '\'') {
                writer.write("&apos;");
            } else if (c == '\"') {
                writer.write("&quot;");
            } else {
                writer.write(c);
            }
            ++n;
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean match(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2, boolean bl) {
        if (limeXMLDocument2 == null || limeXMLDocument == null) {
            throw new NullPointerException("querying with null doc.");
        }
        Set set = limeXMLDocument2.getNameValueSet();
        int n = set.size();
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            Assert.that(string2 != null, "null value");
            if (string2.equals("")) continue;
            String string3 = limeXMLDocument.getValue(string);
            if (string.endsWith("license_type__") && string2.length() > 0 && (string3 == null || !string3.startsWith(string2))) {
                return false;
            }
            if (string3 == null || string3.equals("")) {
                ++n3;
                continue;
            }
            try {
                double d = new Double(string3);
                double d2 = new Double(string2);
                if (d != d2) continue;
                ++n2;
                if (!string.equals(AUDIO_BITRATE_ATTR)) continue;
                bl2 = true;
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = string2.toLowerCase(Locale.US);
                String string5 = I18NConvert.instance().getNorm(string3);
                if (!string5.startsWith(string4) && string5.indexOf(" " + string4) < 0) continue;
                ++n2;
            }
        }
        double d = n;
        double d3 = n2;
        double d4 = n3;
        if (n > 1) {
            if (bl2) {
                d -= 1.0;
                d3 -= 1.0;
                --n2;
            }
            if ((d4 + d3) / d < 0.9) {
                return false;
            }
            return bl || n2 > 0;
        }
        if (n == 1) {
            if (bl && n3 == 1) {
                return true;
            }
            return !(d3 / d < 1.0);
        }
        return false;
    }

    public static boolean isMP3File(File file) {
        return LimeXMLUtils.isMP3File(file.getName());
    }

    public static boolean isMP3File(String string) {
        return string.toLowerCase(Locale.US).endsWith(".mp3");
    }

    public static boolean isRIFFFile(File file) {
        return LimeXMLUtils.isRIFFFile(file.getName());
    }

    public static boolean isRIFFFile(String string) {
        return string.toLowerCase(Locale.US).endsWith(".avi");
    }

    public static boolean isOGMFile(File file) {
        return LimeXMLUtils.isOGMFile(file.getName());
    }

    public static boolean isOGMFile(String string) {
        return string.toLowerCase(Locale.US).endsWith(".ogm");
    }

    public static boolean isOGGFile(File file) {
        return LimeXMLUtils.isOGGFile(file.getName());
    }

    public static boolean isOGGFile(String string) {
        return string.toLowerCase(Locale.US).endsWith(".ogg");
    }

    public static boolean isFLACFile(File file) {
        return LimeXMLUtils.isFLACFile(file.getName());
    }

    public static boolean isFLACFile(String string) {
        return (string = string.toLowerCase(Locale.US)).endsWith(".flac") || string.endsWith(".fla");
    }

    public static boolean isM4AFile(File file) {
        return LimeXMLUtils.isM4AFile(file.getName());
    }

    public static boolean isM4AFile(String string) {
        return (string = string.toLowerCase(Locale.US)).endsWith(".m4a") || string.endsWith(".m4p");
    }

    public static boolean isWMAFile(File file) {
        return LimeXMLUtils.isWMAFile(file.getName());
    }

    public static boolean isWMAFile(String string) {
        return string.toLowerCase(Locale.US).endsWith(".wma");
    }

    public static boolean isWMVFile(File file) {
        return LimeXMLUtils.isWMVFile(file.getName());
    }

    public static boolean isWMVFile(String string) {
        return string.toLowerCase(Locale.US).endsWith(".wmv");
    }

    public static boolean isASFFile(File file) {
        return LimeXMLUtils.isASFFile(file.getName());
    }

    public static boolean isASFFile(String string) {
        return (string = string.toLowerCase(Locale.US)).endsWith(".asf") || string.endsWith(".wm");
    }

    public static boolean isSupportedAudioFormat(File file) {
        return LimeXMLUtils.isSupportedAudioFormat(file.getName());
    }

    public static boolean isSupportedAudioFormat(String string) {
        return LimeXMLUtils.isMP3File(string) || LimeXMLUtils.isOGGFile(string) || LimeXMLUtils.isM4AFile(string) || LimeXMLUtils.isWMAFile(string) || LimeXMLUtils.isFLACFile(string);
    }

    public static boolean isSupportedVideoFormat(File file) {
        return LimeXMLUtils.isSupportedVideoFormat(file.getName());
    }

    public static boolean isSupportedVideoFormat(String string) {
        return LimeXMLUtils.isRIFFFile(string) || LimeXMLUtils.isOGMFile(string) || LimeXMLUtils.isWMVFile(string);
    }

    public static boolean isSupportedMultipleFormat(File file) {
        return LimeXMLUtils.isSupportedMultipleFormat(file.getName());
    }

    public static boolean isSupportedMultipleFormat(String string) {
        return LimeXMLUtils.isASFFile(string);
    }

    public static boolean isSupportedFormat(File file) {
        return LimeXMLUtils.isSupportedFormat(file.getName());
    }

    public static boolean isSupportedFormat(String string) {
        return LimeXMLUtils.isSupportedAudioFormat(string) || LimeXMLUtils.isSupportedVideoFormat(string) || LimeXMLUtils.isSupportedMultipleFormat(string);
    }

    public static boolean isEditableFormat(File file) {
        return LimeXMLUtils.isEditableFormat(file.getName());
    }

    public static boolean isEditableFormat(String string) {
        return LimeXMLUtils.isMP3File(string) || LimeXMLUtils.isOGGFile(string);
    }

    public static boolean isSupportedFormatForSchema(File file, String string) {
        if (LimeXMLUtils.isSupportedMultipleFormat(file)) {
            return true;
        }
        if ("http://www.limewire.com/schemas/audio.xsd".equals(string)) {
            return LimeXMLUtils.isSupportedAudioFormat(file);
        }
        if ("http://www.limewire.com/schemas/video.xsd".equals(string)) {
            return LimeXMLUtils.isSupportedVideoFormat(file);
        }
        return false;
    }

    public static boolean isFilePublishable(File file) {
        return LimeXMLUtils.isMP3File(file.getName()) || LimeXMLUtils.isOGGFile(file.getName());
    }

    public static String encodeXML(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(38) == -1 && string.indexOf(60) == -1 && string.indexOf(62) == -1 && string.indexOf(39) == -1 && string.indexOf(34) == -1) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static byte[] compress(byte[] byArray) {
        byte[] byArray2 = null;
        if (LimeXMLUtils.shouldCompress(byArray)) {
            byArray2 = LimeXMLUtils.compressZLIB(byArray);
        }
        byte[] byArray3 = null;
        if (byArray2 != null) {
            byArray3 = new byte[COMPRESS_HEADER_ZLIB.length() + byArray2.length];
            System.arraycopy(COMPRESS_HEADER_ZLIB.getBytes(), 0, byArray3, 0, COMPRESS_HEADER_ZLIB.length());
            System.arraycopy(byArray2, 0, byArray3, COMPRESS_HEADER_ZLIB.length(), byArray2.length);
        } else {
            byArray3 = new byte[COMPRESS_HEADER_NONE.length() + byArray.length];
            System.arraycopy(COMPRESS_HEADER_NONE.getBytes(), 0, byArray3, 0, COMPRESS_HEADER_NONE.length());
            System.arraycopy(byArray, 0, byArray3, COMPRESS_HEADER_NONE.length(), byArray.length);
        }
        return byArray3;
    }

    private static boolean shouldCompress(byte[] byArray) {
        return byArray.length >= 1000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] compressZLIB(byte[] byArray) {
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(byArray, 0, byArray.length);
            deflaterOutputStream.flush();
            deflaterOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            IOUtils.close(deflaterOutputStream);
            return byArray2;
        }
        catch (IOException iOException) {
            byte[] byArray3;
            try {
                Assert.that(false, "Couldn't write to byte stream");
                byArray3 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(deflaterOutputStream);
                throw throwable;
            }
            IOUtils.close(deflaterOutputStream);
            return byArray3;
        }
    }

    public static byte[] uncompress(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[]{};
        String string = new String(byArray, 0, C_HEADER_BEGIN.length());
        if (string.equals(C_HEADER_BEGIN)) {
            boolean bl = false;
            int n = 0;
            while (n < byArray.length && !bl) {
                if (byArray[n] == 125) {
                    bl = true;
                }
                ++n;
            }
            string = new String(byArray, 1, n - 1 - 1);
            int n2 = LimeXMLUtils.getCompressionType(string);
            if (n2 == 0) {
                byArray2 = new byte[byArray.length - (string.length() + 2)];
                System.arraycopy(byArray, n, byArray2, 0, byArray.length - (string.length() + 2));
            } else if (n2 == 1) {
                byArray2 = new byte[byArray.length - COMPRESS_HEADER_GZIP.length()];
                System.arraycopy(byArray, COMPRESS_HEADER_GZIP.length(), byArray2, 0, byArray.length - COMPRESS_HEADER_GZIP.length());
                byArray2 = LimeXMLUtils.uncompressGZIP(byArray2);
            } else if (n2 == 2) {
                byArray2 = new byte[byArray.length - COMPRESS_HEADER_ZLIB.length()];
                System.arraycopy(byArray, COMPRESS_HEADER_ZLIB.length(), byArray2, 0, byArray.length - COMPRESS_HEADER_ZLIB.length());
                byArray2 = LimeXMLUtils.uncompressZLIB(byArray2);
            }
        } else {
            return byArray;
        }
        return byArray2;
    }

    private static int getCompressionType(String string) {
        String string2 = string.trim();
        if (string2.equals("") || string2.equalsIgnoreCase(C_HEADER_NONE_VAL)) {
            return 0;
        }
        if (string2.equalsIgnoreCase(C_HEADER_GZIP_VAL)) {
            return 1;
        }
        if (string2.equalsIgnoreCase(C_HEADER_ZLIB_VAL)) {
            return 2;
        }
        return -1;
    }

    private static byte[] uncompressGZIP(byte[] byArray) throws IOException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = null;
        try {
            int n;
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = gZIPInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(gZIPInputStream);
            throw throwable;
        }
        IOUtils.close(gZIPInputStream);
        return byArray2;
    }

    private static byte[] uncompressZLIB(byte[] byArray) throws IOException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = null;
        try {
            int n;
            inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inflaterInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(inflaterInputStream);
            throw throwable;
        }
        IOUtils.close(inflaterInputStream);
        return byArray2;
    }

    private static void clearHashBytes(byte[] byArray) {
        int n = 0;
        while (n < 100) {
            byArray[n] = 0;
            ++n;
        }
    }

    public static byte[] hashFile(File file) throws IOException {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        byte[] byArray2 = new byte[100];
        try {
            fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Assert.that(false, "no sha algorithm.");
            }
            long l = file.length();
            if (l < 300L) {
                int n = 0;
                do {
                    LimeXMLUtils.clearHashBytes(byArray2);
                    n = fileInputStream.read(byArray2);
                    messageDigest.update(byArray2);
                    if (file.length() == l) continue;
                    throw new IOException("invalid length");
                } while (n == 100);
            } else {
                long l2 = l / 3L;
                LimeXMLUtils.clearHashBytes(byArray2);
                fileInputStream.read(byArray2);
                messageDigest.update(byArray2);
                if (file.length() != l) {
                    throw new IOException("invalid length");
                }
                LimeXMLUtils.clearHashBytes(byArray2);
                fileInputStream.skip(l2 - 100L);
                fileInputStream.read(byArray2);
                messageDigest.update(byArray2);
                if (file.length() != l) {
                    throw new IOException("invalid length");
                }
                LimeXMLUtils.clearHashBytes(byArray2);
                fileInputStream.skip(file.length() - (l2 + 100L) - 100L);
                fileInputStream.read(byArray2);
                messageDigest.update(byArray2);
                if (file.length() != l) {
                    throw new IOException("invalid length");
                }
            }
            byArray = messageDigest.digest();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return byArray;
    }
}

