/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;

public class UnavailableRangeUploadState
extends UploadState {
    private static final String INACTIVE_RETRY_AFTER = "3600";

    public UnavailableRangeUploadState(HTTPUploader hTTPUploader) {
        super(hTTPUploader);
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        IncompleteFileDesc incompleteFileDesc;
        String string = "HTTP/1.1 416 Requested Range Unavailable\r\n";
        outputStream.write(string.getBytes());
        string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Type: text/plain\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: 0\r\n";
        outputStream.write(string.getBytes());
        this.writeAlts(outputStream);
        this.writeRanges(outputStream);
        this.writeProxies(outputStream);
        if (this.FILE_DESC != null && this.FILE_DESC instanceof IncompleteFileDesc && !(incompleteFileDesc = (IncompleteFileDesc)this.FILE_DESC).isActivelyDownloading()) {
            HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, INACTIVE_RETRY_AFTER, outputStream);
        }
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

