/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MP3MetaData;
import com.limegroup.gnutella.util.CountingInputStream;
import com.limegroup.gnutella.util.IOUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class M4AMetaData
extends AudioMetaData {
    private static final int FTYP_ATOM = 1718909296;
    private static final int MOOV_ATOM = 1836019574;
    private static final int MVHD_ATOM = 1836476516;
    private static final int TRAK_ATOM = 1953653099;
    private static final int TKHD_ATOM = 1953196132;
    private static final int MDIA_ATOM = 1835297121;
    private static final int ESDS_ATOM = 1702061171;
    private static final int ALAC_ATOM = 1634492771;
    private static final int MDHD_ATOM = 1835296868;
    private static final int MINF_ATOM = 1835626086;
    private static final int DINF_ATOM = 1684631142;
    private static final int SMHD_ATOM = 1936549988;
    private static final int STBL_ATOM = 1937007212;
    private static final int STSD_ATOM = 1937011556;
    private static final int MP4A_ATOM = 1836069985;
    private static final int DRMS_ATOM = 1685220723;
    private static final int UDTA_ATOM = 1969517665;
    private static final int META_ATOM = 1835365473;
    private static final int HDLR_ATOM = 1751411826;
    private static final int STTS_ATOM = 0x73747473;
    private static final int STSC_ATOM = 1937011555;
    private static final int STSZ_ATOM = 1937011578;
    private static final int STCO_ATOM = 1937007471;
    private static final int ILST_ATOM = 1768715124;
    private static final int NAME_ATOM = -1452383891;
    private static final int ALBUM_ATOM = -1453233054;
    private static final int ARTIST_ATOM = -1455336876;
    private static final int DATE_ATOM = -1453039239;
    private static final int GENRE_ATOM = 1735291493;
    private static final int GENRE_ATOM_STANDARD = -1452841618;
    private static final int TRACK_ATOM = 1953655662;
    private static final int TRACK_ATOM_STANDARD = -1451986325;
    private static final int COMMENT_ATOM = -1453101708;
    private static final int DISK_ATOM = 1684632427;
    private static final int DATA_ATOM = 1684108385;
    private int _maxLength;

    public M4AMetaData(File file) throws IOException {
        super(file);
    }

    protected void parseFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            short s;
            String string;
            this._maxLength = (int)file.length();
            fileInputStream = new FileInputStream(file);
            this.positionMetaDataStream(fileInputStream);
            Map map = this.populateMetaDataMap(fileInputStream);
            byte[] byArray = (byte[])map.get(new Integer(-1452383891));
            this.setTitle(byArray == null ? "" : new String(byArray, "UTF-8"));
            byArray = (byte[])map.get(new Integer(-1455336876));
            this.setArtist(byArray == null ? "" : new String(byArray, "UTF-8"));
            byArray = (byte[])map.get(new Integer(-1453233054));
            this.setAlbum(byArray == null ? "" : new String(byArray, "UTF-8"));
            byArray = (byte[])map.get(new Integer(-1453101708));
            this.setComment(byArray == null ? "" : new String(byArray, "UTF-8"));
            byArray = (byte[])map.get(new Integer(1735291493));
            if (byArray != null) {
                if (byArray[3] == 1) {
                    string = new String(byArray, 8, byArray.length - 8, "UTF-8");
                    this.setGenre(string);
                } else {
                    short s2 = (short)(ByteOrder.beb2short(byArray, byArray.length - 2) - 1);
                    this.setGenre(MP3MetaData.getGenreString(s2));
                }
            }
            if ((byArray = (byte[])map.get(new Integer(-1453039239))) == null) {
                this.setYear("");
            } else {
                string = new String(byArray, 8, byArray.length - 8);
                if (string.length() > 4) {
                    string = string.substring(0, 4);
                }
                this.setYear(string);
            }
            byArray = (byte[])map.get(new Integer(1953655662));
            if (byArray != null) {
                short s3 = ByteOrder.beb2short(byArray, byArray.length - 6);
                this.setTrack(s3);
                s = ByteOrder.beb2short(byArray, byArray.length - 4);
                this.setTotalTracks(s);
            }
            if ((byArray = (byte[])map.get(new Integer(1684632427))) != null) {
                short s4 = ByteOrder.beb2short(byArray, byArray.length - 4);
                this.setDisk(s4);
                s = ByteOrder.beb2short(byArray, byArray.length - 2);
                this.setTotalDisks(s);
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void skipAtom(int n, DataInputStream dataInputStream) throws IOException {
        IOUtils.ensureSkip(dataInputStream, this.enterAtom(n, dataInputStream));
    }

    private int enterAtom(int n, DataInputStream dataInputStream) throws IOException {
        boolean bl = false;
        int n2 = dataInputStream.readInt();
        if (n2 >= this._maxLength) {
            throw new IOException("invalid size field read");
        }
        int n3 = dataInputStream.readInt();
        if (n3 != n) {
            throw new IOException("atom type mismatch, expected " + n + " got " + n3);
        }
        if (n2 == 1) {
            bl = true;
            n2 = (int)dataInputStream.readLong();
        }
        return n2 -= bl ? 16 : 8;
    }

    private void positionMetaDataStream(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.skipAtom(1718909296, dataInputStream);
        this.enterAtom(1836019574, dataInputStream);
        int n = this.enterAtom(1836476516, dataInputStream) - 20;
        IOUtils.ensureSkip(dataInputStream, 12L);
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        this.setLength(n3 / n2);
        IOUtils.ensureSkip(dataInputStream, n);
        this.enterAtom(1953653099, dataInputStream);
        this.skipAtom(1953196132, dataInputStream);
        this.enterAtom(1835297121, dataInputStream);
        this.skipAtom(1835296868, dataInputStream);
        this.skipAtom(1751411826, dataInputStream);
        this.enterAtom(1835626086, dataInputStream);
        this.skipAtom(1936549988, dataInputStream);
        this.skipAtom(1684631142, dataInputStream);
        this.enterAtom(1937007212, dataInputStream);
        this.enterAtom(1937011556, dataInputStream);
        this.processSTSDAtom(dataInputStream);
        this.skipAtom(0x73747473, dataInputStream);
        this.skipAtom(1937011555, dataInputStream);
        this.skipAtom(1937011578, dataInputStream);
        this.skipAtom(1937007471, dataInputStream);
        this.enterAtom(1969517665, dataInputStream);
        this.enterAtom(1835365473, dataInputStream);
        IOUtils.ensureSkip(dataInputStream, 4L);
        this.skipAtom(1751411826, dataInputStream);
        this._maxLength = this.enterAtom(1768715124, dataInputStream);
    }

    private void processSTSDAtom(DataInputStream dataInputStream) throws IOException {
        IOUtils.ensureSkip(dataInputStream, 12L);
        int n = dataInputStream.readInt();
        IOUtils.ensureSkip(dataInputStream, 28L);
        if (n == 1836069985) {
            this.enterBitrateAtom(1702061171, 26, dataInputStream);
        } else if (n == 1634492771) {
            this.enterBitrateAtom(1634492771, 20, dataInputStream);
        } else {
            throw new IOException("atom type mismatch, expected 1836069985 or 1634492771 got " + n);
        }
    }

    private void enterBitrateAtom(int n, int n2, DataInputStream dataInputStream) throws IOException {
        int n3 = this.enterAtom(n, dataInputStream);
        n3 = (int)((long)n3 - IOUtils.ensureSkip(dataInputStream, n2));
        int n4 = dataInputStream.readInt();
        this.setBitrate(n4 / 1000);
        IOUtils.ensureSkip(dataInputStream, n3 -= 4);
    }

    private Map populateMetaDataMap(InputStream inputStream) throws IOException {
        HashMap<Integer, byte[]> hashMap = new HashMap<Integer, byte[]>();
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(countingInputStream);
        while (countingInputStream.getAmountRead() < this._maxLength && !this.isComplete()) {
            int n = dataInputStream.readInt();
            if (n > this._maxLength) {
                throw new IOException("invalid file size");
            }
            int n2 = dataInputStream.readInt();
            switch (n2) {
                case -1452383891: {
                    hashMap.put(new Integer(-1452383891), this.readDataAtom(dataInputStream));
                    break;
                }
                case -1455336876: {
                    hashMap.put(new Integer(-1455336876), this.readDataAtom(dataInputStream));
                    break;
                }
                case -1453233054: {
                    hashMap.put(new Integer(-1453233054), this.readDataAtom(dataInputStream));
                    break;
                }
                case -1451986325: 
                case 1953655662: {
                    hashMap.put(new Integer(1953655662), this.readDataAtom(dataInputStream));
                    break;
                }
                case -1452841618: 
                case 1735291493: {
                    hashMap.put(new Integer(1735291493), this.readDataAtom(dataInputStream));
                    break;
                }
                case -1453039239: {
                    hashMap.put(new Integer(-1453039239), this.readDataAtom(dataInputStream));
                    break;
                }
                case -1453101708: {
                    hashMap.put(new Integer(-1453101708), this.readDataAtom(dataInputStream));
                    break;
                }
                case 1684632427: {
                    hashMap.put(new Integer(1684632427), this.readDataAtom(dataInputStream));
                    break;
                }
                default: {
                    IOUtils.ensureSkip(dataInputStream, n - 8);
                }
            }
        }
        return hashMap;
    }

    private byte[] readDataAtom(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (dataInputStream.readInt() != 1684108385) {
            throw new IOException("data tag not found");
        }
        byte[] byArray = new byte[n - 8];
        dataInputStream.readFully(byArray);
        return byArray;
    }
}

