/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.util.IOUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class FLACMetaData
extends AudioMetaData {
    public static final String TITLE_TAG = "title";
    public static final String TRACK_TAG = "tracknumber";
    public static final String ALBUM_TAG = "album";
    public static final String GENRE_TAG = "genre";
    public static final String DATE_TAG = "date";
    public static final String COMMENT_TAG = "comment";
    public static final String ARTIST_TAG = "artist";
    public static final String LICENSE_TAG = "license";
    private static final byte FIRST_BIT = -128;

    public FLACMetaData(File file) throws IOException {
        super(file);
    }

    protected void parseFile(File file) throws IOException {
        DataInputStream dataInputStream;
        FileInputStream fileInputStream;
        block3: {
            fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                dataInputStream = new DataInputStream(fileInputStream);
                if (this.readHeader(dataInputStream)) break block3;
            }
            catch (Throwable throwable) {
                IOUtils.close(fileInputStream);
                throw throwable;
            }
            IOUtils.close(fileInputStream);
            return;
        }
        Set set = this.searchAndReadMetaData(dataInputStream);
        this.parseVorbisComment(set);
        IOUtils.close(fileInputStream);
    }

    private boolean readHeader(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readByte() == 102 && dataInputStream.readByte() == 76 && dataInputStream.readByte() == 97 && dataInputStream.readByte() == 67;
    }

    private Set searchAndReadMetaData(DataInputStream dataInputStream) throws IOException {
        HashSet hashSet = new HashSet();
        boolean bl = false;
        do {
            byte[] byArray = new byte[4];
            dataInputStream.readFully(byArray);
            bl = (byArray[0] & 0xFFFFFF80) != 0;
            byte by = (byte)(byArray[0] & 0x7F);
            int n = ByteOrder.beb2int(byArray, 1, 3);
            if (by == 4) {
                this.readVorbisComments(dataInputStream, hashSet);
                continue;
            }
            if (by == 0) {
                this.readStreamInfo(dataInputStream);
                continue;
            }
            IOUtils.ensureSkip(dataInputStream, n);
        } while (!bl);
        return hashSet;
    }

    private void readStreamInfo(DataInputStream dataInputStream) throws IOException {
        IOUtils.ensureSkip(dataInputStream, 10L);
        byte[] byArray = new byte[8];
        dataInputStream.readFully(byArray);
        IOUtils.ensureSkip(dataInputStream, 16L);
        int n = ByteOrder.beb2int(byArray, 0, 3) >> 4;
        int n2 = (ByteOrder.beb2int(byArray, 2, 1) >> 1 & 7) + 1;
        int n3 = (ByteOrder.beb2int(byArray, 2, 2) >> 4 & 0x1F) + 1;
        long l = ByteOrder.beb2int(byArray, 3, 1) & 0xF;
        l <<= 32;
        this.setBitrate(n3 * n / 1024 * n2);
        this.setLength((int)((l |= (long)ByteOrder.beb2int(byArray, 4, 4)) / (long)n));
    }

    private void readVorbisComments(DataInputStream dataInputStream, Set set) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        int n = ByteOrder.leb2int(byArray, 0);
        byte[] byArray2 = new byte[n];
        dataInputStream.readFully(byArray2);
        dataInputStream.readFully(byArray);
        int n2 = ByteOrder.leb2int(byArray, 0);
        int n3 = 0;
        while (n3 < n2) {
            dataInputStream.readFully(byArray);
            int n4 = ByteOrder.leb2int(byArray, 0);
            byte[] byArray3 = new byte[n4];
            dataInputStream.readFully(byArray3);
            set.add(new String(byArray3, "UTF-8"));
            ++n3;
        }
    }

    private void parseVorbisComment(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            int n = string.indexOf(61);
            String string2 = string.substring(0, n);
            string2 = string2.toLowerCase(Locale.US);
            String string3 = string.substring(n + 1);
            if (string2.equals(TITLE_TAG)) {
                this.setTitle(string3);
                continue;
            }
            if (string2.equals(ARTIST_TAG)) {
                this.setArtist(string3);
                continue;
            }
            if (string2.equals(COMMENT_TAG)) {
                this.setComment(string3);
                continue;
            }
            if (string2.equals(ALBUM_TAG)) {
                this.setAlbum(string3);
                continue;
            }
            if (string2.equals(LICENSE_TAG)) {
                this.setLicense(string3);
                continue;
            }
            if (string2.equals(DATE_TAG)) {
                this.setYear(string3.length() > 4 ? string3.substring(0, 4) : string3);
                continue;
            }
            if (!string2.equals(TRACK_TAG)) continue;
            try {
                short s = Short.parseShort(string3);
                this.setTrack(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

