/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.WRMXML;
import com.limegroup.gnutella.metadata.WeedInfo;
import com.limegroup.gnutella.util.CountingInputStream;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ASFParser {
    private static final Log LOG;
    private static final int TYPE_STRING = 0;
    private static final int TYPE_BINARY = 1;
    private static final int TYPE_BOOLEAN = 2;
    private static final int TYPE_INT = 3;
    private static final int TYPE_LONG = 4;
    private String _album;
    private String _artist;
    private String _title;
    private String _year;
    private String _copyright;
    private String _rating;
    private String _genre;
    private String _comment;
    private String _drmType;
    private short _track = (short)-1;
    private int _bitrate = -1;
    private int _length = -1;
    private int _width = -1;
    private int _height = -1;
    private boolean _hasAudio;
    private boolean _hasVideo;
    private WeedInfo _weed;
    private WRMXML _wrmdata;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.metadata.ASFParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    String getAlbum() {
        return this._album;
    }

    String getArtist() {
        return this._artist;
    }

    String getTitle() {
        return this._title;
    }

    String getYear() {
        return this._year;
    }

    String getCopyright() {
        return this._copyright;
    }

    String getRating() {
        return this._rating;
    }

    String getGenre() {
        return this._genre;
    }

    String getComment() {
        return this._comment;
    }

    short getTrack() {
        return this._track;
    }

    int getBitrate() {
        return this._bitrate;
    }

    int getLength() {
        return this._length;
    }

    int getWidth() {
        return this._width;
    }

    int getHeight() {
        return this._height;
    }

    WeedInfo getWeedInfo() {
        return this._weed;
    }

    WRMXML getWRMXML() {
        return this._wrmdata;
    }

    boolean hasAudio() {
        return this._hasAudio;
    }

    boolean hasVideo() {
        return this._hasVideo;
    }

    String getLicenseInfo() {
        if (this._weed != null) {
            return this._weed.getLicenseInfo();
        }
        if (this._wrmdata != null && this._drmType != null) {
            return "licensed: " + this._drmType;
        }
        return null;
    }

    ASFParser(File file) throws IOException {
        this.parseFile(file);
    }

    protected void parseFile(File file) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing file: " + file));
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.parse(bufferedInputStream);
            }
            catch (IOException iOException) {
                LOG.warn((Object)"IOX while parsing", (Throwable)iOException);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedInputStream);
            throw throwable;
        }
        IOUtils.close(bufferedInputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(countingInputStream);
        byte[] byArray = new byte[IDs.HEADER_ID.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, IDs.HEADER_ID)) {
            throw new IOException("not an ASF file");
        }
        long l = ByteOrder.leb2long(dataInputStream);
        int n = ByteOrder.leb2int(dataInputStream);
        IOUtils.ensureSkip(dataInputStream, 2L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Data Offset: " + l + ", objectCount: " + n));
        }
        if (l < 0L) {
            throw new IOException("ASF file is corrupt. Data offset negative:" + l);
        }
        if (n < 0) {
            throw new IOException("ASF file is corrupt. Object count unreasonable:" + ByteOrder.uint2long(n));
        }
        if (n > 100) {
            throw new IOException("object count very high: " + n);
        }
        byte[] byArray2 = new byte[16];
        int n2 = 0;
        while (n2 < n) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parsing object[" + n2 + "]"));
            }
            dataInputStream.readFully(byArray2);
            long l2 = ByteOrder.leb2long(dataInputStream) - 24L;
            if (l2 < 0L) {
                throw new IOException("ASF file is corrupt.  Object size < 0 :" + l2);
            }
            countingInputStream.clearAmountRead();
            this.readObject(dataInputStream, byArray2, l2);
            int n3 = countingInputStream.getAmountRead();
            if ((long)n3 > l2) {
                throw new IOException("read (" + n3 + ") more than size (" + l2 + ")");
            }
            if ((long)n3 != l2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipping to next object.  Read: " + n3 + ", size: " + l2));
                }
                IOUtils.ensureSkip(dataInputStream, l2 - (long)n3);
            }
            ++n2;
        }
    }

    private void readObject(DataInputStream dataInputStream, byte[] byArray, long l) throws IOException {
        if (Arrays.equals(byArray, IDs.FILE_PROPERTIES_ID)) {
            this.parseFileProperties(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.STREAM_PROPERTIES_ID)) {
            this.parseStreamProperties(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.EXTENDED_STREAM_PROPERTIES_ID)) {
            this.parseExtendedStreamProperties(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.CONTENT_DESCRIPTION_ID)) {
            this.parseContentDescription(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.EXTENDED_CONTENT_DESCRIPTION_ID)) {
            this.parseExtendedContentDescription(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.CONTENT_ENCRYPTION_ID)) {
            this.parseContentEncryption(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.EXTENDED_CONTENT_ENCRYPTION_ID)) {
            this.parseExtendedContentEncryption(dataInputStream);
        } else {
            LOG.debug((Object)"Unknown Object, ignoring.");
        }
    }

    private void parseFileProperties(DataInputStream dataInputStream) throws IOException {
        LOG.debug((Object)"Parsing file properties");
        IOUtils.ensureSkip(dataInputStream, 48L);
        int n = (int)(ByteOrder.leb2long(dataInputStream) / 10000000L);
        if (n < 0) {
            throw new IOException("ASF file corrupt.  Duration < 0:" + n);
        }
        this._length = n;
        IOUtils.ensureSkip(dataInputStream, 20L);
        int n2 = ByteOrder.leb2int(dataInputStream);
        if (n2 < 0) {
            throw new IOException("ASF file corrupt.  Max bitrate > 2 Gb/s:" + ByteOrder.uint2long(n2));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("maxBitrate: " + n2));
        }
        this._bitrate = n2 / 1000;
    }

    private void parseStreamProperties(DataInputStream dataInputStream) throws IOException {
        LOG.debug((Object)"Parsing stream properties");
        byte[] byArray = new byte[16];
        dataInputStream.readFully(byArray);
        if (Arrays.equals(byArray, IDs.AUDIO_STREAM_ID)) {
            this._hasAudio = true;
        } else if (Arrays.equals(byArray, IDs.VIDEO_STREAM_ID)) {
            this._hasVideo = true;
            IOUtils.ensureSkip(dataInputStream, 38L);
            this._width = ByteOrder.leb2int(dataInputStream);
            if (this._width < 0) {
                throw new IOException("ASF file corrupt.  Video width excessive:" + ByteOrder.uint2long(this._width));
            }
            this._height = ByteOrder.leb2int(dataInputStream);
            if (this._height < 0) {
                throw new IOException("ASF file corrupt.  Video height excessive:" + ByteOrder.uint2long(this._height));
            }
        }
    }

    private void parseExtendedStreamProperties(DataInputStream dataInputStream) throws IOException {
        LOG.debug((Object)"Parsing extended stream properties");
        IOUtils.ensureSkip(dataInputStream, 56L);
        int n = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
        int n2 = ByteOrder.leb2int(dataInputStream);
        if (n2 < 0) {
            throw new IOException("ASF file corrupt.  Sample rate excessive:" + ByteOrder.uint2long(n2));
        }
        int n3 = ByteOrder.leb2int(dataInputStream);
        if (n3 < 0) {
            throw new IOException("ASF file corrupt.  Byte rate excessive:" + ByteOrder.uint2long(n3));
        }
        if (this._bitrate == -1) {
            this._bitrate = n3 * 8 / 1000;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("channels: " + n + ", sampleRate: " + n2 + ", byteRate: " + n3 + ", bitRate: " + this._bitrate));
        }
    }

    private void parseContentEncryption(DataInputStream dataInputStream) throws IOException {
        LOG.debug((Object)"Parsing content encryption");
        long l = ByteOrder.uint2long(ByteOrder.leb2int(dataInputStream));
        IOUtils.ensureSkip(dataInputStream, l);
        int n = ByteOrder.leb2int(dataInputStream);
        if (n < 0) {
            throw new IOException("ASF file is corrupt.  Type size < 0: " + n);
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        this._drmType = new String(byArray).trim();
        l = ByteOrder.uint2long(ByteOrder.leb2int(dataInputStream));
        IOUtils.ensureSkip(dataInputStream, l);
        l = ByteOrder.uint2long(ByteOrder.leb2int(dataInputStream));
        IOUtils.ensureSkip(dataInputStream, l);
    }

    private void parseExtendedContentEncryption(DataInputStream dataInputStream) throws IOException {
        LOG.debug((Object)"Parsing extended content encryption");
        int n = ByteOrder.leb2int(dataInputStream);
        if (n < 0) {
            throw new IOException("ASF file reports excessive length of encryption data:" + ByteOrder.uint2long(n));
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "UTF-16").trim();
        WRMXML wRMXML = new WRMXML(string);
        if (!wRMXML.isValid()) {
            LOG.debug((Object)"WRM Data is invalid.");
            return;
        }
        this._wrmdata = wRMXML;
        WeedInfo weedInfo = new WeedInfo(wRMXML);
        if (weedInfo.isValid()) {
            LOG.debug((Object)"Parsed weed data.");
            this._weed = weedInfo;
            this._wrmdata = weedInfo;
            if (this._weed.getAuthor() != null) {
                this._artist = this._weed.getAuthor();
            }
            if (this._weed.getTitle() != null) {
                this._title = this._weed.getTitle();
            }
            if (this._weed.getDescription() != null) {
                this._comment = this._weed.getDescription();
            }
            if (this._weed.getCollection() != null) {
                this._album = this._weed.getCollection();
            }
            if (this._weed.getCopyright() != null) {
                this._copyright = this._weed.getCopyright();
            }
            return;
        }
    }

    private void parseContentDescription(DataInputStream dataInputStream) throws IOException {
        LOG.debug((Object)"Parsing Content Description");
        int[] nArray = new int[]{-1, -1, -1, -1, -1};
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
            ++n;
        }
        byte[][] byArray = new byte[5][];
        int n2 = 0;
        while (n2 < nArray.length) {
            byArray[n2] = new byte[nArray[n2]];
            ++n2;
        }
        n2 = 0;
        while (n2 < byArray.length) {
            dataInputStream.readFully(byArray[n2]);
            ++n2;
        }
        this._title = this.string(byArray[0]);
        this._artist = this.string(byArray[1]);
        this._copyright = this.string(byArray[2]);
        this._comment = this.string(byArray[3]);
        this._rating = this.string(byArray[4]);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Standard Tag Values.  Title: " + this._title + ", Author: " + this._artist + ", Copyright: " + this._copyright + ", Description: " + this._comment + ", Rating: " + this._rating));
        }
    }

    private void parseExtendedContentDescription(DataInputStream dataInputStream) throws IOException {
        LOG.debug((Object)"Parsing extended content description");
        int n = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Extended fieldCount: " + n));
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
            byte[] byArray = new byte[n3];
            dataInputStream.readFully(byArray);
            String string = this.string(byArray);
            int n4 = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
            int n5 = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
            switch (n4) {
                case 0: {
                    this.parseExtendedString(string, n5, dataInputStream);
                    break;
                }
                case 1: {
                    this.parseExtendedBinary(string, n5, dataInputStream);
                    break;
                }
                case 2: {
                    this.parseExtendedBoolean(string, n5, dataInputStream);
                    break;
                }
                case 3: {
                    this.parseExtendedInt(string, n5, dataInputStream);
                    break;
                }
                case 4: {
                    this.parseExtendedInt(string, n5, dataInputStream);
                    break;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unknown dataType: " + n4 + " for field: " + string));
                    }
                    IOUtils.ensureSkip(dataInputStream, n5);
                }
            }
            ++n2;
        }
    }

    private void parseExtendedString(String string, int n, DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[Math.min(250, n)];
        dataInputStream.readFully(byArray);
        int n2 = Math.max(0, n - 250);
        IOUtils.ensureSkip(dataInputStream, n2);
        String string2 = this.string(byArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing extended String.  field: " + string + ", Value: " + string2));
        }
        if ("WM/Title".equals(string)) {
            if (this._title == null) {
                this._title = string2;
            }
        } else if ("WM/Author".equals(string)) {
            if (this._artist == null) {
                this._artist = string2;
            }
        } else if ("WM/AlbumTitle".equals(string)) {
            if (this._album == null) {
                this._album = string2;
            }
        } else if ("WM/TrackNumber".equals(string)) {
            if (this._track == -1) {
                this._track = this.toShort(string2);
            }
        } else if ("WM/Year".equals(string)) {
            if (this._year == null) {
                this._year = string2;
            }
        } else if ("WM/Genre".equals(string)) {
            if (this._genre == null) {
                this._genre = string2;
            }
        } else if ("WM/Description".equals(string) && this._comment == null) {
            this._comment = string2;
        }
    }

    private void parseExtendedBoolean(String string, int n, DataInputStream dataInputStream) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ignoring boolean field: " + string + ", size: " + n));
        }
        IOUtils.ensureSkip(dataInputStream, n);
    }

    private void parseExtendedInt(String string, int n, DataInputStream dataInputStream) throws IOException {
        if (n != 4) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Int field size != 4, ignoring.   Field: " + string + ", size: " + n));
            }
            IOUtils.ensureSkip(dataInputStream, n);
            return;
        }
        int n2 = ByteOrder.leb2int(dataInputStream);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing extended int, field: " + string + ", size: " + n + ", value: " + n2));
        }
        if ("WM/TrackNumber".equals(string) && this._track == -1) {
            short s = (short)n2;
            if (s < 0) {
                throw new IOException("ASF file reports negative track number " + s);
            }
            this._track = s;
        }
    }

    private void parseExtendedBinary(String string, int n, DataInputStream dataInputStream) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ignoring binary field: " + string + ", size: " + n));
        }
        IOUtils.ensureSkip(dataInputStream, n);
    }

    private void parseExtendedLong(String string, int n, DataInputStream dataInputStream) throws IOException {
        if (n != 8) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Long field size != 8, ignoring.   Field: " + string + ", size: " + n));
            }
            IOUtils.ensureSkip(dataInputStream, n);
            return;
        }
        long l = ByteOrder.leb2long(dataInputStream);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ignoring long field: " + string + ", size: " + n + ", value: " + l));
        }
    }

    private short toShort(String string) {
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String string(byte[] var1_1) throws IOException {
        if (var1_1 == null) {
            return null;
        }
        try {
            return new String(var1_1, "UTF-16LE").trim();
        }
        catch (UnsupportedEncodingException v0) {
            var2_2 = 0;
            var3_3 = 0;
            ** while (var3_3 < var1_1.length)
        }
lbl-1000:
        // 1 sources

        {
            if (var1_1[var3_3] != 0) {
                var1_1[var2_2++] = var1_1[var3_3];
            }
            ++var3_3;
            continue;
        }
lbl13:
        // 1 sources

        return new String(var1_1, 0, var2_2, "UTF-8");
    }

    private static class IDs {
        private static final byte[] HEADER_ID;
        private static final byte[] FILE_PROPERTIES_ID;
        private static final byte[] STREAM_PROPERTIES_ID;
        private static final byte[] EXTENDED_STREAM_PROPERTIES_ID;
        private static final byte[] CONTENT_DESCRIPTION_ID;
        private static final byte[] EXTENDED_CONTENT_DESCRIPTION_ID;
        private static final byte[] CONTENT_ENCRYPTION_ID;
        private static final byte[] EXTENDED_CONTENT_ENCRYPTION_ID;
        private static final byte[] CODEC_LIST_ID;
        private static final byte[] AUDIO_STREAM_ID;
        private static final byte[] VIDEO_STREAM_ID;

        static {
            byte[] byArray = new byte[16];
            byArray[0] = 48;
            byArray[1] = 38;
            byArray[2] = -78;
            byArray[3] = 117;
            byArray[4] = -114;
            byArray[5] = 102;
            byArray[6] = -49;
            byArray[7] = 17;
            byArray[8] = -90;
            byArray[9] = -39;
            byArray[11] = -86;
            byArray[13] = 98;
            byArray[14] = -50;
            byArray[15] = 108;
            HEADER_ID = byArray;
            byte[] byArray2 = new byte[16];
            byArray2[0] = -95;
            byArray2[1] = -36;
            byArray2[2] = -85;
            byArray2[3] = -116;
            byArray2[4] = 71;
            byArray2[5] = -87;
            byArray2[6] = -49;
            byArray2[7] = 17;
            byArray2[8] = -114;
            byArray2[9] = -28;
            byArray2[11] = -64;
            byArray2[12] = 12;
            byArray2[13] = 32;
            byArray2[14] = 83;
            byArray2[15] = 101;
            FILE_PROPERTIES_ID = byArray2;
            byte[] byArray3 = new byte[16];
            byArray3[0] = -111;
            byArray3[1] = 7;
            byArray3[2] = -36;
            byArray3[3] = -73;
            byArray3[4] = -73;
            byArray3[5] = -87;
            byArray3[6] = -49;
            byArray3[7] = 17;
            byArray3[8] = -114;
            byArray3[9] = -26;
            byArray3[11] = -64;
            byArray3[12] = 12;
            byArray3[13] = 32;
            byArray3[14] = 83;
            byArray3[15] = 101;
            STREAM_PROPERTIES_ID = byArray3;
            EXTENDED_STREAM_PROPERTIES_ID = new byte[]{-53, -91, -26, 20, 114, -58, 50, 67, -125, -103, -87, 105, 82, 6, 91, 90};
            byte[] byArray4 = new byte[16];
            byArray4[0] = 51;
            byArray4[1] = 38;
            byArray4[2] = -78;
            byArray4[3] = 117;
            byArray4[4] = -114;
            byArray4[5] = 102;
            byArray4[6] = -49;
            byArray4[7] = 17;
            byArray4[8] = -90;
            byArray4[9] = -39;
            byArray4[11] = -86;
            byArray4[13] = 98;
            byArray4[14] = -50;
            byArray4[15] = 108;
            CONTENT_DESCRIPTION_ID = byArray4;
            byte[] byArray5 = new byte[16];
            byArray5[0] = 64;
            byArray5[1] = -92;
            byArray5[2] = -48;
            byArray5[3] = -46;
            byArray5[4] = 7;
            byArray5[5] = -29;
            byArray5[6] = -46;
            byArray5[7] = 17;
            byArray5[8] = -105;
            byArray5[9] = -16;
            byArray5[11] = -96;
            byArray5[12] = -55;
            byArray5[13] = 94;
            byArray5[14] = -88;
            byArray5[15] = 80;
            EXTENDED_CONTENT_DESCRIPTION_ID = byArray5;
            byte[] byArray6 = new byte[16];
            byArray6[0] = -5;
            byArray6[1] = -77;
            byArray6[2] = 17;
            byArray6[3] = 34;
            byArray6[4] = 35;
            byArray6[5] = -67;
            byArray6[6] = -46;
            byArray6[7] = 17;
            byArray6[8] = -76;
            byArray6[9] = -73;
            byArray6[11] = -96;
            byArray6[12] = -55;
            byArray6[13] = 85;
            byArray6[14] = -4;
            byArray6[15] = 110;
            CONTENT_ENCRYPTION_ID = byArray6;
            EXTENDED_CONTENT_ENCRYPTION_ID = new byte[]{20, -26, -118, 41, 34, 38, 23, 76, -71, 53, -38, -32, 126, -23, 40, -100};
            byte[] byArray7 = new byte[16];
            byArray7[0] = 64;
            byArray7[1] = 82;
            byArray7[2] = -47;
            byArray7[3] = -122;
            byArray7[4] = 29;
            byArray7[5] = 49;
            byArray7[6] = -48;
            byArray7[7] = 17;
            byArray7[8] = -93;
            byArray7[9] = -92;
            byArray7[11] = -96;
            byArray7[12] = -55;
            byArray7[13] = 3;
            byArray7[14] = 72;
            byArray7[15] = -10;
            CODEC_LIST_ID = byArray7;
            byte[] byArray8 = new byte[16];
            byArray8[0] = 64;
            byArray8[1] = -98;
            byArray8[2] = 105;
            byArray8[3] = -8;
            byArray8[4] = 77;
            byArray8[5] = 91;
            byArray8[6] = -49;
            byArray8[7] = 17;
            byArray8[8] = -88;
            byArray8[9] = -3;
            byArray8[11] = -128;
            byArray8[12] = 95;
            byArray8[13] = 92;
            byArray8[14] = 68;
            byArray8[15] = 43;
            AUDIO_STREAM_ID = byArray8;
            byte[] byArray9 = new byte[16];
            byArray9[0] = -64;
            byArray9[1] = -17;
            byArray9[2] = 25;
            byArray9[3] = -68;
            byArray9[4] = 77;
            byArray9[5] = 91;
            byArray9[6] = -49;
            byArray9[7] = 17;
            byArray9[8] = -88;
            byArray9[9] = -3;
            byArray9[11] = -128;
            byArray9[12] = 95;
            byArray9[13] = 92;
            byArray9[14] = 68;
            byArray9[15] = 43;
            VIDEO_STREAM_ID = byArray9;
        }

        IDs() {
        }
    }

    private static class Extended {
        private static final String WM_TITLE = "WM/Title";
        private static final String WM_AUTHOR = "WM/Author";
        private static final String WM_ALBUMTITLE = "WM/AlbumTitle";
        private static final String WM_TRACK = "WM/Track";
        private static final String WM_TRACK_NUMBER = "WM/TrackNumber";
        private static final String WM_YEAR = "WM/Year";
        private static final String WM_GENRE = "WM/Genre";
        private static final String WM_DESCRIPTION = "WM/Description";
        private static final String WM_LYRICS = "WM/Lyrics";
        private static final String VBR = "IsVBR";
        private static final String WM_UNIQUE_FILE_IDENTIFIER = "WM/UniqueFileIdentifier";
        private static final String WM_ALBUMARTIST = "WM/AlbumArtist";
        private static final String ID3 = "ID3";
        private static final String WM_PROVIDER = "WM/Provider";
        private static final String WM_PROVIDER_RATING = "WM/ProviderRating";
        private static final String WM_PUBLISHER = "WM/Publisher";
        private static final String WM_COMPOSER = "WM/Composer";
        private static final String WM_ENCODING_TIME = "WM/EncodingTime";

        Extended() {
        }
    }
}

