/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.FilterSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IPFilter
extends SpamFilter {
    private static IPFilter _instance;
    private final IPList badHosts = new IPList();
    private final IPList goodHosts = new IPList();

    private IPFilter() {
        String[] stringArray = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        int n = 0;
        while (n < stringArray.length) {
            this.badHosts.add(stringArray[n]);
            ++n;
        }
        stringArray = FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue();
        n = 0;
        while (n < stringArray.length) {
            this.goodHosts.add(stringArray[n]);
            ++n;
        }
    }

    public static IPFilter instance() {
        if (_instance == null) {
            _instance = new IPFilter();
        }
        return _instance;
    }

    public static void refreshIPFilter() {
        _instance = new IPFilter();
    }

    public IPList getBadHosts() {
        return this.badHosts;
    }

    public boolean allow(String string) {
        IP iP;
        try {
            iP = new IP(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                string = inetAddress.getHostAddress();
                iP = new IP(string);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return false;
            }
        }
        return this.goodHosts.contains(iP) || !this.badHosts.contains(iP);
    }

    public boolean allow(byte[] byArray) {
        IP iP;
        try {
            iP = new IP(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return this.goodHosts.contains(iP) || !this.badHosts.contains(iP);
    }

    public boolean allow(Message message) {
        if (message instanceof PingReply) {
            PingReply pingReply = (PingReply)message;
            return this.allow(pingReply.getAddress());
        }
        if (message instanceof QueryReply) {
            QueryReply queryReply = (QueryReply)message;
            return this.allow(queryReply.getIPBytes());
        }
        if (message instanceof PushRequest) {
            PushRequest pushRequest = (PushRequest)message;
            return this.allow(pushRequest.getIP());
        }
        return true;
    }
}

