/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.AssertFailure;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DiskException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.MiniRemoteFileDesc;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.IntervalSet;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadWorker
implements Runnable {
    private static final Log LOG;
    private static final int MIN_SPLIT_SIZE = 16384;
    private static final float MIN_ACCEPTABLE_SPEED;
    private static final int UNKNOWN_SPEED = -1;
    private static final int NORMAL_CONNECT_TIME = 10000;
    private static final int PUSH_CONNECT_TIME = 20000;
    private static final int UDP_PUSH_CONNECT_TIME = 6000;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    public static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    private final ManagedDownloader _manager;
    private final RemoteFileDesc _rfd;
    private final VerifyingFile _commonOutFile;
    private volatile Thread _myThread;
    private volatile boolean _interrupted;
    private final Object _stealLock;
    private Socket _pushSocket;
    private volatile HTTPDownloader _downloader;
    private volatile boolean _shouldRelease;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.DownloadWorker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    }

    DownloadWorker(ManagedDownloader managedDownloader, RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile, Object object) {
        this._manager = managedDownloader;
        this._rfd = remoteFileDesc;
        this._stealLock = object;
        this._commonOutFile = verifyingFile;
    }

    public void run() {
        this._myThread = Thread.currentThread();
        if (LOG.isDebugEnabled()) {
            this._myThread.setName("DownloadWorker for " + this._manager.getSaveFile().getName() + " #" + this._myThread.hashCode());
        }
        try {
            try {
                if (this._interrupted) {
                    throw new InterruptedException();
                }
                this.connectAndDownload();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                LOG.debug((Object)"got an exception in run()", throwable);
                ErrorService.error(throwable);
            }
        }
        finally {
            this._manager.workerFinished(this);
        }
    }

    private void connectAndDownload() {
        Object object;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("connectAndDownload for: " + this._rfd));
        }
        this.establishConnection();
        if (this._downloader == null) {
            return;
        }
        int n = 0;
        Iterator iterator = this._manager.getValidAlts().iterator();
        while (iterator.hasNext() && n < 10) {
            object = (AlternateLocation)iterator.next();
            this._downloader.addSuccessfulAltLoc((AlternateLocation)object);
            ++n;
        }
        n = 0;
        iterator = this._manager.getInvalidAlts().iterator();
        while (iterator.hasNext() && n < 10) {
            object = (AlternateLocation)iterator.next();
            this._downloader.addFailedAltLoc((AlternateLocation)object);
            ++n;
        }
        boolean bl = true;
        while (bl) {
            boolean bl2;
            block31: {
                bl = this._rfd.isHTTP11();
                while (true) {
                    object = this.requestTHEXIfNeeded();
                    this._downloader.consumeBodyIfNecessary();
                    this._downloader.forgetRanges();
                    if (object == null || !((ConnectionStatus)object).isQueued()) {
                        try {
                            object = this.assignAndRequest(bl);
                            this._manager.addPossibleSources(this._downloader.getLocationsReceived());
                        }
                        finally {
                            try {
                                if (object == null || !((ConnectionStatus)object).isConnected()) {
                                    this.releaseRanges();
                                }
                            }
                            catch (AssertFailure assertFailure) {
                                throw new AssertFailure("status " + object + " worker failed " + this.getInfo() + " all workers: " + this._manager.getWorkersInfo(), assertFailure);
                            }
                        }
                    }
                    if (((ConnectionStatus)object).isPartialData()) continue;
                    if (((ConnectionStatus)object).isNoFile() || ((ConnectionStatus)object).isNoData()) break block31;
                    Assert.that(((ConnectionStatus)object).isQueued() || ((ConnectionStatus)object).isConnected());
                    bl2 = this._manager.killQueuedIfNecessary(this, !((ConnectionStatus)object).isQueued() ? -1 : ((ConnectionStatus)object).getQueuePosition());
                    if (((ConnectionStatus)object).isConnected()) break block31;
                    Assert.that(((ConnectionStatus)object).isQueued());
                    if (!bl2 || this.handleQueued((ConnectionStatus)object)) break;
                }
                return;
            }
            this._manager.removeQueuedWorker(this);
            switch (((ConnectionStatus)object).getType()) {
                case 0: {
                    this._downloader.stop();
                    return;
                }
                case 3: {
                    this._downloader.stop();
                    return;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException("illegal status: " + ((ConnectionStatus)object).getType());
                }
            }
            Assert.that(((ConnectionStatus)object).isConnected());
            bl2 = false;
            try {
                bl2 = this.doDownload(bl);
                if (bl2) continue;
                break;
            }
            finally {
                try {
                    this.releaseRanges();
                }
                catch (AssertFailure assertFailure) {
                    throw new AssertFailure("downloaded " + bl2 + " worker failed " + this.getInfo() + " all workers: " + this._manager.getWorkersInfo(), assertFailure);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus requestTHEXIfNeeded() {
        HashTree hashTree = this._commonOutFile.getHashTree();
        ConnectionStatus connectionStatus = null;
        if (this._downloader.hasHashTree() && (hashTree == null || !hashTree.isDepthGoodEnough()) && this._manager.getSHA1Urn() != null) {
            Object object = this._commonOutFile;
            synchronized (object) {
                if (this._commonOutFile.isHashTreeRequested()) {
                    return connectionStatus;
                }
                this._commonOutFile.setHashTreeRequested(true);
            }
            connectionStatus = this._downloader.requestHashTree(this._manager.getSHA1Urn());
            this._commonOutFile.setHashTreeRequested(false);
            if (connectionStatus.isThexResponse() && ((HashTree)(object = connectionStatus.getHashTree())).isBetterTree(hashTree)) {
                this._commonOutFile.setHashTree((HashTree)object);
            }
        }
        return connectionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRanges() {
        int n;
        int n2;
        HTTPDownloader hTTPDownloader;
        if (!this._shouldRelease) {
            return;
        }
        this._shouldRelease = false;
        if (this._commonOutFile.isComplete()) {
            return;
        }
        HTTPDownloader hTTPDownloader2 = hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader2) {
            n2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
            n2 = Math.max(n2, hTTPDownloader.getInitialWritingPoint());
            n = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountToRead() - 1;
        }
        if (n - n2 >= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("releasing ranges " + new Interval(n2, n)));
            }
            this._commonOutFile.releaseBlock(new Interval(n2, n));
            hTTPDownloader.forgetRanges();
        } else {
            LOG.debug((Object)"nothing to release!");
        }
    }

    private boolean handleQueued(ConnectionStatus connectionStatus) {
        try {
            this._manager.removeActiveWorker(this);
            Thread.sleep(connectionStatus.getQueuePollTime());
            return false;
        }
        catch (InterruptedException interruptedException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("worker: interrupted while asleep in queue" + this._downloader));
            }
            this._manager.removeQueuedWorker(this);
            this._downloader.stop();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection() {
        block23: {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("establishConnection(" + this._rfd + ")"));
            }
            if (this._rfd == null) {
                return;
            }
            if (this._manager.isCancelled() || this._manager.isPaused()) {
                this._manager.addRFD(this._rfd);
                return;
            }
            boolean bl = this._rfd.needsPush();
            ManagedDownloader managedDownloader = this._manager;
            synchronized (managedDownloader) {
                int n = this._manager.getState();
                if (this._manager.getNumDownloaders() == 0 && n != 4 && n != 5 && n != 6 && n != 7 && n != 9 && n != 11 && n != 12) {
                    if (this._interrupted) {
                        return;
                    }
                    this._manager.setState(1, bl ? 20000 : 10000);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: attempting connect to " + this._rfd.getHost() + ":" + this._rfd.getPort()));
            }
            DownloadStat.CONNECTION_ATTEMPTS.incrementStat();
            if (this._rfd.isReplyToMulticast()) {
                try {
                    this._downloader = this.connectWithPush();
                }
                catch (IOException iOException) {
                    try {
                        this._downloader = this.connectDirectly();
                    }
                    catch (IOException iOException2) {
                        return;
                    }
                }
                return;
            }
            if (!bl) {
                try {
                    this._downloader = this.connectDirectly();
                }
                catch (IOException iOException) {}
            }
            if (this._downloader == null) {
                try {
                    this._downloader = this.connectWithPush();
                }
                catch (IOException iOException) {
                    if (!bl) break block23;
                    this._manager.forgetRFD(this._rfd);
                }
            }
        }
        if (this._downloader == null) {
            this._manager.informMesh(this._rfd, false);
        } else if (this._interrupted) {
            this._downloader.stop();
            this._downloader = null;
        }
    }

    private HTTPDownloader connectDirectly() throws IOException {
        LOG.trace((Object)"WORKER: attempt direct connection");
        HTTPDownloader hTTPDownloader = new HTTPDownloader(this._rfd, this._commonOutFile, false);
        try {
            hTTPDownloader.connectTCP(10000);
            DownloadStat.CONNECT_DIRECT_SUCCESS.incrementStat();
        }
        catch (IOException iOException) {
            DownloadStat.CONNECT_DIRECT_FAILURES.incrementStat();
            throw iOException;
        }
        return hTTPDownloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader connectWithPush() throws IOException {
        LOG.trace((Object)"WORKER: attempt push connection");
        MiniRemoteFileDesc miniRemoteFileDesc = new MiniRemoteFileDesc(this._rfd.getFileName(), this._rfd.getIndex(), this._rfd.getClientGUID());
        this._manager.registerPushWaiter(this, miniRemoteFileDesc);
        Socket socket = null;
        try {
            DownloadWorker downloadWorker = this;
            synchronized (downloadWorker) {
                RouterService.getDownloadManager().sendPush(this._rfd, this);
                try {
                    this.wait(this._rfd.isFromAlternateLocation() ? 6000 : 20000);
                    socket = this._pushSocket;
                    this._pushSocket = null;
                }
                catch (InterruptedException interruptedException) {
                    DownloadStat.PUSH_FAILURE_INTERRUPTED.incrementStat();
                    throw new IOException("push interupted.");
                }
            }
            if (socket == null) {
                DownloadStat.PUSH_FAILURE_NO_RESPONSE.incrementStat();
                throw new IOException("push socket is null");
            }
        }
        finally {
            this._manager.unregisterPushWaiter(miniRemoteFileDesc);
        }
        HTTPDownloader hTTPDownloader = new HTTPDownloader(socket, this._rfd, this._commonOutFile, false);
        try {
            hTTPDownloader.connectTCP(0);
            DownloadStat.CONNECT_PUSH_SUCCESS.incrementStat();
        }
        catch (IOException iOException) {
            DownloadStat.PUSH_FAILURE_LOST.incrementStat();
            throw iOException;
        }
        return hTTPDownloader;
    }

    synchronized void setPushSocket(Socket socket) {
        this._pushSocket = socket;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDownload(boolean bl) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("WORKER: about to start downloading " + this._downloader));
        }
        boolean bl2 = false;
        try {
            try {
                this._downloader.doDownload();
                this._rfd.resetFailedCount();
                if (bl) {
                    DownloadStat.SUCCESSFUL_HTTP11.incrementStat();
                } else {
                    DownloadStat.SUCCESSFUL_HTTP10.incrementStat();
                }
                LOG.debug((Object)"WORKER: successfully finished download");
            }
            catch (DiskException diskException) {
                this._manager.diskProblemOccured();
            }
            catch (IOException iOException) {
                if (bl) {
                    DownloadStat.FAILED_HTTP11.incrementStat();
                } else {
                    DownloadStat.FAILED_HTTP10.incrementStat();
                }
                bl2 = true;
                this._manager.workerFailed(this);
            }
            catch (AssertFailure assertFailure) {
                throw new AssertFailure("worker failed " + this.getInfo() + " all workers: " + this._manager.getWorkersInfo(), assertFailure);
            }
        }
        catch (Throwable throwable) {
            if (this._commonOutFile.isHopeless()) {
                this._manager.promptAboutCorruptDownload();
            }
            int n = this._downloader.getInitialReadingPoint() + this._downloader.getAmountRead();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("    WORKER:+ terminating from " + this._downloader + " at " + n + " error? " + bl2));
            }
            ManagedDownloader managedDownloader = this._manager;
            synchronized (managedDownloader) {
                if (bl2) {
                    this._downloader.stop();
                    this._rfd.incrementFailedCount();
                    if (this._rfd.getFailedCount() < 2) {
                        this._rfd.setRetryAfter(60);
                        this._manager.addRFD(this._rfd);
                    } else {
                        this._manager.informMesh(this._rfd, false);
                    }
                } else {
                    this._manager.informMesh(this._rfd, true);
                    if (!bl) {
                        this._manager.addRFD(this._rfd);
                    }
                }
            }
            throw throwable;
        }
        if (this._commonOutFile.isHopeless()) {
            this._manager.promptAboutCorruptDownload();
        }
        int n = this._downloader.getInitialReadingPoint() + this._downloader.getAmountRead();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("    WORKER:+ terminating from " + this._downloader + " at " + n + " error? " + bl2));
        }
        ManagedDownloader managedDownloader = this._manager;
        synchronized (managedDownloader) {
            if (bl2) {
                this._downloader.stop();
                this._rfd.incrementFailedCount();
                if (this._rfd.getFailedCount() < 2) {
                    this._rfd.setRetryAfter(60);
                    this._manager.addRFD(this._rfd);
                } else {
                    this._manager.informMesh(this._rfd, false);
                }
            } else {
                this._manager.informMesh(this._rfd, true);
                if (!bl) {
                    this._manager.addRFD(this._rfd);
                }
            }
        }
        return !bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInfo() {
        if (this._downloader != null) {
            HTTPDownloader hTTPDownloader = this._downloader;
            synchronized (hTTPDownloader) {
                return this + "hashcode " + this.hashCode() + " will release? " + this._shouldRelease + " interrupted? " + this._interrupted + " active? " + this._downloader.isActive() + " victim? " + this._downloader.isVictim() + " initial reading " + this._downloader.getInitialReadingPoint() + " initial writing " + this._downloader.getInitialWritingPoint() + " amount to read " + this._downloader.getAmountToRead() + " amount read " + this._downloader.getAmountRead() + "\n";
            }
        }
        return "worker not started";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus assignAndRequest(boolean bl) {
        Serializable serializable;
        block26: {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("assignAndRequest for: " + this._rfd));
            }
            try {
                serializable = null;
                Object object = this._commonOutFile;
                synchronized (object) {
                    if (this._commonOutFile.hasFreeBlocksToAssign() > 0) {
                        serializable = this.pickAvailableInterval(bl);
                    }
                }
                if (serializable == null) {
                    object = this._stealLock;
                    synchronized (object) {
                        this.assignGrey();
                        break block26;
                    }
                }
                this.assignWhite((Interval)serializable);
            }
            catch (NoSuchElementException noSuchElementException) {
                DownloadStat.NSE_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)noSuchElementException);
                return this.handleNoMoreDownloaders();
            }
            catch (NoSuchRangeException noSuchRangeException) {
                LOG.debug((Object)this._downloader, (Throwable)noSuchRangeException);
                return this.handleNoRanges();
            }
            catch (TryAgainLaterException tryAgainLaterException) {
                DownloadStat.TAL_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)tryAgainLaterException);
                return this.handleTryAgainLater();
            }
            catch (RangeNotAvailableException rangeNotAvailableException) {
                DownloadStat.RNA_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)rangeNotAvailableException);
                return this.handleRangeNotAvailable();
            }
            catch (FileNotFoundException fileNotFoundException) {
                DownloadStat.FNF_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)fileNotFoundException);
                return this.handleFileNotFound();
            }
            catch (NotSharingException notSharingException) {
                DownloadStat.NS_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)notSharingException);
                return this.handleNotSharing();
            }
            catch (QueuedException queuedException) {
                DownloadStat.Q_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)queuedException);
                return this.handleQueued(queuedException.getQueuePosition(), queuedException.getMinPollTime());
            }
            catch (ProblemReadingHeaderException problemReadingHeaderException) {
                DownloadStat.PRH_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)problemReadingHeaderException);
                return this.handleProblemReadingHeader();
            }
            catch (UnknownCodeException unknownCodeException) {
                DownloadStat.UNKNOWN_CODE_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)unknownCodeException);
                return this.handleUnknownCode();
            }
            catch (ContentUrnMismatchException contentUrnMismatchException) {
                DownloadStat.CONTENT_URN_MISMATCH_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)contentUrnMismatchException);
                return ConnectionStatus.getNoFile();
            }
            catch (IOException iOException) {
                DownloadStat.IO_EXCEPTION.incrementStat();
                LOG.debug((Object)this._downloader, (Throwable)iOException);
                return this.handleIO();
            }
        }
        DownloadStat.RESPONSE_OK.incrementStat();
        if (this._rfd.getFailedCount() > 0) {
            DownloadStat.RETRIED_SUCCESS.incrementStat();
        }
        this._rfd.resetFailedCount();
        serializable = this._manager;
        synchronized (serializable) {
            if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted) {
                LOG.trace((Object)"Stopped in assignAndRequest");
                this._manager.addRFD(this._rfd);
                return ConnectionStatus.getNoData();
            }
            this._manager.workerStarted(this);
        }
        return ConnectionStatus.getConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignWhite(Interval interval) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException {
        int n = interval.low;
        int n2 = interval.high;
        this._shouldRelease = true;
        this._downloader.connectHTTP(n, n2 + 1, true, this._commonOutFile.getBlockSize());
        HTTPDownloader hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader) {
            int n3 = this._downloader.getInitialReadingPoint();
            int n4 = this._downloader.getAmountToRead() - 1 + n3;
            if (n4 - n3 >= 0) {
                if (n3 > n) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WORKER: Host gave subrange, different low.  Was: " + n + ", is now: " + n3));
                    }
                    this._commonOutFile.releaseBlock(new Interval(n, n3 - 1));
                }
                if (n4 < n2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WORKER: Host gave subrange, different high.  Was: " + n2 + ", is now: " + n4));
                    }
                    this._commonOutFile.releaseBlock(new Interval(n4 + 1, n2));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WORKER: assigning white " + n3 + "-" + n4 + " to " + this._downloader));
                }
            } else {
                LOG.debug((Object)"debouched at birth");
            }
        }
    }

    private Interval pickAvailableInterval(boolean bl) throws NoSuchRangeException {
        Interval interval = null;
        if (!this._downloader.getRemoteFileDesc().isPartialSource()) {
            interval = bl ? this._commonOutFile.leaseWhite(this.findChunkSize()) : this._commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet intervalSet = this._downloader.getRemoteFileDesc().getAvailableRanges();
                interval = bl ? this._commonOutFile.leaseWhite(intervalSet, this.findChunkSize()) : this._commonOutFile.leaseWhite(intervalSet);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NoSuchRangeException();
            }
        }
        return interval;
    }

    private int findChunkSize() {
        int n = this._commonOutFile.getChunkSize();
        int n2 = this._commonOutFile.hasFreeBlocksToAssign();
        if (n2 <= n && this._manager.getActiveWorkers().size() > 1) {
            n = Math.max(16384, n2 / 2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignGrey() throws NoSuchElementException, IOException, TryAgainLaterException, QueuedException, FileNotFoundException, NotSharingException, NoSuchRangeException {
        int n;
        if (this._downloader.getRemoteFileDesc().isPartialSource()) {
            throw new NoSuchRangeException();
        }
        DownloadWorker downloadWorker = this.findSlowestDownloader();
        if (downloadWorker == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"didn't find anybody to steal from");
            }
            throw new NoSuchElementException();
        }
        Interval interval = downloadWorker.getDownloadInterval();
        if (interval.low == interval.high) {
            throw new NoSuchElementException();
        }
        this._downloader.connectHTTP(interval.low, interval.high, false, this._commonOutFile.getBlockSize());
        HTTPDownloader hTTPDownloader = downloadWorker.getDownloader();
        synchronized (hTTPDownloader) {
            if (!downloadWorker.getDownloader().isActive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"victim is no longer active");
                }
                throw new NoSuchElementException();
            }
            Interval interval2 = downloadWorker.getDownloadInterval();
            if (interval2.high != interval.high) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("victim is now downloading something else " + interval2 + " vs. " + interval));
                }
                throw new NoSuchElementException();
            }
            if (interval2.low > interval.low && LOG.isDebugEnabled()) {
                LOG.debug((Object)("victim managed to download " + (interval2.low - interval.low) + " bytes while stealer was connecting"));
            }
            int n2 = this._downloader.getInitialReadingPoint();
            int n3 = this._downloader.getAmountToRead() + n2;
            if (n3 < interval.high) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WORKER: not stealing because stealer gave a subrange.  Expected low: " + interval.low + ", high: " + interval.high + ".  Was low: " + n2 + ", high: " + n3));
                }
                throw new IOException("bad stealer.");
            }
            n = Math.max(interval2.low, n2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: picking stolen grey " + n + "-" + interval.high + " from " + downloadWorker + " to " + this._downloader));
            }
            downloadWorker.getDownloader().stopAt(n);
        }
        this._downloader.startAt(n);
        this._shouldRelease = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Interval getDownloadInterval() {
        HTTPDownloader hTTPDownloader;
        HTTPDownloader hTTPDownloader2 = hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader2) {
            int n = Math.max(hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead(), hTTPDownloader.getInitialWritingPoint());
            int n2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountToRead();
            return new Interval(n, n2);
        }
    }

    private DownloadWorker findSlowestDownloader() {
        float f;
        DownloadWorker downloadWorker = null;
        float f2 = f = this.getOurSpeed();
        Set set = this._manager.getQueuedWorkers().keySet();
        Iterator iterator = this._manager.getAllWorkers().iterator();
        while (iterator.hasNext()) {
            HTTPDownloader hTTPDownloader;
            DownloadWorker downloadWorker2 = (DownloadWorker)iterator.next();
            if (set.contains(downloadWorker2) || (hTTPDownloader = downloadWorker2.getDownloader()) == null || hTTPDownloader == this._downloader) continue;
            if (f == -1.0f) {
                if (!downloadWorker2.isSlow()) continue;
                return downloadWorker2;
            }
            float f3 = 0.0f;
            try {
                hTTPDownloader.getMeasuredBandwidth();
                f3 = hTTPDownloader.getAverageBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f3 = Math.max(0.0f, f - 0.1f);
            }
            if (!(f3 < f2)) continue;
            f2 = f3;
            downloadWorker = downloadWorker2;
        }
        return downloadWorker;
    }

    private float getOurSpeed() {
        if (this._downloader == null) {
            return -1.0f;
        }
        try {
            this._downloader.getMeasuredBandwidth();
            return this._downloader.getAverageBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return -1.0f;
        }
    }

    boolean isSlow() {
        float f = this.getOurSpeed();
        return f < MIN_ACCEPTABLE_SPEED && f != -1.0f;
    }

    private ConnectionStatus handleNoMoreDownloaders() {
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoData();
    }

    private ConnectionStatus handleNoRanges() {
        this._rfd.setAvailableRanges(null);
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(300);
        }
        this._rfd.resetFailedCount();
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleTryAgainLater() {
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(60);
        }
        if (!this._manager.getActiveWorkers().isEmpty() && this._rfd.getWaitTime(System.currentTimeMillis()) < 600) {
            this._rfd.setRetryAfter(600);
        }
        this._manager.addRFD(this._rfd);
        this._rfd.resetFailedCount();
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleRangeNotAvailable() {
        this._rfd.resetFailedCount();
        this._manager.informMesh(this._rfd, true);
        return ConnectionStatus.getPartialData();
    }

    private ConnectionStatus handleFileNotFound() {
        this._manager.informMesh(this._rfd, false);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleNotSharing() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleQueued(int n, int n2) {
        if (this._manager.getActiveWorkers().isEmpty()) {
            if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted) {
                return ConnectionStatus.getNoData();
            }
            this._manager.setState(10);
        }
        this._rfd.resetFailedCount();
        return ConnectionStatus.getQueued(n, n2);
    }

    private ConnectionStatus handleProblemReadingHeader() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleUnknownCode() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleIO() {
        this._rfd.incrementFailedCount();
        if (this._rfd.getFailedCount() < 2) {
            this._rfd.setRetryAfter(60);
            this._manager.addRFD(this._rfd);
        } else {
            this._manager.informMesh(this._rfd, false);
        }
        return ConnectionStatus.getNoFile();
    }

    void interrupt() {
        this._interrupted = true;
        if (this._downloader != null) {
            this._downloader.stop();
        }
        if (this._myThread != null) {
            this._myThread.interrupt();
        }
    }

    public RemoteFileDesc getRFD() {
        return this._rfd;
    }

    HTTPDownloader getDownloader() {
        return this._downloader;
    }

    public String toString() {
        String string = this._myThread != null ? this._myThread.getName() : "new";
        return String.valueOf(string) + " -> " + this._rfd;
    }
}

