/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AltLocManager {
    private static final AltLocManager INSTANCE = new AltLocManager();
    private final Map urnMap = Collections.synchronizedMap(new HashMap());

    public static AltLocManager instance() {
        return INSTANCE;
    }

    private AltLocManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AlternateLocation alternateLocation, Object object) {
        Object object2;
        URNData uRNData;
        URN uRN = alternateLocation.getSHA1Urn();
        AlternateLocationCollection alternateLocationCollection = null;
        Object object3 = this.urnMap;
        synchronized (object3) {
            uRNData = (URNData)this.urnMap.get(uRN);
            if (uRNData == null) {
                uRNData = new URNData();
                this.urnMap.put(uRN, uRNData);
            }
        }
        object3 = uRNData;
        synchronized (object3) {
            if (alternateLocation instanceof DirectAltLoc) {
                if (uRNData.direct == AlternateLocationCollection.EMPTY) {
                    uRNData.direct = AlternateLocationCollection.create(uRN);
                }
                alternateLocationCollection = uRNData.direct;
            } else {
                object2 = (PushAltLoc)alternateLocation;
                if (((PushAltLoc)object2).supportsFWTVersion() < 1) {
                    if (uRNData.push == AlternateLocationCollection.EMPTY) {
                        uRNData.push = AlternateLocationCollection.create(uRN);
                    }
                    alternateLocationCollection = uRNData.push;
                } else {
                    if (uRNData.fwt == AlternateLocationCollection.EMPTY) {
                        uRNData.fwt = AlternateLocationCollection.create(uRN);
                    }
                    alternateLocationCollection = uRNData.fwt;
                }
            }
        }
        boolean bl = alternateLocationCollection.add(alternateLocation);
        object2 = uRNData.getListeners().iterator();
        while (object2.hasNext()) {
            AltLocListener altLocListener = (AltLocListener)object2.next();
            if (altLocListener == object) continue;
            altLocListener.locationAdded(alternateLocation);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AlternateLocation alternateLocation, Object object) {
        AlternateLocationCollection alternateLocationCollection;
        URN uRN = alternateLocation.getSHA1Urn();
        URNData uRNData = (URNData)this.urnMap.get(uRN);
        if (uRNData == null) {
            return false;
        }
        URNData uRNData2 = uRNData;
        synchronized (uRNData2) {
            PushAltLoc pushAltLoc;
            alternateLocationCollection = alternateLocation instanceof DirectAltLoc ? uRNData.direct : ((pushAltLoc = (PushAltLoc)alternateLocation).supportsFWTVersion() < 1 ? uRNData.push : uRNData.fwt);
        }
        if (alternateLocationCollection == null) {
            return false;
        }
        boolean bl = alternateLocationCollection.remove(alternateLocation);
        if (!alternateLocationCollection.hasAlternateLocations()) {
            this.removeIfEmpty(uRN, uRNData);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIfEmpty(URN uRN, URNData uRNData) {
        boolean bl = false;
        URNData uRNData2 = uRNData;
        synchronized (uRNData2) {
            if (!uRNData.direct.hasAlternateLocations() && !uRNData.push.hasAlternateLocations() && !uRNData.fwt.hasAlternateLocations() && uRNData.getListeners().isEmpty()) {
                bl = true;
            }
        }
        if (bl) {
            this.urnMap.remove(uRN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection getDirect(URN uRN) {
        URNData uRNData = (URNData)this.urnMap.get(uRN);
        if (uRNData == null) {
            return AlternateLocationCollection.EMPTY;
        }
        URNData uRNData2 = uRNData;
        synchronized (uRNData2) {
            return uRNData.direct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection getPush(URN uRN, boolean bl) {
        URNData uRNData = (URNData)this.urnMap.get(uRN);
        if (uRNData == null) {
            return AlternateLocationCollection.EMPTY;
        }
        URNData uRNData2 = uRNData;
        synchronized (uRNData2) {
            return bl ? uRNData.fwt : uRNData.push;
        }
    }

    public void purge() {
        this.urnMap.clear();
    }

    public void purge(URN uRN) {
        this.urnMap.remove(uRN);
    }

    public boolean hasAltlocs(URN uRN) {
        URNData uRNData = (URNData)this.urnMap.get(uRN);
        if (uRNData == null) {
            return false;
        }
        return uRNData.hasAltLocs();
    }

    public int getNumLocs(URN uRN) {
        URNData uRNData = (URNData)this.urnMap.get(uRN);
        if (uRNData == null) {
            return 0;
        }
        return uRNData.getNumLocs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(URN uRN, AltLocListener altLocListener) {
        URNData uRNData;
        Map map = this.urnMap;
        synchronized (map) {
            uRNData = (URNData)this.urnMap.get(uRN);
            if (uRNData == null) {
                uRNData = new URNData();
                this.urnMap.put(uRN, uRNData);
            }
        }
        uRNData.addListener(altLocListener);
    }

    public void removeListener(URN uRN, AltLocListener altLocListener) {
        URNData uRNData = (URNData)this.urnMap.get(uRN);
        if (uRNData == null) {
            return;
        }
        uRNData.removeListener(altLocListener);
        this.removeIfEmpty(uRN, uRNData);
    }

    private static class URNData {
        public AlternateLocationCollection direct = AlternateLocationCollection.EMPTY;
        public AlternateLocationCollection push = AlternateLocationCollection.EMPTY;
        public AlternateLocationCollection fwt = AlternateLocationCollection.EMPTY;
        private volatile List listeners = Collections.EMPTY_LIST;

        URNData() {
        }

        public synchronized boolean hasAltLocs() {
            return this.direct.hasAlternateLocations() || this.push.hasAlternateLocations() || this.fwt.hasAlternateLocations();
        }

        public synchronized int getNumLocs() {
            return this.direct.getAltLocsSize() + this.push.getAltLocsSize() + this.fwt.getAltLocsSize();
        }

        public synchronized void addListener(AltLocListener altLocListener) {
            ArrayList<AltLocListener> arrayList = new ArrayList<AltLocListener>(this.listeners);
            arrayList.add(altLocListener);
            this.listeners = arrayList;
        }

        public synchronized void removeListener(AltLocListener altLocListener) {
            ArrayList arrayList = new ArrayList(this.listeners);
            arrayList.remove(altLocListener);
            this.listeners = arrayList;
        }

        public List getListeners() {
            return this.listeners;
        }
    }
}

